/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.io.GedcomFileReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class GedcomFileWriter
extends BufferedWriter {
    String EOL = System.getProperty("line.separator");
    private int levelShift = 0;
    private int shiftedLevel = -1;

    public GedcomFileWriter(File fileOut, Charset charset, String eol) throws UnsupportedEncodingException, FileNotFoundException {
        super(new OutputStreamWriter((OutputStream)new FileOutputStream(fileOut), charset));
        this.EOL = eol;
    }

    public String writeLine(int level, String tag, String value) throws IOException {
        return this.writeLine(level, null, tag, value);
    }

    public String writeLine(GedcomFileReader input) throws IOException {
        return this.writeLine(input.getLevel(), input.getXref(), input.getTag(), input.getValue());
    }

    public String writeLine(int level, String xref, String tag, String value) throws IOException {
        if (level <= this.shiftedLevel) {
            this.shiftedLevel = -1;
            this.levelShift = 0;
        }
        String result = Integer.toString(level + this.levelShift) + " ";
        if (xref != null && xref.length() > 0) {
            result = result + "@" + xref + "@ ";
        }
        result = result + tag;
        if (value != null && value.length() > 0) {
            result = result + " " + value;
        }
        this.write(result + this.EOL);
        return result;
    }

    public String shiftLine(GedcomFileReader input) throws IOException {
        return this.shiftLine(input.getLevel(), input.getXref(), input.getTag(), input.getValue());
    }

    public String shiftLine(int level, String xref, String tag, String value) throws IOException {
        if (this.levelShift == 0) {
            String result = this.writeLine(level + 1, xref, tag, value);
            this.levelShift = 1;
            this.shiftedLevel = level;
            return result;
        }
        return null;
    }
}

