/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.ChangeSupport;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;

public class TextFieldWidget
extends JTextField {
    private boolean isTemplate = false;
    private boolean isSelectAllOnFocus = false;
    private ChangeSupport changeSupport;
    private boolean blockSystemSelectionAccessViaToolkit = false;

    public TextFieldWidget() {
        this("", 0);
    }

    public TextFieldWidget(String text) {
        this(text, 0);
    }

    public TextFieldWidget(String text, int cols) {
        super(text, cols);
        this.setAlignmentX(0.0f);
        this.changeSupport = new ChangeSupport(this){

            @Override
            public void fireChangeEvent() {
                TextFieldWidget.this.isTemplate = false;
                super.fireChangeEvent();
            }
        };
        this.getDocument().addDocumentListener(this.changeSupport);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void setDocument(Document doc) {
        Document old = this.getDocument();
        if (this.changeSupport != null && old != null) {
            old.removeDocumentListener(this.changeSupport);
        }
        super.setDocument(doc);
        if (this.changeSupport != null && doc != null) {
            doc.addDocumentListener(this.changeSupport);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public TextFieldWidget setTemplate(boolean set) {
        this.isTemplate = set;
        return this;
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    public void setSelectAllOnFocus(boolean set) {
        this.isSelectAllOnFocus = set;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004 && (this.isTemplate || this.isSelectAllOnFocus)) {
            this.selectAll();
        }
        super.processFocusEvent(e);
    }

    @Override
    public Toolkit getToolkit() {
        if (this.blockSystemSelectionAccessViaToolkit) {
            throw new HeadlessException("no access to system selection atm");
        }
        return super.getToolkit();
    }

    @Override
    public void selectAll() {
        if (this.getDocument() != null) {
            this.setCaretPosition(this.getDocument().getLength());
            try {
                if (this.getToolkit().getSystemSelection() != null) {
                    this.blockSystemSelectionAccessViaToolkit = true;
                }
                this.moveCaretPosition(0);
            }
            finally {
                this.blockSystemSelectionAccessViaToolkit = false;
            }
        }
    }

    @Override
    public String getText() {
        if (this.isTemplate) {
            return "";
        }
        return super.getText();
    }

    public boolean isEmpty() {
        return this.getText().trim().length() == 0;
    }

    @Override
    public void setText(String txt) {
        super.setText(txt);
        this.setCaretPosition(0);
    }
}

