/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.graph;

import ancestris.modules.views.graph.GraphParameter;
import ancestris.modules.views.graph.GraphTopComponent;
import ancestris.modules.views.graph.LabelFamEnum;
import ancestris.modules.views.graph.LabelIndiEnum;
import ancestris.util.swing.ColorChooserButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GraphSettings
extends JPanel {
    private final GraphTopComponent theGTC;
    private final LabelIndiEnum[] labelIndi = LabelIndiEnum.values();
    private final LabelFamEnum[] labelFam = LabelFamEnum.values();
    private ColorChooserButton colorButtonAssociation;
    private ColorChooserButton colorButtonBackground;
    private ColorChooserButton colorButtonCujus;
    private ColorChooserButton colorButtonDefault;
    private ColorChooserButton colorButtonMarriage;
    private ColorChooserButton colorButtonMarriageSosa;
    private ColorChooserButton colorButtonSelected;
    private ColorChooserButton colorButtonSosa;
    private JButton jButtonApply;
    private JButton jButtonReset;
    private JCheckBox jCBAutoCentering;
    private JCheckBox jCBPositionning;
    private JCheckBox jCheckBoxColorScheme;
    private JComboBox<LabelFamEnum> jComboBoxFamLabels;
    private JComboBox<LabelIndiEnum> jComboBoxIndiLabels;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelAutoPositionning;
    private JLabel jLabelColor;
    private JLabel jLabelEdge;
    private JLabel jLabelLabels;
    private JLabel jLabelNode;
    private JLabel jLabelpx;
    private JLabel jLabelpx2;
    private JLabel jLabelpx4;
    private JLabel jLabelpx5;
    private JLabel jLabelpx6;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldCujusNodeSize;
    private JTextField jTextFieldDefaultEdgeSize;
    private JTextField jTextFieldDefaultNodeSize;
    private JTextField jTextFieldEdgeWeight;
    private JTextField jTextFieldFamNodeWeght;
    private JTextField jTextFieldIndiNodeWeght;
    private JTextField jTextFieldSelectedEdgeSize;
    private JTextField jTextFieldSelectedNodeSize;
    private JTextField jTextFieldSosaEdgeSize;
    private JTextField jTextFieldSosaNodeSize;
    private JLabel labelColorAssociation;
    private JLabel labelColorBackground;
    private JLabel labelColorCujus;
    private JLabel labelColorDefault;
    private JLabel labelColorMariage;
    private JLabel labelColorMariageSosa;
    private JLabel labelColorSelected;
    private JLabel labelColorSosa;
    private JLabel labelCujusNodeSize;
    private JLabel labelDefaultEdgeSize;
    private JLabel labelDefaultNodeSize;
    private JLabel labelEdgeWeight;
    private JLabel labelFamNodeWeight;
    private JLabel labelIndiNodeWeight;
    private JLabel labelSelectedEdgeSize;
    private JLabel labelSelectedNodeSize;
    private JLabel labelSosaEdgeSize;
    private JLabel labelSosaNodeSize;

    public GraphSettings(GraphTopComponent gtc) {
        this.theGTC = gtc;
        this.initComponents();
        this.initValues();
        this.colorButtonSosa.addColorChangedListener(newColor -> {
            this.getParam().setColorSosa(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
        this.colorButtonDefault.addColorChangedListener(newColor -> {
            this.getParam().setColorDef(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
        this.colorButtonMarriage.addColorChangedListener(newColor -> {
            this.getParam().setColorMariage(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
        this.colorButtonAssociation.addColorChangedListener(newColor -> {
            this.getParam().setColorAsso(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
        this.colorButtonCujus.addColorChangedListener(newColor -> {
            this.getParam().setColorCujus(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
        this.colorButtonSelected.addColorChangedListener(newColor -> {
            this.getParam().setColorSticked(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
        this.colorButtonBackground.addColorChangedListener(newColor -> {
            this.getParam().setColorBack(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
        this.colorButtonMarriageSosa.addColorChangedListener(newColor -> {
            this.getParam().setColorMariageSosa(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
    }

    private void initValues() {
        this.colorButtonSosa.setSelectedColor(Color.decode(this.getParam().getColorSosa()), false);
        this.colorButtonDefault.setSelectedColor(Color.decode(this.getParam().getColorDef()), false);
        this.colorButtonMarriage.setSelectedColor(Color.decode(this.getParam().getColorMariage()), false);
        this.colorButtonAssociation.setSelectedColor(Color.decode(this.getParam().getColorAsso()), false);
        this.colorButtonCujus.setSelectedColor(Color.decode(this.getParam().getColorCujus()), false);
        this.colorButtonSelected.setSelectedColor(Color.decode(this.getParam().getColorSticked()), false);
        this.colorButtonBackground.setSelectedColor(Color.decode(this.getParam().getColorBack()), false);
        this.colorButtonMarriageSosa.setSelectedColor(Color.decode(this.getParam().getColorMariageSosa()), false);
        this.jTextFieldDefaultNodeSize.setText(this.getParam().getSizeNode());
        this.jTextFieldDefaultEdgeSize.setText(this.getParam().getSizeEdge());
        this.jTextFieldSosaNodeSize.setText(this.getParam().getSizeNodeSosa());
        this.jTextFieldSosaEdgeSize.setText(this.getParam().getSizeEdgeSosa());
        this.jTextFieldSelectedNodeSize.setText(this.getParam().getSizeNodeSelected());
        this.jTextFieldSelectedEdgeSize.setText(this.getParam().getSizeEdgeSelected());
        this.jTextFieldCujusNodeSize.setText(this.getParam().getSizeCujus());
        this.jTextFieldEdgeWeight.setText(String.valueOf(this.getParam().getEdgeWeight()));
        this.jTextFieldIndiNodeWeght.setText(String.valueOf(this.getParam().getIndiNodeWeight()));
        this.jTextFieldFamNodeWeght.setText(String.valueOf(this.getParam().getMariageNodeWeight()));
        this.jComboBoxFamLabels.setSelectedItem((Object)this.getParam().getLabelFam());
        this.jComboBoxIndiLabels.setSelectedItem((Object)this.getParam().getLabelIndi());
        this.jCheckBoxColorScheme.setSelected(this.getParam().isUseGenerationScheme());
        this.jCBPositionning.setSelected(this.getParam().getQualityLevel());
        this.jCBAutoCentering.setSelected(this.getParam().getAutoCentering());
    }

    public static final String toHexString(Color colour) {
        Object hexColour = Integer.toHexString(colour.getRGB() & 0xFFFFFF);
        if (((String)hexColour).length() < 6) {
            hexColour = "000000".substring(0, 6 - ((String)hexColour).length()) + (String)hexColour;
        }
        return "#" + (String)hexColour;
    }

    private GraphParameter getParam() {
        return this.theGTC.getGraphParam();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabelColor = new JLabel();
        this.labelColorDefault = new JLabel();
        this.colorButtonDefault = new ColorChooserButton();
        this.labelColorCujus = new JLabel();
        this.colorButtonCujus = new ColorChooserButton();
        this.labelColorSosa = new JLabel();
        this.colorButtonSosa = new ColorChooserButton();
        this.labelColorMariage = new JLabel();
        this.colorButtonMarriage = new ColorChooserButton();
        this.labelColorMariageSosa = new JLabel();
        this.colorButtonMarriageSosa = new ColorChooserButton();
        this.labelColorAssociation = new JLabel();
        this.colorButtonAssociation = new ColorChooserButton();
        this.labelColorSelected = new JLabel();
        this.colorButtonSelected = new ColorChooserButton();
        this.labelColorBackground = new JLabel();
        this.colorButtonBackground = new ColorChooserButton();
        this.jCheckBoxColorScheme = new JCheckBox();
        this.jLabelNode = new JLabel();
        this.labelDefaultNodeSize = new JLabel();
        this.jTextFieldDefaultNodeSize = new JTextField();
        this.jLabelpx = new JLabel();
        this.labelCujusNodeSize = new JLabel();
        this.jTextFieldCujusNodeSize = new JTextField();
        this.jLabel5 = new JLabel();
        this.labelSosaNodeSize = new JLabel();
        this.jTextFieldSosaNodeSize = new JTextField();
        this.jLabel3 = new JLabel();
        this.labelSelectedNodeSize = new JLabel();
        this.jTextFieldSelectedNodeSize = new JTextField();
        this.jLabelpx6 = new JLabel();
        this.jLabelEdge = new JLabel();
        this.labelDefaultEdgeSize = new JLabel();
        this.jTextFieldDefaultEdgeSize = new JTextField();
        this.jLabelpx2 = new JLabel();
        this.labelSosaEdgeSize = new JLabel();
        this.jTextFieldSosaEdgeSize = new JTextField();
        this.jLabelpx4 = new JLabel();
        this.labelSelectedEdgeSize = new JLabel();
        this.jTextFieldSelectedEdgeSize = new JTextField();
        this.jLabelpx5 = new JLabel();
        this.jLabelAutoPositionning = new JLabel();
        this.labelIndiNodeWeight = new JLabel();
        this.jTextFieldIndiNodeWeght = new JTextField();
        this.labelFamNodeWeight = new JLabel();
        this.jTextFieldFamNodeWeght = new JTextField();
        this.labelEdgeWeight = new JLabel();
        this.jTextFieldEdgeWeight = new JTextField();
        this.jCBPositionning = new JCheckBox();
        this.jCBAutoCentering = new JCheckBox();
        this.jLabelLabels = new JLabel();
        this.jLabel6 = new JLabel();
        this.jComboBoxIndiLabels = new JComboBox<LabelIndiEnum>(this.labelIndi);
        this.jLabel7 = new JLabel();
        this.jComboBoxFamLabels = new JComboBox<LabelFamEnum>(this.labelFam);
        this.jButtonApply = new JButton();
        this.jButtonReset = new JButton();
        this.jPanel1.setPreferredSize(new Dimension(710, 530));
        this.jLabelColor.setFont(this.jLabelColor.getFont().deriveFont(this.jLabelColor.getFont().getStyle() | 1, this.jLabelColor.getFont().getSize() + 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelColor, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabelColor.text"));
        this.jLabelColor.setMaximumSize(new Dimension(500, 40));
        this.jLabelColor.setMinimumSize(new Dimension(220, 40));
        Mnemonics.setLocalizedText((JLabel)this.labelColorDefault, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorDefault.text"));
        this.colorButtonDefault.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonDefault.toolTipText"));
        this.colorButtonDefault.setMaximumSize(new Dimension(50, 25));
        this.colorButtonDefault.setMinimumSize(new Dimension(50, 25));
        this.colorButtonDefault.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.labelColorCujus, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorCujus.text"));
        this.colorButtonCujus.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonCujus.toolTipText"));
        this.colorButtonCujus.setMaximumSize(new Dimension(50, 25));
        this.colorButtonCujus.setMinimumSize(new Dimension(50, 25));
        this.colorButtonCujus.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.labelColorSosa, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorSosa.text"));
        this.colorButtonSosa.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonSosa.toolTipText"));
        this.colorButtonSosa.setMaximumSize(new Dimension(50, 25));
        this.colorButtonSosa.setMinimumSize(new Dimension(50, 25));
        this.colorButtonSosa.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.labelColorMariage, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorMariage.text"));
        this.colorButtonMarriage.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonMarriage.toolTipText"));
        this.colorButtonMarriage.setMaximumSize(new Dimension(50, 25));
        this.colorButtonMarriage.setMinimumSize(new Dimension(50, 25));
        this.colorButtonMarriage.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.labelColorMariageSosa, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorMariageSosa.text"));
        this.colorButtonMarriageSosa.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonMarriageSosa.toolTipText"));
        this.colorButtonMarriageSosa.setMaximumSize(new Dimension(50, 25));
        this.colorButtonMarriageSosa.setMinimumSize(new Dimension(50, 25));
        this.colorButtonMarriageSosa.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.labelColorAssociation, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorAssociation.text"));
        this.colorButtonAssociation.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonAssociation.toolTipText"));
        this.colorButtonAssociation.setMaximumSize(new Dimension(50, 25));
        this.colorButtonAssociation.setMinimumSize(new Dimension(50, 25));
        this.colorButtonAssociation.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.labelColorSelected, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorSelected.text"));
        this.colorButtonSelected.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonSelected.toolTipText"));
        this.colorButtonSelected.setMaximumSize(new Dimension(50, 25));
        this.colorButtonSelected.setMinimumSize(new Dimension(50, 25));
        this.colorButtonSelected.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.labelColorBackground, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorBackground.text_1"));
        this.colorButtonBackground.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonBackground.toolTipText_1"));
        this.colorButtonBackground.setMaximumSize(new Dimension(50, 25));
        this.colorButtonBackground.setMinimumSize(new Dimension(50, 25));
        this.colorButtonBackground.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxColorScheme, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jCheckBoxColorScheme.text"));
        this.jCheckBoxColorScheme.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jCheckBoxColorScheme.toolTipText"));
        this.jLabelNode.setFont(this.jLabelNode.getFont().deriveFont(this.jLabelNode.getFont().getStyle() | 1, this.jLabelNode.getFont().getSize() + 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelNode, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabelNode.text"));
        this.jLabelNode.setMaximumSize(new Dimension(500, 40));
        this.jLabelNode.setMinimumSize(new Dimension(220, 40));
        Mnemonics.setLocalizedText((JLabel)this.labelDefaultNodeSize, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelDefaultNodeSize.text"));
        this.jTextFieldDefaultNodeSize.setHorizontalAlignment(0);
        this.jTextFieldDefaultNodeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldDefaultNodeSize.text"));
        this.jTextFieldDefaultNodeSize.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldDefaultNodeSize.toolTipText"));
        this.jTextFieldDefaultNodeSize.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldDefaultNodeSize.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.jLabelpx, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabelpx.text"));
        this.jLabelpx.setMaximumSize(new Dimension(20, 25));
        this.jLabelpx.setPreferredSize(new Dimension(20, 25));
        Mnemonics.setLocalizedText((JLabel)this.labelCujusNodeSize, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelCujusNodeSize.text"));
        this.jTextFieldCujusNodeSize.setHorizontalAlignment(0);
        this.jTextFieldCujusNodeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldCujusNodeSize.text"));
        this.jTextFieldCujusNodeSize.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldCujusNodeSize.toolTipText"));
        this.jTextFieldCujusNodeSize.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldCujusNodeSize.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabel5.text"));
        this.jLabel5.setMaximumSize(new Dimension(20, 25));
        this.jLabel5.setPreferredSize(new Dimension(20, 25));
        Mnemonics.setLocalizedText((JLabel)this.labelSosaNodeSize, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelSosaNodeSize.text"));
        this.jTextFieldSosaNodeSize.setHorizontalAlignment(0);
        this.jTextFieldSosaNodeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldSosaNodeSize.text"));
        this.jTextFieldSosaNodeSize.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldSosaNodeSize.toolTipText"));
        this.jTextFieldSosaNodeSize.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldSosaNodeSize.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabel3.text"));
        this.jLabel3.setMaximumSize(new Dimension(20, 25));
        this.jLabel3.setPreferredSize(new Dimension(20, 25));
        Mnemonics.setLocalizedText((JLabel)this.labelSelectedNodeSize, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelSelectedNodeSize.text"));
        this.jTextFieldSelectedNodeSize.setHorizontalAlignment(0);
        this.jTextFieldSelectedNodeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldSelectedNodeSize.text"));
        this.jTextFieldSelectedNodeSize.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldSelectedNodeSize.toolTipText"));
        this.jTextFieldSelectedNodeSize.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldSelectedNodeSize.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.jLabelpx6, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabelpx6.text"));
        this.jLabelEdge.setFont(this.jLabelEdge.getFont().deriveFont(this.jLabelEdge.getFont().getStyle() | 1, this.jLabelEdge.getFont().getSize() + 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelEdge, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabelEdge.text"));
        this.jLabelEdge.setMaximumSize(new Dimension(500, 40));
        this.jLabelEdge.setMinimumSize(new Dimension(220, 40));
        Mnemonics.setLocalizedText((JLabel)this.labelDefaultEdgeSize, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelDefaultEdgeSize.text"));
        this.jTextFieldDefaultEdgeSize.setHorizontalAlignment(0);
        this.jTextFieldDefaultEdgeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldDefaultEdgeSize.text"));
        this.jTextFieldDefaultEdgeSize.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldDefaultEdgeSize.toolTipText"));
        this.jTextFieldDefaultEdgeSize.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldDefaultEdgeSize.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.jLabelpx2, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabelpx2.text"));
        this.jLabelpx2.setMaximumSize(new Dimension(20, 25));
        this.jLabelpx2.setPreferredSize(new Dimension(20, 25));
        Mnemonics.setLocalizedText((JLabel)this.labelSosaEdgeSize, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelSosaEdgeSize.text"));
        this.jTextFieldSosaEdgeSize.setHorizontalAlignment(0);
        this.jTextFieldSosaEdgeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldSosaEdgeSize.text"));
        this.jTextFieldSosaEdgeSize.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldSosaEdgeSize.toolTipText"));
        this.jTextFieldSosaEdgeSize.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldSosaEdgeSize.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.jLabelpx4, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabelpx4.text"));
        this.jLabelpx4.setMaximumSize(new Dimension(20, 25));
        this.jLabelpx4.setPreferredSize(new Dimension(20, 25));
        Mnemonics.setLocalizedText((JLabel)this.labelSelectedEdgeSize, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelSelectedEdgeSize.text"));
        this.jTextFieldSelectedEdgeSize.setHorizontalAlignment(0);
        this.jTextFieldSelectedEdgeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldSelectedEdgeSize.text"));
        this.jTextFieldSelectedEdgeSize.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldSelectedEdgeSize.toolTipText"));
        this.jTextFieldSelectedEdgeSize.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldSelectedEdgeSize.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.jLabelpx5, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabelpx5.text"));
        this.jLabelpx5.setMaximumSize(new Dimension(20, 25));
        this.jLabelpx5.setPreferredSize(new Dimension(20, 25));
        this.jLabelAutoPositionning.setFont(this.jLabelAutoPositionning.getFont().deriveFont(this.jLabelAutoPositionning.getFont().getStyle() | 1, this.jLabelAutoPositionning.getFont().getSize() + 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelAutoPositionning, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabelAutoPositionning.text"));
        this.jLabelAutoPositionning.setMaximumSize(new Dimension(500, 40));
        this.jLabelAutoPositionning.setMinimumSize(new Dimension(220, 40));
        Mnemonics.setLocalizedText((JLabel)this.labelIndiNodeWeight, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelIndiNodeWeight.text"));
        this.jTextFieldIndiNodeWeght.setHorizontalAlignment(0);
        this.jTextFieldIndiNodeWeght.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldIndiNodeWeght.text"));
        this.jTextFieldIndiNodeWeght.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldIndiNodeWeght.toolTipText"));
        this.jTextFieldIndiNodeWeght.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldIndiNodeWeght.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.labelFamNodeWeight, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelFamNodeWeight.text"));
        this.jTextFieldFamNodeWeght.setHorizontalAlignment(0);
        this.jTextFieldFamNodeWeght.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldFamNodeWeght.text"));
        this.jTextFieldFamNodeWeght.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldFamNodeWeght.toolTipText"));
        this.jTextFieldFamNodeWeght.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldFamNodeWeght.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.labelEdgeWeight, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelEdgeWeight.text"));
        this.jTextFieldEdgeWeight.setHorizontalAlignment(0);
        this.jTextFieldEdgeWeight.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldEdgeWeight.text"));
        this.jTextFieldEdgeWeight.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldEdgeWeight.toolTipText"));
        this.jTextFieldEdgeWeight.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldEdgeWeight.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((AbstractButton)this.jCBPositionning, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jCBPositionning.text"));
        this.jCBPositionning.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jCBPositionning.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCBAutoCentering, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jCBAutoCentering.text"));
        this.jCBAutoCentering.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jCBAutoCentering.toolTipText"));
        this.jLabelLabels.setFont(this.jLabelLabels.getFont().deriveFont(this.jLabelLabels.getFont().getStyle() | 1, this.jLabelLabels.getFont().getSize() + 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelLabels, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabelLabels.text"));
        this.jLabelLabels.setMaximumSize(new Dimension(500, 40));
        this.jLabelLabels.setMinimumSize(new Dimension(220, 40));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabel6.text"));
        this.jComboBoxIndiLabels.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jComboBoxIndiLabels.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabel7.text"));
        this.jLabel7.setMaximumSize(new Dimension(150, 25));
        this.jLabel7.setMinimumSize(new Dimension(150, 25));
        this.jComboBoxFamLabels.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jComboBoxFamLabels.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonApply, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jButtonApply.text"));
        this.jButtonApply.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jButtonApply.toolTipText"));
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphSettings.this.jButtonApplyActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonReset, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jButtonReset.text"));
        this.jButtonReset.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jButtonReset.toolTipText"));
        this.jButtonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphSettings.this.jButtonResetActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelAutoPositionning, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelFamNodeWeight).addComponent(this.labelIndiNodeWeight).addComponent(this.labelEdgeWeight)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldFamNodeWeght, -2, -1, -2).addComponent(this.jTextFieldIndiNodeWeght, -2, 50, -2).addComponent(this.jTextFieldEdgeWeight, -2, -1, -2))).addComponent(this.jCBPositionning).addComponent(this.jCBAutoCentering)))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(30, 30, 30).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelLabels, -2, -1, -2).addComponent(this.jLabelNode, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxFamLabels, -2, -1, -2).addComponent(this.jComboBoxIndiLabels, -2, -1, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelDefaultNodeSize).addComponent(this.labelCujusNodeSize).addComponent(this.labelSosaNodeSize).addComponent(this.labelSelectedNodeSize)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldDefaultNodeSize, -2, -1, -2).addComponent(this.jTextFieldCujusNodeSize, -2, -1, -2).addComponent(this.jTextFieldSosaNodeSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelpx, -2, -1, -2).addComponent(this.jLabel5, -2, -1, -2).addComponent(this.jLabel3, -2, -1, -2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldSelectedNodeSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelpx6))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelEdge, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelDefaultEdgeSize).addComponent(this.labelSosaEdgeSize).addComponent(this.labelSelectedEdgeSize)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldSelectedEdgeSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelpx5, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldDefaultEdgeSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelpx2, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldSosaEdgeSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelpx4, -2, -1, -2))))))))).addGap(68, 68, 68)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonApply).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonReset).addContainerGap(387, Short.MAX_VALUE)))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelColor, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxColorScheme).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.labelColorSelected, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.labelColorBackground).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.colorButtonBackground, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.labelColorCujus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.colorButtonCujus, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelColorSosa).addComponent(this.labelColorMariage).addComponent(this.labelColorMariageSosa).addComponent(this.labelColorAssociation).addComponent(this.labelColorDefault)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 21, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.colorButtonSosa, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent((Component)this.colorButtonMarriage, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent((Component)this.colorButtonMarriageSosa, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent((Component)this.colorButtonAssociation, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent((Component)this.colorButtonSelected, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent((Component)this.colorButtonDefault, GroupLayout.Alignment.TRAILING, -2, -1, -2))))))).addContainerGap(512, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelColor, -2, -1, -2).addComponent(this.jLabelNode, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelColorDefault).addComponent((Component)this.colorButtonDefault, -2, -1, -2).addComponent(this.labelDefaultNodeSize).addComponent(this.jTextFieldDefaultNodeSize, -2, -1, -2).addComponent(this.jLabelpx, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelColorCujus).addComponent((Component)this.colorButtonCujus, -2, -1, -2).addComponent(this.labelCujusNodeSize).addComponent(this.jTextFieldCujusNodeSize, -2, -1, -2).addComponent(this.jLabel5, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelColorSosa).addComponent((Component)this.colorButtonSosa, -2, -1, -2).addComponent(this.labelSosaNodeSize).addComponent(this.jTextFieldSosaNodeSize, -2, -1, -2).addComponent(this.jLabel3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelColorMariage).addComponent((Component)this.colorButtonMarriage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelColorMariageSosa).addComponent((Component)this.colorButtonMarriageSosa, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelColorAssociation).addComponent((Component)this.colorButtonAssociation, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelColorSelected).addComponent((Component)this.colorButtonSelected, -2, -1, -2).addComponent(this.labelSelectedNodeSize).addComponent(this.jTextFieldSelectedNodeSize, -2, -1, -2).addComponent(this.jLabelpx6))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelEdge, -2, -1, -2).addGap(186, 186, 186)).addGroup(jPanel1Layout.createSequentialGroup().addGap(24, 24, 24).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelpx2, -2, -1, -2).addComponent(this.jTextFieldDefaultEdgeSize, -2, -1, -2).addComponent(this.labelDefaultEdgeSize)).addGap(37, 37, 37).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelpx4, -2, -1, -2).addComponent(this.jTextFieldSosaEdgeSize, -2, -1, -2).addComponent(this.labelSosaEdgeSize)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelpx5, -2, -1, -2).addComponent(this.jTextFieldSelectedEdgeSize, -2, -1, -2).addComponent(this.labelSelectedEdgeSize)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelColorBackground).addComponent((Component)this.colorButtonBackground, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxColorScheme).addGap(30, 30, 30).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelAutoPositionning, -2, -1, -2).addComponent(this.jLabelLabels, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelIndiNodeWeight).addComponent(this.jTextFieldIndiNodeWeght, -2, 25, -2).addComponent(this.jLabel6).addComponent(this.jComboBoxIndiLabels, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelFamNodeWeight).addComponent(this.jTextFieldFamNodeWeght, -2, -1, -2).addComponent(this.jLabel7, -2, -1, -2).addComponent(this.jComboBoxFamLabels, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelEdgeWeight).addComponent(this.jTextFieldEdgeWeight, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCBPositionning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCBAutoCentering).addComponent(this.jButtonApply).addComponent(this.jButtonReset)).addContainerGap(24, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1).addGap(0, 0, 0)));
    }

    private void jButtonResetActionPerformed(ActionEvent evt) {
        GraphParameter gp = new GraphParameter();
        gp.setAutoDisplay(this.getParam().isAutoDisplay());
        gp.setCenterGraph(this.getParam().isCenterGraph());
        gp.setShowLabel(this.getParam().isShowLabel());
        gp.setHideNodes(this.getParam().isHideNodes());
        this.theGTC.setGraphParam(gp);
        this.theGTC.updateCss();
        this.theGTC.updateWeight();
        this.initValues();
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        this.getParam().setSizeCujus(this.jTextFieldCujusNodeSize.getText());
        this.getParam().setSizeEdgeSosa(this.jTextFieldSosaEdgeSize.getText());
        this.getParam().setSizeNodeSosa(this.jTextFieldSosaNodeSize.getText());
        this.getParam().setSizeEdgeSelected(this.jTextFieldSelectedEdgeSize.getText());
        this.getParam().setSizeNodeSelected(this.jTextFieldSelectedNodeSize.getText());
        this.getParam().setSizeEdge(this.jTextFieldDefaultEdgeSize.getText());
        this.getParam().setSizeNode(this.jTextFieldDefaultNodeSize.getText());
        this.getParam().setLabelFam((LabelFamEnum)((Object)this.jComboBoxFamLabels.getSelectedItem()));
        this.getParam().setLabelIndi((LabelIndiEnum)((Object)this.jComboBoxIndiLabels.getSelectedItem()));
        this.getParam().setUseGenerationScheme(this.jCheckBoxColorScheme.isSelected());
        this.theGTC.updateCss();
        this.getParam().setEdgeWeight(Double.parseDouble(this.jTextFieldEdgeWeight.getText()));
        this.getParam().setIndiNodeWeight(Double.parseDouble(this.jTextFieldIndiNodeWeght.getText()));
        this.getParam().setMariageNodeWeight(Double.parseDouble(this.jTextFieldFamNodeWeght.getText()));
        this.getParam().setQualityLevel(this.jCBPositionning.isSelected());
        this.getParam().setAutoCentering(this.jCBAutoCentering.isSelected());
        this.theGTC.updateWeight();
    }
}

