/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.gedcom.GedcomDirectory;
import ancestris.util.Utilities;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyNote;
import java.util.Collection;
import java.util.List;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;

public class IndiQuickSearch
implements SearchProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(SearchRequest request, SearchResponse response) {
        String req = request.getText();
        IndiQuickSearch indiQuickSearch = this;
        synchronized (indiQuickSearch) {
            List contexts = GedcomDirectory.getDefault().getContexts();
            boolean many = contexts.size() > 1;
            int index = 0;
            for (Context context : contexts) {
                String gedcomName = context.getGedcom().getDisplayName();
                Collection people = context.getGedcom().getIndis();
                for (Indi indi : people) {
                    if (!Utilities.wordsMatch((String)this.getStringFromIndi(indi), (String)req)) continue;
                    String sosaStr = indi.getSosaString();
                    String indiName = indi.toString(true) + (String)(sosaStr.isEmpty() ? "" : " [" + indi.getSosaString() + "]");
                    if (response.addResult(this.createAction((Entity)indi), Utilities.createHtmlDisplayName((String)indiName, (String)req, (int)index, (String)(many ? gedcomName : "")))) continue;
                    return;
                }
                ++index;
            }
        }
    }

    private Runnable createAction(Entity entity) {
        return () -> SelectionDispatcher.fireSelection((Context)new Context(entity));
    }

    private String getStringFromIndi(Indi indi) {
        String nick;
        PropertyName nameP;
        String[] firstnames;
        String[] names;
        Object ret = "";
        for (String name : names = indi.getLastNames()) {
            ret = (String)ret + name + " ";
        }
        for (String firstname : firstnames = indi.getFirstNames()) {
            ret = (String)ret + firstname + " ";
        }
        ret = (String)ret + indi.toString(true);
        String sosaStr = indi.getSosaString();
        if (!sosaStr.isEmpty()) {
            ret = (String)ret + " [" + sosaStr + "]";
        }
        if ((nameP = indi.getNameProperty()) instanceof PropertyName && !(nick = nameP.getNick()).isEmpty()) {
            ret = (String)ret + " " + nick;
        }
        List properties = indi.getAllProperties("NOTE");
        for (Property noteProp : properties) {
            String text;
            if (noteProp == null || noteProp instanceof PropertyNote || (text = noteProp.getDisplayValue().replaceAll("(\\r|\\n)", "").trim()).isEmpty()) continue;
            ret = (String)ret + " " + text;
        }
        return ((String)ret).toLowerCase();
    }
}

