/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook;

import ancestris.modules.webbook.Log;
import ancestris.modules.webbook.WebBook;
import genj.gedcom.Gedcom;
import java.util.MissingResourceException;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WebBookStarter {
    private final Gedcom gedcom;
    private final Log log;
    private static RequestProcessor RP = null;
    private RequestProcessor.Task theTask = null;

    public WebBookStarter(Gedcom gedcom) {
        this.gedcom = gedcom;
        String logname = gedcom.getRegistry().get("webbook.logFile", "");
        this.log = new Log(logname, NbBundle.getMessage(WebBookStarter.class, (String)"OpenIDE-Module-Name") + " " + gedcom.getDisplayName());
    }

    public synchronized void start() {
        final ProgressHandle ph = ProgressHandle.createHandle((String)NbBundle.getMessage(WebBookStarter.class, (String)"TASK_WebBookExecution"), () -> this.handleCancel());
        Runnable runnable = new Runnable(){

            @Override
            public synchronized void run() {
                ph.start();
                this.execute();
            }

            private void execute() {
                WebBookStarter.this.log.write(NbBundle.getMessage(WebBookStarter.class, (String)"TASK_WebBookExecutionStart"));
                try {
                    new WebBook(WebBookStarter.this.gedcom, WebBookStarter.this.log);
                    if (WebBookStarter.this.log.endSuccessful) {
                        WebBookStarter.this.log.write(WebBookStarter.this.log.NORMAL, NbBundle.getMessage(WebBookStarter.class, (String)"TASK_WebBookExecutionSuccess"));
                    } else {
                        WebBookStarter.this.log.write(WebBookStarter.this.log.ERROR, NbBundle.getMessage(WebBookStarter.class, (String)"TASK_WebBookExecutionFailed"));
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (MissingResourceException ex) {
                    WebBookStarter.this.log.printStackTrace(ex);
                    Thread.currentThread().interrupt();
                }
            }
        };
        if (RP == null) {
            RP = new RequestProcessor("WebBookStarter", 1, true);
        }
        this.theTask = RP.create(runnable);
        this.theTask.addTaskListener(task -> {
            ph.finish();
            this.log.close();
        });
        this.theTask.schedule(0);
    }

    private boolean handleCancel() {
        if (null == this.theTask) {
            return false;
        }
        this.log.write(this.log.ERROR, NbBundle.getMessage(WebBookStarter.class, (String)"TASK_WebBookExecutionStopped"));
        return this.theTask.cancel();
    }
}

