/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.history;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.core.pluginservice.PluginInterface;
import ancestris.gedcom.GedcomDirectory;
import ancestris.modules.gedcom.history.GedcomHistory;
import ancestris.modules.gedcom.history.GedcomHistoryPlugin;
import ancestris.modules.gedcom.history.GedcomHistoryTableModel;
import ancestris.util.swing.DialogManager;
import ancestris.view.AncestrisTopComponent;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.time.PointInTime;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.openide.awt.Mnemonics;
import org.openide.modules.Places;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class GedcomHistoryTopComponent
extends AncestrisTopComponent
implements ChangeListener,
LookupListener {
    private static final String PREFERRED_ID = "GedcomHistoryTopComponent";
    private static final Logger log = Logger.getLogger(GedcomHistoryTopComponent.class.getName());
    private GedcomHistory gedcomHistory = null;
    private GedcomHistoryTableModel historyTableModel = null;
    private Gedcom gedcom = null;
    static final String ICON_PATH = "ancestris/modules/gedcom/history/DisplayHistoryIcon.png";
    private JScrollPane gedcomHistoryScrollPane;
    private JTable gedcomHistoryTable;
    private JButton jButton1;
    private JLabel jLabel1;

    public String getAncestrisDockMode() {
        return "ancestris-table";
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void resultChanged(LookupEvent le) {
        Context context = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        this.setEnabled(context != null && !context.getProperties().isEmpty());
    }

    public GedcomHistoryTopComponent() {
        Context context = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        if (context == null) {
            List gedcontexts = GedcomDirectory.getDefault().getContexts();
            if (gedcontexts.isEmpty()) {
                return;
            }
            context = (Context)gedcontexts.get(0);
        }
        if (context != null) {
            for (PluginInterface pluginInterface : Lookup.getDefault().lookupAll(PluginInterface.class)) {
                if (!(pluginInterface instanceof GedcomHistoryPlugin)) continue;
                this.gedcomHistory = ((GedcomHistoryPlugin)pluginInterface).getGedcomHistory(context.getGedcom());
                if (this.gedcomHistory != null) {
                    this.gedcom = context.getGedcom();
                    this.historyTableModel = new GedcomHistoryTableModel(this.gedcomHistory, this.getGedcom());
                    this.initComponents();
                    this.setContext(context);
                    this.setName(context.getGedcom().getDisplayName());
                    this.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"HINT_GedcomHistoryTopComponent", (Object)context.getGedcom().getDisplayName()));
                    this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
                    this.jLabel1.setText(NbBundle.getMessage(this.getClass(), (String)"CTL_GedcomHistoryTopComponent"));
                    this.gedcomHistoryTable.getSelectionModel().addListSelectionListener(new RowListener());
                    this.gedcomHistoryTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focs, int row, int col) {
                            SimpleDateFormat dateFormat = new SimpleDateFormat(" HH:mm:ss");
                            if (value instanceof GregorianCalendar) {
                                PointInTime pit = new PointInTime((Calendar)((GregorianCalendar)value));
                                value = pit.getValue(false) + dateFormat.format(((GregorianCalendar)value).getTime());
                            }
                            return super.getTableCellRendererComponent(table, value, selected, focs, row, col);
                        }
                    });
                } else {
                    log.log(Level.FINE, "No history recorder found for {0}", context.getGedcom().getDisplayName());
                }
                this.gedcomHistoryTable.putClientProperty("print.printable", Boolean.TRUE);
                return;
            }
            log.log(Level.FINE, "No Instance of GedcomHistoryPlugin found");
        } else {
            log.log(Level.FINE, "No context found");
        }
    }

    private void initComponents() {
        this.gedcomHistoryScrollPane = new JScrollPane();
        this.gedcomHistoryTable = new JTable();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.gedcomHistoryTable.setAutoCreateRowSorter(true);
        this.gedcomHistoryTable.setModel(this.historyTableModel);
        this.gedcomHistoryScrollPane.setViewportView(this.gedcomHistoryTable);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/history/ClearHistoryIcon.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(GedcomHistoryTopComponent.class, (String)"GedcomHistoryTopComponent.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(GedcomHistoryTopComponent.class, (String)"GedcomHistoryTopComponent.jButton1.toolTipText"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomHistoryTopComponent.this.jButton1ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GedcomHistoryTopComponent.class, (String)"GedcomHistoryTopComponent.jLabel1.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1)).addComponent(this.gedcomHistoryScrollPane, -1, 397, Short.MAX_VALUE)).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel1).addComponent(this.jButton1)).addGap(0, 0, 0).addComponent(this.gedcomHistoryScrollPane, -1, 276, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        DialogManager dm = DialogManager.createYesNo((String)NbBundle.getMessage(GedcomHistoryTopComponent.class, (String)"delete.Title"), (String)NbBundle.getMessage(GedcomHistoryTopComponent.class, (String)"delete.Text"));
        if (DialogManager.YES_OPTION.equals(dm.show())) {
            String gedcomName = this.gedcom.getName().substring(0, this.gedcom.getName().lastIndexOf(".") == -1 ? this.gedcom.getName().length() : this.gedcom.getName().lastIndexOf("."));
            File cacheSubdirectory = Places.getCacheSubdirectory((String)"ModificationsHistory");
            File historyFile = new File(cacheSubdirectory.getAbsolutePath() + System.getProperty("file.separator") + gedcomName + ".hist");
            if (historyFile.exists()) {
                historyFile.delete();
            }
            this.gedcomHistory.clear();
            this.historyTableModel.fireTableDataChanged();
        }
    }

    public void componentOpened() {
        AncestrisPlugin.register((Object)this);
        if (this.gedcomHistory != null) {
            this.gedcomHistory.addChangeListener(this);
        }
    }

    public void componentClosed() {
        AncestrisPlugin.unregister((Object)this);
        if (this.gedcomHistory != null) {
            this.gedcomHistory.removeChangeListener(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.historyTableModel.fireTableRowsInserted(this.gedcomHistory.getHistoryList().size() - 1, this.gedcomHistory.getHistoryList().size() - 1);
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    private class RowListener
    implements ListSelectionListener {
        private RowListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            Entity entity;
            if (event.getValueIsAdjusting()) {
                return;
            }
            String currentId = (String)GedcomHistoryTopComponent.this.historyTableModel.getValueAt(GedcomHistoryTopComponent.this.gedcomHistoryTable.convertRowIndexToModel(GedcomHistoryTopComponent.this.gedcomHistoryTable.getSelectedRow()), 2);
            if (currentId != null && GedcomHistoryTopComponent.this.getGedcom() != null && (entity = GedcomHistoryTopComponent.this.getGedcom().getEntity(currentId)) != null) {
                SelectionDispatcher.fireSelection((Context)new Context(entity));
            }
        }
    }
}

