/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve;

import ancestris.modules.releve.dnd.TransferableRecord;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.DataManager;
import ancestris.modules.releve.table.ReleveTable;
import ancestris.modules.releve.table.TableModelRecordAbstract;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class RecordTransferHandle
extends TransferHandler {
    private final DataManager dataManager;

    public RecordTransferHandle(DataManager dataManager) {
        this.dataManager = dataManager;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public Transferable createTransferable(JComponent component) {
        if (component instanceof ReleveTable) {
            ReleveTable table = (ReleveTable)component;
            TableModelRecordAbstract model = (TableModelRecordAbstract)table.getModel();
            AbstractRecord record = model.getRecord(table.convertRowIndexToModel(table.getSelectedRow()));
            String fileName = this.dataManager.getCurrentFile() != null ? this.dataManager.getCurrentFile().getName() : "";
            TransferableRecord.TransferableData data = RecordTransferHandle.createTransferableData(component, fileName, record);
            return new TransferableRecord(data);
        }
        return null;
    }

    public static TransferableRecord.TransferableData createTransferableData(JComponent component, String fileName, AbstractRecord record) {
        TransferableRecord.TransferableData data = new TransferableRecord.TransferableData();
        data.sourceComponent = component;
        data.fileName = fileName;
        data.cityName = record.getPlace().getCityName();
        data.cityCode = record.getPlace().getCityCode();
        data.countyName = record.getPlace().getCountyName();
        data.stateName = record.getPlace().getStateName();
        data.countryName = record.getPlace().getCountryName();
        data.recordType = record.getType().name();
        data.eventTag = record.getFieldValue(AbstractRecord.FieldType.eventTag);
        data.eventType = record.getFieldValue(AbstractRecord.FieldType.eventType);
        data.cote = record.getFieldValue(AbstractRecord.FieldType.cote);
        data.freeComment = record.getFieldValue(AbstractRecord.FieldType.freeComment);
        data.eventDate = record.getFieldValue(AbstractRecord.FieldType.eventDate);
        data.secondDate = record.getFieldValue(AbstractRecord.FieldType.secondDate);
        data.notary = record.getFieldValue(AbstractRecord.FieldType.notary);
        data.parish = record.getFieldValue(AbstractRecord.FieldType.parish);
        data.generalComment = record.getFieldValue(AbstractRecord.FieldType.generalComment);
        data.deedText = record.getFieldValue(AbstractRecord.FieldType.deedText);
        data.eventMedia = record.getFieldValue(AbstractRecord.FieldType.eventMedia);
        data.participant1.firstName = record.getFieldValue(AbstractRecord.FieldType.indiFirstName);
        data.participant1.lastName = record.getFieldValue(AbstractRecord.FieldType.indiLastName);
        data.participant1.sex = record.getFieldValue(AbstractRecord.FieldType.indiSex);
        data.participant1.age = record.getFieldValue(AbstractRecord.FieldType.indiAge);
        data.participant1.birthDate = record.getFieldValue(AbstractRecord.FieldType.indiBirthDate);
        data.participant1.birthPlace = record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace);
        data.participant1.birthAddress = record.getFieldValue(AbstractRecord.FieldType.indiBirthAddress);
        data.participant1.deathDate = record.getFieldValue(AbstractRecord.FieldType.indiDeathDate);
        data.participant1.deathPlace = record.getFieldValue(AbstractRecord.FieldType.indiDeathPlace);
        data.participant1.deathAddress = record.getFieldValue(AbstractRecord.FieldType.indiDeathAddress);
        data.participant1.occupation = record.getFieldValue(AbstractRecord.FieldType.indiOccupation);
        data.participant1.residence = record.getFieldValue(AbstractRecord.FieldType.indiResidence);
        data.participant1.address = record.getFieldValue(AbstractRecord.FieldType.indiAddress);
        data.participant1.comment = record.getFieldValue(AbstractRecord.FieldType.indiComment);
        data.participant1.marriedFirstName = record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName);
        data.participant1.marriedLastName = record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName);
        data.participant1.marriedComment = record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment);
        data.participant1.marriedOccupation = record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation);
        data.participant1.marriedResidence = record.getFieldValue(AbstractRecord.FieldType.indiMarriedResidence);
        data.participant1.marriedAddress = record.getFieldValue(AbstractRecord.FieldType.indiMarriedAddress);
        data.participant1.marriedDead = record.getFieldValue(AbstractRecord.FieldType.indiMarriedDead);
        data.participant1.fatherFirstName = record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName);
        data.participant1.fatherLastName = record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName);
        data.participant1.fatherOccupation = record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation);
        data.participant1.fatherResidence = record.getFieldValue(AbstractRecord.FieldType.indiFatherResidence);
        data.participant1.fatherAddress = record.getFieldValue(AbstractRecord.FieldType.indiFatherAddress);
        data.participant1.fatherAge = record.getFieldValue(AbstractRecord.FieldType.indiFatherAge);
        data.participant1.fatherDead = record.getFieldValue(AbstractRecord.FieldType.indiFatherDead);
        data.participant1.fatherComment = record.getFieldValue(AbstractRecord.FieldType.indiFatherComment);
        data.participant1.motherFirstName = record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName);
        data.participant1.motherLastName = record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName);
        data.participant1.motherOccupation = record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation);
        data.participant1.motherResidence = record.getFieldValue(AbstractRecord.FieldType.indiMotherResidence);
        data.participant1.motherAddress = record.getFieldValue(AbstractRecord.FieldType.indiMotherAddress);
        data.participant1.motherAge = record.getFieldValue(AbstractRecord.FieldType.indiMotherAge);
        data.participant1.motherDead = record.getFieldValue(AbstractRecord.FieldType.indiMotherDead);
        data.participant1.motherComment = record.getFieldValue(AbstractRecord.FieldType.indiMotherComment);
        data.participant2.firstName = record.getFieldValue(AbstractRecord.FieldType.wifeFirstName);
        data.participant2.lastName = record.getFieldValue(AbstractRecord.FieldType.wifeLastName);
        data.participant2.sex = record.getFieldValue(AbstractRecord.FieldType.wifeSex);
        data.participant2.age = record.getFieldValue(AbstractRecord.FieldType.wifeAge);
        data.participant2.birthDate = record.getFieldValue(AbstractRecord.FieldType.wifeBirthDate);
        data.participant2.birthPlace = record.getFieldValue(AbstractRecord.FieldType.wifeBirthPlace);
        data.participant2.birthAddress = record.getFieldValue(AbstractRecord.FieldType.wifeBirthAddress);
        data.participant2.occupation = record.getFieldValue(AbstractRecord.FieldType.wifeOccupation);
        data.participant2.residence = record.getFieldValue(AbstractRecord.FieldType.wifeResidence);
        data.participant2.address = record.getFieldValue(AbstractRecord.FieldType.wifeAddress);
        data.participant2.comment = record.getFieldValue(AbstractRecord.FieldType.wifeComment);
        data.participant2.marriedFirstName = record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName);
        data.participant2.marriedLastName = record.getFieldValue(AbstractRecord.FieldType.wifeMarriedLastName);
        data.participant2.marriedComment = record.getFieldValue(AbstractRecord.FieldType.wifeMarriedComment);
        data.participant2.marriedOccupation = record.getFieldValue(AbstractRecord.FieldType.wifeMarriedOccupation);
        data.participant2.marriedResidence = record.getFieldValue(AbstractRecord.FieldType.wifeMarriedResidence);
        data.participant2.marriedAddress = record.getFieldValue(AbstractRecord.FieldType.wifeMarriedAddress);
        data.participant2.marriedDead = record.getFieldValue(AbstractRecord.FieldType.wifeMarriedDead);
        data.participant2.fatherFirstName = record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName);
        data.participant2.fatherLastName = record.getFieldValue(AbstractRecord.FieldType.wifeFatherLastName);
        data.participant2.fatherOccupation = record.getFieldValue(AbstractRecord.FieldType.wifeFatherOccupation);
        data.participant2.fatherResidence = record.getFieldValue(AbstractRecord.FieldType.wifeFatherResidence);
        data.participant2.fatherAddress = record.getFieldValue(AbstractRecord.FieldType.wifeFatherAddress);
        data.participant2.fatherAge = record.getFieldValue(AbstractRecord.FieldType.wifeFatherAge);
        data.participant2.fatherDead = record.getFieldValue(AbstractRecord.FieldType.wifeFatherDead);
        data.participant2.fatherComment = record.getFieldValue(AbstractRecord.FieldType.wifeFatherComment);
        data.participant2.motherFirstName = record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName);
        data.participant2.motherLastName = record.getFieldValue(AbstractRecord.FieldType.wifeMotherLastName);
        data.participant2.motherOccupation = record.getFieldValue(AbstractRecord.FieldType.wifeMotherOccupation);
        data.participant2.motherResidence = record.getFieldValue(AbstractRecord.FieldType.wifeMotherResidence);
        data.participant2.motherAddress = record.getFieldValue(AbstractRecord.FieldType.wifeMotherAddress);
        data.participant2.motherAge = record.getFieldValue(AbstractRecord.FieldType.wifeMotherAge);
        data.participant2.motherDead = record.getFieldValue(AbstractRecord.FieldType.wifeMotherDead);
        data.participant2.motherComment = record.getFieldValue(AbstractRecord.FieldType.wifeMotherComment);
        data.witness1.firstName = record.getFieldValue(AbstractRecord.FieldType.witness1FirstName);
        data.witness1.lastName = record.getFieldValue(AbstractRecord.FieldType.witness1LastName);
        data.witness1.occupation = record.getFieldValue(AbstractRecord.FieldType.witness1Occupation);
        data.witness1.comment = record.getFieldValue(AbstractRecord.FieldType.witness1Comment);
        data.witness2.firstName = record.getFieldValue(AbstractRecord.FieldType.witness2FirstName);
        data.witness2.lastName = record.getFieldValue(AbstractRecord.FieldType.witness2LastName);
        data.witness2.occupation = record.getFieldValue(AbstractRecord.FieldType.witness2Occupation);
        data.witness2.comment = record.getFieldValue(AbstractRecord.FieldType.witness2Comment);
        data.witness3.firstName = record.getFieldValue(AbstractRecord.FieldType.witness3FirstName);
        data.witness3.lastName = record.getFieldValue(AbstractRecord.FieldType.witness3LastName);
        data.witness3.occupation = record.getFieldValue(AbstractRecord.FieldType.witness3Occupation);
        data.witness3.comment = record.getFieldValue(AbstractRecord.FieldType.witness3Comment);
        data.witness4.firstName = record.getFieldValue(AbstractRecord.FieldType.witness4FirstName);
        data.witness4.lastName = record.getFieldValue(AbstractRecord.FieldType.witness4LastName);
        data.witness4.occupation = record.getFieldValue(AbstractRecord.FieldType.witness4Occupation);
        data.witness4.comment = record.getFieldValue(AbstractRecord.FieldType.witness4Comment);
        return data;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDataFlavorSupported(TransferableRecord.recordFlavor)) {
            return false;
        }
        try {
            TransferableRecord.TransferableData data = (TransferableRecord.TransferableData)support.getTransferable().getTransferData(TransferableRecord.recordFlavor);
            if (data.sourceComponent.equals(support.getComponent())) {
                return false;
            }
        }
        catch (UnsupportedFlavorException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
    }
}

