/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.merge.DoubleMetaphone;
import ancestris.modules.releve.merge.MergeLogger;
import ancestris.modules.releve.merge.MergeRecord;
import ancestris.modules.releve.merge.SimilarNameSet;
import ancestris.modules.releve.merge.SpouseFamily;
import ancestris.modules.releve.merge.SpouseTag;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

public class MergeQuery {
    protected static int minMarriageYearOld = 18;
    protected static int minParentYearOld = 18;
    protected static int minMajorityYearOld = 18;
    protected static int indiMaxYearOld = 100;
    protected static int aboutYear = 5;
    protected static int maxParentYearOld = 60;
    private static final DoubleMetaphone dm = new DoubleMetaphone();

    protected static List<Fam> findFamilyCompatibleWithParticipantParents(MergeRecord record, MergeRecord.RecordParticipant participant, Gedcom gedcom) throws Exception {
        ArrayList<Fam> parentFamilies = new ArrayList<Fam>();
        MergeRecord.RecordParent mergeFather = participant.getFather();
        MergeRecord.RecordParent mergeMother = participant.getMother();
        if (mergeFather.getLastName().isEmpty() && mergeFather.getFirstName().isEmpty() && mergeMother.getLastName().isEmpty() && mergeMother.getFirstName().isEmpty()) {
            if (MergeLogger.LOG.isLoggable(Level.FINER)) {
                MergeLogger.LOG.exiting(MergeQuery.class.getName(), "findFamilyCompatibleWithParticipantParents", parentFamilies);
            }
            return parentFamilies;
        }
        PropertyDate recordBirthDate = participant.getBirthDate();
        for (Fam fam : gedcom.getFamilies()) {
            Indi father = fam.getHusband();
            Indi mother = fam.getWife();
            if (father == null && mother == null) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s father == null && mother == null", fam));
                continue;
            }
            PropertyDate marriageDate = fam.getMarriageDate();
            if (marriageDate != null && marriageDate.isComparable()) {
                if (!MergeQuery.isRecordAfterThanDate(recordBirthDate, marriageDate, 0, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s birth\u00a8%s must be after marriage %s", fam, recordBirthDate, marriageDate));
                    continue;
                }
                if (!MergeQuery.isRecordAfterThanDate(participant.getDeathDate(), marriageDate, 0, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s death\u00a8%s must be after parent mariage %s", fam, participant.getDeathDate(), marriageDate));
                    continue;
                }
            }
            if (father != null) {
                if (!mergeFather.getLastName().isEmpty()) {
                    if (!MergeQuery.isSameLastName(mergeFather.getLastName(), father.getLastName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeFather.getLastName()\u00a8%s must be equal father.getLastName() %s %s", fam, mergeFather.getLastName(), father, father.getLastName()));
                        continue;
                    }
                } else if (!MergeQuery.isSameLastName(participant.getLastName(), father.getLastName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getLastName() %s must be equal father.getLastName() %s %s", fam, participant.getLastName(), father, father.getLastName()));
                    continue;
                }
                if (!(mergeFather.getFirstName().isEmpty() || father.getFirstName().isEmpty() || MergeQuery.isSameFirstName(mergeFather.getFirstName(), father.getFirstName()))) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeFather.getFirstName() %s must be equal father.getFirstName() %s %s", fam, mergeFather.getFirstName(), father, father.getFirstName()));
                    continue;
                }
                if (record.getRecordType() == MergeRecord.RecordType.BIRTH) {
                    if (!MergeQuery.isRecordAfterThanDate(recordBirthDate, father.getBirthDate(), 0, minParentYearOld)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s recordBirthDate %s must be after father.getBirthDate() %s %s + %dy", fam, recordBirthDate, father, father.getBirthDate(), minParentYearOld));
                        continue;
                    }
                } else if (record.getRecordType() == MergeRecord.RecordType.MARRIAGE && !MergeQuery.isRecordAfterThanDate(record.getEventDate(), father.getBirthDate(), 0, minParentYearOld + minMarriageYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s record.getEventDate %s must be after father.getBirthDate() %s %s + %dy", fam, record.getEventDate(), father, father.getBirthDate(), minParentYearOld + minMarriageYearOld));
                    continue;
                }
                if (!MergeQuery.isRecordBeforeThanDate(recordBirthDate, father.getDeathDate(), 9, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s recordBirthDate %s must be before father.getDeathDate() %s %s - %d month", fam, recordBirthDate, father, father.getDeathDate(), 9));
                    continue;
                }
            }
            if (mother != null) {
                if (!mergeMother.getLastName().isEmpty() && !MergeQuery.isSameLastName(mergeMother.getLastName(), mother.getLastName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeMother.getLastName()\u00a8%s must be same as mother.getLastName() %s %s", fam, mergeMother.getLastName(), mother, mother.getLastName()));
                    continue;
                }
                if (!(mergeMother.getFirstName().isEmpty() || mother.getFirstName().isEmpty() || MergeQuery.isSameFirstName(mergeMother.getFirstName(), mother.getFirstName()))) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeMother.getFirstName()\u00a8%s must be same as mother.getFirstName() %s %s", fam, mergeMother.getFirstName(), mother, mother.getFirstName()));
                    continue;
                }
                if (record.getRecordType() == MergeRecord.RecordType.BIRTH) {
                    if (!MergeQuery.isRecordAfterThanDate(recordBirthDate, mother.getBirthDate(), 0, minParentYearOld)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s recordBirthDate\u00a8%s must be after mother.getBirthDate() %s %s + %dy", fam, recordBirthDate, mother, mother.getBirthDate(), minParentYearOld));
                        continue;
                    }
                } else if (record.getRecordType() == MergeRecord.RecordType.MARRIAGE && !MergeQuery.isRecordAfterThanDate(record.getEventDate(), mother.getBirthDate(), 0, minParentYearOld + minMarriageYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s record.getEventDate()\u00a8%s must be after mother.getBirthDate() %s %s + %dy", fam, record.getEventDate(), mother, mother.getBirthDate(), minParentYearOld + minMarriageYearOld));
                    continue;
                }
                if (!MergeQuery.isRecordBeforeThanDate(recordBirthDate, mother.getDeathDate(), 0, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s recordBirthDate %s must be before mother.getDeathDate() %s %s ", fam, recordBirthDate, mother, mother.getDeathDate()));
                    continue;
                }
            }
            Indi[] children = fam.getChildren();
            boolean foundChild = false;
            for (int i = 0; i < children.length && !foundChild; ++i) {
                PropertyDate childBirth = children[i].getBirthDate();
                PointInTime maxChildPith = new PointInTime();
                PointInTime minChildPith = new PointInTime();
                if (childBirth == null || !childBirth.isComparable()) continue;
                if (childBirth.getFormat() == PropertyDate.DATE) {
                    minChildPith.set(childBirth.getStart());
                    maxChildPith.set(childBirth.getStart());
                } else if (childBirth.getFormat() == PropertyDate.BETWEEN_AND) {
                    minChildPith.set(childBirth.getStart());
                    maxChildPith.set(childBirth.getEnd());
                } else if (childBirth.getFormat() == PropertyDate.AFTER || childBirth.getFormat() == PropertyDate.FROM) {
                    minChildPith.set(recordBirthDate.getStart());
                    maxChildPith = childBirth.getStart();
                } else if (childBirth.getFormat() == PropertyDate.BEFORE || childBirth.getFormat() == PropertyDate.TO) {
                    minChildPith.set(childBirth.getStart());
                    maxChildPith.set(recordBirthDate.getStart());
                } else {
                    minChildPith.set(childBirth.getStart());
                    minChildPith.add(0, 0, -aboutYear);
                    maxChildPith.set(childBirth.getStart());
                    maxChildPith.add(0, 0, aboutYear);
                }
                Delta delta = Delta.get((PointInTime)maxChildPith, (PointInTime)recordBirthDate.getStart(), (Calendar)PointInTime.GREGORIAN);
                if (delta.getYears() > maxParentYearOld - minMarriageYearOld) {
                    foundChild = true;
                }
                if ((delta = Delta.get((PointInTime)recordBirthDate.getStart(), (PointInTime)maxChildPith, (Calendar)PointInTime.GREGORIAN)).getYears() <= maxParentYearOld - minMarriageYearOld) continue;
                foundChild = true;
            }
            if (foundChild) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s children found before %s", fam, recordBirthDate));
                continue;
            }
            if (!parentFamilies.contains(fam)) {
                parentFamilies.add(fam);
                continue;
            }
            if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
            MergeLogger.LOG.log(MergeLogger.getRefuse("%s already exists in parentFamilies", fam));
        }
        if (MergeLogger.LOG.isLoggable(Level.FINER)) {
            StringBuilder result = new StringBuilder("RETURN");
            for (Fam fam : parentFamilies) {
                result.append(" ").append(fam.getId());
            }
            MergeLogger.LOG.finer(result.toString());
        }
        return parentFamilies;
    }

    protected static List<SpouseFamily> findFamilyCompatibleWithParticipantMarried(MergeRecord record, MergeRecord.RecordParticipant participant, Gedcom gedcom) throws Exception {
        ArrayList<SpouseFamily> marriedFamilies = new ArrayList<SpouseFamily>();
        MergeRecord.RecordMarried mergeMarried = participant.getMarriedFamily().getMarried();
        if (mergeMarried.getLastName().isEmpty()) {
            if (MergeLogger.LOG.isLoggable(Level.FINER)) {
                MergeLogger.LOG.exiting(MergeQuery.class.getName(), "findFamilyCompatibleWithParticipantMarried", marriedFamilies);
            }
            return marriedFamilies;
        }
        for (Fam fam : gedcom.getFamilies()) {
            SpouseFamily spouse;
            Indi husband = fam.getHusband();
            Indi wife = fam.getWife();
            if (husband == null || wife == null) continue;
            if (participant.getSex() == 1) {
                if (!participant.getLastName().isEmpty() && !MergeQuery.isSameLastName(participant.getLastName(), husband.getLastName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s participant.getLastName() %s must be same as husband.getLastName() %s %s", fam, participant.getLastName(), husband, husband.getLastName()));
                    continue;
                }
                if (!participant.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(participant.getFirstName(), husband.getFirstName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s participant.getFirstName() %s must be same as husband.getFirstName() %s %s", fam, participant.getFirstName(), husband, husband.getFirstName()));
                    continue;
                }
                if (!MergeQuery.isRecordAfterThanDate(record.getEventDate(), husband.getBirthDate(), 0, minMarriageYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s record.getEventDate() %s must be after husband.getBirthDate() %s %s + %dy", fam, record.getEventDate(), husband, husband.getBirthDate(), minMarriageYearOld));
                    continue;
                }
                if (!MergeQuery.isCompatible(participant.getBirthDate(), husband.getBirthDate(), 1)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s participant.getBirthDate() %s must be compatible with husband.getBirthDate() %s %s", fam, participant.getBirthDate(), husband, husband.getBirthDate()));
                    continue;
                }
                if (!MergeQuery.isRecordBeforeThanDate(record.getEventDate(), husband.getDeathDate(), 0, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s record.getEventDate() %s must be before husband.getDeathDate() %s %s", fam, record.getEventDate(), husband, husband.getDeathDate()));
                    continue;
                }
                if (!mergeMarried.getLastName().isEmpty() && !MergeQuery.isSameLastName(mergeMarried.getLastName(), wife.getLastName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s mergeMarried.getLastName() %s must be same as wife.getLastName() %s %s", fam, mergeMarried.getLastName(), wife, wife.getLastName()));
                    continue;
                }
                if (!mergeMarried.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(mergeMarried.getFirstName(), wife.getFirstName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s mergeMarried.getFirstName() %s must be same as wife.getFirstName() %s %s", fam, mergeMarried.getFirstName(), wife, wife.getFirstName()));
                    continue;
                }
                if (!MergeQuery.isRecordAfterThanDate(record.getEventDate(), wife.getBirthDate(), 0, minMarriageYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s record.getEventDate() %s must after wife.getBirthDate() %s %s + %dy", fam, record.getEventDate(), wife, wife.getBirthDate(), minMarriageYearOld));
                    continue;
                }
                if (!MergeQuery.isRecordAfterThanDate(record.getEventDate(), fam.getMarriageDate(), 0, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s record.getEventDate() %s must after fam.getMarriageDate() %s", fam, record.getEventDate(), fam.getMarriageDate()));
                    continue;
                }
                if (!MergeQuery.isRecordAfterThanDate(record.getEventDate(), wife.getBirthDate(), 0, minMarriageYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s record.getEventDate() %s must after wife.getBirthDate() %s %s + %dy", fam, record.getEventDate(), wife, wife.getBirthDate(), minMarriageYearOld));
                    continue;
                }
                if (!MergeQuery.isCompatible(mergeMarried.getDeathDate(), wife.getDeathDate(), 1)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s mergeMarried.getDeathDate() %s must compatible with wife.getDeathDate() %s %s ", fam, mergeMarried.getDeathDate(), wife, wife.getDeathDate()));
                    continue;
                }
                if (MergeQuery.isRecordAfterThanDate(record.getEventDate(), wife.getDeathDate(), 0, 0)) {
                    if (!MergeQuery.isRecordAfterThanDate(record.getEventDate(), mergeMarried.getDeathDate(), 0, 0)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s record.getEventDate() %s must be after mergeMarried.getDeathDate() %s (married dead)", fam, record.getEventDate(), mergeMarried.getDeathDate()));
                        continue;
                    }
                } else if (!MergeQuery.isRecordBeforeThanDate(record.getEventDate(), mergeMarried.getDeathDate(), 0, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s record.getEventDate() %s must be before mergeMarried.getDeathDate() %s (married alive)", fam, record.getEventDate(), mergeMarried.getDeathDate()));
                    continue;
                }
                spouse = new SpouseFamily(fam, SpouseTag.HUSB);
            } else {
                if (!participant.getLastName().isEmpty() && !MergeQuery.isSameLastName(participant.getLastName(), wife.getLastName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s participant.getLastName() %s must be same as wife.getLastName() %s %s", fam, participant.getLastName(), wife, wife.getLastName()));
                    continue;
                }
                if (!participant.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(participant.getFirstName(), wife.getFirstName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s participant.getFirstName() %s must be same as wife.getFirstName() %s %s", fam, participant.getFirstName(), wife, wife.getFirstName()));
                    continue;
                }
                if (!MergeQuery.isRecordAfterThanDate(record.getEventDate(), wife.getBirthDate(), 0, minMarriageYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s record.getEventDate() %s must be after wife.getBirthDate() %s %s + %dy", fam, record.getEventDate(), wife, wife.getBirthDate(), minMarriageYearOld));
                    continue;
                }
                if (!MergeQuery.isCompatible(participant.getBirthDate(), wife.getBirthDate(), 1)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s participant.getBirthDate() %s must be compatible with wife.getBirthDate() %s %s", fam, participant.getBirthDate(), wife, wife.getBirthDate()));
                    continue;
                }
                if (!MergeQuery.isRecordBeforeThanDate(record.getEventDate(), wife.getDeathDate(), 0, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s record.getEventDate() %s must be before wife.getDeathDate() %s %s", fam, record.getEventDate(), wife, wife.getDeathDate()));
                    continue;
                }
                if (!mergeMarried.getLastName().isEmpty() && !MergeQuery.isSameLastName(mergeMarried.getLastName(), husband.getLastName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s mergeMarried.getLastName() %s must be same as husband.getLastName() %s %s", fam, mergeMarried.getLastName(), wife, husband.getLastName()));
                    continue;
                }
                if (!mergeMarried.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(mergeMarried.getFirstName(), husband.getFirstName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s mergeMarried.getFirstName() %s must be same as husband.getFirstName() %s %s", fam, mergeMarried.getFirstName(), wife, husband.getFirstName()));
                    continue;
                }
                if (!MergeQuery.isRecordAfterThanDate(record.getEventDate(), husband.getBirthDate(), 0, minMarriageYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s record.getEventDate() %s must after husband.getBirthDate() %s %s + %dy", fam, record.getEventDate(), husband, husband.getBirthDate(), minMarriageYearOld));
                    continue;
                }
                if (!MergeQuery.isRecordAfterThanDate(record.getEventDate(), fam.getMarriageDate(), 0, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s record.getEventDate() %s must after fam.getMarriageDate() %s", fam, record.getEventDate(), fam.getMarriageDate()));
                    continue;
                }
                if (!MergeQuery.isRecordAfterThanDate(record.getEventDate(), husband.getBirthDate(), 0, minMarriageYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s record.getEventDate() %s must after husband.getBirthDate() %s %s + %dy", fam, record.getEventDate(), husband, husband.getBirthDate(), minMarriageYearOld));
                    continue;
                }
                if (!MergeQuery.isCompatible(mergeMarried.getDeathDate(), husband.getDeathDate(), 1)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s mergeMarried.getDeathDate() %s must compatible with husband.getDeathDate() %s %s ", fam, mergeMarried.getDeathDate(), husband, husband.getDeathDate()));
                    continue;
                }
                if (MergeQuery.isRecordAfterThanDate(record.getEventDate(), husband.getDeathDate(), 0, 0)) {
                    if (!MergeQuery.isRecordAfterThanDate(record.getEventDate(), mergeMarried.getDeathDate(), 0, 0)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s record.getEventDate() %s must be after mergeMarried.getDeathDate() %s (married dead)", fam, record.getEventDate(), mergeMarried.getDeathDate()));
                        continue;
                    }
                } else if (!MergeQuery.isRecordBeforeThanDate(record.getEventDate(), mergeMarried.getDeathDate(), 0, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s record.getEventDate() %s must be before mergeMarried.getDeathDate() %s (married alive)", fam, record.getEventDate(), mergeMarried.getDeathDate()));
                    continue;
                }
                spouse = new SpouseFamily(fam, SpouseTag.WIFE);
            }
            if (marriedFamilies.contains(spouse)) continue;
            marriedFamilies.add(spouse);
        }
        if (MergeLogger.LOG.isLoggable(Level.FINER)) {
            StringBuilder result = new StringBuilder("RETURN marriedFamilies");
            for (SpouseFamily fam : marriedFamilies) {
                result.append(" ").append(fam.family.getId() + " " + fam.tag);
            }
            MergeLogger.LOG.finer(result.toString());
        }
        return marriedFamilies;
    }

    protected static List<Fam> findFamilyCompatibleWithMarriageRecord(MergeRecord marriageRecord, Gedcom gedcom, Fam selectedFamily) throws Exception {
        if (MergeLogger.LOG.isLoggable(Level.FINER)) {
            MergeLogger.LOG.entering(MergeQuery.class.getName(), "findFamilyCompatibleWithMarriageRecord");
        }
        ArrayList<Fam> families = new ArrayList<Fam>();
        if (selectedFamily != null) {
            families.add(selectedFamily);
            if (MergeLogger.LOG.isLoggable(MergeLogger.ACCEPT)) {
                MergeLogger.LOG.log(MergeLogger.getAccept("%s selectedFamily", selectedFamily));
            }
        }
        PropertyDate marriageDate = marriageRecord.getEventDate();
        for (Fam fam : gedcom.getFamilies()) {
            Indi husband = fam.getHusband();
            Indi wife = fam.getWife();
            if (husband == null && wife == null) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s father == null && mother == null", fam));
                continue;
            }
            if (husband != null) {
                MergeRecord.RecordParent mergeFather = marriageRecord.getIndi().getFather();
                if (!mergeFather.getLastName().isEmpty()) {
                    if (!MergeQuery.isSameLastName(mergeFather.getLastName(), husband.getLastName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeFather.getLastName()\u00a8%s must be same as husband.getLastName() %s %s", fam, mergeFather.getLastName(), husband, husband.getLastName()));
                        continue;
                    }
                } else if (!MergeQuery.isSameLastName(marriageRecord.getIndi().getLastName(), husband.getLastName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getIndi().getLastName() %s must be same as husband.getLastName() %s %s", fam, marriageRecord.getIndi().getLastName(), husband, husband.getLastName()));
                    continue;
                }
                if (!marriageRecord.getIndi().getFirstName().isEmpty() && !MergeQuery.isSameFirstName(marriageRecord.getIndi().getFirstName(), husband.getFirstName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getIndi().getFirstName() %s must be same as  husband.getFirstName() %s %s", fam, marriageRecord.getIndi().getFirstName(), husband, husband.getFirstName()));
                    continue;
                }
                if (!MergeQuery.isCompatible(marriageRecord.getIndi().getBirthDate(), husband.getBirthDate(), 1)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getIndi().getBirthDate() %s must be compatible with husband.getBirthDate() %s %s", fam, marriageRecord.getIndi().getBirthDate(), husband, husband.getBirthDate()));
                    continue;
                }
                if (!marriageRecord.getIndi().getBirthDate().isValid() && !MergeQuery.isRecordAfterThanDate(marriageDate, husband.getBirthDate(), 0, minMarriageYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate %s must be before husband.getBirthDate() %s %s + %dy", fam, marriageDate, husband, husband.getBirthDate(), minMarriageYearOld));
                    continue;
                }
                if (!MergeQuery.isRecordBeforeThanDate(marriageDate, husband.getDeathDate(), 0, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate %s must be before husband.getDeathDate() %s %s", fam, marriageDate, husband, husband.getDeathDate()));
                    continue;
                }
                if (!MergeQuery.isCompatible(marriageRecord.getIndi().getDeathDate(), husband.getDeathDate(), 1)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getIndi().getDeathDate() %s must be compatible with husband.getDeathDate() %s %s", fam, marriageRecord.getIndi().getDeathDate(), husband, husband.getDeathDate()));
                    continue;
                }
                Indi indiFather = husband.getBiologicalFather();
                if (indiFather != null) {
                    if (!mergeFather.getLastName().isEmpty() && !MergeQuery.isSameLastName(mergeFather.getLastName(), indiFather.getLastName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeFather.getLastName()\u00a8%s must be same as indiFather.getLastName() %s %s", fam, mergeFather.getLastName(), indiFather, indiFather.getLastName()));
                        continue;
                    }
                    if (!mergeFather.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(mergeFather.getFirstName(), indiFather.getFirstName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeFather.getFirstName()\u00a8%s must be same as indiFather.getFirstName() %s %s", fam, mergeFather.getFirstName(), indiFather, indiFather.getFirstName()));
                        continue;
                    }
                    if (!MergeQuery.isRecordAfterThanDate(marriageDate, indiFather.getBirthDate(), 0, minParentYearOld + minMarriageYearOld)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate %s must be after indiFather.getBirthDate() %s  %s + %dy", fam, marriageDate, indiFather, indiFather.getBirthDate(), minParentYearOld + minMarriageYearOld));
                        continue;
                    }
                    if (!MergeQuery.isRecordBeforeThanDate(marriageRecord.getIndi().getBirthDate(), indiFather.getDeathDate(), 9, 0)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getIndi().getBirthDate() %s must be before indiFather.getDeathDate()  %s + %d month", fam, marriageRecord.getIndi().getBirthDate(), indiFather.getDeathDate(), 9));
                        continue;
                    }
                }
                Indi indiMother = husband.getBiologicalMother();
                MergeRecord.RecordParent mergeMother = marriageRecord.getIndi().getMother();
                if (indiMother != null) {
                    if (!mergeMother.getLastName().isEmpty() && !MergeQuery.isSameLastName(mergeMother.getLastName(), indiMother.getLastName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeMother.getLastName()\u00a8%s must be same as indiMother.getLastName() %s %s", fam, mergeMother.getLastName(), indiMother, indiMother.getLastName()));
                        continue;
                    }
                    if (!mergeMother.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(mergeMother.getFirstName(), indiMother.getFirstName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeMother.getFirstName()\u00a8%s must be same as indiMother.getFirstName() %s %s", fam, mergeMother.getFirstName(), indiMother, indiMother.getFirstName()));
                        continue;
                    }
                    if (!MergeQuery.isRecordAfterThanDate(marriageDate, indiMother.getBirthDate(), 0, minParentYearOld + minMarriageYearOld)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate\u00a8%s must be after indiMother.getBirthDate() %s %s + %dy", fam, marriageDate, indiMother, indiMother.getBirthDate(), minParentYearOld + minMarriageYearOld));
                        continue;
                    }
                    if (!MergeQuery.isRecordBeforeThanDate(marriageRecord.getIndi().getBirthDate(), indiMother.getDeathDate(), 0, 0)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getIndi().getBirthDate()\u00a8%s must be before indiMother.getDeathDate() %s %s", fam, marriageRecord.getIndi().getBirthDate(), indiMother, indiMother.getDeathDate()));
                        continue;
                    }
                }
            }
            if (wife != null) {
                Indi wifeMother;
                if (!marriageRecord.getWife().getLastName().isEmpty() && !MergeQuery.isSameLastName(marriageRecord.getWife().getLastName(), wife.getLastName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s marriageRecord.getWife().getLastName() %s must be same as wife.getLastName() %s %s", fam, marriageRecord.getWife().getLastName(), wife, wife.getLastName()));
                    continue;
                }
                if (!marriageRecord.getWife().getFirstName().isEmpty() && !MergeQuery.isSameFirstName(marriageRecord.getWife().getFirstName(), wife.getFirstName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s marriageRecord.getWife().getFirstName() %s must be same as wife.getFirstName() %s %s", fam, marriageRecord.getWife().getFirstName(), wife, wife.getFirstName()));
                    continue;
                }
                if (!MergeQuery.isCompatible(marriageRecord.getWife().getBirthDate(), wife.getBirthDate(), 1)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s marriageRecord.getWife().getBirthDate() %s must compatible with wife.getBirthDate() %s %s ", fam, marriageRecord.getWife().getBirthDate(), wife, wife.getBirthDate()));
                    continue;
                }
                if (!marriageRecord.getWife().getBirthDate().isValid() && !MergeQuery.isRecordAfterThanDate(marriageDate, wife.getBirthDate(), 0, minMarriageYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s marriageDate %s must be after wife.getBirthDate() %s %s + %dy", fam, marriageDate, wife, wife.getBirthDate(), minMarriageYearOld));
                    continue;
                }
                if (!MergeQuery.isRecordBeforeThanDate(marriageDate, wife.getDeathDate(), 0, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s marriageDate %s must be before wife.getDeathDate() %s %s", fam, marriageDate, wife, wife.getDeathDate()));
                    continue;
                }
                if (!MergeQuery.isCompatible(marriageRecord.getWife().getDeathDate(), wife.getDeathDate(), 1)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s marriageRecord.getWife().getDeathDate() %s must be compatible with wife.getDeathDate() %s %s", fam, marriageRecord.getWife().getDeathDate(), wife, wife.getDeathDate()));
                    continue;
                }
                Indi wifeFather = wife.getBiologicalFather();
                if (wifeFather != null) {
                    MergeRecord.RecordParent mergeWifeFather = marriageRecord.getWife().getFather();
                    if (!mergeWifeFather.getLastName().isEmpty() && !MergeQuery.isSameLastName(mergeWifeFather.getLastName(), wifeFather.getLastName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeWifeFather.getLastName()\u00a8%s must be same as wifeFather.getLastName() %s %s", fam, mergeWifeFather.getLastName(), wifeFather, wifeFather.getLastName()));
                        continue;
                    }
                    if (!mergeWifeFather.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(mergeWifeFather.getFirstName(), wifeFather.getFirstName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeWifeFather.getFirstName()\u00a8%s must be same as wifeFather.getFirstName() %s %s", fam, mergeWifeFather.getFirstName(), wifeFather, wifeFather.getFirstName()));
                        continue;
                    }
                    if (!MergeQuery.isRecordAfterThanDate(marriageDate, wifeFather.getBirthDate(), 0, minParentYearOld + minMarriageYearOld)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate\u00a8%s must be after wifeFather.getBirthDate() %s %s + %dy", fam, marriageDate, wifeFather, wifeFather.getBirthDate(), minParentYearOld + minMarriageYearOld));
                        continue;
                    }
                    if (!MergeQuery.isRecordBeforeThanDate(marriageRecord.getWife().getBirthDate(), wifeFather.getDeathDate(), 9, 0)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getWife().getBirthDate()\u00a8%s must be before wifeFather.getDeathDate() %s %s -%d month", fam, marriageRecord.getWife().getBirthDate(), wifeFather, wifeFather.getDeathDate(), 9));
                        continue;
                    }
                }
                if ((wifeMother = wife.getBiologicalMother()) != null) {
                    MergeRecord.RecordParent mergeWifeMother = marriageRecord.getWife().getMother();
                    if (!mergeWifeMother.getLastName().isEmpty() && !MergeQuery.isSameLastName(mergeWifeMother.getLastName(), wifeMother.getLastName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeWifeMother.getLastName()\u00a8%s must be same as wifeMother.getLastName() %s %s", fam, mergeWifeMother.getLastName(), wifeMother, wifeMother.getLastName()));
                        continue;
                    }
                    if (!mergeWifeMother.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(mergeWifeMother.getFirstName(), wifeMother.getFirstName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeWifeMother.getFirstName()\u00a8%s must be same as wifeMother.getFirstName() %s %s", fam, mergeWifeMother.getFirstName(), wifeMother, wifeMother.getFirstName()));
                        continue;
                    }
                    if (!MergeQuery.isRecordAfterThanDate(marriageDate, wifeMother.getBirthDate(), 0, minParentYearOld + minMarriageYearOld)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate\u00a8%s must be after wifeMother.getBirthDate() %s %s + %dy", fam, marriageDate, wifeMother, wifeMother.getBirthDate(), minParentYearOld + minMarriageYearOld));
                        continue;
                    }
                    if (!MergeQuery.isRecordBeforeThanDate(marriageRecord.getWife().getBirthDate(), wifeMother.getDeathDate(), 9, 0)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getWife().getBirthDate()\u00a8%s must be before wifeMother.getDeathDate() %s %s -%d month", fam, marriageRecord.getWife().getBirthDate(), wifeMother, wifeMother.getDeathDate(), 9));
                        continue;
                    }
                }
            }
            if (families.contains(fam)) continue;
            families.add(fam);
        }
        if (MergeLogger.LOG.isLoggable(Level.FINER)) {
            StringBuilder result = new StringBuilder("RETURN families");
            for (Fam fam : families) {
                result.append(" ").append(fam.getId());
            }
            MergeLogger.LOG.finer(result.toString());
        }
        return families;
    }

    protected static void findFatherMotherCompatibleWithBirthParticipant(MergeRecord record, Gedcom gedcom, List<Fam> excludedFamilies, List<Indi> fathers, List<Indi> mothers) throws Exception {
        PropertyDate recordBirthDate;
        if (MergeLogger.LOG.isLoggable(Level.FINER)) {
            MergeLogger.LOG.entering(MergeQuery.class.getName(), "findFatherMotherCompatibleWithBirthParticipant");
        }
        if (!(recordBirthDate = record.getIndi().getBirthDate()).isComparable()) {
            recordBirthDate = record.getEventDate();
        }
        MergeRecord.RecordParticipant participant = record.getIndi();
        Collection entities = gedcom.getIndis();
        for (Indi parent : entities) {
            PropertyDate lastChildBirthDate;
            PropertyDate firstChildBirthDate;
            Indi[] children;
            PropertyDate marriageDate;
            Fam[] fams;
            if (excludedFamilies != null) {
                boolean found = false;
                for (Fam fam : excludedFamilies) {
                    Indi husband = fam.getHusband();
                    Indi wife = fam.getWife();
                    if ((husband == null || parent.compareTo((Property)husband) != 0) && (wife == null || parent.compareTo((Property)wife) != 0)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
            }
            MergeRecord.RecordParent mergeFather = participant.getFather();
            MergeRecord.RecordParent mergeMother = participant.getMother();
            if (parent.getSex() == 1) {
                Indi father = parent;
                if (!mergeFather.getLastName().isEmpty()) {
                    if (!MergeQuery.isSameLastName(mergeFather.getLastName(), father.getLastName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s participant.getLastName() %s must be same as father.getLastName() %s %s", father, participant.getLastName(), father, father.getLastName()));
                        continue;
                    }
                } else if (!MergeQuery.isSameLastName(participant.getLastName(), father.getLastName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getLastName()\u00a8%s must be same as father.getLastName() %s %s", father, participant.getLastName(), father, father.getLastName()));
                    continue;
                }
                if (mergeFather.getFirstName().isEmpty() || father.getFirstName().isEmpty() || !MergeQuery.isSameFirstName(mergeFather.getFirstName(), father.getFirstName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeFather.getFirstName()\u00a8%s must be same as father.getFirstName() %s %s", father, mergeFather.getFirstName(), father, father.getFirstName()));
                    continue;
                }
                if (!MergeQuery.isRecordAfterThanDate(recordBirthDate, father.getBirthDate(), 0, minParentYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s recordBirthDate %s must be after father.getBirthDate() %s %s + %dy", father, recordBirthDate, father, father.getBirthDate(), minMarriageYearOld));
                    continue;
                }
                if (!MergeQuery.isRecordBeforeThanDate(recordBirthDate, father.getDeathDate(), 9, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s recordBirthDate %s must be before father.getDeathDate() %s %s + 9m", father, recordBirthDate, father, father.getDeathDate()));
                    continue;
                }
                fams = father.getFamiliesWhereSpouse();
                boolean incompatible = false;
                for (Fam fam : fams) {
                    Indi wife;
                    marriageDate = fam.getMarriageDate();
                    children = fam.getChildren(true);
                    firstChildBirthDate = null;
                    lastChildBirthDate = null;
                    if (children.length > 0) {
                        firstChildBirthDate = children[0].getBirthDate();
                        lastChildBirthDate = children[children.length - 1].getBirthDate();
                    }
                    if (MergeQuery.isRecordBeforeThanDate(recordBirthDate, marriageDate, 0, 0) || MergeQuery.isRecordBeforeThanDate(recordBirthDate, firstChildBirthDate, 0, 0) || MergeQuery.isRecordAfterThanDate(recordBirthDate, lastChildBirthDate, 0, 0) || (wife = fam.getWife()) == null || mergeMother.getLastName().isEmpty() || MergeQuery.isSameLastName(mergeMother.getLastName(), wife.getLastName()) || mergeMother.getFirstName().isEmpty() || MergeQuery.isSameFirstName(mergeMother.getFirstName(), wife.getFirstName())) continue;
                    incompatible = true;
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) break;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s father must not have child with other spouse at %s ; but found family %s with spouse %s and first child birth %s and last child birth %s", father, recordBirthDate, fam, wife, firstChildBirthDate, lastChildBirthDate));
                    break;
                }
                if (incompatible) continue;
                fathers.add(father);
                continue;
            }
            if (parent.getSex() != 2) continue;
            Indi mother = parent;
            if (mergeMother.getLastName().isEmpty() || mother.getLastName().isEmpty() || !MergeQuery.isSameLastName(mergeMother.getLastName(), mother.getLastName())) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeMother.getLastName() %s must be same as mother.getLastName() %s %s", mother, mergeMother.getLastName(), mother, mother.getLastName()));
                continue;
            }
            if (mergeMother.getFirstName().isEmpty() || !mother.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(mergeMother.getFirstName(), mother.getFirstName())) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s mergeMother.getFirstName() %s must be same as mother.getFirstName() %s %s", mother, mergeMother.getFirstName(), mother, mother.getFirstName()));
                continue;
            }
            if (!MergeQuery.isRecordAfterThanDate(recordBirthDate, mother.getBirthDate(), 0, minParentYearOld)) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s recordBirthDate %s must be after mother.getBirthDate() %s %s + %dy", mother, recordBirthDate, mother, mother.getBirthDate(), minMarriageYearOld));
                continue;
            }
            if (!MergeQuery.isRecordBeforeThanDate(recordBirthDate, mother.getDeathDate(), 0, 0)) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s recordBirthDate %s must be before mother.getDeathDate() %s %s", mother, recordBirthDate, mother, mother.getDeathDate()));
                continue;
            }
            fams = mother.getFamiliesWhereSpouse();
            boolean incompatible = false;
            for (Fam fam : fams) {
                marriageDate = fam.getMarriageDate();
                children = fam.getChildren(true);
                firstChildBirthDate = null;
                lastChildBirthDate = null;
                if (children.length > 0) {
                    firstChildBirthDate = children[0].getBirthDate();
                    lastChildBirthDate = children[children.length - 1].getBirthDate();
                }
                if (MergeQuery.isRecordBeforeThanDate(recordBirthDate, marriageDate, 0, 0) || MergeQuery.isRecordBeforeThanDate(recordBirthDate, firstChildBirthDate, 0, 0) || MergeQuery.isRecordAfterThanDate(recordBirthDate, lastChildBirthDate, 0, 0) || mergeFather.getLastName().isEmpty() || MergeQuery.isSameLastName(mergeFather.getLastName(), fam.getHusband().getLastName()) || mergeFather.getFirstName().isEmpty() || MergeQuery.isSameFirstName(mergeFather.getFirstName(), fam.getHusband().getFirstName())) continue;
                incompatible = true;
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) break;
                MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s mother must not have child with other spouse at %s ; but found family %s with spouse %s and first child birth %s and last child birth %s", mother, recordBirthDate, fam, fam.getHusband(), firstChildBirthDate, lastChildBirthDate));
                break;
            }
            if (incompatible) continue;
            mothers.add(parent);
        }
        if (MergeLogger.LOG.isLoggable(Level.FINER)) {
            StringBuilder result = new StringBuilder("RETURN fathers");
            for (Indi father : fathers) {
                result.append(" ").append(father.getId());
            }
            result.append(" mothers ");
            for (Indi mother : mothers) {
                result.append(" ").append(mother.getId());
            }
            MergeLogger.LOG.finer(result.toString());
        }
    }

    protected static void findHusbanWifeCompatibleWithMarriageRecord(MergeRecord marriageRecord, Gedcom gedcom, List<Fam> excludedFamilies, List<Indi> husbands, List<Indi> wifes) throws Exception {
        if (MergeLogger.LOG.isLoggable(Level.FINER)) {
            MergeLogger.LOG.entering(MergeQuery.class.getName(), "findHusbanWifeCompatibleWithMarriageRecord");
        }
        PropertyDate marriageDate = marriageRecord.getEventDate();
        Collection entities = gedcom.getIndis();
        for (Indi indi : entities) {
            Fam[] spouseFamList;
            if (excludedFamilies != null) {
                boolean found = false;
                for (Fam fam : excludedFamilies) {
                    Indi husband = fam.getHusband();
                    Indi wife = fam.getWife();
                    if ((husband == null || indi.compareTo((Property)husband) != 0) && (wife == null || indi.compareTo((Property)wife) != 0)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
            }
            if (indi.getSex() == 1) {
                Indi indiMother;
                Indi husband = indi;
                if (!marriageRecord.getIndi().getLastName().isEmpty() && !MergeQuery.isSameLastName(marriageRecord.getIndi().getLastName(), husband.getLastName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getIndi().getLastName() %s must be same as husband.getLastName() %s %s", husband, marriageRecord.getIndi().getLastName(), husband, husband.getLastName()));
                    continue;
                }
                if (!marriageRecord.getIndi().getFirstName().isEmpty() && !MergeQuery.isSameFirstName(marriageRecord.getIndi().getFirstName(), husband.getFirstName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getIndi().getFirstName() %s must be same as husband.getFirstName() %s %s", husband, marriageRecord.getIndi().getFirstName(), husband, husband.getFirstName()));
                    continue;
                }
                if (!MergeQuery.isCompatible(marriageRecord.getIndi().getBirthDate(), husband.getBirthDate(), 1)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s marriageRecord.getIndi().getBirthDate() %s must be compatible with husband.getBirthDate() %s %s", husband, marriageRecord.getIndi().getBirthDate(), husband, husband.getBirthDate()));
                    continue;
                }
                if (!marriageRecord.getIndi().getBirthDate().isValid() && !MergeQuery.isRecordAfterThanDate(marriageDate, husband.getBirthDate(), 0, minMarriageYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate\u00a8%s must be after husband.getBirthDate() %s %s + %dy", husband, marriageDate, husband, husband.getBirthDate(), minParentYearOld + minMarriageYearOld));
                    continue;
                }
                if (!MergeQuery.isRecordBeforeThanDate(marriageDate, husband.getDeathDate(), 0, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate\u00a8%s must be before husband.getDeathDate() %s %s", husband, marriageDate, husband, husband.getDeathDate()));
                    continue;
                }
                if (!MergeQuery.isCompatible(marriageRecord.getIndi().getDeathDate(), husband.getDeathDate(), 1)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s marriageRecord.getIndi().getDeathDate() %s must be compatible with husband.getDeathDate() %s %s", husband, marriageRecord.getIndi().getDeathDate(), husband, husband.getDeathDate()));
                    continue;
                }
                Indi indiFather = husband.getBiologicalFather();
                if (indiFather != null) {
                    MergeRecord.RecordParent mergeFather = marriageRecord.getIndi().getFather();
                    if (!mergeFather.getLastName().isEmpty() && !MergeQuery.isSameLastName(mergeFather.getLastName(), indiFather.getLastName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeFather.getLastName()\u00a8%s must be same as indiFather.getLastName() %s %s", husband, mergeFather.getLastName(), indiFather, indiFather.getLastName()));
                        continue;
                    }
                    if (!mergeFather.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(mergeFather.getFirstName(), indiFather.getFirstName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeFather.getFirstName()\u00a8%s must be same as indiFather.getFirstName() %s %s", husband, mergeFather.getFirstName(), indiFather, indiFather.getFirstName()));
                        continue;
                    }
                    if (!MergeQuery.isRecordAfterThanDate(marriageDate, indiFather.getBirthDate(), 0, minParentYearOld + minMarriageYearOld)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate %s must be after indiFather.getBirthDate() %s  %s + %dy", husband, marriageDate, indiFather, indiFather.getBirthDate(), minParentYearOld + minMarriageYearOld));
                        continue;
                    }
                    if (!MergeQuery.isRecordBeforeThanDate(marriageRecord.getIndi().getBirthDate(), indiFather.getDeathDate(), 9, 0)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getIndi().getBirthDate() %s must be before indiFather.getDeathDate()  %s + %d month", husband, marriageRecord.getIndi().getBirthDate(), indiFather.getDeathDate(), 9));
                        continue;
                    }
                }
                if ((indiMother = husband.getBiologicalMother()) != null) {
                    MergeRecord.RecordParent mergeMother = marriageRecord.getIndi().getMother();
                    if (!mergeMother.getLastName().isEmpty() && !MergeQuery.isSameLastName(mergeMother.getLastName(), indiMother.getLastName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeMother.getLastName()\u00a8%s must be same as indiMother.getLastName() %s %s", husband, mergeMother.getLastName(), indiMother, indiMother.getLastName()));
                        continue;
                    }
                    if (!mergeMother.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(mergeMother.getFirstName(), indiMother.getFirstName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeMother.getFirstName()\u00a8%s must be same as indiMother.getFirstName() %s %s", husband, mergeMother.getFirstName(), indiMother, indiMother.getFirstName()));
                        continue;
                    }
                    if (!MergeQuery.isRecordAfterThanDate(marriageDate, indiMother.getBirthDate(), 0, minParentYearOld + minMarriageYearOld)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate\u00a8%s must be after indiMother.getBirthDate() %s %s + %dy", husband, marriageDate, indiMother, indiMother.getBirthDate(), minParentYearOld + minMarriageYearOld));
                        continue;
                    }
                    if (!MergeQuery.isRecordBeforeThanDate(marriageRecord.getIndi().getBirthDate(), indiMother.getDeathDate(), 0, 0)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getIndi().getBirthDate()\u00a8%s must be before indiMother.getDeathDate() %s %s", husband, marriageRecord.getIndi().getBirthDate(), indiMother, indiMother.getDeathDate()));
                        continue;
                    }
                }
                boolean oftherSpouseFound = false;
                for (Fam fam : spouseFamList = husband.getFamiliesWhereSpouse()) {
                    Indi wife = fam.getWife();
                    if (MergeQuery.isSameLastName(marriageRecord.getWife().getLastName(), wife.getLastName()) && MergeQuery.isSameLastName(marriageRecord.getWife().getFirstName(), wife.getFirstName()) || MergeQuery.isRecordBeforeThanDate(marriageDate, fam.getMarriageDate(), 0, 0) || MergeQuery.isRecordAfterThanDate(marriageDate, wife.getDeathDate(), 0, 0)) continue;
                    oftherSpouseFound = true;
                    break;
                }
                if (oftherSpouseFound) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s husband must not have spouse with other name", husband));
                    continue;
                }
                husbands.add(husband);
                continue;
            }
            if (indi.getSex() != 2) continue;
            Indi wife = indi;
            if (!marriageRecord.getWife().getLastName().isEmpty() && !MergeQuery.isSameLastName(marriageRecord.getWife().getLastName(), wife.getLastName())) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getWife().getLastName() %s must be same as wife.getLastName() %s %s", wife, marriageRecord.getWife().getLastName(), wife, wife.getLastName()));
                continue;
            }
            if (!marriageRecord.getWife().getFirstName().isEmpty() && !MergeQuery.isSameFirstName(marriageRecord.getWife().getFirstName(), wife.getFirstName())) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getWife().getFirstName() %s must be same as wife.getFirstName() %s %s", wife, marriageRecord.getWife().getFirstName(), wife, wife.getFirstName()));
                continue;
            }
            if (!MergeQuery.isCompatible(marriageRecord.getWife().getBirthDate(), wife.getBirthDate(), 1) && MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) {
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getWife().getBirthDate() %s must compatible with wife.getBirthDate() %s %s ", wife, marriageRecord.getWife().getBirthDate(), wife, wife.getBirthDate()));
                continue;
            }
            if (!marriageRecord.getWife().getBirthDate().isValid() && !MergeQuery.isRecordAfterThanDate(marriageDate, wife.getBirthDate(), 0, minMarriageYearOld)) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate %s must be after wife.getBirthDate() %s %s + %dy", wife, marriageDate, wife, wife.getBirthDate(), minMarriageYearOld));
                continue;
            }
            if (!MergeQuery.isRecordBeforeThanDate(marriageDate, wife.getDeathDate(), 0, 0)) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate %s must be before wife.getDeathDate() %s %s", wife, marriageDate, wife, wife.getDeathDate()));
                continue;
            }
            if (!MergeQuery.isCompatible(marriageRecord.getWife().getDeathDate(), wife.getDeathDate(), 1)) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getWife().getDeathDate() %s must be compatible with wife.getDeathDate() %s %s", wife, marriageRecord.getWife().getDeathDate(), wife, wife.getDeathDate()));
                continue;
            }
            Indi wifeFather = wife.getBiologicalFather();
            if (wifeFather != null) {
                MergeRecord.RecordParent mergeWifeFather = marriageRecord.getWife().getFather();
                if (!mergeWifeFather.getLastName().isEmpty() && !MergeQuery.isSameLastName(mergeWifeFather.getLastName(), wifeFather.getLastName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeWifeFather.getLastName()\u00a8%s must be same as wifeFather.getLastName() %s %s", wife, mergeWifeFather.getLastName(), wifeFather, wifeFather.getLastName()));
                    continue;
                }
                if (!mergeWifeFather.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(mergeWifeFather.getFirstName(), wifeFather.getFirstName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeWifeFather.getFirstName()\u00a8%s must be same as wifeFather.getFirstName() %s %s", wife, mergeWifeFather.getFirstName(), wifeFather, wifeFather.getFirstName()));
                    continue;
                }
                if (!MergeQuery.isRecordAfterThanDate(marriageDate, wifeFather.getBirthDate(), 0, minParentYearOld + minMarriageYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate\u00a8%s must be after wifeFather.getBirthDate() %s %s + %dy", wife, marriageDate, wifeFather, wifeFather.getBirthDate(), minParentYearOld + minMarriageYearOld));
                    continue;
                }
                if (!MergeQuery.isRecordBeforeThanDate(marriageRecord.getWife().getBirthDate(), wifeFather.getDeathDate(), 9, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getWife().getBirthDate()\u00a8%s must be before wifeFather.getDeathDate() %s %s -%d month", wife, marriageRecord.getWife().getBirthDate(), wifeFather, wifeFather.getDeathDate(), 9));
                    continue;
                }
            }
            if (!MergeQuery.isRecordAfterThanDate(marriageDate, wife.getBirthDate(), 0, minMarriageYearOld)) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate %s must be after wife.getBirthDate() %s %s + %dy", wife, marriageDate, wife, wife.getBirthDate(), minMarriageYearOld));
                continue;
            }
            Indi wifeMother = wife.getBiologicalMother();
            if (wifeMother != null) {
                MergeRecord.RecordParent mergeWifeMother = marriageRecord.getWife().getMother();
                if (!mergeWifeMother.getLastName().isEmpty() && !MergeQuery.isSameLastName(mergeWifeMother.getLastName(), wifeMother.getLastName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeWifeMother.getLastName()\u00a8%s must be same as wifeMother.getLastName() %s %s", wife, mergeWifeMother.getLastName(), wifeMother, wifeMother.getLastName()));
                    continue;
                }
                if (!mergeWifeMother.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(mergeWifeMother.getFirstName(), wifeMother.getFirstName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeWifeMother.getFirstName()\u00a8%s must be same as wifeMother.getFirstName() %s %s", wife, mergeWifeMother.getFirstName(), wifeMother, wifeMother.getFirstName()));
                    continue;
                }
                if (!MergeQuery.isRecordAfterThanDate(marriageDate, wifeMother.getBirthDate(), 0, minParentYearOld + minMarriageYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageDate\u00a8%s must be after wifeMother.getBirthDate() %s %s + %dy", wife, marriageDate, wifeMother, wifeMother.getBirthDate(), minParentYearOld + minMarriageYearOld));
                    continue;
                }
                if (!MergeQuery.isRecordBeforeThanDate(marriageRecord.getWife().getBirthDate(), wifeMother.getDeathDate(), 9, 0)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s marriageRecord.getWife().getBirthDate()\u00a8%s must be before wifeMother.getDeathDate() %s %s -%d month", wife, marriageRecord.getWife().getBirthDate(), wifeMother, wifeMother.getDeathDate(), 9));
                    continue;
                }
            }
            boolean oftherSpouseFound = false;
            for (Fam fam : spouseFamList = wife.getFamiliesWhereSpouse()) {
                Indi husband = fam.getHusband();
                if (MergeQuery.isSameLastName(marriageRecord.getIndi().getLastName(), husband.getLastName()) && MergeQuery.isSameLastName(marriageRecord.getIndi().getFirstName(), husband.getFirstName()) || MergeQuery.isRecordBeforeThanDate(marriageDate, fam.getMarriageDate(), 0, 0) || MergeQuery.isRecordAfterThanDate(marriageDate, husband.getDeathDate(), 0, 0)) continue;
                oftherSpouseFound = true;
                break;
            }
            if (oftherSpouseFound) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s wife must not have spouse with other name", wife));
                continue;
            }
            wifes.add(wife);
        }
        if (MergeLogger.LOG.isLoggable(Level.FINER)) {
            StringBuilder result = new StringBuilder("RETURN husbands");
            for (Indi husband : husbands) {
                result.append(" ").append(husband.getId());
            }
            result.append(" wifes ");
            for (Indi wife : wifes) {
                result.append(" ").append(wife.getId());
            }
            MergeLogger.LOG.finer(result.toString());
        }
    }

    protected static List<Indi> findIndiCompatibleWithParticipant(MergeRecord record, MergeRecord.RecordParticipant participant, Gedcom gedcom, Indi excludeIndi) throws Exception {
        if (MergeLogger.LOG.isLoggable(Level.FINER)) {
            MergeLogger.LOG.entering(MergeQuery.class.getName(), "findIndiCompatibleWithParticipant");
        }
        ArrayList<Indi> sameIndis = new ArrayList<Indi>();
        for (Indi indi : gedcom.getIndis()) {
            if (excludeIndi != null && excludeIndi.compareTo((Property)indi) == 0) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s indi in  exclude", indi));
                continue;
            }
            if (participant.getSex() != 0 && indi.getSex() != 0 && participant.getSex() != indi.getSex()) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant %d must be same sex as indi %d ", indi, participant.getSex(), indi.getSex()));
                continue;
            }
            if (!participant.getLastName().isEmpty() && !MergeQuery.isSameLastName(participant.getLastName(), indi.getLastName())) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getLastName() %s must be same as indi.getLastName() %s %s", indi, participant.getLastName(), indi, indi.getLastName()));
                continue;
            }
            if (!participant.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(participant.getFirstName(), indi.getFirstName())) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getFirstName() %s must be same as indi.getFirstName() %s %s", indi, participant.getFirstName(), indi, indi.getFirstName()));
                continue;
            }
            PropertyDate indiBirtDate = indi.getBirthDate();
            if (indiBirtDate != null && !MergeQuery.isCompatible(participant.getBirthDate(), indiBirtDate, 1)) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s participant.getBirthDate() %s must be compatible with indiBirtDate %s %s", indi, participant.getBirthDate(), indi, indiBirtDate));
                continue;
            }
            PropertyDate indiDeathDate = indi.getDeathDate();
            if (indiDeathDate != null && !MergeQuery.isCompatible(participant.getDeathDate(), indiDeathDate, 1)) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.REFUSE, String.format("REFUSE %s participant.getDeathDate() %s must be compatible with indiDeathDate) %s %s", indi, participant.getDeathDate(), indi, indiDeathDate));
                continue;
            }
            Fam[] sameIndiFamiliesWhereSpouse = indi.getFamiliesWhereSpouse();
            Fam famConflict = null;
            for (Fam fam : sameIndiFamiliesWhereSpouse) {
                if (MergeQuery.isRecordAfterThanDate(participant.getDeathDate(), fam.getMarriageDate(), 0, 0)) continue;
                famConflict = fam;
                break;
            }
            if (famConflict != null) {
                if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getDeathDate()\u00a8%s must be after fam.getMarriageDate() %s %s", indi, participant.getDeathDate(), famConflict, famConflict.getMarriageDate()));
                continue;
            }
            Fam parentFamily = indi.getFamilyWhereBiologicalChild();
            if (parentFamily != null) {
                Indi indiMother;
                Indi indiFather;
                PropertyDate parentMarriageDate = parentFamily.getMarriageDate();
                if (parentMarriageDate != null) {
                    if (!MergeQuery.isRecordAfterThanDate(participant.getBirthDate(), parentMarriageDate, 0, 0)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getBirthDate()\u00a8%s must be after parentMarriageDate %s %s", indi, participant.getBirthDate(), parentFamily, parentMarriageDate));
                        continue;
                    }
                    if (!MergeQuery.isRecordAfterThanDate(participant.getDeathDate(), parentMarriageDate, 0, 0)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getBirthDate()\u00a8%s must be after parentMarriageDate %s %s", indi, participant.getDeathDate(), parentFamily, parentMarriageDate));
                        continue;
                    }
                }
                if ((indiFather = parentFamily.getHusband()) != null) {
                    MergeRecord.RecordParent mergeFather = participant.getFather();
                    if (!mergeFather.getLastName().isEmpty() && !MergeQuery.isSameLastName(mergeFather.getLastName(), indiFather.getLastName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeFather.getLastName()\u00a8%s must be same as indiFather.getLastName() %s %s", indi, mergeFather.getLastName(), indiFather, indiFather.getLastName()));
                        continue;
                    }
                    if (!mergeFather.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(mergeFather.getFirstName(), indiFather.getFirstName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeFather.getFirstName()\u00a8%s must be same as indiFather.getFirstName() %s %s", indi, mergeFather.getFirstName(), indiFather, indiFather.getFirstName()));
                        continue;
                    }
                    if (!MergeQuery.isRecordAfterThanDate(participant.getBirthDate(), indiFather.getBirthDate(), 0, minParentYearOld)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getBirthDate() %s must be after indiFather.getBirthDate() %s  %s + %dy", indi, participant.getBirthDate(), indiFather, indiFather.getBirthDate(), minParentYearOld));
                        continue;
                    }
                    if (!MergeQuery.isRecordBeforeThanDate(participant.getBirthDate(), indiFather.getDeathDate(), 9, 0)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getBirthDate() %s must be before indiFather.getDeathDate()  %s + %d month", indi, participant.getBirthDate(), indiFather.getDeathDate(), 9));
                        continue;
                    }
                }
                if ((indiMother = parentFamily.getWife()) != null) {
                    MergeRecord.RecordParent mergeMother = participant.getMother();
                    if (!mergeMother.getLastName().isEmpty() && !MergeQuery.isSameLastName(mergeMother.getLastName(), indiMother.getLastName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeMother.getLastName()\u00a8%s must be same as indiMother.getLastName() %s %s", indi, mergeMother.getLastName(), indiMother, indiMother.getLastName()));
                        continue;
                    }
                    if (!mergeMother.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(mergeMother.getFirstName(), indiMother.getFirstName())) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s mergeMother.getFirstName()\u00a8%s must be same as indiMother.getFirstName() %s %s", indi, mergeMother.getFirstName(), indiMother, indiMother.getFirstName()));
                        continue;
                    }
                    if (!MergeQuery.isRecordAfterThanDate(participant.getBirthDate(), indiMother.getBirthDate(), 0, minParentYearOld)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getBirthDate()\u00a8%s must be after indiMother.getBirthDate() %s %s + %dy", indi, participant.getBirthDate(), indiMother, indiMother.getBirthDate(), minParentYearOld));
                        continue;
                    }
                    if (!MergeQuery.isRecordBeforeThanDate(participant.getBirthDate(), indiMother.getDeathDate(), 0, 0)) {
                        if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                        MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getBirthDate()\u00a8%s must be before indiMother.getDeathDate() %s %s", indi, participant.getBirthDate(), indiMother, indiMother.getDeathDate()));
                        continue;
                    }
                }
            }
            sameIndis.add(indi);
        }
        if (MergeLogger.LOG.isLoggable(Level.FINER)) {
            StringBuilder result = new StringBuilder("RETURN");
            result.append(" sameIndis ");
            for (Indi indi : sameIndis) {
                result.append(" ").append(indi.getId());
            }
            MergeLogger.LOG.finer(result.toString());
        }
        return sameIndis;
    }

    protected static List<Indi> findSameChild(MergeRecord birthRecord, Gedcom gedcom, Fam selectedFamily) throws Exception {
        if (MergeLogger.LOG.isLoggable(Level.FINER)) {
            MergeLogger.LOG.entering(MergeQuery.class.getName(), "findSameChild");
        }
        ArrayList<Indi> sameChildren = new ArrayList<Indi>();
        MergeRecord.RecordParticipant participant = birthRecord.getIndi();
        PropertyDate recordBirthDate = participant.getBirthDate();
        if (selectedFamily != null) {
            for (Indi indi : selectedFamily.getChildren()) {
                if (participant.getSex() != 0 && indi.getSex() != 0 && participant.getSex() != indi.getSex()) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant %d must be same sex as child %d ", indi, participant.getSex(), indi.getSex()));
                    continue;
                }
                if (!participant.getLastName().isEmpty() && !MergeQuery.isSameLastName(participant.getLastName(), indi.getLastName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getLastName() %s must be same as indi.getLastName() %s %s", indi, participant.getLastName(), indi, indi.getLastName()));
                    continue;
                }
                if (!participant.getFirstName().isEmpty() && !MergeQuery.isSameFirstName(participant.getFirstName(), indi.getFirstName())) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getFirstName() %s must be same as indi.getFirstName() %s %s", indi, participant.getFirstName(), indi, indi.getFirstName()));
                    continue;
                }
                PropertyDate indiBirtDate = indi.getBirthDate();
                if (indiBirtDate != null && !MergeQuery.isCompatible(recordBirthDate, indiBirtDate, 1)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getBirthDate() %s must be compatible with indiBirtDate %s %s", indi, participant.getBirthDate(), indi, indiBirtDate));
                    continue;
                }
                Indi indiFather = selectedFamily.getHusband();
                if (indiFather != null && !MergeQuery.isRecordAfterThanDate(recordBirthDate, indiFather.getBirthDate(), 0, minParentYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getBirthDate() %s must be after indiFather.getBirthDate() %s  %s + %dy", indi, participant.getBirthDate(), indiFather, indiFather.getBirthDate(), minParentYearOld));
                    continue;
                }
                Indi indiMother = selectedFamily.getWife();
                if (indiMother != null && !MergeQuery.isRecordAfterThanDate(recordBirthDate, indiMother.getBirthDate(), 0, minParentYearOld)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getBirthDate()\u00a8%s must be after indiMother.getBirthDate() %s %s + %dy", indi, participant.getBirthDate(), indiMother, indiMother.getBirthDate(), minParentYearOld));
                    continue;
                }
                PropertyDate childDeathDate = indi.getDeathDate();
                if (childDeathDate != null && !MergeQuery.isCompatible(participant.getDeathDate(), childDeathDate, 1)) {
                    if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                    MergeLogger.LOG.log(MergeLogger.getRefuse("%s participant.getDeathDate(() %s must be compatible with indi.getDeathDate() %s %s", indi, participant.getDeathDate(), indi, indi.getDeathDate()));
                    continue;
                }
                sameChildren.add(indi);
            }
        }
        if (MergeLogger.LOG.isLoggable(Level.FINER)) {
            StringBuilder result = new StringBuilder("RETURN sameChildren");
            for (Indi indi : sameChildren) {
                result.append(" ").append(indi.getId());
            }
            MergeLogger.LOG.finer(result.toString());
        }
        return sameChildren;
    }

    protected static boolean isCompatible(PropertyDate recordDate, PropertyDate entityDate) {
        return MergeQuery.isCompatible(recordDate, entityDate, 0);
    }

    public static boolean isCompatible(PropertyDate recordDate, PropertyDate entityDate, int marge) {
        boolean result;
        if (recordDate == null) {
            return true;
        }
        if (!recordDate.isComparable()) {
            return true;
        }
        if (entityDate == null) {
            return true;
        }
        if (!entityDate.isComparable()) {
            return true;
        }
        try {
            int entityEnd;
            int entityStart;
            int recordEnd;
            int recordStart;
            if (recordDate.getFormat() == PropertyDate.DATE) {
                pit = new PointInTime();
                pit.set(recordDate.getStart());
                if (pit.isComplete()) {
                    recordEnd = recordStart = pit.getJulianDay();
                } else if (pit.getYear() != Integer.MAX_VALUE && pit.getMonth() == Integer.MAX_VALUE) {
                    pit.set(0, 0, pit.getYear());
                    recordStart = pit.getJulianDay();
                    pit.set(0, 0, pit.getYear() + 1);
                    recordEnd = pit.getJulianDay() - 1;
                } else if (pit.getYear() != Integer.MAX_VALUE && pit.getMonth() != Integer.MAX_VALUE && pit.getMonth() == Integer.MAX_VALUE) {
                    pit.set(0, pit.getMonth(), pit.getYear());
                    recordStart = pit.getJulianDay();
                    pit.set(0, pit.getMonth() + 1, pit.getYear());
                    recordEnd = pit.getJulianDay() - 1;
                } else {
                    recordEnd = recordStart = pit.getJulianDay();
                }
            } else if (recordDate.getFormat() == PropertyDate.BETWEEN_AND || recordDate.getFormat() == PropertyDate.FROM_TO) {
                pit = new PointInTime();
                pit.set(recordDate.getStart());
                recordStart = pit.getJulianDay();
                pit.set(recordDate.getEnd());
                recordEnd = pit.getJulianDay();
            } else if (recordDate.getFormat() == PropertyDate.FROM || recordDate.getFormat() == PropertyDate.AFTER) {
                pit = new PointInTime();
                pit.set(recordDate.getStart());
                recordStart = pit.getJulianDay();
                pit.set(recordDate.getStart());
                recordEnd = pit.add(0, 0, indiMaxYearOld).getJulianDay();
            } else if (recordDate.getFormat() == PropertyDate.TO || recordDate.getFormat() == PropertyDate.BEFORE) {
                pit = new PointInTime();
                pit.set(recordDate.getStart());
                recordStart = pit.add(0, 0, -indiMaxYearOld).getJulianDay();
                pit.set(recordDate.getStart());
                if (pit.getMonth() == Integer.MAX_VALUE) {
                    pit.add(0, 0, 1);
                }
                recordEnd = pit.getJulianDay();
            } else {
                pit = new PointInTime();
                pit.set(recordDate.getStart());
                recordStart = pit.add(0, 0, -aboutYear).getJulianDay();
                pit.set(recordDate.getStart());
                recordEnd = pit.add(0, 0, aboutYear).getJulianDay();
            }
            if (entityDate.getFormat() == PropertyDate.DATE) {
                PointInTime pit = new PointInTime();
                pit.set(entityDate.getStart());
                entityEnd = entityStart = pit.getJulianDay();
            } else if (entityDate.getFormat() == PropertyDate.BETWEEN_AND || entityDate.getFormat() == PropertyDate.FROM_TO) {
                entityStart = entityDate.getStart().getJulianDay();
                entityEnd = entityDate.getEnd().getJulianDay();
            } else if (entityDate.getFormat() == PropertyDate.FROM || entityDate.getFormat() == PropertyDate.AFTER) {
                PointInTime pit = new PointInTime();
                pit.set(entityDate.getStart());
                entityStart = pit.getJulianDay();
                pit.set(entityDate.getStart());
                entityEnd = pit.add(0, 0, indiMaxYearOld).getJulianDay();
            } else if (entityDate.getFormat() == PropertyDate.TO || entityDate.getFormat() == PropertyDate.BEFORE) {
                PointInTime pit = new PointInTime();
                pit.set(entityDate.getStart());
                entityStart = pit.add(0, 0, -indiMaxYearOld).getJulianDay();
                entityEnd = entityDate.getStart().getJulianDay();
            } else {
                PointInTime pit = new PointInTime();
                pit.set(entityDate.getStart());
                entityStart = pit.add(0, 0, -aboutYear).getJulianDay();
                pit.set(entityDate.getStart());
                entityEnd = pit.add(0, 0, aboutYear).getJulianDay();
            }
            result = recordEnd >= entityStart - marge ? entityEnd >= recordStart - marge : false;
        }
        catch (GedcomException ex) {
            result = false;
        }
        return result;
    }

    public static boolean isSameLastName(String str1, String str2) {
        boolean result = false;
        if (str1 != null && !str1.isEmpty()) {
            String[] names1 = str1.split(",");
            String[] names2 = str2.split(",");
            for (String name1 : names1) {
                String similarName1 = SimilarNameSet.getSimilarLastName().getSimilarName(name1);
                for (String name2 : names2) {
                    if (result |= dm.encode(similarName1).equals(dm.encode(SimilarNameSet.getSimilarLastName().getSimilarName(name2)))) break;
                }
                if (!result) {
                    continue;
                }
                break;
            }
        } else {
            return true;
        }
        return result;
    }

    public static boolean isSameFirstName(String str1, String str2) {
        boolean result = false;
        if (str1 != null && !str1.isEmpty()) {
            String[] names1 = str1.split("[\\,|\\ ]+");
            String[] names2 = str2.split("[\\,|\\ ]+");
            for (String name1 : names1) {
                String similarName1 = SimilarNameSet.getSimilarFirstName().getSimilarName(name1);
                for (String name2 : names2) {
                    if (result |= dm.encode(similarName1).equals(dm.encode(SimilarNameSet.getSimilarFirstName().getSimilarName(name2)))) break;
                }
                if (!result) {
                    continue;
                }
                break;
            }
        } else {
            return true;
        }
        return result;
    }

    protected static boolean isRecordAfterThanDate(PropertyDate recordDate, PropertyDate parentBirthDate, int minMonthShift, int minYearShift) {
        boolean result;
        if (recordDate == null) {
            return true;
        }
        if (!recordDate.isComparable()) {
            return true;
        }
        if (parentBirthDate == null) {
            return true;
        }
        if (!parentBirthDate.isComparable()) {
            return true;
        }
        try {
            int birthEnd;
            int birthStart;
            int maxEnd;
            int minStart;
            PointInTime pit = new PointInTime();
            if (recordDate.getFormat() == PropertyDate.DATE) {
                int maxStart;
                pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                int minEnd = minStart = pit.add(0, 0, -indiMaxYearOld).getJulianDay();
                pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                maxEnd = maxStart = pit.add(0, -minMonthShift, -minYearShift).getJulianDay();
            } else if (recordDate.getFormat() == PropertyDate.BETWEEN_AND || recordDate.getFormat() == PropertyDate.FROM_TO) {
                pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                minStart = pit.add(0, 0, -indiMaxYearOld).getJulianDay();
                pit.set(recordDate.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN));
                int minEnd = pit.add(0, 0, -indiMaxYearOld).getJulianDay();
                pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                pit.set(recordDate.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN));
                maxEnd = pit.add(0, -minMonthShift, -minYearShift).getJulianDay();
            } else if (recordDate.getFormat() == PropertyDate.FROM || recordDate.getFormat() == PropertyDate.AFTER) {
                pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                minStart = pit.add(0, 0, -indiMaxYearOld).getJulianDay();
                int minEnd = Integer.MAX_VALUE;
                pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                maxEnd = Integer.MAX_VALUE;
            } else if (recordDate.getFormat() == PropertyDate.TO || recordDate.getFormat() == PropertyDate.BEFORE) {
                minStart = Integer.MIN_VALUE;
                pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                int minEnd = pit.add(0, 0, -indiMaxYearOld).getJulianDay();
                pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                maxEnd = pit.add(0, -minMonthShift, -minYearShift).getJulianDay();
            } else {
                pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                minStart = pit.add(0, 0, -indiMaxYearOld - aboutYear).getJulianDay();
                pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                int minEnd = pit.add(0, 0, -indiMaxYearOld + aboutYear).getJulianDay();
                pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                maxEnd = pit.add(0, -minMonthShift, -minYearShift + aboutYear).getJulianDay();
            }
            if (parentBirthDate.getFormat() == PropertyDate.DATE) {
                birthEnd = birthStart = parentBirthDate.getStart().getJulianDay();
            } else if (parentBirthDate.getFormat() == PropertyDate.BETWEEN_AND || parentBirthDate.getFormat() == PropertyDate.FROM_TO) {
                birthStart = parentBirthDate.getStart().getJulianDay();
                birthEnd = parentBirthDate.getEnd().getJulianDay();
            } else if (parentBirthDate.getFormat() == PropertyDate.FROM || parentBirthDate.getFormat() == PropertyDate.AFTER) {
                birthStart = parentBirthDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getJulianDay();
                birthEnd = Integer.MAX_VALUE;
            } else if (parentBirthDate.getFormat() == PropertyDate.TO || parentBirthDate.getFormat() == PropertyDate.BEFORE) {
                pit.set(parentBirthDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                birthStart = pit.add(0, 0, -indiMaxYearOld).getJulianDay();
                birthEnd = parentBirthDate.getStart().getJulianDay();
            } else {
                PointInTime startPit = new PointInTime();
                startPit.set(parentBirthDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                birthStart = startPit.add(0, 0, -aboutYear).getJulianDay();
                PointInTime endPit = new PointInTime();
                endPit.set(parentBirthDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
                birthEnd = startPit.add(0, 0, aboutYear).getJulianDay();
            }
            result = birthStart > maxEnd ? false : minStart <= birthEnd;
        }
        catch (GedcomException ex) {
            result = false;
        }
        return result;
    }

    protected static boolean isRecordBeforeThanDate(PropertyDate recordDate, PropertyDate parentDeathDate, int minMonthShift, int minYearShift) throws GedcomException {
        int maxEnd;
        int maxStart;
        int recEnd;
        int recStart;
        if (recordDate == null) {
            return true;
        }
        if (!recordDate.isComparable()) {
            return true;
        }
        if (parentDeathDate == null) {
            return true;
        }
        if (!parentDeathDate.isComparable()) {
            return true;
        }
        if (recordDate.getFormat() == PropertyDate.DATE) {
            pit = new PointInTime();
            pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            recEnd = recStart = pit.add(0, -minMonthShift, -minYearShift).getJulianDay();
        } else if (recordDate.getFormat() == PropertyDate.BETWEEN_AND || recordDate.getFormat() == PropertyDate.FROM_TO) {
            pit = new PointInTime();
            pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            recStart = pit.add(0, -minMonthShift, -minYearShift).getJulianDay();
            pit.set(recordDate.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN));
            recEnd = pit.add(0, -minMonthShift, -minYearShift).getJulianDay();
        } else if (recordDate.getFormat() == PropertyDate.FROM || recordDate.getFormat() == PropertyDate.AFTER) {
            pit = new PointInTime();
            pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            recStart = pit.add(0, -minMonthShift, -minYearShift).getJulianDay();
            pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            recEnd = pit.add(0, 0, indiMaxYearOld).getJulianDay();
        } else if (recordDate.getFormat() == PropertyDate.TO || recordDate.getFormat() == PropertyDate.BEFORE) {
            pit = new PointInTime();
            pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            recStart = pit.add(0, 0, -indiMaxYearOld).getJulianDay();
            pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            recEnd = pit.add(0, -minMonthShift, -minYearShift).getJulianDay();
        } else {
            pit = new PointInTime();
            pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            recStart = pit.add(0, -minMonthShift, -minYearShift - aboutYear).getJulianDay();
            pit.set(recordDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            recEnd = pit.add(0, -minMonthShift, -minYearShift + aboutYear).getJulianDay();
        }
        if (parentDeathDate.getFormat() == PropertyDate.DATE) {
            PointInTime pit = new PointInTime();
            pit.set(parentDeathDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            maxStart = pit.add(0, 0, -indiMaxYearOld).getJulianDay();
            maxEnd = parentDeathDate.getStart().getJulianDay();
        } else if (parentDeathDate.getFormat() == PropertyDate.BETWEEN_AND || parentDeathDate.getFormat() == PropertyDate.FROM_TO) {
            PointInTime pit = new PointInTime();
            pit.set(parentDeathDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            maxStart = pit.add(0, 0, -indiMaxYearOld).getJulianDay();
            maxEnd = parentDeathDate.getEnd().getJulianDay();
        } else if (parentDeathDate.getFormat() == PropertyDate.FROM || parentDeathDate.getFormat() == PropertyDate.AFTER) {
            PointInTime pit = new PointInTime();
            pit.set(parentDeathDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            maxStart = pit.add(0, 0, -indiMaxYearOld).getJulianDay();
            pit.set(parentDeathDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            maxEnd = pit.add(0, 0, indiMaxYearOld).getJulianDay();
        } else if (parentDeathDate.getFormat() == PropertyDate.TO || parentDeathDate.getFormat() == PropertyDate.BEFORE) {
            PointInTime pit = new PointInTime();
            pit.set(parentDeathDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            maxStart = pit.add(0, 0, -indiMaxYearOld).getJulianDay();
            maxEnd = parentDeathDate.getStart().getJulianDay();
        } else {
            PointInTime pit = new PointInTime();
            pit.set(parentDeathDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            maxStart = pit.add(0, 0, -indiMaxYearOld).getJulianDay();
            pit.set(parentDeathDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN));
            maxEnd = pit.add(0, 0, aboutYear).getJulianDay();
        }
        boolean result = recEnd >= maxStart && maxEnd >= recStart;
        return result;
    }

    public static PropertyDate getMostAccurateDate(PropertyDate recordDate, PropertyDate gedcomDate) {
        PropertyDate result;
        try {
            if (!gedcomDate.isValid()) {
                result = recordDate;
            } else if (gedcomDate.getFormat() == PropertyDate.DATE) {
                if (recordDate.getFormat() == PropertyDate.DATE) {
                    if (gedcomDate.getStart().getYear() == Integer.MAX_VALUE) {
                        result = recordDate.getStart().getYear() != Integer.MAX_VALUE ? recordDate : gedcomDate;
                    } else if (gedcomDate.getStart().getMonth() == Integer.MAX_VALUE) {
                        result = recordDate.getStart().getMonth() != Integer.MAX_VALUE ? recordDate : gedcomDate;
                    } else if (gedcomDate.getStart().getDay() == Integer.MAX_VALUE) {
                        result = recordDate.getStart().getDay() != Integer.MAX_VALUE ? recordDate : gedcomDate;
                    } else if (recordDate.getStart().getYear() != Integer.MAX_VALUE && recordDate.getStart().getMonth() != Integer.MAX_VALUE && recordDate.getStart().getDay() != Integer.MAX_VALUE) {
                        if (recordDate.getStart().getYear() == gedcomDate.getStart().getYear() && recordDate.getStart().getMonth() == gedcomDate.getStart().getMonth() && recordDate.getStart().getDay() == gedcomDate.getStart().getDay()) {
                            return gedcomDate;
                        }
                        result = null;
                    } else {
                        result = gedcomDate;
                    }
                } else {
                    result = gedcomDate;
                }
            } else {
                boolean aboutEnd;
                int end;
                boolean aboutStart;
                int start;
                int end2;
                int start2;
                PointInTime endPit;
                PointInTime startPit;
                int end1;
                int start1;
                boolean about1 = false;
                boolean about2 = false;
                if (recordDate.getFormat() == PropertyDate.DATE) {
                    end1 = start1 = recordDate.getStart().getJulianDay();
                } else if (recordDate.getFormat() == PropertyDate.BEFORE || recordDate.getFormat() == PropertyDate.TO) {
                    start1 = Integer.MIN_VALUE;
                    end1 = recordDate.getStart().getJulianDay();
                } else if (recordDate.getFormat() == PropertyDate.AFTER || recordDate.getFormat() == PropertyDate.FROM) {
                    start1 = recordDate.getStart().getJulianDay();
                    end1 = Integer.MAX_VALUE;
                } else if (recordDate.getFormat() == PropertyDate.BETWEEN_AND || recordDate.getFormat() == PropertyDate.FROM_TO) {
                    start1 = recordDate.getStart().getJulianDay();
                    end1 = recordDate.getEnd().getJulianDay();
                } else {
                    startPit = new PointInTime();
                    startPit.set(recordDate.getStart());
                    start1 = startPit.add(0, 0, -aboutYear).getJulianDay();
                    endPit = new PointInTime();
                    endPit.set(recordDate.getStart());
                    end1 = startPit.add(0, 0, aboutYear).getJulianDay();
                    about1 = true;
                }
                if (gedcomDate.getFormat() == PropertyDate.DATE) {
                    end2 = start2 = gedcomDate.getStart().getJulianDay();
                } else if (gedcomDate.getFormat() == PropertyDate.BEFORE || gedcomDate.getFormat() == PropertyDate.TO) {
                    startPit = new PointInTime();
                    startPit.set(gedcomDate.getStart());
                    start2 = Integer.MIN_VALUE;
                    end2 = gedcomDate.getStart().getJulianDay();
                } else if (gedcomDate.getFormat() == PropertyDate.AFTER || gedcomDate.getFormat() == PropertyDate.FROM) {
                    start2 = gedcomDate.getStart().getJulianDay();
                    startPit = new PointInTime();
                    startPit.set(gedcomDate.getStart());
                    end2 = Integer.MAX_VALUE;
                } else if (gedcomDate.getFormat() == PropertyDate.BETWEEN_AND || gedcomDate.getFormat() == PropertyDate.FROM_TO) {
                    start2 = gedcomDate.getStart().getJulianDay();
                    end2 = gedcomDate.getEnd().getJulianDay();
                } else {
                    startPit = new PointInTime();
                    startPit.set(gedcomDate.getStart());
                    start2 = startPit.add(0, 0, -aboutYear).getJulianDay();
                    endPit = new PointInTime();
                    endPit.set(gedcomDate.getStart());
                    end2 = endPit.add(0, 0, aboutYear).getJulianDay();
                    about2 = true;
                }
                if (start1 > start2) {
                    start = start1;
                    aboutStart = about1;
                } else {
                    start = start2;
                    aboutStart = about2;
                }
                if (end1 > end2) {
                    end = end2;
                    aboutEnd = about2;
                } else {
                    end = end1;
                    aboutEnd = about1;
                }
                if (start <= end) {
                    if (start == start1 && end == end1) {
                        result = recordDate;
                    } else if (start == start2 && end == end2) {
                        result = gedcomDate;
                    } else if (start != Integer.MIN_VALUE && end != Integer.MAX_VALUE) {
                        if (aboutEnd && end == end2 || aboutStart && start == start2) {
                            result = gedcomDate;
                        } else {
                            result = new PropertyDate();
                            result.setValue(PropertyDate.BETWEEN_AND, MergeQuery.toPointInTime(start), MergeQuery.toPointInTime(end), "intersection entre la date du releve et la date du gedcom");
                        }
                    } else if (start == Integer.MIN_VALUE && end != Integer.MAX_VALUE) {
                        result = new PropertyDate();
                        result.setValue(PropertyDate.BEFORE, MergeQuery.toPointInTime(end), null, "");
                    } else if (start != Integer.MIN_VALUE && end == Integer.MAX_VALUE) {
                        result = new PropertyDate();
                        result.setValue(PropertyDate.AFTER, MergeQuery.toPointInTime(start), null, "");
                    } else {
                        result = null;
                    }
                } else {
                    result = null;
                }
            }
        }
        catch (GedcomException ex) {
            result = null;
        }
        return result;
    }

    protected static PointInTime toPointInTime(int julianDay) {
        int l = julianDay + 68569;
        int n = 4 * l / 146097;
        int i = 4000 * ((l -= (146097 * n + 3) / 4) + 1) / 1461001;
        l = l - 1461 * i / 4 + 31;
        int j = 80 * l / 2447;
        int d = l - 2447 * j / 80;
        l = j / 11;
        int m = j + 2 - 12 * l;
        int y = 100 * (n - 49) + i + l;
        return new PointInTime(Integer.MAX_VALUE, Integer.MAX_VALUE, y <= 0 ? y - 1 : y);
    }

    protected static String findOccupation(Indi indi, PropertyDate occupationDate) {
        Object result;
        Property foundOccupation = null;
        Property foundDate = null;
        for (Property iterationOccupation : indi.getProperties("OCCU")) {
            for (Property iterationDate : iterationOccupation.getProperties("DATE", false)) {
                if (foundOccupation == null) {
                    foundOccupation = iterationOccupation;
                    foundDate = iterationDate;
                    continue;
                }
                if (Math.abs(occupationDate.compareTo((Property)((PropertyDate)iterationDate))) > Math.abs(occupationDate.compareTo(foundDate))) continue;
                foundOccupation = iterationOccupation;
                foundDate = iterationDate;
            }
        }
        if (foundOccupation != null) {
            String date;
            Property place;
            result = foundOccupation.getValue();
            Property address = foundOccupation.getProperty("ADDR");
            if (address != null && !address.getValue().isEmpty()) {
                if (!((String)result).isEmpty()) {
                    result = (String)result + ", ";
                }
                result = (String)result + address.getValue();
            }
            if ((place = foundOccupation.getProperty("PLAC")) != null && !place.getValue().isEmpty()) {
                if (!((String)result).isEmpty()) {
                    result = (String)result + ", ";
                }
                result = (String)result + place.getValue();
            }
            if (!(date = foundOccupation.getPropertyDisplayValue("DATE")).isEmpty()) {
                result = (String)result + " (" + date + ")";
            }
        } else {
            result = MergeQuery.findResidence(indi, occupationDate);
        }
        return result;
    }

    protected static String findResidence(Indi indi, PropertyDate residenceDate) {
        Property foundResidence = null;
        Property foundDate = null;
        for (Property iterationResidence : indi.getProperties("RESI")) {
            for (Property iterationDate : iterationResidence.getProperties("DATE", false)) {
                if (foundResidence == null) {
                    foundResidence = iterationResidence;
                    foundDate = iterationDate;
                    continue;
                }
                if (Math.abs(residenceDate.compareTo((Property)((PropertyDate)iterationDate))) > Math.abs(residenceDate.compareTo(foundDate))) continue;
                foundResidence = iterationResidence;
                foundDate = iterationDate;
            }
        }
        Object result = "";
        if (foundResidence != null) {
            String date;
            Property place;
            result = foundResidence.getValue();
            Property address = foundResidence.getProperty("ADDR");
            if (address != null && !address.getValue().isEmpty()) {
                if (!((String)result).isEmpty()) {
                    result = (String)result + ", ";
                }
                result = (String)result + address.getValue();
            }
            if ((place = foundResidence.getProperty("PLAC")) != null && !place.getValue().isEmpty()) {
                if (!((String)result).isEmpty()) {
                    result = (String)result + ", ";
                }
                result = (String)result + place.getValue();
            }
            if (!(date = foundResidence.getPropertyDisplayValue("DATE")).isEmpty()) {
                result = (String)result + " (" + date + ")";
            }
        }
        return result;
    }

    static {
        dm.setMaxCodeLen(5);
    }
}

