<?xml version='1.0' encoding='ISO-8859-1'?>

<!-- =============================================================== -->
<!--                                                                 -->
<!-- Convert XSL FO to CSV (comma separated values)                  -->
<!--                                                                 -->
<!-- Author: Nils Meier, nmeier at sourceforge dot net (<2008)       -->
<!-- Author: Frederic : updated 2025-03-01 to support nested tables  -->
<!--                                                                 -->
<!-- =============================================================== -->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:genj="http://genj.sourceforge.net/XSL/Format"
                exclude-result-prefixes="fo">
 
    <xsl:output method="text" encoding="utf-8" indent="no"/>
    <xsl:variable name="separator">;</xsl:variable>
    <xsl:variable name="delimitor">"</xsl:variable>

    <!-- catch only tables not including tables -->
    <xsl:template match="fo:table[count(descendant::fo:table)=0]">
        <xsl:if test="@genj:csv='true'">
            <xsl:apply-templates/>
        </xsl:if>
    </xsl:template>


    <!-- catch only rows that do not include tables -->
    <xsl:template match="fo:table-row[count(descendant::fo:table)=0]">
        <xsl:if test="../../@genj:csvprefix">
            <xsl:value-of select="$delimitor"/>
            <xsl:value-of select="../../@genj:csvprefix"/>
            <xsl:value-of select="$delimitor"/>
            <xsl:value-of select="$separator"/>
        </xsl:if>
        <xsl:apply-templates select="fo:table-cell"/>
        <xsl:text>&#xa;</xsl:text>
    </xsl:template>



    <!-- catch only cells that do not include tables -->
    <xsl:template match="fo:table-cell[count(descendant::fo:table)=0]">
        <xsl:if test="not(@genj:csv='false')">
            <xsl:value-of select="$delimitor"/>
            <xsl:value-of select="."/>
            <xsl:value-of select="$delimitor"/>
            <xsl:if test="position()!=last()">
                <xsl:value-of select="$separator"/>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <!-- skip remaining text -->
    <xsl:template match="text()">
    </xsl:template>
 
</xsl:stylesheet>