# NAME

lcagentrc - lcagent rcfile

# DESCRIPTION

The rcfile consists of some global options followed by a list of
channels with their settings and commands.

## Comments

A comment begins with \# and all the following characters up to a
NEWLINE are ignored.

# OPTIONS

## Global Options

**debug**

:   Enable debug logging. The same as setting \--debug on the command
    line.

**directory *directory***

:   Set the default directory for channels. Change to this *directory*
    before executing any commands.

**enable**

:   Enable channels. The default. Can be overridden by *noenable* per
    channel.

**join**

:   Join channels. The default. Can be overridden by *nojoin* per
    channel.

**logfile**

:   Set the path to the logfile. Logs will be written here instead of to
    *stderr*.

**noenable \| disable**

:   Do not enable channels. Can be overridden by *enable* per channel.

**nojoin**

:   Do not join channels. Can be overridden by *join* per channel.

**seed *seed***

:   Generate a symmetric key from *seed* and use it to encrypt and
    decrypt data sent and received on all channels.

If an encryption seed is used, the permissions for the rcfile must not
be world readable or lcagent will refuse to run and print an error.

## Channel Options

**enable**

:   Enable this channel. The default, unless *noenable* is set globally.

**directory**

:   Change to this *directory* before executing any commands for this
    channel.

**join**

:   Join channel. The default, unless *nojoin* is set globally.

**noenable \| disable**

:   The channel is not enabled. The channel will still be joined (unless
    *nojoin* is also set, and attempts to execute it will be logged, but
    no commands will execute. This also prevents execution with
    **lcagent** exec.

**nojoin**

:   Do not join the Librecast Channel. The channel commands can still be
    executed by calling **lcagent** exec.

**command *command***

:   Execute *command*. If it fails, do not execute any following
    commands. The channel will continue listening.

**try *command***

:   Execute *command*. If it fails, continue executing any subsequent
    commands anyway.

# EXAMPLE

    # This is an example rcfile for lcagent(1)
    # Comments begin with a hash and run until the end of the line.
    # Whitespace, including blank lines are ignored.
    # Indenting channel settings is optional, but is recommended for readability.
    # Leaving a blank line between channels is also advised.

    # enable debug logging and set logfile
    debug
    logfile /var/log/lcagent.log
    seed somepassword

    # set any global options
    # these can be overridden by individual channel options
    # these are the defaults:
    join
    enable


    channel "my very first channel"
    	# we usually indent the settings for each channel
    	noenable             # this channel will not be executed
    	command "/this/command/not/executed"

    # this channel will not be joined, but can still be executed
    # with `lcagent exec`
    channel 'single quotes are valid string delimiters too'
    	nojoin               # this channel will not be joined
    	command "cat > /tmp/somefile"
    	command "bzip2 /tmp/somefile"
    	reload               # reload lcagent config on success

    channel unquoted-string-channel
    	try "/bin/false"     # this can fail, and we still continue
    	command "/bin/true"  # this command must succeed, or we stop
    	command "/usr/local/bin/someplugin"
    	restart              # restart lcagent config on success

    # this channel will apply a git patch sent to it which was created
    # with git-format-patch(1).
    # If the patch applies without error, `gmake test` is run
    channel "lcagent patchtest"
            directory /home/lcagent/src/lcagent
            command "git am --committer-date-is-author-date"
            command "gmake test"

# SEE ALSO

**lcagent**(1), **librecast**(7)
