---
myst:
  html_meta:
    keywords: LaTeX, généralités, bases, saisie, clavier, caractère, GNU/Linux
---

% Quelques commentaires relatifs au balisage à utiliser sont à trouver
% dans la version de cette page pour mac os.

# Comment obtenir ce caractère utile pour le codage TeX et LaTeX sur mon clavier sous GNU/Linux ?


Dans ce qui suit :

- {kbd}`⇧` est la touche de majuscule (non verrouillée), aussi nommée par le mot anglais *shift* ;
- {kbd}`⇪` est la touche de majuscule verrouillée (dont l'état activé est matérialisé par l'allumage d'une petite LED).

:::{todo}
Ce qui précède est à adapter ou à supprimer.
:::

:::{todo}
Ce qui suit est à compléter en s'inspirant de [](/1_generalites/bases/comment_obtenir_ce_caractere_sous_macOS). Quelques informations (à vérifier) sont disponibles pour les majuscules accentuées sur la page Wikipédia dédiée à l'[obtention des majuscules accentuées](wpfr:Usage_des_majuscules_en_français#Claviers_physiques_et_logiciels_en_informatique).
:::


## Clavier Français (France)

Le clavier est de type AZERTY. Ce qui suit s'applique à la méthode d'entrée "Français (France)".


:::{list-table} Les caractères utiles au code TeX et LaTeX
:widths: 13 29 58
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère 
  - Combinaison de touches (Français (France))
  - Commentaire
* - `\`
  - 
  - 
* - `(`
  - 
  - 
* - `)`
  - 
  - 
* - `{`
  - 
  - 
* - `}`
  - 
  - 
* - `[`
  - 
  - 
* - `]`
  - 
  - 
* - `_`
  - 
  - 
* - `~`
  - 
  - Caractère nommé *tilde*
* - `%`
  - 
  - 
* - `&`
  - 
  -  
* - `#`
  - 
  - 
* - `$`
  - 
  - 
* - `<`
  - 
  - 
* - `>`
  - 
  - 
* - `@`
  - 
  - 
* - `:`
  - 
  - 
* - `^`
  - 
  - 
* - `|`
  - 
  - Caractère nommé *pipe* (tuyau).
:::



:::{list-table} Les majuscules accentuées
:widths: 13 36 51
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère 
  - Combinaison de touches (Français (France))
  - Commentaire
* - `À`
  - 
  - 
* - `Â`
  - 
  - 
* - `É`
  - 
  - 
* - `È`
  - 
  - 
* - `Ê`
  - 
  - 
* - `Ë`
  - 
  - 
* - `Î`
  -  
  - 
* - `Ï`
  - 
  - 
* - `Ô`
  - 
  - 
* - `Ù`
  - 
  - 
* - `Û`
  - 
  - 
* - `Ü`
  - 
  - 
* - `Ÿ`
  - 
  -   
:::



:::{list-table} Autres caractères utilisés en langue française ou avec les moteurs UTF-8
:widths: 12 26 61
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère 
  - Combinaison de touches (Français (France))
  - Commentaire
* - `æ`
  - 
  - 
* - `œ`
  - 
  - 
* - `Æ`
  - 
  - 
* - `Œ`
  - 
  - 
* - `ç`
  - 
  - 
* - `Ç`
  - 
  - 
* - `«`
  - 
  - 
* - `»`
  - 
  - 
* - `…`
  - 
  - *(Pour LuaLaTeX/XeLaTeX)* 
* - espace insécable
  - 
  - *(Pour LuaLaTeX/XeLaTeX)* 
* - `—` (—)
  - 
  - *(Pour LuaLaTeX/XeLaTeX)* Tiret cadratin (ou tiret long)
* - `–` (–)
  - 
  - *(Pour LuaLaTeX/XeLaTeX)* Tiret semi-cadratin (ou tiret moyen)
* - `§`
  - 
  - 
* - `€` 
  - 
  -   
:::



## Clavier Français (Suisse)

Le clavier est de type QWERTZ. Ce qui suit s'applique à la méthode d'entrée "Français (Suisse)".

:::{list-table} Les caractères utiles au code TeX et LaTeX
:widths: 15 30 55
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère 
  - Combinaison de touches (Français (Suisse))
  - Commentaire
* - `\`
  - 
  - 
* - `(`
  - 
  - 
* - `)`
  - 
  - 
* - `{`
  - 
  - 
* - `}`
  - 
  - 
* - `[`
  - 
  - 
* - `]`
  - 
  - 
* - `_`
  - 
  - 
* - `~`
  - 
  - Caractère nommé *tilde*
* - `%`
  - 
  - 
* - `&`
  - 
  -  
* - `#`
  - 
  - 
* - `$`
  - 
  - 
* - `<`
  - 
  - 
* - `>`
  - 
  - 
* - `@`
  - 
  - 
* - `:`
  - 
  - 
* - `^`
  - 
  - 
* - `|`
  - 
  - Caractère nommé *pipe* (tuyau).
:::



:::{list-table} Les majuscules accentuées
:widths: 14 30 56
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère 
  - Combinaison de touches (Français (Suisse))
  - Commentaire
* - `À`
  - 
  - 
* - `Â`
  - 
  - 
* - `É`
  - 
  - 
* - `È`
  - 
  - 
* - `Ê`
  - 
  - 
* - `Ë`
  - 
  - 
* - `Î`
  -  
  - 
* - `Ï`
  - 
  - 
* - `Ô`
  - 
  - 
* - `Ù`
  - 
  - 
* - `Û`
  - 
  - 
* - `Ü`
  - 
  - 
* - `Ÿ`
  - 
  -     
:::




:::{list-table} Autres caractères utilisés en langue française ou avec les moteurs UTF-8
:widths: 13 30 57
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère 
  - Combinaison de touches (Français (Suisse))
  - Commentaire
* - `æ`
  - 
  - 
* - `œ`
  - 
  - 
* - `Æ`
  - 
  - 
* - `Œ`
  - 
  - 
* - `ç`
  - 
  - 
* - `Ç`
  - 
  - 
* - `«`
  - 
  - 
* - `»`
  - 
  - 
* - `…`
  - 
  - *(Pour LuaLaTeX/XeLaTeX)* 
* - espace insécable
  - 
  - *(Pour LuaLaTeX/XeLaTeX)* 
* - `—` (—)
  - 
  - *(Pour LuaLaTeX/XeLaTeX)* Tiret cadratin (ou tiret long)
* - `–` (–)
  - 
  - *(Pour LuaLaTeX/XeLaTeX)* Tiret semi-cadratin (ou tiret moyen)
* - `§`
  - 
  - 
* - `€` 
  - 
  -   
:::



## Clavier Français (Canada)

Le clavier est de type QWERTY. Ce qui suit s'applique à la méthode d'entrée "Français (Canada)".

:::{list-table} Les caractères utiles au code TeX et LaTeX
:widths: 13 32 55
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère 
  - Combinaison de touches (Français (Canada))
  - Commentaire
* - `\`
  - 
  - 
* - `(`
  - 
  - 
* - `)`
  - 
  - 
* - `{`
  - 
  - 
* - `}`
  - 
  - 
* - `[`
  - 
  - 
* - `]`
  - 
  - 
* - `_`
  - 
  - 
* - `~`
  - 
  - Caractère nommé *tilde*
* - `%`
  - 
  - 
* - `&`
  - 
  -  
* - `#`
  - 
  - 
* - `$`
  - 
  - 
* - `<`
  - 
  - 
* - `>`
  - 
  - 
* - `@`
  - 
  - 
* - `:`
  - 
  - 
* - `^`
  - 
  - 
* - `|`
  - 
  - Caractère nommé *pipe* (tuyau).
:::



:::{list-table} Les majuscules accentuées
:widths: 13 32 55
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère 
  - Combinaison de touches (Français (Canada))
  - Commentaire
* - `À`
  - 
  - 
* - `Â`
  - 
  - 
* - `É`
  - 
  - 
* - `È`
  - 
  - 
* - `Ê`
  - 
  - 
* - `Ë`
  - 
  - 
* - `Î`
  -  
  - 
* - `Ï`
  - 
  - 
* - `Ô`
  - 
  - 
* - `Ù`
  - 
  - 
* - `Û`
  - 
  - 
* - `Ü`
  - 
  - 
* - `Ÿ`
  - 
  -     
:::



:::{list-table} Autres caractères utilisés en langue française ou avec les moteurs UTF-8
:widths: 13 31 56
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère 
  - Combinaison de touches (Français (Canada))
  - Commentaire
* - `æ`
  - 
  - 
* - `œ`
  - 
  - 
* - `Æ`
  - 
  - 
* - `Œ`
  - 
  - 
* - `ç`
  - 
  - 
* - `Ç`
  - 
  - 
* - `«`
  - 
  - 
* - `»`
  - 
  - 
* - `…`
  - 
  - *(Pour LuaLaTeX/XeLaTeX)* 
* - espace insécable
  - 
  - *(Pour LuaLaTeX/XeLaTeX)* 
* - `—` (—)
  - 
  - *(Pour LuaLaTeX/XeLaTeX)* Tiret cadratin (ou tiret long)
* - `–` (–)
  - 
  - *(Pour LuaLaTeX/XeLaTeX)* Tiret semi-cadratin (ou tiret moyen)
* - `§`
  - 
  - 
* - `€` 
  - 
  -   
:::

:::{todo}
Compléter avec des méthodes d'entrée complémentaires. Par exemple par la visualisation d'un clavier virtuel qui affiche ce que produisent des combinaisons de touches, si cela est disponible sous ce système. Voir ce qui a été fait sur [](/1_generalites/bases/comment_obtenir_ce_caractere_sous_macOS)
:::

