---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, verbatim
---

# Comment insérer un texte sans que LaTeX le mette en forme ?

L'environnement `verbatim` permet d'insérer un texte tel quel sans que LaTeX 
ne le traite. Il permet notamment de faire apparaître des commandes LaTeX. 
Il est cependant fragile et peut produire des résultats très bizarres, 
par exemple, il vaut mieux éviter de l'utiliser de manière inconsidérée 
dans des contextes curieux comme les tableaux, en argument 
à une autre commande, etc.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page

\begin{document}
\begin{verbatim}
La commande \LaTeX{} permet d'imprimer 
le logo LaTeX.
\end{verbatim}
\end{document}
```

La commande `\verb` permet de faire la même chose localement. 


:::{seealso}
Une [section](/4_domaines_specialises/sciences/informatique/verbatim/start) 
de la FAQ est intégralement consacrée à ce sujet. Elle détaille les commandes
indiquées ci-dessus et présente différentes extensions permettant de résoudre
les difficultés liées.
:::