---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              fractions, fraction continue, fractions continues
---

# Comment obtenir une fraction continue ?

## Avec les commandes de base

Une [fraction continue](wpfr:Fraction_continue) peut être construite 
avec la commande mathématique `\frac` (détaillée dans la question 
"[](/4_domaines_specialises/mathematiques/structures/fractions/ecrire_une_fraction)"). 

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\[
  \sqrt{2} =
    1 + \frac{1}{1 + \frac{1}{1 + \frac{1}{1 + \frac{1}{1 +
      \frac{1}{1 + \frac{1}{1 + \frac{1}{1 + 
      \cdots }}}}}}}
\]
\end{document}
```

Notez que l'imbrication des fractions finit par les écraser
verticalement les fractions, ce qui peut les rendre peu esthétiques.


## Avec l'extension <ctanpkg:mathtools>

L'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) propose une commande
`\cfrac` qui évite l'écrasement des fractions. 
Pour toute dernière fraction, l'exemple ci-dessous utilise en plus la commande 
`\vphantom` pour que LaTeX laisse une place verticale correspondant 
à une fraction non affichée. Ce sujet est détaillé à la question 
"[](/3_composition/texte/boites/exploiter_les_fantomes)" et illustré, 
par exemple, à la question 
"[](/4_domaines_specialises/mathematiques/structures/delimiteurs/ne_pas_equilibrer_les_delimiteurs)".

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\[
  \sqrt{3} =
    1 + \cfrac{1}{1 + \cfrac{1}{2 + \cfrac{1}{1 + \cfrac{1}{2 +
      \cfrac{1}{1 + \cfrac{1}{2 + \cfrac{1}{1 + 
      \cdots \vphantom{\cfrac{1}{1}} }}}}}}}
\]
\end{document}
```


:::{sources}
- [Continued fractions](https://tex.stackexchange.com/q/346398), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::