#@package: Thermometer Thermometer

package require Itcl
package require Tk

#
# Copyright (C) 1992-1997 NeoSoft.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  NeoSoft makes no 
# representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.

#
# This file defines a Thermometer class, which can be used to graphically
# show the progress of the loading of a file, etc.
#
# In its main function, it can take either a percent complete, or two number 
# which represent a ratio of how far done the activity is, and it will
# adjust its appearance accordingly.
#
# $Id: thermometer.tcl,v 1.1.1.1 1999/03/31 20:34:39 damon Exp $
#

itcl_class Thermometer {

    constructor {config} {
    }

    method configure {config} {
    }

    method create {scaleWindowArg} {
	set scaleWindow $scaleWindowArg

	frame $scaleWindow

	label $scaleWindow.label -text $text
	pack $scaleWindow.label

	frame $scaleWindow.progress
	pack $scaleWindow.progress

        frame $scaleWindow.progress.indicator \
	    -geometry 1x20 -relief raised -borderwidth 2 \
	    -bg SteelBlue1
        pack $scaleWindow.progress.indicator -expand yes -anchor sw

	frame $scaleWindow.progress.distance -geometry 201x5 \
	    -relief flat -bg black
	pack $scaleWindow.progress.distance -anchor sw
    }

    method setf {percent} {
	if {$percent == $previousPercent} return
	set previousPercent $percent
	$scaleWindow.progress.indicator configure -geometry [expr $percent*2+1]x20
	update
    }

    method ratio {howfar total} {
	setf [expr int($howfar * 100.0 / $total)]
    }

    method text {string} {
	$scaleWindow.label configure -text $string
    }

    protected previousPercent -1

    public scaleWindow
    public text "Percent Complete"
}
