// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include <stdbool.h>

#include "cpu_features_macros.h"
#include "cpuinfo_aarch64.h"
#include "internal/bit_utils.h"
#include "internal/filesystem.h"
#include "internal/stack_line_reader.h"
#include "internal/string_view.h"

#if !defined(CPU_FEATURES_ARCH_AARCH64)
#error "Cannot compile aarch64_base on a non aarch64 platform."
#endif

////////////////////////////////////////////////////////////////////////////////
// Definitions for introspection.
////////////////////////////////////////////////////////////////////////////////
#define INTROSPECTION_TABLE                                                  \
  LINE(AARCH64_FP, fp, "fp", AARCH64_HWCAP_FP, 0)                            \
  LINE(AARCH64_ASIMD, asimd, "asimd", AARCH64_HWCAP_ASIMD, 0)                \
  LINE(AARCH64_EVTSTRM, evtstrm, "evtstrm", AARCH64_HWCAP_EVTSTRM, 0)        \
  LINE(AARCH64_AES, aes, "aes", AARCH64_HWCAP_AES, 0)                        \
  LINE(AARCH64_PMULL, pmull, "pmull", AARCH64_HWCAP_PMULL, 0)                \
  LINE(AARCH64_SHA1, sha1, "sha1", AARCH64_HWCAP_SHA1, 0)                    \
  LINE(AARCH64_SHA2, sha2, "sha2", AARCH64_HWCAP_SHA2, 0)                    \
  LINE(AARCH64_CRC32, crc32, "crc32", AARCH64_HWCAP_CRC32, 0)                \
  LINE(AARCH64_ATOMICS, atomics, "atomics", AARCH64_HWCAP_ATOMICS, 0)        \
  LINE(AARCH64_FPHP, fphp, "fphp", AARCH64_HWCAP_FPHP, 0)                    \
  LINE(AARCH64_ASIMDHP, asimdhp, "asimdhp", AARCH64_HWCAP_ASIMDHP, 0)        \
  LINE(AARCH64_CPUID, cpuid, "cpuid", AARCH64_HWCAP_CPUID, 0)                \
  LINE(AARCH64_ASIMDRDM, asimdrdm, "asimdrdm", AARCH64_HWCAP_ASIMDRDM, 0)    \
  LINE(AARCH64_JSCVT, jscvt, "jscvt", AARCH64_HWCAP_JSCVT, 0)                \
  LINE(AARCH64_FCMA, fcma, "fcma", AARCH64_HWCAP_FCMA, 0)                    \
  LINE(AARCH64_LRCPC, lrcpc, "lrcpc", AARCH64_HWCAP_LRCPC, 0)                \
  LINE(AARCH64_DCPOP, dcpop, "dcpop", AARCH64_HWCAP_DCPOP, 0)                \
  LINE(AARCH64_SHA3, sha3, "sha3", AARCH64_HWCAP_SHA3, 0)                    \
  LINE(AARCH64_SM3, sm3, "sm3", AARCH64_HWCAP_SM3, 0)                        \
  LINE(AARCH64_SM4, sm4, "sm4", AARCH64_HWCAP_SM4, 0)                        \
  LINE(AARCH64_ASIMDDP, asimddp, "asimddp", AARCH64_HWCAP_ASIMDDP, 0)        \
  LINE(AARCH64_SHA512, sha512, "sha512", AARCH64_HWCAP_SHA512, 0)            \
  LINE(AARCH64_SVE, sve, "sve", AARCH64_HWCAP_SVE, 0)                        \
  LINE(AARCH64_ASIMDFHM, asimdfhm, "asimdfhm", AARCH64_HWCAP_ASIMDFHM, 0)    \
  LINE(AARCH64_DIT, dit, "dit", AARCH64_HWCAP_DIT, 0)                        \
  LINE(AARCH64_USCAT, uscat, "uscat", AARCH64_HWCAP_USCAT, 0)                \
  LINE(AARCH64_ILRCPC, ilrcpc, "ilrcpc", AARCH64_HWCAP_ILRCPC, 0)            \
  LINE(AARCH64_FLAGM, flagm, "flagm", AARCH64_HWCAP_FLAGM, 0)                \
  LINE(AARCH64_SSBS, ssbs, "ssbs", AARCH64_HWCAP_SSBS, 0)                    \
  LINE(AARCH64_SB, sb, "sb", AARCH64_HWCAP_SB, 0)                            \
  LINE(AARCH64_PACA, paca, "paca", AARCH64_HWCAP_PACA, 0)                    \
  LINE(AARCH64_PACG, pacg, "pacg", AARCH64_HWCAP_PACG, 0)                    \
  LINE(AARCH64_DCPODP, dcpodp, "dcpodp", 0, AARCH64_HWCAP2_DCPODP)           \
  LINE(AARCH64_SVE2, sve2, "sve2", 0, AARCH64_HWCAP2_SVE2)                   \
  LINE(AARCH64_SVEAES, sveaes, "sveaes", 0, AARCH64_HWCAP2_SVEAES)           \
  LINE(AARCH64_SVEPMULL, svepmull, "svepmull", 0, AARCH64_HWCAP2_SVEPMULL)   \
  LINE(AARCH64_SVEBITPERM, svebitperm, "svebitperm", 0,                      \
       AARCH64_HWCAP2_SVEBITPERM)                                            \
  LINE(AARCH64_SVESHA3, svesha3, "svesha3", 0, AARCH64_HWCAP2_SVESHA3)       \
  LINE(AARCH64_SVESM4, svesm4, "svesm4", 0, AARCH64_HWCAP2_SVESM4)           \
  LINE(AARCH64_FLAGM2, flagm2, "flagm2", 0, AARCH64_HWCAP2_FLAGM2)           \
  LINE(AARCH64_FRINT, frint, "frint", 0, AARCH64_HWCAP2_FRINT)               \
  LINE(AARCH64_SVEI8MM, svei8mm, "svei8mm", 0, AARCH64_HWCAP2_SVEI8MM)       \
  LINE(AARCH64_SVEF32MM, svef32mm, "svef32mm", 0, AARCH64_HWCAP2_SVEF32MM)   \
  LINE(AARCH64_SVEF64MM, svef64mm, "svef64mm", 0, AARCH64_HWCAP2_SVEF64MM)   \
  LINE(AARCH64_SVEBF16, svebf16, "svebf16", 0, AARCH64_HWCAP2_SVEBF16)       \
  LINE(AARCH64_I8MM, i8mm, "i8mm", 0, AARCH64_HWCAP2_I8MM)                   \
  LINE(AARCH64_BF16, bf16, "bf16", 0, AARCH64_HWCAP2_BF16)                   \
  LINE(AARCH64_DGH, dgh, "dgh", 0, AARCH64_HWCAP2_DGH)                       \
  LINE(AARCH64_RNG, rng, "rng", 0, AARCH64_HWCAP2_RNG)                       \
  LINE(AARCH64_BTI, bti, "bti", 0, AARCH64_HWCAP2_BTI)                       \
  LINE(AARCH64_MTE, mte, "mte", 0, AARCH64_HWCAP2_MTE)                       \
  LINE(AARCH64_ECV, ecv, "ecv", 0, AARCH64_HWCAP2_ECV)                       \
  LINE(AARCH64_AFP, afp, "afp", 0, AARCH64_HWCAP2_AFP)                       \
  LINE(AARCH64_RPRES, rpres, "rpres", 0, AARCH64_HWCAP2_RPRES)               \
  LINE(AARCH64_MTE3, mte3, "mte3", 0, AARCH64_HWCAP2_MTE3)                   \
  LINE(AARCH64_SME, sme, "sme", 0, AARCH64_HWCAP2_SME)                       \
  LINE(AARCH64_SME_I16I64, smei16i64, "smei16i64", 0,                        \
       AARCH64_HWCAP2_SME_I16I64)                                            \
  LINE(AARCH64_SME_F64F64, smef64f64, "smef64f64", 0,                        \
       AARCH64_HWCAP2_SME_F64F64)                                            \
  LINE(AARCH64_SME_I8I32, smei8i32, "smei8i32", 0, AARCH64_HWCAP2_SME_I8I32) \
  LINE(AARCH64_SME_F16F32, smef16f32, "smef16f32", 0,                        \
       AARCH64_HWCAP2_SME_F16F32)                                            \
  LINE(AARCH64_SME_B16F32, smeb16f32, "smeb16f32", 0,                        \
       AARCH64_HWCAP2_SME_B16F32)                                            \
  LINE(AARCH64_SME_F32F32, smef32f32, "smef32f32", 0,                        \
       AARCH64_HWCAP2_SME_F32F32)                                            \
  LINE(AARCH64_SME_FA64, smefa64, "smefa64", 0, AARCH64_HWCAP2_SME_FA64)     \
  LINE(AARCH64_WFXT, wfxt, "wfxt", 0, AARCH64_HWCAP2_WFXT)                   \
  LINE(AARCH64_EBF16, ebf16, "ebf16", 0, AARCH64_HWCAP2_EBF16)               \
  LINE(AARCH64_SVE_EBF16, sveebf16, "sveebf16", 0, AARCH64_HWCAP2_SVE_EBF16) \
  LINE(AARCH64_CSSC, cssc, "cssc", 0, AARCH64_HWCAP2_CSSC)                   \
  LINE(AARCH64_RPRFM, rprfm, "rprfm", 0, AARCH64_HWCAP2_RPRFM)               \
  LINE(AARCH64_SVE2P1, sve2p1, "sve2p1", 0, AARCH64_HWCAP2_SVE2P1)           \
  LINE(AARCH64_SME2, sme2, "sme2", 0, AARCH64_HWCAP2_SME2)                   \
  LINE(AARCH64_SME2P1, sme2p1, "sme2p1", 0, AARCH64_HWCAP2_SME2P1)           \
  LINE(AARCH64_SME_I16I32, smei16i32, "smei16i32", 0,                        \
       AARCH64_HWCAP2_SME_I16I32)                                            \
  LINE(AARCH64_SME_BI32I32, smebi32i32, "smebi32i32", 0,                     \
       AARCH64_HWCAP2_SME_BI32I32)                                           \
  LINE(AARCH64_SME_B16B16, smeb16b16, "smeb16b16", 0,                        \
       AARCH64_HWCAP2_SME_B16B16)                                            \
  LINE(AARCH64_SME_F16F16, smef16f16, "smef16f16", 0,                        \
       AARCH64_HWCAP2_SME_F16F16)                                            \
  LINE(AARCH64_MOPS, mops, "mops", 0, AARCH64_HWCAP2_MOPS)                   \
  LINE(AARCH64_HBC, hbc, "hbc", 0, AARCH64_HWCAP2_HBC)                       \
  LINE(AARCH64_SVE_B16B16, sveb16b16, "sveb16b16", 0,                        \
       AARCH64_HWCAP2_SVE_B16B16)                                            \
  LINE(AARCH64_LRCPC3, lrcpc3, "lrcpc3", 0, AARCH64_HWCAP2_LRCPC3)           \
  LINE(AARCH64_LSE128, lse128, "lse128", 0, AARCH64_HWCAP2_LSE128)           \
  LINE(AARCH64_FPMR, fpmr, "fpmr", 0, AARCH64_HWCAP2_FPMR)                   \
  LINE(AARCH64_LUT, lut, "lut", 0, AARCH64_HWCAP2_LUT)                       \
  LINE(AARCH64_FAMINMAX, faminmax, "faminmax", 0, AARCH64_HWCAP2_FAMINMAX)   \
  LINE(AARCH64_F8CVT, f8cvt, "f8cvt", 0, AARCH64_HWCAP2_F8CVT)               \
  LINE(AARCH64_F8FMA, f8fma, "f8fma", 0, AARCH64_HWCAP2_F8FMA)               \
  LINE(AARCH64_F8DP4, f8dp4, "f8dp4", 0, AARCH64_HWCAP2_F8DP4)               \
  LINE(AARCH64_F8DP2, f8dp2, "f8dp2", 0, AARCH64_HWCAP2_F8DP2)               \
  LINE(AARCH64_F8E4M3, f8e4m3, "f8e4m3", 0, AARCH64_HWCAP2_F8E4M3)           \
  LINE(AARCH64_F8E5M2, f8e5m2, "f8e5m2", 0, AARCH64_HWCAP2_F8E5M2)           \
  LINE(AARCH64_SME_LUTV2, smelutv2, "smelutv1", 0, AARCH64_HWCAP2_SME_LUTV2) \
  LINE(AARCH64_SME_F8F16, smef8f16, "smef8f16", 0, AARCH64_HWCAP2_SME_F8F16) \
  LINE(AARCH64_SME_F8F32, smef8f32, "smef8f32", 0, AARCH64_HWCAP2_SME_F8F32) \
  LINE(AARCH64_SME_SF8FMA, smesf8fma, "smesf8fma", 0,                        \
       AARCH64_HWCAP2_SME_SF8FMA)                                            \
  LINE(AARCH64_SME_SF8DP4, smesf8dp4, "smesf8dp4", 0,                        \
       AARCH64_HWCAP2_SME_SF8DP4)                                            \
  LINE(AARCH64_SME_SF8DP2, smesf8dp2, "smesf8dp2", 0, AARCH64_HWCAP2_SME_SF8DP2)

#define INTROSPECTION_PREFIX Aarch64
#define INTROSPECTION_ENUM_PREFIX AARCH64
#include "define_introspection_and_hwcaps.inl"
