
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_seq_mv.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_CSRMatrixAdd( HYPRE_Complex alpha, hypre_CSRMatrix *A, HYPRE_Complex beta, hypre_CSRMatrix *B )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixAdd)( alpha, A, beta, B );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixAddFirstPass( HYPRE_Int firstrow, HYPRE_Int lastrow, HYPRE_Int *marker, HYPRE_Int *twspace, HYPRE_Int *map_A2C, HYPRE_Int *map_B2C, hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_Int nnzrows_C, HYPRE_Int nrows_C, HYPRE_Int ncols_C, HYPRE_Int *rownnz_C, HYPRE_MemoryLocation memory_location_C, HYPRE_Int *C_i, hypre_CSRMatrix **C_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixAddFirstPass)( firstrow, lastrow, marker, twspace, map_A2C, map_B2C, A, B, nnzrows_C, nrows_C, ncols_C, rownnz_C, memory_location_C, C_i, C_ptr );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_CSRMatrixAddHost( HYPRE_Complex alpha, hypre_CSRMatrix *A, HYPRE_Complex beta, hypre_CSRMatrix *B )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixAddHost)( alpha, A, beta, B );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_CSRMatrixAddPartial( hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_Int *row_nums )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixAddPartial)( A, B, row_nums );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixAddSecondPass( HYPRE_Int firstrow, HYPRE_Int lastrow, HYPRE_Int *marker, HYPRE_Int *map_A2C, HYPRE_Int *map_B2C, HYPRE_Int *rownnz_C, HYPRE_Complex alpha, HYPRE_Complex beta, hypre_CSRMatrix *A, hypre_CSRMatrix *B, hypre_CSRMatrix *C )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixAddSecondPass)( firstrow, lastrow, marker, map_A2C, map_B2C, rownnz_C, alpha, beta, A, B, C );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixBigInitialize( hypre_CSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixBigInitialize)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixBigJtoJ( hypre_CSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixBigJtoJ)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixCheckSetNumNonzeros( hypre_CSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixCheckSetNumNonzeros)( matrix );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_CSRMatrixClone( hypre_CSRMatrix *A, HYPRE_Int copy_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixClone)( A, copy_data );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_CSRMatrixClone_v2( hypre_CSRMatrix *A, HYPRE_Int copy_data, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixClone_v2)( A, copy_data, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixComputeColSum( hypre_CSRMatrix *A, HYPRE_Complex *col_sum, HYPRE_Int type, HYPRE_Complex scal )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixComputeColSum)( A, col_sum, type, scal );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixComputeRowSum( hypre_CSRMatrix *A, HYPRE_Int *CF_i, HYPRE_Int *CF_j, HYPRE_Complex *row_sum, HYPRE_Int type, HYPRE_Complex scal, const char *set_or_add )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixComputeRowSum)( A, CF_i, CF_j, row_sum, type, scal, set_or_add );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixCopy( hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_Int copy_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixCopy)( A, B, copy_data );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_CSRMatrixCreate( HYPRE_Int num_rows, HYPRE_Int num_cols, HYPRE_Int num_nonzeros )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixCreate)( num_rows, num_cols, num_nonzeros );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_CSRMatrixDeleteZeros( hypre_CSRMatrix *A, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixDeleteZeros)( A, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixDestroy( hypre_CSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixDestroy)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixDiagScale( hypre_CSRMatrix *A, hypre_Vector *ld, hypre_Vector *rd )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixDiagScale)( A, ld, rd );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixEliminateRowsCols( hypre_CSRMatrix *A, HYPRE_Int nrows, HYPRE_Int *rows )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixEliminateRowsCols)( A, nrows, rows );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixExtractDiagonal( hypre_CSRMatrix *A, HYPRE_Complex *d, HYPRE_Int type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixExtractDiagonal)( A, d, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixExtractDiagonalHost( hypre_CSRMatrix *A, HYPRE_Complex *d, HYPRE_Int type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixExtractDiagonalHost)( A, d, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_CSRMatrixFnorm( hypre_CSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixFnorm)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixGetLoadBalancedPartitionBegin( hypre_CSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixGetLoadBalancedPartitionBegin)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixGetLoadBalancedPartitionEnd( hypre_CSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixGetLoadBalancedPartitionEnd)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixInitialize( hypre_CSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixInitialize)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixInitialize_v2( hypre_CSRMatrix *matrix, HYPRE_Int bigInit, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixInitialize_v2)( matrix, bigInit, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixJtoBigJ( hypre_CSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixJtoBigJ)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixMatvec( HYPRE_Complex alpha, hypre_CSRMatrix *A, hypre_Vector *x, HYPRE_Complex beta, hypre_Vector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixMatvec)( alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixMatvecOutOfPlace( HYPRE_Complex alpha, hypre_CSRMatrix *A, hypre_Vector *x, HYPRE_Complex beta, hypre_Vector *b, hypre_Vector *y, HYPRE_Int offset )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixMatvecOutOfPlace)( alpha, A, x, beta, b, y, offset );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixMatvecT( HYPRE_Complex alpha, hypre_CSRMatrix *A, hypre_Vector *x, HYPRE_Complex beta, hypre_Vector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixMatvecT)( alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixMatvec_FF( HYPRE_Complex alpha, hypre_CSRMatrix *A, hypre_Vector *x, HYPRE_Complex beta, hypre_Vector *y, HYPRE_Int *CF_marker_x, HYPRE_Int *CF_marker_y, HYPRE_Int fpt )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixMatvec_FF)( alpha, A, x, beta, y, CF_marker_x, CF_marker_y, fpt );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixMigrate( hypre_CSRMatrix *A, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixMigrate)( A, memory_location );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_CSRMatrixMultiply( hypre_CSRMatrix *A, hypre_CSRMatrix *B )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixMultiply)( A, B );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_CSRMatrixMultiplyHost( hypre_CSRMatrix *A, hypre_CSRMatrix *B )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixMultiplyHost)( A, B );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixPermute( hypre_CSRMatrix *A, HYPRE_Int *perm, HYPRE_Int *rqperm, hypre_CSRMatrix **B_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixPermute)( A, perm, rqperm, B_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixPrefetch( hypre_CSRMatrix *A, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixPrefetch)( A, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixPrint( hypre_CSRMatrix *matrix, const char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixPrint)( matrix, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixPrintHB( hypre_CSRMatrix *matrix_input, char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixPrintHB)( matrix_input, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixPrintIJ( hypre_CSRMatrix *matrix, HYPRE_Int base_i, HYPRE_Int base_j, char *filename )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixPrintIJ)( matrix, base_i, base_j, filename );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixPrintMM( hypre_CSRMatrix *matrix, HYPRE_Int basei, HYPRE_Int basej, HYPRE_Int trans, const char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixPrintMM)( matrix, basei, basej, trans, file_name );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_CSRMatrixRead( char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixRead)( file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixReorder( hypre_CSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixReorder)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixResize( hypre_CSRMatrix *matrix, HYPRE_Int new_num_rows, HYPRE_Int new_num_cols, HYPRE_Int new_num_nonzeros )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixResize)( matrix, new_num_rows, new_num_cols, new_num_nonzeros );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixScale( hypre_CSRMatrix *A, HYPRE_Complex scalar )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixScale)( A, scalar );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixSetConstantValues( hypre_CSRMatrix *A, HYPRE_Complex value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixSetConstantValues)( A, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixSetDataOwner( hypre_CSRMatrix *matrix, HYPRE_Int owns_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixSetDataOwner)( matrix, owns_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixSetPatternOnly( hypre_CSRMatrix *matrix, HYPRE_Int pattern_only )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixSetPatternOnly)( matrix, pattern_only );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixSetRownnz( hypre_CSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixSetRownnz)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixSplit( hypre_CSRMatrix *Bs_ext, HYPRE_BigInt first_col_diag_B, HYPRE_BigInt last_col_diag_B, HYPRE_Int num_cols_offd_B, HYPRE_BigInt *col_map_offd_B, HYPRE_Int *num_cols_offd_C_ptr, HYPRE_BigInt **col_map_offd_C_ptr, hypre_CSRMatrix **Bext_diag_ptr, hypre_CSRMatrix **Bext_offd_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixSplit)( Bs_ext, first_col_diag_B, last_col_diag_B, num_cols_offd_B, col_map_offd_B, num_cols_offd_C_ptr, col_map_offd_C_ptr, Bext_diag_ptr, Bext_offd_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Complex
hypre_CSRMatrixSumElts( hypre_CSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixSumElts)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixTaggedFnorm( hypre_CSRMatrix *A, HYPRE_Int num_tags, HYPRE_Int *tags, HYPRE_Real **tnorms_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixTaggedFnorm)( A, num_tags, tags, tnorms_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixTranspose( hypre_CSRMatrix *A, hypre_CSRMatrix **AT, HYPRE_Int data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixTranspose)( A, AT, data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixTransposeHost( hypre_CSRMatrix *A, hypre_CSRMatrix **AT, HYPRE_Int data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixTransposeHost)( A, AT, data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixTruncateDiag( hypre_CSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixTruncateDiag)( A );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_CSRMatrixUnion( hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_BigInt *col_map_offd_A, HYPRE_BigInt *col_map_offd_B, HYPRE_BigInt **col_map_offd_C )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixUnion)( A, B, col_map_offd_A, col_map_offd_B, col_map_offd_C );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GenerateLocalPartitioning( HYPRE_BigInt length, HYPRE_Int num_procs, HYPRE_Int myid, HYPRE_BigInt *part )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GenerateLocalPartitioning)( length, num_procs, myid, part );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GeneratePartitioning( HYPRE_BigInt length, HYPRE_Int num_procs, HYPRE_BigInt **part_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GeneratePartitioning)( length, num_procs, part_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MappedMatrixAssemble( hypre_MappedMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MappedMatrixAssemble)( matrix );
}

/*--------------------------------------------------------------------------*/

hypre_MappedMatrix *
hypre_MappedMatrixCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MappedMatrixCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MappedMatrixDestroy( hypre_MappedMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MappedMatrixDestroy)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MappedMatrixGetColIndex( hypre_MappedMatrix *matrix, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MappedMatrixGetColIndex)( matrix, j );
}

/*--------------------------------------------------------------------------*/

void *
hypre_MappedMatrixGetMatrix( hypre_MappedMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MappedMatrixGetMatrix)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MappedMatrixInitialize( hypre_MappedMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MappedMatrixInitialize)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MappedMatrixLimitedDestroy( hypre_MappedMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MappedMatrixLimitedDestroy)( matrix );
}

/*--------------------------------------------------------------------------*/

void
hypre_MappedMatrixPrint( hypre_MappedMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MappedMatrixPrint)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MappedMatrixSetMapData( hypre_MappedMatrix *matrix, void *map_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MappedMatrixSetMapData)( matrix, map_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MappedMatrixSetMatrix( hypre_MappedMatrix *matrix, void *matrix_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MappedMatrixSetMatrix)( matrix, matrix_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MultiblockMatrixAssemble( hypre_MultiblockMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MultiblockMatrixAssemble)( matrix );
}

/*--------------------------------------------------------------------------*/

hypre_MultiblockMatrix *
hypre_MultiblockMatrixCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MultiblockMatrixCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MultiblockMatrixDestroy( hypre_MultiblockMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MultiblockMatrixDestroy)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MultiblockMatrixInitialize( hypre_MultiblockMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MultiblockMatrixInitialize)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MultiblockMatrixLimitedDestroy( hypre_MultiblockMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MultiblockMatrixLimitedDestroy)( matrix );
}

/*--------------------------------------------------------------------------*/

void
hypre_MultiblockMatrixPrint( hypre_MultiblockMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MultiblockMatrixPrint)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MultiblockMatrixSetNumSubmatrices( hypre_MultiblockMatrix *matrix, HYPRE_Int n )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MultiblockMatrixSetNumSubmatrices)( matrix, n );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MultiblockMatrixSetSubmatrix( hypre_MultiblockMatrix *matrix, HYPRE_Int j, void *submatrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MultiblockMatrixSetSubmatrix)( matrix, j, submatrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MultiblockMatrixSetSubmatrixType( hypre_MultiblockMatrix *matrix, HYPRE_Int j, HYPRE_Int type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MultiblockMatrixSetSubmatrixType)( matrix, j, type );
}

/*--------------------------------------------------------------------------*/

hypre_Vector *
hypre_SeqMultiVectorCreate( HYPRE_Int size, HYPRE_Int num_vectors )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqMultiVectorCreate)( size, num_vectors );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorAxpy( HYPRE_Complex alpha, hypre_Vector *x, hypre_Vector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorAxpy)( alpha, x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorAxpyHost( HYPRE_Complex alpha, hypre_Vector *x, hypre_Vector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorAxpyHost)( alpha, x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorAxpyz( HYPRE_Complex alpha, hypre_Vector *x, HYPRE_Complex beta, hypre_Vector *y, hypre_Vector *z )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorAxpyz)( alpha, x, beta, y, z );
}

/*--------------------------------------------------------------------------*/

hypre_Vector *
hypre_SeqVectorCloneDeep( hypre_Vector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorCloneDeep)( x );
}

/*--------------------------------------------------------------------------*/

hypre_Vector *
hypre_SeqVectorCloneDeep_v2( hypre_Vector *x, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorCloneDeep_v2)( x, memory_location );
}

/*--------------------------------------------------------------------------*/

hypre_Vector *
hypre_SeqVectorCloneShallow( hypre_Vector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorCloneShallow)( x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorCopy( hypre_Vector *x, hypre_Vector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorCopy)( x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorCopyTags( hypre_Vector *x, hypre_Vector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorCopyTags)( x, y );
}

/*--------------------------------------------------------------------------*/

hypre_Vector *
hypre_SeqVectorCreate( HYPRE_Int size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorCreate)( size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorDestroy( hypre_Vector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorDestroy)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorInitialize( hypre_Vector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorInitialize)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorInitializeShell( hypre_Vector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorInitializeShell)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorInitialize_v2( hypre_Vector *vector, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorInitialize_v2)( vector, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_SeqVectorInnerProd( hypre_Vector *x, hypre_Vector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorInnerProd)( x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_SeqVectorInnerProdHost( hypre_Vector *x, hypre_Vector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorInnerProdHost)( x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorInnerProdTagged( hypre_Vector *x, hypre_Vector *y, HYPRE_Complex *iprod )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorInnerProdTagged)( x, y, iprod );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorMassAxpy( HYPRE_Complex *alpha, hypre_Vector **x, hypre_Vector *y, HYPRE_Int k, HYPRE_Int unroll )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorMassAxpy)( alpha, x, y, k, unroll );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorMassAxpy4( HYPRE_Complex *alpha, hypre_Vector **x, hypre_Vector *y, HYPRE_Int k )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorMassAxpy4)( alpha, x, y, k );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorMassAxpy8( HYPRE_Complex *alpha, hypre_Vector **x, hypre_Vector *y, HYPRE_Int k )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorMassAxpy8)( alpha, x, y, k );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorMassDotpTwo( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z, HYPRE_Int k, HYPRE_Int unroll, HYPRE_Real *result_x, HYPRE_Real *result_y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorMassDotpTwo)( x, y, z, k, unroll, result_x, result_y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorMassDotpTwo4( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z, HYPRE_Int k, HYPRE_Real *result_x, HYPRE_Real *result_y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorMassDotpTwo4)( x, y, z, k, result_x, result_y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorMassDotpTwo8( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z, HYPRE_Int k, HYPRE_Real *result_x, HYPRE_Real *result_y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorMassDotpTwo8)( x, y, z, k, result_x, result_y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorMassInnerProd( hypre_Vector *x, hypre_Vector **y, HYPRE_Int k, HYPRE_Int unroll, HYPRE_Real *result )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorMassInnerProd)( x, y, k, unroll, result );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorMassInnerProd4( hypre_Vector *x, hypre_Vector **y, HYPRE_Int k, HYPRE_Real *result )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorMassInnerProd4)( x, y, k, result );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorMassInnerProd8( hypre_Vector *x, hypre_Vector **y, HYPRE_Int k, HYPRE_Real *result )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorMassInnerProd8)( x, y, k, result );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorMigrate( hypre_Vector *x, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorMigrate)( x, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorPointwiseDivision( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorPointwiseDivision)( x, y, z_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorPointwiseDivpy( hypre_Vector *x, hypre_Vector *b, hypre_Vector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorPointwiseDivpy)( x, b, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorPointwiseDivpyMarked( hypre_Vector *x, hypre_Vector *b, hypre_Vector *y, HYPRE_Int *marker, HYPRE_Int marker_val )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorPointwiseDivpyMarked)( x, b, y, marker, marker_val );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorPointwiseInverse( hypre_Vector *x, hypre_Vector **y_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorPointwiseInverse)( x, y_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorPointwiseProduct( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorPointwiseProduct)( x, y, z_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorPrint( hypre_Vector *vector, char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorPrint)( vector, file_name );
}

/*--------------------------------------------------------------------------*/

hypre_Vector *
hypre_SeqVectorRead( char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorRead)( file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorResize( hypre_Vector *vector, HYPRE_Int size_in, HYPRE_Int num_vectors_in )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorResize)( vector, size_in, num_vectors_in );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorScale( HYPRE_Complex alpha, hypre_Vector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorScale)( alpha, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorScaleHost( HYPRE_Complex alpha, hypre_Vector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorScaleHost)( alpha, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorSetConstantValues( hypre_Vector *v, HYPRE_Complex value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorSetConstantValues)( v, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorSetConstantValuesHost( hypre_Vector *v, HYPRE_Complex value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorSetConstantValuesHost)( v, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorSetData( hypre_Vector *vector, HYPRE_Complex *data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorSetData)( vector, data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorSetDataOwner( hypre_Vector *vector, HYPRE_Int owns_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorSetDataOwner)( vector, owns_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorSetNumTags( hypre_Vector *vector, HYPRE_Int num_tags )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorSetNumTags)( vector, num_tags );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorSetOwnsTags( hypre_Vector *vector, HYPRE_Int owns_tags )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorSetOwnsTags)( vector, owns_tags );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorSetRandomValues( hypre_Vector *v, HYPRE_Int seed )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorSetRandomValues)( v, seed );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorSetSize( hypre_Vector *vector, HYPRE_Int size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorSetSize)( vector, size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorSetTags( hypre_Vector *vector, HYPRE_MemoryLocation memory_location, HYPRE_Int *tags )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorSetTags)( vector, memory_location, tags );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorSetValuesTagged( hypre_Vector *vector, HYPRE_Complex *values )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorSetValuesTagged)( vector, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SeqVectorStridedCopy( hypre_Vector *x, HYPRE_Int istride, HYPRE_Int ostride, HYPRE_Int size, HYPRE_Complex *data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorStridedCopy)( x, istride, ostride, size, data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Complex
hypre_SeqVectorSumElts( hypre_Vector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorSumElts)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Complex
hypre_SeqVectorSumEltsHost( hypre_Vector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SeqVectorSumEltsHost)( vector );
}


#endif

