/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */
/*
 * Copyright (c) 2022, Qualcomm Innovation Center, Inc. All rights reserved.
 * Copyright (c) 2023, Linaro Limited
 */

#ifndef __DT_BINDINGS_INTERCONNECT_QCOM_SA8775P_H
#define __DT_BINDINGS_INTERCONNECT_QCOM_SA8775P_H

/* aggre1_noc */
#define MASTER_QUP_3			0
#define MASTER_EMAC			1
#define MASTER_EMAC_1			2
#define MASTER_SDC			3
#define MASTER_UFS_MEM			4
#define MASTER_USB2			5
#define MASTER_USB3_0			6
#define MASTER_USB3_1			7
#define SLAVE_A1NOC_SNOC		8

/* aggre2_noc */
#define MASTER_QDSS_BAM			0
#define MASTER_QUP_0			1
#define MASTER_QUP_1			2
#define MASTER_QUP_2			3
#define MASTER_CNOC_A2NOC		4
#define MASTER_CRYPTO_CORE0		5
#define MASTER_CRYPTO_CORE1		6
#define MASTER_IPA			7
#define MASTER_QDSS_ETR_0		8
#define MASTER_QDSS_ETR_1		9
#define MASTER_UFS_CARD			10
#define SLAVE_A2NOC_SNOC		11

/* clk_virt */
#define MASTER_QUP_CORE_0		0
#define MASTER_QUP_CORE_1		1
#define MASTER_QUP_CORE_2		2
#define MASTER_QUP_CORE_3		3
#define SLAVE_QUP_CORE_0		4
#define SLAVE_QUP_CORE_1		5
#define SLAVE_QUP_CORE_2		6
#define SLAVE_QUP_CORE_3		7

/* config_noc */
#define MASTER_GEM_NOC_CNOC		0
#define MASTER_GEM_NOC_PCIE_SNOC	1
#define SLAVE_AHB2PHY_0			2
#define SLAVE_AHB2PHY_1			3
#define SLAVE_AHB2PHY_2			4
#define SLAVE_AHB2PHY_3			5
#define SLAVE_ANOC_THROTTLE_CFG		6
#define SLAVE_AOSS			7
#define SLAVE_APPSS			8
#define SLAVE_BOOT_ROM			9
#define SLAVE_CAMERA_CFG		10
#define SLAVE_CAMERA_NRT_THROTTLE_CFG	11
#define SLAVE_CAMERA_RT_THROTTLE_CFG	12
#define SLAVE_CLK_CTL			13
#define SLAVE_CDSP_CFG			14
#define SLAVE_CDSP1_CFG			15
#define SLAVE_RBCPR_CX_CFG		16
#define SLAVE_RBCPR_MMCX_CFG		17
#define SLAVE_RBCPR_MX_CFG		18
#define SLAVE_CPR_NSPCX			19
#define SLAVE_CRYPTO_0_CFG		20
#define SLAVE_CX_RDPM			21
#define SLAVE_DISPLAY_CFG		22
#define SLAVE_DISPLAY_RT_THROTTLE_CFG	23
#define SLAVE_DISPLAY1_CFG		24
#define SLAVE_DISPLAY1_RT_THROTTLE_CFG  25
#define SLAVE_EMAC_CFG			26
#define SLAVE_EMAC1_CFG			27
#define SLAVE_GP_DSP0_CFG		28
#define SLAVE_GP_DSP1_CFG		29
#define SLAVE_GPDSP0_THROTTLE_CFG	30
#define SLAVE_GPDSP1_THROTTLE_CFG	31
#define SLAVE_GPU_TCU_THROTTLE_CFG	32
#define SLAVE_GFX3D_CFG			33
#define SLAVE_HWKM			34
#define SLAVE_IMEM_CFG			35
#define SLAVE_IPA_CFG			36
#define SLAVE_IPC_ROUTER_CFG		37
#define SLAVE_LPASS			38
#define SLAVE_LPASS_THROTTLE_CFG	39
#define SLAVE_MX_RDPM			40
#define SLAVE_MXC_RDPM			41
#define SLAVE_PCIE_0_CFG		42
#define SLAVE_PCIE_1_CFG		43
#define SLAVE_PCIE_RSC_CFG		44
#define SLAVE_PCIE_TCU_THROTTLE_CFG	45
#define SLAVE_PCIE_THROTTLE_CFG		46
#define SLAVE_PDM			47
#define SLAVE_PIMEM_CFG			48
#define SLAVE_PKA_WRAPPER_CFG		49
#define SLAVE_QDSS_CFG			50
#define SLAVE_QM_CFG			51
#define SLAVE_QM_MPU_CFG		52
#define SLAVE_QUP_0			53
#define SLAVE_QUP_1			54
#define SLAVE_QUP_2			55
#define SLAVE_QUP_3			56
#define SLAVE_SAIL_THROTTLE_CFG		57
#define SLAVE_SDC1			58
#define SLAVE_SECURITY			59
#define SLAVE_SNOC_THROTTLE_CFG		60
#define SLAVE_TCSR			61
#define SLAVE_TLMM			62
#define SLAVE_TSC_CFG			63
#define SLAVE_UFS_CARD_CFG		64
#define SLAVE_UFS_MEM_CFG		65
#define SLAVE_USB2			66
#define SLAVE_USB3_0			67
#define SLAVE_USB3_1			68
#define SLAVE_VENUS_CFG			69
#define SLAVE_VENUS_CVP_THROTTLE_CFG	70
#define SLAVE_VENUS_V_CPU_THROTTLE_CFG	71
#define SLAVE_VENUS_VCODEC_THROTTLE_CFG	72
#define SLAVE_DDRSS_CFG			73
#define SLAVE_GPDSP_NOC_CFG		74
#define SLAVE_CNOC_MNOC_HF_CFG		75
#define SLAVE_CNOC_MNOC_SF_CFG		76
#define SLAVE_PCIE_ANOC_CFG		77
#define SLAVE_SNOC_CFG			78
#define SLAVE_BOOT_IMEM			79
#define SLAVE_IMEM			80
#define SLAVE_PIMEM			81
#define SLAVE_PCIE_0			82
#define SLAVE_PCIE_1			83
#define SLAVE_QDSS_STM			84
#define SLAVE_TCU			85

/* dc_noc */
#define MASTER_CNOC_DC_NOC		0
#define SLAVE_LLCC_CFG			1
#define SLAVE_GEM_NOC_CFG		2

/* gem_noc */
#define MASTER_GPU_TCU			0
#define MASTER_PCIE_TCU			1
#define MASTER_SYS_TCU			2
#define MASTER_APPSS_PROC		3
#define MASTER_COMPUTE_NOC		4
#define MASTER_COMPUTE_NOC_1		5
#define MASTER_GEM_NOC_CFG		6
#define MASTER_GPDSP_SAIL		7
#define MASTER_GFX3D			8
#define MASTER_MNOC_HF_MEM_NOC		9
#define MASTER_MNOC_SF_MEM_NOC		10
#define MASTER_ANOC_PCIE_GEM_NOC	11
#define MASTER_SNOC_GC_MEM_NOC		12
#define MASTER_SNOC_SF_MEM_NOC		13
#define SLAVE_GEM_NOC_CNOC		14
#define SLAVE_LLCC			15
#define SLAVE_GEM_NOC_PCIE_CNOC		16
#define SLAVE_SERVICE_GEM_NOC_1		17
#define SLAVE_SERVICE_GEM_NOC_2		18
#define SLAVE_SERVICE_GEM_NOC		19
#define SLAVE_SERVICE_GEM_NOC2		20

/* gpdsp_anoc */
#define MASTER_DSP0			0
#define MASTER_DSP1			1
#define SLAVE_GP_DSP_SAIL_NOC		2

/* lpass_ag_noc */
#define MASTER_CNOC_LPASS_AG_NOC	0
#define MASTER_LPASS_PROC		1
#define SLAVE_LPASS_CORE_CFG		2
#define SLAVE_LPASS_LPI_CFG		3
#define SLAVE_LPASS_MPU_CFG		4
#define SLAVE_LPASS_TOP_CFG		5
#define SLAVE_LPASS_SNOC		6
#define SLAVE_SERVICES_LPASS_AML_NOC	7
#define SLAVE_SERVICE_LPASS_AG_NOC	8

/* mc_virt */
#define MASTER_LLCC			0
#define SLAVE_EBI1			1

/*mmss_noc */
#define MASTER_CAMNOC_HF		0
#define MASTER_CAMNOC_ICP		1
#define MASTER_CAMNOC_SF		2
#define MASTER_MDP0			3
#define MASTER_MDP1			4
#define MASTER_MDP_CORE1_0		5
#define MASTER_MDP_CORE1_1		6
#define MASTER_CNOC_MNOC_HF_CFG		7
#define MASTER_CNOC_MNOC_SF_CFG		8
#define MASTER_VIDEO_P0			9
#define MASTER_VIDEO_P1			10
#define MASTER_VIDEO_PROC		11
#define MASTER_VIDEO_V_PROC		12
#define SLAVE_MNOC_HF_MEM_NOC		13
#define SLAVE_MNOC_SF_MEM_NOC		14
#define SLAVE_SERVICE_MNOC_HF		15
#define SLAVE_SERVICE_MNOC_SF		16

/* nspa_noc */
#define MASTER_CDSP_NOC_CFG		0
#define MASTER_CDSP_PROC		1
#define SLAVE_HCP_A			2
#define SLAVE_CDSP_MEM_NOC		3
#define SLAVE_SERVICE_NSP_NOC		4

/* nspb_noc */
#define MASTER_CDSPB_NOC_CFG		0
#define MASTER_CDSP_PROC_B		1
#define SLAVE_CDSPB_MEM_NOC		2
#define SLAVE_HCP_B			3
#define SLAVE_SERVICE_NSPB_NOC		4

/* pcie_anoc */
#define MASTER_PCIE_0			0
#define MASTER_PCIE_1			1
#define SLAVE_ANOC_PCIE_GEM_NOC		2

/* system_noc */
#define MASTER_GIC_AHB			0
#define MASTER_A1NOC_SNOC		1
#define MASTER_A2NOC_SNOC		2
#define MASTER_LPASS_ANOC		3
#define MASTER_SNOC_CFG			4
#define MASTER_PIMEM			5
#define MASTER_GIC			6
#define SLAVE_SNOC_GEM_NOC_GC		7
#define SLAVE_SNOC_GEM_NOC_SF		8
#define SLAVE_SERVICE_SNOC		9

#endif /* __DT_BINDINGS_INTERCONNECT_QCOM_SA8775P_H */
