"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import meshtastic.protobuf.channel_pb2
import meshtastic.protobuf.config_pb2
import meshtastic.protobuf.device_ui_pb2
import meshtastic.protobuf.module_config_pb2
import meshtastic.protobuf.portnums_pb2
import meshtastic.protobuf.telemetry_pb2
import meshtastic.protobuf.xmodem_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _HardwareModel:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _HardwareModelEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_HardwareModel.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNSET: _HardwareModel.ValueType  # 0
    """
    TODO: REPLACE
    """
    TLORA_V2: _HardwareModel.ValueType  # 1
    """
    TODO: REPLACE
    """
    TLORA_V1: _HardwareModel.ValueType  # 2
    """
    TODO: REPLACE
    """
    TLORA_V2_1_1P6: _HardwareModel.ValueType  # 3
    """
    TODO: REPLACE
    """
    TBEAM: _HardwareModel.ValueType  # 4
    """
    TODO: REPLACE
    """
    HELTEC_V2_0: _HardwareModel.ValueType  # 5
    """
    The original heltec WiFi_Lora_32_V2, which had battery voltage sensing hooked to GPIO 13
    (see HELTEC_V2 for the new version).
    """
    TBEAM_V0P7: _HardwareModel.ValueType  # 6
    """
    TODO: REPLACE
    """
    T_ECHO: _HardwareModel.ValueType  # 7
    """
    TODO: REPLACE
    """
    TLORA_V1_1P3: _HardwareModel.ValueType  # 8
    """
    TODO: REPLACE
    """
    RAK4631: _HardwareModel.ValueType  # 9
    """
    TODO: REPLACE
    """
    HELTEC_V2_1: _HardwareModel.ValueType  # 10
    """
    The new version of the heltec WiFi_Lora_32_V2 board that has battery sensing hooked to GPIO 37.
    Sadly they did not update anything on the silkscreen to identify this board
    """
    HELTEC_V1: _HardwareModel.ValueType  # 11
    """
    Ancient heltec WiFi_Lora_32 board
    """
    LILYGO_TBEAM_S3_CORE: _HardwareModel.ValueType  # 12
    """
    New T-BEAM with ESP32-S3 CPU
    """
    RAK11200: _HardwareModel.ValueType  # 13
    """
    RAK WisBlock ESP32 core: https://docs.rakwireless.com/Product-Categories/WisBlock/RAK11200/Overview/
    """
    NANO_G1: _HardwareModel.ValueType  # 14
    """
    B&Q Consulting Nano Edition G1: https://uniteng.com/wiki/doku.php?id=meshtastic:nano
    """
    TLORA_V2_1_1P8: _HardwareModel.ValueType  # 15
    """
    TODO: REPLACE
    """
    TLORA_T3_S3: _HardwareModel.ValueType  # 16
    """
    TODO: REPLACE
    """
    NANO_G1_EXPLORER: _HardwareModel.ValueType  # 17
    """
    B&Q Consulting Nano G1 Explorer: https://wiki.uniteng.com/en/meshtastic/nano-g1-explorer
    """
    NANO_G2_ULTRA: _HardwareModel.ValueType  # 18
    """
    B&Q Consulting Nano G2 Ultra: https://wiki.uniteng.com/en/meshtastic/nano-g2-ultra
    """
    LORA_TYPE: _HardwareModel.ValueType  # 19
    """
    LoRAType device: https://loratype.org/
    """
    WIPHONE: _HardwareModel.ValueType  # 20
    """
    wiphone https://www.wiphone.io/
    """
    WIO_WM1110: _HardwareModel.ValueType  # 21
    """
    WIO Tracker WM1110 family from Seeed Studio. Includes wio-1110-tracker and wio-1110-sdk
    """
    RAK2560: _HardwareModel.ValueType  # 22
    """
    RAK2560 Solar base station based on RAK4630
    """
    HELTEC_HRU_3601: _HardwareModel.ValueType  # 23
    """
    Heltec HRU-3601: https://heltec.org/project/hru-3601/
    """
    HELTEC_WIRELESS_BRIDGE: _HardwareModel.ValueType  # 24
    """
    Heltec Wireless Bridge
    """
    STATION_G1: _HardwareModel.ValueType  # 25
    """
    B&Q Consulting Station Edition G1: https://uniteng.com/wiki/doku.php?id=meshtastic:station
    """
    RAK11310: _HardwareModel.ValueType  # 26
    """
    RAK11310 (RP2040 + SX1262)
    """
    SENSELORA_RP2040: _HardwareModel.ValueType  # 27
    """
    Makerfabs SenseLoRA Receiver (RP2040 + RFM96)
    """
    SENSELORA_S3: _HardwareModel.ValueType  # 28
    """
    Makerfabs SenseLoRA Industrial Monitor (ESP32-S3 + RFM96)
    """
    CANARYONE: _HardwareModel.ValueType  # 29
    """
    Canary Radio Company - CanaryOne: https://canaryradio.io/products/canaryone
    """
    RP2040_LORA: _HardwareModel.ValueType  # 30
    """
    Waveshare RP2040 LoRa - https://www.waveshare.com/rp2040-lora.htm
    """
    STATION_G2: _HardwareModel.ValueType  # 31
    """
    B&Q Consulting Station G2: https://wiki.uniteng.com/en/meshtastic/station-g2
    """
    LORA_RELAY_V1: _HardwareModel.ValueType  # 32
    """
    ---------------------------------------------------------------------------
    Less common/prototype boards listed here (needs one more byte over the air)
    ---------------------------------------------------------------------------
    """
    NRF52840DK: _HardwareModel.ValueType  # 33
    """
    TODO: REPLACE
    """
    PPR: _HardwareModel.ValueType  # 34
    """
    TODO: REPLACE
    """
    GENIEBLOCKS: _HardwareModel.ValueType  # 35
    """
    TODO: REPLACE
    """
    NRF52_UNKNOWN: _HardwareModel.ValueType  # 36
    """
    TODO: REPLACE
    """
    PORTDUINO: _HardwareModel.ValueType  # 37
    """
    TODO: REPLACE
    """
    ANDROID_SIM: _HardwareModel.ValueType  # 38
    """
    The simulator built into the android app
    """
    DIY_V1: _HardwareModel.ValueType  # 39
    """
    Custom DIY device based on @NanoVHF schematics: https://github.com/NanoVHF/Meshtastic-DIY/tree/main/Schematics
    """
    NRF52840_PCA10059: _HardwareModel.ValueType  # 40
    """
    nRF52840 Dongle : https://www.nordicsemi.com/Products/Development-hardware/nrf52840-dongle/
    """
    DR_DEV: _HardwareModel.ValueType  # 41
    """
    Custom Disaster Radio esp32 v3 device https://github.com/sudomesh/disaster-radio/tree/master/hardware/board_esp32_v3
    """
    M5STACK: _HardwareModel.ValueType  # 42
    """
    M5 esp32 based MCU modules with enclosure, TFT and LORA Shields. All Variants (Basic, Core, Fire, Core2, CoreS3, Paper) https://m5stack.com/
    """
    HELTEC_V3: _HardwareModel.ValueType  # 43
    """
    New Heltec LoRA32 with ESP32-S3 CPU
    """
    HELTEC_WSL_V3: _HardwareModel.ValueType  # 44
    """
    New Heltec Wireless Stick Lite with ESP32-S3 CPU
    """
    BETAFPV_2400_TX: _HardwareModel.ValueType  # 45
    """
    New BETAFPV ELRS Micro TX Module 2.4G with ESP32 CPU
    """
    BETAFPV_900_NANO_TX: _HardwareModel.ValueType  # 46
    """
    BetaFPV ExpressLRS "Nano" TX Module 900MHz with ESP32 CPU
    """
    RPI_PICO: _HardwareModel.ValueType  # 47
    """
    Raspberry Pi Pico (W) with Waveshare SX1262 LoRa Node Module
    """
    HELTEC_WIRELESS_TRACKER: _HardwareModel.ValueType  # 48
    """
    Heltec Wireless Tracker with ESP32-S3 CPU, built-in GPS, and TFT
    Newer V1.1, version is written on the PCB near the display.
    """
    HELTEC_WIRELESS_PAPER: _HardwareModel.ValueType  # 49
    """
    Heltec Wireless Paper with ESP32-S3 CPU and E-Ink display
    """
    T_DECK: _HardwareModel.ValueType  # 50
    """
    LilyGo T-Deck with ESP32-S3 CPU, Keyboard and IPS display
    """
    T_WATCH_S3: _HardwareModel.ValueType  # 51
    """
    LilyGo T-Watch S3 with ESP32-S3 CPU and IPS display
    """
    PICOMPUTER_S3: _HardwareModel.ValueType  # 52
    """
    Bobricius Picomputer with ESP32-S3 CPU, Keyboard and IPS display
    """
    HELTEC_HT62: _HardwareModel.ValueType  # 53
    """
    Heltec HT-CT62 with ESP32-C3 CPU and SX1262 LoRa
    """
    EBYTE_ESP32_S3: _HardwareModel.ValueType  # 54
    """
    EBYTE SPI LoRa module and ESP32-S3
    """
    ESP32_S3_PICO: _HardwareModel.ValueType  # 55
    """
    Waveshare ESP32-S3-PICO with PICO LoRa HAT and 2.9inch e-Ink
    """
    CHATTER_2: _HardwareModel.ValueType  # 56
    """
    CircuitMess Chatter 2 LLCC68 Lora Module and ESP32 Wroom
    Lora module can be swapped out for a Heltec RA-62 which is "almost" pin compatible
    with one cut and one jumper Meshtastic works
    """
    HELTEC_WIRELESS_PAPER_V1_0: _HardwareModel.ValueType  # 57
    """
    Heltec Wireless Paper, With ESP32-S3 CPU and E-Ink display
    Older "V1.0" Variant, has no "version sticker"
    E-Ink model is DEPG0213BNS800
    Tab on the screen protector is RED
    Flex connector marking is FPC-7528B
    """
    HELTEC_WIRELESS_TRACKER_V1_0: _HardwareModel.ValueType  # 58
    """
    Heltec Wireless Tracker with ESP32-S3 CPU, built-in GPS, and TFT
    Older "V1.0" Variant
    """
    UNPHONE: _HardwareModel.ValueType  # 59
    """
    unPhone with ESP32-S3, TFT touchscreen,  LSM6DS3TR-C accelerometer and gyroscope
    """
    TD_LORAC: _HardwareModel.ValueType  # 60
    """
    Teledatics TD-LORAC NRF52840 based M.2 LoRA module
    Compatible with the TD-WRLS development board
    """
    CDEBYTE_EORA_S3: _HardwareModel.ValueType  # 61
    """
    CDEBYTE EoRa-S3 board using their own MM modules, clone of LILYGO T3S3
    """
    TWC_MESH_V4: _HardwareModel.ValueType  # 62
    """
    TWC_MESH_V4
    Adafruit NRF52840 feather express with SX1262, SSD1306 OLED and NEO6M GPS
    """
    NRF52_PROMICRO_DIY: _HardwareModel.ValueType  # 63
    """
    NRF52_PROMICRO_DIY
    Promicro NRF52840 with SX1262/LLCC68, SSD1306 OLED and NEO6M GPS
    """
    RADIOMASTER_900_BANDIT_NANO: _HardwareModel.ValueType  # 64
    """
    RadioMaster 900 Bandit Nano, https://www.radiomasterrc.com/products/bandit-nano-expresslrs-rf-module
    ESP32-D0WDQ6 With SX1276/SKY66122, SSD1306 OLED and No GPS
    """
    HELTEC_CAPSULE_SENSOR_V3: _HardwareModel.ValueType  # 65
    """
    Heltec Capsule Sensor V3 with ESP32-S3 CPU, Portable LoRa device that can replace GNSS modules or sensors
    """
    HELTEC_VISION_MASTER_T190: _HardwareModel.ValueType  # 66
    """
    Heltec Vision Master T190 with ESP32-S3 CPU, and a 1.90 inch TFT display
    """
    HELTEC_VISION_MASTER_E213: _HardwareModel.ValueType  # 67
    """
    Heltec Vision Master E213 with ESP32-S3 CPU, and a 2.13 inch E-Ink display
    """
    HELTEC_VISION_MASTER_E290: _HardwareModel.ValueType  # 68
    """
    Heltec Vision Master E290 with ESP32-S3 CPU, and a 2.9 inch E-Ink display
    """
    HELTEC_MESH_NODE_T114: _HardwareModel.ValueType  # 69
    """
    Heltec Mesh Node T114 board with nRF52840 CPU, and a 1.14 inch TFT display, Ultimate low-power design,
    specifically adapted for the Meshtatic project
    """
    SENSECAP_INDICATOR: _HardwareModel.ValueType  # 70
    """
    Sensecap Indicator from Seeed Studio. ESP32-S3 device with TFT and RP2040 coprocessor
    """
    TRACKER_T1000_E: _HardwareModel.ValueType  # 71
    """
    Seeed studio T1000-E tracker card. NRF52840 w/ LR1110 radio, GPS, button, buzzer, and sensors.
    """
    RAK3172: _HardwareModel.ValueType  # 72
    """
    RAK3172 STM32WLE5 Module (https://store.rakwireless.com/products/wisduo-lpwan-module-rak3172)
    """
    WIO_E5: _HardwareModel.ValueType  # 73
    """
    Seeed Studio Wio-E5 (either mini or Dev kit) using STM32WL chip.
    """
    RADIOMASTER_900_BANDIT: _HardwareModel.ValueType  # 74
    """
    RadioMaster 900 Bandit, https://www.radiomasterrc.com/products/bandit-expresslrs-rf-module
    SSD1306 OLED and No GPS
    """
    ME25LS01_4Y10TD: _HardwareModel.ValueType  # 75
    """
    Minewsemi ME25LS01 (ME25LE01_V1.0). NRF52840 w/ LR1110 radio, buttons and leds and pins.
    """
    RP2040_FEATHER_RFM95: _HardwareModel.ValueType  # 76
    """
    RP2040_FEATHER_RFM95
    Adafruit Feather RP2040 with RFM95 LoRa Radio RFM95 with SX1272, SSD1306 OLED
    https://www.adafruit.com/product/5714
    https://www.adafruit.com/product/326
    https://www.adafruit.com/product/938
     ^^^ short A0 to switch to I2C address 0x3C
    """
    M5STACK_COREBASIC: _HardwareModel.ValueType  # 77
    """M5 esp32 based MCU modules with enclosure, TFT and LORA Shields. All Variants (Basic, Core, Fire, Core2, CoreS3, Paper) https://m5stack.com/"""
    M5STACK_CORE2: _HardwareModel.ValueType  # 78
    RPI_PICO2: _HardwareModel.ValueType  # 79
    """Pico2 with Waveshare Hat, same as Pico"""
    M5STACK_CORES3: _HardwareModel.ValueType  # 80
    """M5 esp32 based MCU modules with enclosure, TFT and LORA Shields. All Variants (Basic, Core, Fire, Core2, CoreS3, Paper) https://m5stack.com/"""
    SEEED_XIAO_S3: _HardwareModel.ValueType  # 81
    """Seeed XIAO S3 DK"""
    MS24SF1: _HardwareModel.ValueType  # 82
    """
    Nordic nRF52840+Semtech SX1262 LoRa BLE Combo Module. nRF52840+SX1262 MS24SF1
    """
    TLORA_C6: _HardwareModel.ValueType  # 83
    """
    Lilygo TLora-C6 with the new ESP32-C6 MCU
    """
    WISMESH_TAP: _HardwareModel.ValueType  # 84
    """
    WisMesh Tap
    RAK-4631 w/ TFT in injection modled case
    """
    ROUTASTIC: _HardwareModel.ValueType  # 85
    """
    Similar to PORTDUINO but used by Routastic devices, this is not any
    particular device and does not run Meshtastic's code but supports
    the same frame format.
    Runs on linux, see https://github.com/Jorropo/routastic
    """
    MESH_TAB: _HardwareModel.ValueType  # 86
    """
    Mesh-Tab, esp32 based
    https://github.com/valzzu/Mesh-Tab
    """
    MESHLINK: _HardwareModel.ValueType  # 87
    """
    MeshLink board developed by LoraItalia. NRF52840, eByte E22900M22S (Will also come with other frequencies), 25w MPPT solar charger (5v,12v,18v selectable), support for gps, buzzer, oled or e-ink display, 10 gpios, hardware watchdog
    https://www.loraitalia.it
    """
    XIAO_NRF52_KIT: _HardwareModel.ValueType  # 88
    """
    Seeed XIAO nRF52840 + Wio SX1262 kit
    """
    THINKNODE_M1: _HardwareModel.ValueType  # 89
    """
    Elecrow ThinkNode M1 & M2
    https://www.elecrow.com/wiki/ThinkNode-M1_Transceiver_Device(Meshtastic)_Power_By_nRF52840.html
    https://www.elecrow.com/wiki/ThinkNode-M2_Transceiver_Device(Meshtastic)_Power_By_NRF52840.html (this actually uses ESP32-S3)
    """
    THINKNODE_M2: _HardwareModel.ValueType  # 90
    T_ETH_ELITE: _HardwareModel.ValueType  # 91
    """
    Lilygo T-ETH-Elite
    """
    HELTEC_SENSOR_HUB: _HardwareModel.ValueType  # 92
    """
    Heltec HRI-3621 industrial probe
    """
    MUZI_BASE: _HardwareModel.ValueType  # 93
    """
    Muzi Works Muzi-Base device
    """
    HELTEC_MESH_POCKET: _HardwareModel.ValueType  # 94
    """
    Heltec Magnetic Power Bank with Meshtastic compatible
    """
    SEEED_SOLAR_NODE: _HardwareModel.ValueType  # 95
    """
    Seeed Solar Node
    """
    NOMADSTAR_METEOR_PRO: _HardwareModel.ValueType  # 96
    """
    NomadStar Meteor Pro https://nomadstar.ch/
    """
    CROWPANEL: _HardwareModel.ValueType  # 97
    """
    Elecrow CrowPanel Advance models, ESP32-S3 and TFT with SX1262 radio plugin
    """
    LINK_32: _HardwareModel.ValueType  # 98
    """
    Lilygo LINK32 board with sensors
    """
    SEEED_WIO_TRACKER_L1: _HardwareModel.ValueType  # 99
    """
    Seeed Tracker L1
    """
    SEEED_WIO_TRACKER_L1_EINK: _HardwareModel.ValueType  # 100
    """
    Seeed Tracker L1 EINK driver
    """
    MUZI_R1_NEO: _HardwareModel.ValueType  # 101
    """
    Muzi Works R1 Neo
    """
    T_DECK_PRO: _HardwareModel.ValueType  # 102
    """
    Lilygo T-Deck Pro
    """
    T_LORA_PAGER: _HardwareModel.ValueType  # 103
    """
    Lilygo TLora Pager
    """
    M5STACK_RESERVED: _HardwareModel.ValueType  # 104
    """
    M5Stack Reserved
    0x68
    """
    WISMESH_TAG: _HardwareModel.ValueType  # 105
    """
    RAKwireless WisMesh Tag
    """
    RAK3312: _HardwareModel.ValueType  # 106
    """
    RAKwireless WisBlock Core RAK3312 https://docs.rakwireless.com/product-categories/wisduo/rak3112-module/overview/
    """
    THINKNODE_M5: _HardwareModel.ValueType  # 107
    """
    Elecrow ThinkNode M5 https://www.elecrow.com/wiki/ThinkNode_M5_Meshtastic_LoRa_Signal_Transceiver_ESP32-S3.html
    """
    HELTEC_MESH_SOLAR: _HardwareModel.ValueType  # 108
    """
    MeshSolar is an integrated power management and communication solution designed for outdoor low-power devices.
    https://heltec.org/project/meshsolar/
    """
    T_ECHO_LITE: _HardwareModel.ValueType  # 109
    """
    Lilygo T-Echo Lite
    """
    HELTEC_V4: _HardwareModel.ValueType  # 110
    """
    New Heltec LoRA32 with ESP32-S3 CPU
    """
    M5STACK_C6L: _HardwareModel.ValueType  # 111
    """
    M5Stack C6L
    """
    M5STACK_CARDPUTER_ADV: _HardwareModel.ValueType  # 112
    """
    M5Stack Cardputer Adv
    """
    HELTEC_WIRELESS_TRACKER_V2: _HardwareModel.ValueType  # 113
    """
    ESP32S3 main controller with GPS and TFT screen.
    """
    T_WATCH_ULTRA: _HardwareModel.ValueType  # 114
    """
    LilyGo T-Watch Ultra
    """
    THINKNODE_M3: _HardwareModel.ValueType  # 115
    """
    Elecrow ThinkNode M3
    """
    WISMESH_TAP_V2: _HardwareModel.ValueType  # 116
    """
    RAK WISMESH_TAP_V2 with ESP32-S3 CPU
    """
    RAK3401: _HardwareModel.ValueType  # 117
    """
    RAK3401
    """
    RAK6421: _HardwareModel.ValueType  # 118
    """
    RAK6421 Hat+
    """
    THINKNODE_M4: _HardwareModel.ValueType  # 119
    """
    Elecrow ThinkNode M4
    """
    THINKNODE_M6: _HardwareModel.ValueType  # 120
    """
    Elecrow ThinkNode M6
    """
    PRIVATE_HW: _HardwareModel.ValueType  # 255
    """
    ------------------------------------------------------------------------------------------------------------------------------------------
    Reserved ID For developing private Ports. These will show up in live traffic sparsely, so we can use a high number. Keep it within 8 bits.
    ------------------------------------------------------------------------------------------------------------------------------------------
    """

class HardwareModel(_HardwareModel, metaclass=_HardwareModelEnumTypeWrapper):
    """
    Note: these enum names must EXACTLY match the string used in the device
    bin/build-all.sh script.
    Because they will be used to find firmware filenames in the android app for OTA updates.
    To match the old style filenames, _ is converted to -, p is converted to .
    """

UNSET: HardwareModel.ValueType  # 0
"""
TODO: REPLACE
"""
TLORA_V2: HardwareModel.ValueType  # 1
"""
TODO: REPLACE
"""
TLORA_V1: HardwareModel.ValueType  # 2
"""
TODO: REPLACE
"""
TLORA_V2_1_1P6: HardwareModel.ValueType  # 3
"""
TODO: REPLACE
"""
TBEAM: HardwareModel.ValueType  # 4
"""
TODO: REPLACE
"""
HELTEC_V2_0: HardwareModel.ValueType  # 5
"""
The original heltec WiFi_Lora_32_V2, which had battery voltage sensing hooked to GPIO 13
(see HELTEC_V2 for the new version).
"""
TBEAM_V0P7: HardwareModel.ValueType  # 6
"""
TODO: REPLACE
"""
T_ECHO: HardwareModel.ValueType  # 7
"""
TODO: REPLACE
"""
TLORA_V1_1P3: HardwareModel.ValueType  # 8
"""
TODO: REPLACE
"""
RAK4631: HardwareModel.ValueType  # 9
"""
TODO: REPLACE
"""
HELTEC_V2_1: HardwareModel.ValueType  # 10
"""
The new version of the heltec WiFi_Lora_32_V2 board that has battery sensing hooked to GPIO 37.
Sadly they did not update anything on the silkscreen to identify this board
"""
HELTEC_V1: HardwareModel.ValueType  # 11
"""
Ancient heltec WiFi_Lora_32 board
"""
LILYGO_TBEAM_S3_CORE: HardwareModel.ValueType  # 12
"""
New T-BEAM with ESP32-S3 CPU
"""
RAK11200: HardwareModel.ValueType  # 13
"""
RAK WisBlock ESP32 core: https://docs.rakwireless.com/Product-Categories/WisBlock/RAK11200/Overview/
"""
NANO_G1: HardwareModel.ValueType  # 14
"""
B&Q Consulting Nano Edition G1: https://uniteng.com/wiki/doku.php?id=meshtastic:nano
"""
TLORA_V2_1_1P8: HardwareModel.ValueType  # 15
"""
TODO: REPLACE
"""
TLORA_T3_S3: HardwareModel.ValueType  # 16
"""
TODO: REPLACE
"""
NANO_G1_EXPLORER: HardwareModel.ValueType  # 17
"""
B&Q Consulting Nano G1 Explorer: https://wiki.uniteng.com/en/meshtastic/nano-g1-explorer
"""
NANO_G2_ULTRA: HardwareModel.ValueType  # 18
"""
B&Q Consulting Nano G2 Ultra: https://wiki.uniteng.com/en/meshtastic/nano-g2-ultra
"""
LORA_TYPE: HardwareModel.ValueType  # 19
"""
LoRAType device: https://loratype.org/
"""
WIPHONE: HardwareModel.ValueType  # 20
"""
wiphone https://www.wiphone.io/
"""
WIO_WM1110: HardwareModel.ValueType  # 21
"""
WIO Tracker WM1110 family from Seeed Studio. Includes wio-1110-tracker and wio-1110-sdk
"""
RAK2560: HardwareModel.ValueType  # 22
"""
RAK2560 Solar base station based on RAK4630
"""
HELTEC_HRU_3601: HardwareModel.ValueType  # 23
"""
Heltec HRU-3601: https://heltec.org/project/hru-3601/
"""
HELTEC_WIRELESS_BRIDGE: HardwareModel.ValueType  # 24
"""
Heltec Wireless Bridge
"""
STATION_G1: HardwareModel.ValueType  # 25
"""
B&Q Consulting Station Edition G1: https://uniteng.com/wiki/doku.php?id=meshtastic:station
"""
RAK11310: HardwareModel.ValueType  # 26
"""
RAK11310 (RP2040 + SX1262)
"""
SENSELORA_RP2040: HardwareModel.ValueType  # 27
"""
Makerfabs SenseLoRA Receiver (RP2040 + RFM96)
"""
SENSELORA_S3: HardwareModel.ValueType  # 28
"""
Makerfabs SenseLoRA Industrial Monitor (ESP32-S3 + RFM96)
"""
CANARYONE: HardwareModel.ValueType  # 29
"""
Canary Radio Company - CanaryOne: https://canaryradio.io/products/canaryone
"""
RP2040_LORA: HardwareModel.ValueType  # 30
"""
Waveshare RP2040 LoRa - https://www.waveshare.com/rp2040-lora.htm
"""
STATION_G2: HardwareModel.ValueType  # 31
"""
B&Q Consulting Station G2: https://wiki.uniteng.com/en/meshtastic/station-g2
"""
LORA_RELAY_V1: HardwareModel.ValueType  # 32
"""
---------------------------------------------------------------------------
Less common/prototype boards listed here (needs one more byte over the air)
---------------------------------------------------------------------------
"""
NRF52840DK: HardwareModel.ValueType  # 33
"""
TODO: REPLACE
"""
PPR: HardwareModel.ValueType  # 34
"""
TODO: REPLACE
"""
GENIEBLOCKS: HardwareModel.ValueType  # 35
"""
TODO: REPLACE
"""
NRF52_UNKNOWN: HardwareModel.ValueType  # 36
"""
TODO: REPLACE
"""
PORTDUINO: HardwareModel.ValueType  # 37
"""
TODO: REPLACE
"""
ANDROID_SIM: HardwareModel.ValueType  # 38
"""
The simulator built into the android app
"""
DIY_V1: HardwareModel.ValueType  # 39
"""
Custom DIY device based on @NanoVHF schematics: https://github.com/NanoVHF/Meshtastic-DIY/tree/main/Schematics
"""
NRF52840_PCA10059: HardwareModel.ValueType  # 40
"""
nRF52840 Dongle : https://www.nordicsemi.com/Products/Development-hardware/nrf52840-dongle/
"""
DR_DEV: HardwareModel.ValueType  # 41
"""
Custom Disaster Radio esp32 v3 device https://github.com/sudomesh/disaster-radio/tree/master/hardware/board_esp32_v3
"""
M5STACK: HardwareModel.ValueType  # 42
"""
M5 esp32 based MCU modules with enclosure, TFT and LORA Shields. All Variants (Basic, Core, Fire, Core2, CoreS3, Paper) https://m5stack.com/
"""
HELTEC_V3: HardwareModel.ValueType  # 43
"""
New Heltec LoRA32 with ESP32-S3 CPU
"""
HELTEC_WSL_V3: HardwareModel.ValueType  # 44
"""
New Heltec Wireless Stick Lite with ESP32-S3 CPU
"""
BETAFPV_2400_TX: HardwareModel.ValueType  # 45
"""
New BETAFPV ELRS Micro TX Module 2.4G with ESP32 CPU
"""
BETAFPV_900_NANO_TX: HardwareModel.ValueType  # 46
"""
BetaFPV ExpressLRS "Nano" TX Module 900MHz with ESP32 CPU
"""
RPI_PICO: HardwareModel.ValueType  # 47
"""
Raspberry Pi Pico (W) with Waveshare SX1262 LoRa Node Module
"""
HELTEC_WIRELESS_TRACKER: HardwareModel.ValueType  # 48
"""
Heltec Wireless Tracker with ESP32-S3 CPU, built-in GPS, and TFT
Newer V1.1, version is written on the PCB near the display.
"""
HELTEC_WIRELESS_PAPER: HardwareModel.ValueType  # 49
"""
Heltec Wireless Paper with ESP32-S3 CPU and E-Ink display
"""
T_DECK: HardwareModel.ValueType  # 50
"""
LilyGo T-Deck with ESP32-S3 CPU, Keyboard and IPS display
"""
T_WATCH_S3: HardwareModel.ValueType  # 51
"""
LilyGo T-Watch S3 with ESP32-S3 CPU and IPS display
"""
PICOMPUTER_S3: HardwareModel.ValueType  # 52
"""
Bobricius Picomputer with ESP32-S3 CPU, Keyboard and IPS display
"""
HELTEC_HT62: HardwareModel.ValueType  # 53
"""
Heltec HT-CT62 with ESP32-C3 CPU and SX1262 LoRa
"""
EBYTE_ESP32_S3: HardwareModel.ValueType  # 54
"""
EBYTE SPI LoRa module and ESP32-S3
"""
ESP32_S3_PICO: HardwareModel.ValueType  # 55
"""
Waveshare ESP32-S3-PICO with PICO LoRa HAT and 2.9inch e-Ink
"""
CHATTER_2: HardwareModel.ValueType  # 56
"""
CircuitMess Chatter 2 LLCC68 Lora Module and ESP32 Wroom
Lora module can be swapped out for a Heltec RA-62 which is "almost" pin compatible
with one cut and one jumper Meshtastic works
"""
HELTEC_WIRELESS_PAPER_V1_0: HardwareModel.ValueType  # 57
"""
Heltec Wireless Paper, With ESP32-S3 CPU and E-Ink display
Older "V1.0" Variant, has no "version sticker"
E-Ink model is DEPG0213BNS800
Tab on the screen protector is RED
Flex connector marking is FPC-7528B
"""
HELTEC_WIRELESS_TRACKER_V1_0: HardwareModel.ValueType  # 58
"""
Heltec Wireless Tracker with ESP32-S3 CPU, built-in GPS, and TFT
Older "V1.0" Variant
"""
UNPHONE: HardwareModel.ValueType  # 59
"""
unPhone with ESP32-S3, TFT touchscreen,  LSM6DS3TR-C accelerometer and gyroscope
"""
TD_LORAC: HardwareModel.ValueType  # 60
"""
Teledatics TD-LORAC NRF52840 based M.2 LoRA module
Compatible with the TD-WRLS development board
"""
CDEBYTE_EORA_S3: HardwareModel.ValueType  # 61
"""
CDEBYTE EoRa-S3 board using their own MM modules, clone of LILYGO T3S3
"""
TWC_MESH_V4: HardwareModel.ValueType  # 62
"""
TWC_MESH_V4
Adafruit NRF52840 feather express with SX1262, SSD1306 OLED and NEO6M GPS
"""
NRF52_PROMICRO_DIY: HardwareModel.ValueType  # 63
"""
NRF52_PROMICRO_DIY
Promicro NRF52840 with SX1262/LLCC68, SSD1306 OLED and NEO6M GPS
"""
RADIOMASTER_900_BANDIT_NANO: HardwareModel.ValueType  # 64
"""
RadioMaster 900 Bandit Nano, https://www.radiomasterrc.com/products/bandit-nano-expresslrs-rf-module
ESP32-D0WDQ6 With SX1276/SKY66122, SSD1306 OLED and No GPS
"""
HELTEC_CAPSULE_SENSOR_V3: HardwareModel.ValueType  # 65
"""
Heltec Capsule Sensor V3 with ESP32-S3 CPU, Portable LoRa device that can replace GNSS modules or sensors
"""
HELTEC_VISION_MASTER_T190: HardwareModel.ValueType  # 66
"""
Heltec Vision Master T190 with ESP32-S3 CPU, and a 1.90 inch TFT display
"""
HELTEC_VISION_MASTER_E213: HardwareModel.ValueType  # 67
"""
Heltec Vision Master E213 with ESP32-S3 CPU, and a 2.13 inch E-Ink display
"""
HELTEC_VISION_MASTER_E290: HardwareModel.ValueType  # 68
"""
Heltec Vision Master E290 with ESP32-S3 CPU, and a 2.9 inch E-Ink display
"""
HELTEC_MESH_NODE_T114: HardwareModel.ValueType  # 69
"""
Heltec Mesh Node T114 board with nRF52840 CPU, and a 1.14 inch TFT display, Ultimate low-power design,
specifically adapted for the Meshtatic project
"""
SENSECAP_INDICATOR: HardwareModel.ValueType  # 70
"""
Sensecap Indicator from Seeed Studio. ESP32-S3 device with TFT and RP2040 coprocessor
"""
TRACKER_T1000_E: HardwareModel.ValueType  # 71
"""
Seeed studio T1000-E tracker card. NRF52840 w/ LR1110 radio, GPS, button, buzzer, and sensors.
"""
RAK3172: HardwareModel.ValueType  # 72
"""
RAK3172 STM32WLE5 Module (https://store.rakwireless.com/products/wisduo-lpwan-module-rak3172)
"""
WIO_E5: HardwareModel.ValueType  # 73
"""
Seeed Studio Wio-E5 (either mini or Dev kit) using STM32WL chip.
"""
RADIOMASTER_900_BANDIT: HardwareModel.ValueType  # 74
"""
RadioMaster 900 Bandit, https://www.radiomasterrc.com/products/bandit-expresslrs-rf-module
SSD1306 OLED and No GPS
"""
ME25LS01_4Y10TD: HardwareModel.ValueType  # 75
"""
Minewsemi ME25LS01 (ME25LE01_V1.0). NRF52840 w/ LR1110 radio, buttons and leds and pins.
"""
RP2040_FEATHER_RFM95: HardwareModel.ValueType  # 76
"""
RP2040_FEATHER_RFM95
Adafruit Feather RP2040 with RFM95 LoRa Radio RFM95 with SX1272, SSD1306 OLED
https://www.adafruit.com/product/5714
https://www.adafruit.com/product/326
https://www.adafruit.com/product/938
 ^^^ short A0 to switch to I2C address 0x3C
"""
M5STACK_COREBASIC: HardwareModel.ValueType  # 77
"""M5 esp32 based MCU modules with enclosure, TFT and LORA Shields. All Variants (Basic, Core, Fire, Core2, CoreS3, Paper) https://m5stack.com/"""
M5STACK_CORE2: HardwareModel.ValueType  # 78
RPI_PICO2: HardwareModel.ValueType  # 79
"""Pico2 with Waveshare Hat, same as Pico"""
M5STACK_CORES3: HardwareModel.ValueType  # 80
"""M5 esp32 based MCU modules with enclosure, TFT and LORA Shields. All Variants (Basic, Core, Fire, Core2, CoreS3, Paper) https://m5stack.com/"""
SEEED_XIAO_S3: HardwareModel.ValueType  # 81
"""Seeed XIAO S3 DK"""
MS24SF1: HardwareModel.ValueType  # 82
"""
Nordic nRF52840+Semtech SX1262 LoRa BLE Combo Module. nRF52840+SX1262 MS24SF1
"""
TLORA_C6: HardwareModel.ValueType  # 83
"""
Lilygo TLora-C6 with the new ESP32-C6 MCU
"""
WISMESH_TAP: HardwareModel.ValueType  # 84
"""
WisMesh Tap
RAK-4631 w/ TFT in injection modled case
"""
ROUTASTIC: HardwareModel.ValueType  # 85
"""
Similar to PORTDUINO but used by Routastic devices, this is not any
particular device and does not run Meshtastic's code but supports
the same frame format.
Runs on linux, see https://github.com/Jorropo/routastic
"""
MESH_TAB: HardwareModel.ValueType  # 86
"""
Mesh-Tab, esp32 based
https://github.com/valzzu/Mesh-Tab
"""
MESHLINK: HardwareModel.ValueType  # 87
"""
MeshLink board developed by LoraItalia. NRF52840, eByte E22900M22S (Will also come with other frequencies), 25w MPPT solar charger (5v,12v,18v selectable), support for gps, buzzer, oled or e-ink display, 10 gpios, hardware watchdog
https://www.loraitalia.it
"""
XIAO_NRF52_KIT: HardwareModel.ValueType  # 88
"""
Seeed XIAO nRF52840 + Wio SX1262 kit
"""
THINKNODE_M1: HardwareModel.ValueType  # 89
"""
Elecrow ThinkNode M1 & M2
https://www.elecrow.com/wiki/ThinkNode-M1_Transceiver_Device(Meshtastic)_Power_By_nRF52840.html
https://www.elecrow.com/wiki/ThinkNode-M2_Transceiver_Device(Meshtastic)_Power_By_NRF52840.html (this actually uses ESP32-S3)
"""
THINKNODE_M2: HardwareModel.ValueType  # 90
T_ETH_ELITE: HardwareModel.ValueType  # 91
"""
Lilygo T-ETH-Elite
"""
HELTEC_SENSOR_HUB: HardwareModel.ValueType  # 92
"""
Heltec HRI-3621 industrial probe
"""
MUZI_BASE: HardwareModel.ValueType  # 93
"""
Muzi Works Muzi-Base device
"""
HELTEC_MESH_POCKET: HardwareModel.ValueType  # 94
"""
Heltec Magnetic Power Bank with Meshtastic compatible
"""
SEEED_SOLAR_NODE: HardwareModel.ValueType  # 95
"""
Seeed Solar Node
"""
NOMADSTAR_METEOR_PRO: HardwareModel.ValueType  # 96
"""
NomadStar Meteor Pro https://nomadstar.ch/
"""
CROWPANEL: HardwareModel.ValueType  # 97
"""
Elecrow CrowPanel Advance models, ESP32-S3 and TFT with SX1262 radio plugin
"""
LINK_32: HardwareModel.ValueType  # 98
"""
Lilygo LINK32 board with sensors
"""
SEEED_WIO_TRACKER_L1: HardwareModel.ValueType  # 99
"""
Seeed Tracker L1
"""
SEEED_WIO_TRACKER_L1_EINK: HardwareModel.ValueType  # 100
"""
Seeed Tracker L1 EINK driver
"""
MUZI_R1_NEO: HardwareModel.ValueType  # 101
"""
Muzi Works R1 Neo
"""
T_DECK_PRO: HardwareModel.ValueType  # 102
"""
Lilygo T-Deck Pro
"""
T_LORA_PAGER: HardwareModel.ValueType  # 103
"""
Lilygo TLora Pager
"""
M5STACK_RESERVED: HardwareModel.ValueType  # 104
"""
M5Stack Reserved
0x68
"""
WISMESH_TAG: HardwareModel.ValueType  # 105
"""
RAKwireless WisMesh Tag
"""
RAK3312: HardwareModel.ValueType  # 106
"""
RAKwireless WisBlock Core RAK3312 https://docs.rakwireless.com/product-categories/wisduo/rak3112-module/overview/
"""
THINKNODE_M5: HardwareModel.ValueType  # 107
"""
Elecrow ThinkNode M5 https://www.elecrow.com/wiki/ThinkNode_M5_Meshtastic_LoRa_Signal_Transceiver_ESP32-S3.html
"""
HELTEC_MESH_SOLAR: HardwareModel.ValueType  # 108
"""
MeshSolar is an integrated power management and communication solution designed for outdoor low-power devices.
https://heltec.org/project/meshsolar/
"""
T_ECHO_LITE: HardwareModel.ValueType  # 109
"""
Lilygo T-Echo Lite
"""
HELTEC_V4: HardwareModel.ValueType  # 110
"""
New Heltec LoRA32 with ESP32-S3 CPU
"""
M5STACK_C6L: HardwareModel.ValueType  # 111
"""
M5Stack C6L
"""
M5STACK_CARDPUTER_ADV: HardwareModel.ValueType  # 112
"""
M5Stack Cardputer Adv
"""
HELTEC_WIRELESS_TRACKER_V2: HardwareModel.ValueType  # 113
"""
ESP32S3 main controller with GPS and TFT screen.
"""
T_WATCH_ULTRA: HardwareModel.ValueType  # 114
"""
LilyGo T-Watch Ultra
"""
THINKNODE_M3: HardwareModel.ValueType  # 115
"""
Elecrow ThinkNode M3
"""
WISMESH_TAP_V2: HardwareModel.ValueType  # 116
"""
RAK WISMESH_TAP_V2 with ESP32-S3 CPU
"""
RAK3401: HardwareModel.ValueType  # 117
"""
RAK3401
"""
RAK6421: HardwareModel.ValueType  # 118
"""
RAK6421 Hat+
"""
THINKNODE_M4: HardwareModel.ValueType  # 119
"""
Elecrow ThinkNode M4
"""
THINKNODE_M6: HardwareModel.ValueType  # 120
"""
Elecrow ThinkNode M6
"""
PRIVATE_HW: HardwareModel.ValueType  # 255
"""
------------------------------------------------------------------------------------------------------------------------------------------
Reserved ID For developing private Ports. These will show up in live traffic sparsely, so we can use a high number. Keep it within 8 bits.
------------------------------------------------------------------------------------------------------------------------------------------
"""
global___HardwareModel = HardwareModel

class _Constants:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ConstantsEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Constants.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ZERO: _Constants.ValueType  # 0
    """
    First enum must be zero, and we are just using this enum to
    pass int constants between two very different environments
    """
    DATA_PAYLOAD_LEN: _Constants.ValueType  # 233
    """
    From mesh.options
    note: this payload length is ONLY the bytes that are sent inside of the Data protobuf (excluding protobuf overhead). The 16 byte header is
    outside of this envelope
    """

class Constants(_Constants, metaclass=_ConstantsEnumTypeWrapper):
    """
    Shared constants between device and phone
    """

ZERO: Constants.ValueType  # 0
"""
First enum must be zero, and we are just using this enum to
pass int constants between two very different environments
"""
DATA_PAYLOAD_LEN: Constants.ValueType  # 233
"""
From mesh.options
note: this payload length is ONLY the bytes that are sent inside of the Data protobuf (excluding protobuf overhead). The 16 byte header is
outside of this envelope
"""
global___Constants = Constants

class _CriticalErrorCode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CriticalErrorCodeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CriticalErrorCode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NONE: _CriticalErrorCode.ValueType  # 0
    """
    TODO: REPLACE
    """
    TX_WATCHDOG: _CriticalErrorCode.ValueType  # 1
    """
    A software bug was detected while trying to send lora
    """
    SLEEP_ENTER_WAIT: _CriticalErrorCode.ValueType  # 2
    """
    A software bug was detected on entry to sleep
    """
    NO_RADIO: _CriticalErrorCode.ValueType  # 3
    """
    No Lora radio hardware could be found
    """
    UNSPECIFIED: _CriticalErrorCode.ValueType  # 4
    """
    Not normally used
    """
    UBLOX_UNIT_FAILED: _CriticalErrorCode.ValueType  # 5
    """
    We failed while configuring a UBlox GPS
    """
    NO_AXP192: _CriticalErrorCode.ValueType  # 6
    """
    This board was expected to have a power management chip and it is missing or broken
    """
    INVALID_RADIO_SETTING: _CriticalErrorCode.ValueType  # 7
    """
    The channel tried to set a radio setting which is not supported by this chipset,
    radio comms settings are now undefined.
    """
    TRANSMIT_FAILED: _CriticalErrorCode.ValueType  # 8
    """
    Radio transmit hardware failure. We sent data to the radio chip, but it didn't
    reply with an interrupt.
    """
    BROWNOUT: _CriticalErrorCode.ValueType  # 9
    """
    We detected that the main CPU voltage dropped below the minimum acceptable value
    """
    SX1262_FAILURE: _CriticalErrorCode.ValueType  # 10
    """Selftest of SX1262 radio chip failed"""
    RADIO_SPI_BUG: _CriticalErrorCode.ValueType  # 11
    """
    A (likely software but possibly hardware) failure was detected while trying to send packets.
    If this occurs on your board, please post in the forum so that we can ask you to collect some information to allow fixing this bug
    """
    FLASH_CORRUPTION_RECOVERABLE: _CriticalErrorCode.ValueType  # 12
    """
    Corruption was detected on the flash filesystem but we were able to repair things.
    If you see this failure in the field please post in the forum because we are interested in seeing if this is occurring in the field.
    """
    FLASH_CORRUPTION_UNRECOVERABLE: _CriticalErrorCode.ValueType  # 13
    """
    Corruption was detected on the flash filesystem but we were unable to repair things.
    NOTE: Your node will probably need to be reconfigured the next time it reboots (it will lose the region code etc...)
    If you see this failure in the field please post in the forum because we are interested in seeing if this is occurring in the field.
    """

class CriticalErrorCode(_CriticalErrorCode, metaclass=_CriticalErrorCodeEnumTypeWrapper):
    """
    Error codes for critical errors
    The device might report these fault codes on the screen.
    If you encounter a fault code, please post on the meshtastic.discourse.group
    and we'll try to help.
    """

NONE: CriticalErrorCode.ValueType  # 0
"""
TODO: REPLACE
"""
TX_WATCHDOG: CriticalErrorCode.ValueType  # 1
"""
A software bug was detected while trying to send lora
"""
SLEEP_ENTER_WAIT: CriticalErrorCode.ValueType  # 2
"""
A software bug was detected on entry to sleep
"""
NO_RADIO: CriticalErrorCode.ValueType  # 3
"""
No Lora radio hardware could be found
"""
UNSPECIFIED: CriticalErrorCode.ValueType  # 4
"""
Not normally used
"""
UBLOX_UNIT_FAILED: CriticalErrorCode.ValueType  # 5
"""
We failed while configuring a UBlox GPS
"""
NO_AXP192: CriticalErrorCode.ValueType  # 6
"""
This board was expected to have a power management chip and it is missing or broken
"""
INVALID_RADIO_SETTING: CriticalErrorCode.ValueType  # 7
"""
The channel tried to set a radio setting which is not supported by this chipset,
radio comms settings are now undefined.
"""
TRANSMIT_FAILED: CriticalErrorCode.ValueType  # 8
"""
Radio transmit hardware failure. We sent data to the radio chip, but it didn't
reply with an interrupt.
"""
BROWNOUT: CriticalErrorCode.ValueType  # 9
"""
We detected that the main CPU voltage dropped below the minimum acceptable value
"""
SX1262_FAILURE: CriticalErrorCode.ValueType  # 10
"""Selftest of SX1262 radio chip failed"""
RADIO_SPI_BUG: CriticalErrorCode.ValueType  # 11
"""
A (likely software but possibly hardware) failure was detected while trying to send packets.
If this occurs on your board, please post in the forum so that we can ask you to collect some information to allow fixing this bug
"""
FLASH_CORRUPTION_RECOVERABLE: CriticalErrorCode.ValueType  # 12
"""
Corruption was detected on the flash filesystem but we were able to repair things.
If you see this failure in the field please post in the forum because we are interested in seeing if this is occurring in the field.
"""
FLASH_CORRUPTION_UNRECOVERABLE: CriticalErrorCode.ValueType  # 13
"""
Corruption was detected on the flash filesystem but we were unable to repair things.
NOTE: Your node will probably need to be reconfigured the next time it reboots (it will lose the region code etc...)
If you see this failure in the field please post in the forum because we are interested in seeing if this is occurring in the field.
"""
global___CriticalErrorCode = CriticalErrorCode

class _FirmwareEdition:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FirmwareEditionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FirmwareEdition.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    VANILLA: _FirmwareEdition.ValueType  # 0
    """
    Vanilla firmware
    """
    SMART_CITIZEN: _FirmwareEdition.ValueType  # 1
    """
    Firmware for use in the Smart Citizen environmental monitoring network
    """
    OPEN_SAUCE: _FirmwareEdition.ValueType  # 16
    """
    Open Sauce, the maker conference held yearly in CA
    """
    DEFCON: _FirmwareEdition.ValueType  # 17
    """
    DEFCON, the yearly hacker conference
    """
    BURNING_MAN: _FirmwareEdition.ValueType  # 18
    """
    Burning Man, the yearly hippie gathering in the desert
    """
    HAMVENTION: _FirmwareEdition.ValueType  # 19
    """
    Hamvention, the Dayton amateur radio convention
    """
    DIY_EDITION: _FirmwareEdition.ValueType  # 127
    """
    Placeholder for DIY and unofficial events
    """

class FirmwareEdition(_FirmwareEdition, metaclass=_FirmwareEditionEnumTypeWrapper):
    """
    Enum to indicate to clients whether this firmware is a special firmware build, like an event.
    The first 16 values are reserved for non-event special firmwares, like the Smart Citizen use case.
    """

VANILLA: FirmwareEdition.ValueType  # 0
"""
Vanilla firmware
"""
SMART_CITIZEN: FirmwareEdition.ValueType  # 1
"""
Firmware for use in the Smart Citizen environmental monitoring network
"""
OPEN_SAUCE: FirmwareEdition.ValueType  # 16
"""
Open Sauce, the maker conference held yearly in CA
"""
DEFCON: FirmwareEdition.ValueType  # 17
"""
DEFCON, the yearly hacker conference
"""
BURNING_MAN: FirmwareEdition.ValueType  # 18
"""
Burning Man, the yearly hippie gathering in the desert
"""
HAMVENTION: FirmwareEdition.ValueType  # 19
"""
Hamvention, the Dayton amateur radio convention
"""
DIY_EDITION: FirmwareEdition.ValueType  # 127
"""
Placeholder for DIY and unofficial events
"""
global___FirmwareEdition = FirmwareEdition

class _ExcludedModules:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ExcludedModulesEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ExcludedModules.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    EXCLUDED_NONE: _ExcludedModules.ValueType  # 0
    """
    Default value of 0 indicates no modules are excluded.
    """
    MQTT_CONFIG: _ExcludedModules.ValueType  # 1
    """
    MQTT module
    """
    SERIAL_CONFIG: _ExcludedModules.ValueType  # 2
    """
    Serial module
    """
    EXTNOTIF_CONFIG: _ExcludedModules.ValueType  # 4
    """
    External Notification module
    """
    STOREFORWARD_CONFIG: _ExcludedModules.ValueType  # 8
    """
    Store and Forward module
    """
    RANGETEST_CONFIG: _ExcludedModules.ValueType  # 16
    """
    Range Test module
    """
    TELEMETRY_CONFIG: _ExcludedModules.ValueType  # 32
    """
    Telemetry module
    """
    CANNEDMSG_CONFIG: _ExcludedModules.ValueType  # 64
    """
    Canned Message module
    """
    AUDIO_CONFIG: _ExcludedModules.ValueType  # 128
    """
    Audio module
    """
    REMOTEHARDWARE_CONFIG: _ExcludedModules.ValueType  # 256
    """
    Remote Hardware module
    """
    NEIGHBORINFO_CONFIG: _ExcludedModules.ValueType  # 512
    """
    Neighbor Info module
    """
    AMBIENTLIGHTING_CONFIG: _ExcludedModules.ValueType  # 1024
    """
    Ambient Lighting module
    """
    DETECTIONSENSOR_CONFIG: _ExcludedModules.ValueType  # 2048
    """
    Detection Sensor module
    """
    PAXCOUNTER_CONFIG: _ExcludedModules.ValueType  # 4096
    """
    Paxcounter module
    """
    BLUETOOTH_CONFIG: _ExcludedModules.ValueType  # 8192
    """
    Bluetooth config (not technically a module, but used to indicate bluetooth capabilities)
    """
    NETWORK_CONFIG: _ExcludedModules.ValueType  # 16384
    """
    Network config (not technically a module, but used to indicate network capabilities)
    """

class ExcludedModules(_ExcludedModules, metaclass=_ExcludedModulesEnumTypeWrapper):
    """
    Enum for modules excluded from a device's configuration.
    Each value represents a ModuleConfigType that can be toggled as excluded
    by setting its corresponding bit in the `excluded_modules` bitmask field.
    """

EXCLUDED_NONE: ExcludedModules.ValueType  # 0
"""
Default value of 0 indicates no modules are excluded.
"""
MQTT_CONFIG: ExcludedModules.ValueType  # 1
"""
MQTT module
"""
SERIAL_CONFIG: ExcludedModules.ValueType  # 2
"""
Serial module
"""
EXTNOTIF_CONFIG: ExcludedModules.ValueType  # 4
"""
External Notification module
"""
STOREFORWARD_CONFIG: ExcludedModules.ValueType  # 8
"""
Store and Forward module
"""
RANGETEST_CONFIG: ExcludedModules.ValueType  # 16
"""
Range Test module
"""
TELEMETRY_CONFIG: ExcludedModules.ValueType  # 32
"""
Telemetry module
"""
CANNEDMSG_CONFIG: ExcludedModules.ValueType  # 64
"""
Canned Message module
"""
AUDIO_CONFIG: ExcludedModules.ValueType  # 128
"""
Audio module
"""
REMOTEHARDWARE_CONFIG: ExcludedModules.ValueType  # 256
"""
Remote Hardware module
"""
NEIGHBORINFO_CONFIG: ExcludedModules.ValueType  # 512
"""
Neighbor Info module
"""
AMBIENTLIGHTING_CONFIG: ExcludedModules.ValueType  # 1024
"""
Ambient Lighting module
"""
DETECTIONSENSOR_CONFIG: ExcludedModules.ValueType  # 2048
"""
Detection Sensor module
"""
PAXCOUNTER_CONFIG: ExcludedModules.ValueType  # 4096
"""
Paxcounter module
"""
BLUETOOTH_CONFIG: ExcludedModules.ValueType  # 8192
"""
Bluetooth config (not technically a module, but used to indicate bluetooth capabilities)
"""
NETWORK_CONFIG: ExcludedModules.ValueType  # 16384
"""
Network config (not technically a module, but used to indicate network capabilities)
"""
global___ExcludedModules = ExcludedModules

@typing.final
class Position(google.protobuf.message.Message):
    """
    A GPS Position
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _LocSource:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _LocSourceEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Position._LocSource.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        LOC_UNSET: Position._LocSource.ValueType  # 0
        """
        TODO: REPLACE
        """
        LOC_MANUAL: Position._LocSource.ValueType  # 1
        """
        TODO: REPLACE
        """
        LOC_INTERNAL: Position._LocSource.ValueType  # 2
        """
        TODO: REPLACE
        """
        LOC_EXTERNAL: Position._LocSource.ValueType  # 3
        """
        TODO: REPLACE
        """

    class LocSource(_LocSource, metaclass=_LocSourceEnumTypeWrapper):
        """
        How the location was acquired: manual, onboard GPS, external (EUD) GPS
        """

    LOC_UNSET: Position.LocSource.ValueType  # 0
    """
    TODO: REPLACE
    """
    LOC_MANUAL: Position.LocSource.ValueType  # 1
    """
    TODO: REPLACE
    """
    LOC_INTERNAL: Position.LocSource.ValueType  # 2
    """
    TODO: REPLACE
    """
    LOC_EXTERNAL: Position.LocSource.ValueType  # 3
    """
    TODO: REPLACE
    """

    class _AltSource:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AltSourceEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Position._AltSource.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ALT_UNSET: Position._AltSource.ValueType  # 0
        """
        TODO: REPLACE
        """
        ALT_MANUAL: Position._AltSource.ValueType  # 1
        """
        TODO: REPLACE
        """
        ALT_INTERNAL: Position._AltSource.ValueType  # 2
        """
        TODO: REPLACE
        """
        ALT_EXTERNAL: Position._AltSource.ValueType  # 3
        """
        TODO: REPLACE
        """
        ALT_BAROMETRIC: Position._AltSource.ValueType  # 4
        """
        TODO: REPLACE
        """

    class AltSource(_AltSource, metaclass=_AltSourceEnumTypeWrapper):
        """
        How the altitude was acquired: manual, GPS int/ext, etc
        Default: same as location_source if present
        """

    ALT_UNSET: Position.AltSource.ValueType  # 0
    """
    TODO: REPLACE
    """
    ALT_MANUAL: Position.AltSource.ValueType  # 1
    """
    TODO: REPLACE
    """
    ALT_INTERNAL: Position.AltSource.ValueType  # 2
    """
    TODO: REPLACE
    """
    ALT_EXTERNAL: Position.AltSource.ValueType  # 3
    """
    TODO: REPLACE
    """
    ALT_BAROMETRIC: Position.AltSource.ValueType  # 4
    """
    TODO: REPLACE
    """

    LATITUDE_I_FIELD_NUMBER: builtins.int
    LONGITUDE_I_FIELD_NUMBER: builtins.int
    ALTITUDE_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    LOCATION_SOURCE_FIELD_NUMBER: builtins.int
    ALTITUDE_SOURCE_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    TIMESTAMP_MILLIS_ADJUST_FIELD_NUMBER: builtins.int
    ALTITUDE_HAE_FIELD_NUMBER: builtins.int
    ALTITUDE_GEOIDAL_SEPARATION_FIELD_NUMBER: builtins.int
    PDOP_FIELD_NUMBER: builtins.int
    HDOP_FIELD_NUMBER: builtins.int
    VDOP_FIELD_NUMBER: builtins.int
    GPS_ACCURACY_FIELD_NUMBER: builtins.int
    GROUND_SPEED_FIELD_NUMBER: builtins.int
    GROUND_TRACK_FIELD_NUMBER: builtins.int
    FIX_QUALITY_FIELD_NUMBER: builtins.int
    FIX_TYPE_FIELD_NUMBER: builtins.int
    SATS_IN_VIEW_FIELD_NUMBER: builtins.int
    SENSOR_ID_FIELD_NUMBER: builtins.int
    NEXT_UPDATE_FIELD_NUMBER: builtins.int
    SEQ_NUMBER_FIELD_NUMBER: builtins.int
    PRECISION_BITS_FIELD_NUMBER: builtins.int
    latitude_i: builtins.int
    """
    The new preferred location encoding, multiply by 1e-7 to get degrees
    in floating point
    """
    longitude_i: builtins.int
    """
    TODO: REPLACE
    """
    altitude: builtins.int
    """
    In meters above MSL (but see issue #359)
    """
    time: builtins.int
    """
    This is usually not sent over the mesh (to save space), but it is sent
    from the phone so that the local device can set its time if it is sent over
    the mesh (because there are devices on the mesh without GPS or RTC).
    seconds since 1970
    """
    location_source: global___Position.LocSource.ValueType
    """
    TODO: REPLACE
    """
    altitude_source: global___Position.AltSource.ValueType
    """
    TODO: REPLACE
    """
    timestamp: builtins.int
    """
    Positional timestamp (actual timestamp of GPS solution) in integer epoch seconds
    """
    timestamp_millis_adjust: builtins.int
    """
    Pos. timestamp milliseconds adjustment (rarely available or required)
    """
    altitude_hae: builtins.int
    """
    HAE altitude in meters - can be used instead of MSL altitude
    """
    altitude_geoidal_separation: builtins.int
    """
    Geoidal separation in meters
    """
    PDOP: builtins.int
    """
    Horizontal, Vertical and Position Dilution of Precision, in 1/100 units
    - PDOP is sufficient for most cases
    - for higher precision scenarios, HDOP and VDOP can be used instead,
      in which case PDOP becomes redundant (PDOP=sqrt(HDOP^2 + VDOP^2))
    TODO: REMOVE/INTEGRATE
    """
    HDOP: builtins.int
    """
    TODO: REPLACE
    """
    VDOP: builtins.int
    """
    TODO: REPLACE
    """
    gps_accuracy: builtins.int
    """
    GPS accuracy (a hardware specific constant) in mm
      multiplied with DOP to calculate positional accuracy
    Default: "'bout three meters-ish" :)
    """
    ground_speed: builtins.int
    """
    Ground speed in m/s and True North TRACK in 1/100 degrees
    Clarification of terms:
    - "track" is the direction of motion (measured in horizontal plane)
    - "heading" is where the fuselage points (measured in horizontal plane)
    - "yaw" indicates a relative rotation about the vertical axis
    TODO: REMOVE/INTEGRATE
    """
    ground_track: builtins.int
    """
    TODO: REPLACE
    """
    fix_quality: builtins.int
    """
    GPS fix quality (from NMEA GxGGA statement or similar)
    """
    fix_type: builtins.int
    """
    GPS fix type 2D/3D (from NMEA GxGSA statement)
    """
    sats_in_view: builtins.int
    """
    GPS "Satellites in View" number
    """
    sensor_id: builtins.int
    """
    Sensor ID - in case multiple positioning sensors are being used
    """
    next_update: builtins.int
    """
    Estimated/expected time (in seconds) until next update:
    - if we update at fixed intervals of X seconds, use X
    - if we update at dynamic intervals (based on relative movement etc),
      but "AT LEAST every Y seconds", use Y
    """
    seq_number: builtins.int
    """
    A sequence number, incremented with each Position message to help
      detect lost updates if needed
    """
    precision_bits: builtins.int
    """
    Indicates the bits of precision set by the sending node
    """
    def __init__(
        self,
        *,
        latitude_i: builtins.int | None = ...,
        longitude_i: builtins.int | None = ...,
        altitude: builtins.int | None = ...,
        time: builtins.int = ...,
        location_source: global___Position.LocSource.ValueType = ...,
        altitude_source: global___Position.AltSource.ValueType = ...,
        timestamp: builtins.int = ...,
        timestamp_millis_adjust: builtins.int = ...,
        altitude_hae: builtins.int | None = ...,
        altitude_geoidal_separation: builtins.int | None = ...,
        PDOP: builtins.int = ...,
        HDOP: builtins.int = ...,
        VDOP: builtins.int = ...,
        gps_accuracy: builtins.int = ...,
        ground_speed: builtins.int | None = ...,
        ground_track: builtins.int | None = ...,
        fix_quality: builtins.int = ...,
        fix_type: builtins.int = ...,
        sats_in_view: builtins.int = ...,
        sensor_id: builtins.int = ...,
        next_update: builtins.int = ...,
        seq_number: builtins.int = ...,
        precision_bits: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_altitude", b"_altitude", "_altitude_geoidal_separation", b"_altitude_geoidal_separation", "_altitude_hae", b"_altitude_hae", "_ground_speed", b"_ground_speed", "_ground_track", b"_ground_track", "_latitude_i", b"_latitude_i", "_longitude_i", b"_longitude_i", "altitude", b"altitude", "altitude_geoidal_separation", b"altitude_geoidal_separation", "altitude_hae", b"altitude_hae", "ground_speed", b"ground_speed", "ground_track", b"ground_track", "latitude_i", b"latitude_i", "longitude_i", b"longitude_i"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["HDOP", b"HDOP", "PDOP", b"PDOP", "VDOP", b"VDOP", "_altitude", b"_altitude", "_altitude_geoidal_separation", b"_altitude_geoidal_separation", "_altitude_hae", b"_altitude_hae", "_ground_speed", b"_ground_speed", "_ground_track", b"_ground_track", "_latitude_i", b"_latitude_i", "_longitude_i", b"_longitude_i", "altitude", b"altitude", "altitude_geoidal_separation", b"altitude_geoidal_separation", "altitude_hae", b"altitude_hae", "altitude_source", b"altitude_source", "fix_quality", b"fix_quality", "fix_type", b"fix_type", "gps_accuracy", b"gps_accuracy", "ground_speed", b"ground_speed", "ground_track", b"ground_track", "latitude_i", b"latitude_i", "location_source", b"location_source", "longitude_i", b"longitude_i", "next_update", b"next_update", "precision_bits", b"precision_bits", "sats_in_view", b"sats_in_view", "sensor_id", b"sensor_id", "seq_number", b"seq_number", "time", b"time", "timestamp", b"timestamp", "timestamp_millis_adjust", b"timestamp_millis_adjust"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_altitude", b"_altitude"]) -> typing.Literal["altitude"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_altitude_geoidal_separation", b"_altitude_geoidal_separation"]) -> typing.Literal["altitude_geoidal_separation"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_altitude_hae", b"_altitude_hae"]) -> typing.Literal["altitude_hae"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ground_speed", b"_ground_speed"]) -> typing.Literal["ground_speed"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ground_track", b"_ground_track"]) -> typing.Literal["ground_track"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_latitude_i", b"_latitude_i"]) -> typing.Literal["latitude_i"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_longitude_i", b"_longitude_i"]) -> typing.Literal["longitude_i"] | None: ...

global___Position = Position

@typing.final
class User(google.protobuf.message.Message):
    """
    Broadcast when a newly powered mesh node wants to find a node num it can use
    Sent from the phone over bluetooth to set the user id for the owner of this node.
    Also sent from nodes to each other when a new node signs on (so all clients can have this info)
    The algorithm is as follows:
    when a node starts up, it broadcasts their user and the normal flow is for all
    other nodes to reply with their User as well (so the new node can build its nodedb)
    If a node ever receives a User (not just the first broadcast) message where
    the sender node number equals our node number, that indicates a collision has
    occurred and the following steps should happen:
    If the receiving node (that was already in the mesh)'s macaddr is LOWER than the
    new User who just tried to sign in: it gets to keep its nodenum.
    We send a broadcast message of OUR User (we use a broadcast so that the other node can
    receive our message, considering we have the same id - it also serves to let
    observers correct their nodedb) - this case is rare so it should be okay.
    If any node receives a User where the macaddr is GTE than their local macaddr,
    they have been vetoed and should pick a new random nodenum (filtering against
    whatever it knows about the nodedb) and rebroadcast their User.
    A few nodenums are reserved and will never be requested:
    0xff - broadcast
    0 through 3 - for future use
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    LONG_NAME_FIELD_NUMBER: builtins.int
    SHORT_NAME_FIELD_NUMBER: builtins.int
    MACADDR_FIELD_NUMBER: builtins.int
    HW_MODEL_FIELD_NUMBER: builtins.int
    IS_LICENSED_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    PUBLIC_KEY_FIELD_NUMBER: builtins.int
    IS_UNMESSAGABLE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """
    A globally unique ID string for this user.
    In the case of Signal that would mean +16504442323, for the default macaddr derived id it would be !<8 hexidecimal bytes>.
    Note: app developers are encouraged to also use the following standard
    node IDs "^all" (for broadcast), "^local" (for the locally connected node)
    """
    long_name: builtins.str
    """
    A full name for this user, i.e. "Kevin Hester"
    """
    short_name: builtins.str
    """
    A VERY short name, ideally two characters.
    Suitable for a tiny OLED screen
    """
    macaddr: builtins.bytes
    """
    Deprecated in Meshtastic 2.1.x
    This is the addr of the radio.
    Not populated by the phone, but added by the esp32 when broadcasting
    """
    hw_model: global___HardwareModel.ValueType
    """
    TBEAM, HELTEC, etc...
    Starting in 1.2.11 moved to hw_model enum in the NodeInfo object.
    Apps will still need the string here for older builds
    (so OTA update can find the right image), but if the enum is available it will be used instead.
    """
    is_licensed: builtins.bool
    """
    In some regions Ham radio operators have different bandwidth limitations than others.
    If this user is a licensed operator, set this flag.
    Also, "long_name" should be their licence number.
    """
    role: meshtastic.protobuf.config_pb2.Config.DeviceConfig.Role.ValueType
    """
    Indicates that the user's role in the mesh
    """
    public_key: builtins.bytes
    """
    The public key of the user's device.
    This is sent out to other nodes on the mesh to allow them to compute a shared secret key.
    """
    is_unmessagable: builtins.bool
    """
    Whether or not the node can be messaged
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        long_name: builtins.str = ...,
        short_name: builtins.str = ...,
        macaddr: builtins.bytes = ...,
        hw_model: global___HardwareModel.ValueType = ...,
        is_licensed: builtins.bool = ...,
        role: meshtastic.protobuf.config_pb2.Config.DeviceConfig.Role.ValueType = ...,
        public_key: builtins.bytes = ...,
        is_unmessagable: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_is_unmessagable", b"_is_unmessagable", "is_unmessagable", b"is_unmessagable"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_is_unmessagable", b"_is_unmessagable", "hw_model", b"hw_model", "id", b"id", "is_licensed", b"is_licensed", "is_unmessagable", b"is_unmessagable", "long_name", b"long_name", "macaddr", b"macaddr", "public_key", b"public_key", "role", b"role", "short_name", b"short_name"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_is_unmessagable", b"_is_unmessagable"]) -> typing.Literal["is_unmessagable"] | None: ...

global___User = User

@typing.final
class RouteDiscovery(google.protobuf.message.Message):
    """
    A message used in a traceroute
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROUTE_FIELD_NUMBER: builtins.int
    SNR_TOWARDS_FIELD_NUMBER: builtins.int
    ROUTE_BACK_FIELD_NUMBER: builtins.int
    SNR_BACK_FIELD_NUMBER: builtins.int
    @property
    def route(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """
        The list of nodenums this packet has visited so far to the destination.
        """

    @property
    def snr_towards(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """
        The list of SNRs (in dB, scaled by 4) in the route towards the destination.
        """

    @property
    def route_back(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """
        The list of nodenums the packet has visited on the way back from the destination.
        """

    @property
    def snr_back(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """
        The list of SNRs (in dB, scaled by 4) in the route back from the destination.
        """

    def __init__(
        self,
        *,
        route: collections.abc.Iterable[builtins.int] | None = ...,
        snr_towards: collections.abc.Iterable[builtins.int] | None = ...,
        route_back: collections.abc.Iterable[builtins.int] | None = ...,
        snr_back: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["route", b"route", "route_back", b"route_back", "snr_back", b"snr_back", "snr_towards", b"snr_towards"]) -> None: ...

global___RouteDiscovery = RouteDiscovery

@typing.final
class Routing(google.protobuf.message.Message):
    """
    A Routing control Data packet handled by the routing module
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Error:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ErrorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Routing._Error.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NONE: Routing._Error.ValueType  # 0
        """
        This message is not a failure
        """
        NO_ROUTE: Routing._Error.ValueType  # 1
        """
        Our node doesn't have a route to the requested destination anymore.
        """
        GOT_NAK: Routing._Error.ValueType  # 2
        """
        We received a nak while trying to forward on your behalf
        """
        TIMEOUT: Routing._Error.ValueType  # 3
        """
        TODO: REPLACE
        """
        NO_INTERFACE: Routing._Error.ValueType  # 4
        """
        No suitable interface could be found for delivering this packet
        """
        MAX_RETRANSMIT: Routing._Error.ValueType  # 5
        """
        We reached the max retransmission count (typically for naive flood routing)
        """
        NO_CHANNEL: Routing._Error.ValueType  # 6
        """
        No suitable channel was found for sending this packet (i.e. was requested channel index disabled?)
        """
        TOO_LARGE: Routing._Error.ValueType  # 7
        """
        The packet was too big for sending (exceeds interface MTU after encoding)
        """
        NO_RESPONSE: Routing._Error.ValueType  # 8
        """
        The request had want_response set, the request reached the destination node, but no service on that node wants to send a response
        (possibly due to bad channel permissions)
        """
        DUTY_CYCLE_LIMIT: Routing._Error.ValueType  # 9
        """
        Cannot send currently because duty cycle regulations will be violated.
        """
        BAD_REQUEST: Routing._Error.ValueType  # 32
        """
        The application layer service on the remote node received your request, but considered your request somehow invalid
        """
        NOT_AUTHORIZED: Routing._Error.ValueType  # 33
        """
        The application layer service on the remote node received your request, but considered your request not authorized
        (i.e you did not send the request on the required bound channel)
        """
        PKI_FAILED: Routing._Error.ValueType  # 34
        """
        The client specified a PKI transport, but the node was unable to send the packet using PKI (and did not send the message at all)
        """
        PKI_UNKNOWN_PUBKEY: Routing._Error.ValueType  # 35
        """
        The receiving node does not have a Public Key to decode with
        """
        ADMIN_BAD_SESSION_KEY: Routing._Error.ValueType  # 36
        """
        Admin packet otherwise checks out, but uses a bogus or expired session key
        """
        ADMIN_PUBLIC_KEY_UNAUTHORIZED: Routing._Error.ValueType  # 37
        """
        Admin packet sent using PKC, but not from a public key on the admin key list
        """
        RATE_LIMIT_EXCEEDED: Routing._Error.ValueType  # 38
        """
        Airtime fairness rate limit exceeded for a packet
        This typically enforced per portnum and is used to prevent a single node from monopolizing airtime
        """

    class Error(_Error, metaclass=_ErrorEnumTypeWrapper):
        """
        A failure in delivering a message (usually used for routing control messages, but might be provided in addition to ack.fail_id to provide
        details on the type of failure).
        """

    NONE: Routing.Error.ValueType  # 0
    """
    This message is not a failure
    """
    NO_ROUTE: Routing.Error.ValueType  # 1
    """
    Our node doesn't have a route to the requested destination anymore.
    """
    GOT_NAK: Routing.Error.ValueType  # 2
    """
    We received a nak while trying to forward on your behalf
    """
    TIMEOUT: Routing.Error.ValueType  # 3
    """
    TODO: REPLACE
    """
    NO_INTERFACE: Routing.Error.ValueType  # 4
    """
    No suitable interface could be found for delivering this packet
    """
    MAX_RETRANSMIT: Routing.Error.ValueType  # 5
    """
    We reached the max retransmission count (typically for naive flood routing)
    """
    NO_CHANNEL: Routing.Error.ValueType  # 6
    """
    No suitable channel was found for sending this packet (i.e. was requested channel index disabled?)
    """
    TOO_LARGE: Routing.Error.ValueType  # 7
    """
    The packet was too big for sending (exceeds interface MTU after encoding)
    """
    NO_RESPONSE: Routing.Error.ValueType  # 8
    """
    The request had want_response set, the request reached the destination node, but no service on that node wants to send a response
    (possibly due to bad channel permissions)
    """
    DUTY_CYCLE_LIMIT: Routing.Error.ValueType  # 9
    """
    Cannot send currently because duty cycle regulations will be violated.
    """
    BAD_REQUEST: Routing.Error.ValueType  # 32
    """
    The application layer service on the remote node received your request, but considered your request somehow invalid
    """
    NOT_AUTHORIZED: Routing.Error.ValueType  # 33
    """
    The application layer service on the remote node received your request, but considered your request not authorized
    (i.e you did not send the request on the required bound channel)
    """
    PKI_FAILED: Routing.Error.ValueType  # 34
    """
    The client specified a PKI transport, but the node was unable to send the packet using PKI (and did not send the message at all)
    """
    PKI_UNKNOWN_PUBKEY: Routing.Error.ValueType  # 35
    """
    The receiving node does not have a Public Key to decode with
    """
    ADMIN_BAD_SESSION_KEY: Routing.Error.ValueType  # 36
    """
    Admin packet otherwise checks out, but uses a bogus or expired session key
    """
    ADMIN_PUBLIC_KEY_UNAUTHORIZED: Routing.Error.ValueType  # 37
    """
    Admin packet sent using PKC, but not from a public key on the admin key list
    """
    RATE_LIMIT_EXCEEDED: Routing.Error.ValueType  # 38
    """
    Airtime fairness rate limit exceeded for a packet
    This typically enforced per portnum and is used to prevent a single node from monopolizing airtime
    """

    ROUTE_REQUEST_FIELD_NUMBER: builtins.int
    ROUTE_REPLY_FIELD_NUMBER: builtins.int
    ERROR_REASON_FIELD_NUMBER: builtins.int
    error_reason: global___Routing.Error.ValueType
    """
    A failure in delivering a message (usually used for routing control messages, but might be provided
    in addition to ack.fail_id to provide details on the type of failure).
    """
    @property
    def route_request(self) -> global___RouteDiscovery:
        """
        A route request going from the requester
        """

    @property
    def route_reply(self) -> global___RouteDiscovery:
        """
        A route reply
        """

    def __init__(
        self,
        *,
        route_request: global___RouteDiscovery | None = ...,
        route_reply: global___RouteDiscovery | None = ...,
        error_reason: global___Routing.Error.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["error_reason", b"error_reason", "route_reply", b"route_reply", "route_request", b"route_request", "variant", b"variant"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["error_reason", b"error_reason", "route_reply", b"route_reply", "route_request", b"route_request", "variant", b"variant"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["variant", b"variant"]) -> typing.Literal["route_request", "route_reply", "error_reason"] | None: ...

global___Routing = Routing

@typing.final
class Data(google.protobuf.message.Message):
    """
    (Formerly called SubPacket)
    The payload portion fo a packet, this is the actual bytes that are sent
    inside a radio packet (because from/to are broken out by the comms library)
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PORTNUM_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    WANT_RESPONSE_FIELD_NUMBER: builtins.int
    DEST_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    REPLY_ID_FIELD_NUMBER: builtins.int
    EMOJI_FIELD_NUMBER: builtins.int
    BITFIELD_FIELD_NUMBER: builtins.int
    portnum: meshtastic.protobuf.portnums_pb2.PortNum.ValueType
    """
    Formerly named typ and of type Type
    """
    payload: builtins.bytes
    """
    TODO: REPLACE
    """
    want_response: builtins.bool
    """
    Not normally used, but for testing a sender can request that recipient
    responds in kind (i.e. if it received a position, it should unicast back it's position).
    Note: that if you set this on a broadcast you will receive many replies.
    """
    dest: builtins.int
    """
    The address of the destination node.
    This field is is filled in by the mesh radio device software, application
    layer software should never need it.
    RouteDiscovery messages _must_ populate this.
    Other message types might need to if they are doing multihop routing.
    """
    source: builtins.int
    """
    The address of the original sender for this message.
    This field should _only_ be populated for reliable multihop packets (to keep
    packets small).
    """
    request_id: builtins.int
    """
    Only used in routing or response messages.
    Indicates the original message ID that this message is reporting failure on. (formerly called original_id)
    """
    reply_id: builtins.int
    """
    If set, this message is intened to be a reply to a previously sent message with the defined id.
    """
    emoji: builtins.int
    """
    Defaults to false. If true, then what is in the payload should be treated as an emoji like giving
    a message a heart or poop emoji.
    """
    bitfield: builtins.int
    """
    Bitfield for extra flags. First use is to indicate that user approves the packet being uploaded to MQTT.
    """
    def __init__(
        self,
        *,
        portnum: meshtastic.protobuf.portnums_pb2.PortNum.ValueType = ...,
        payload: builtins.bytes = ...,
        want_response: builtins.bool = ...,
        dest: builtins.int = ...,
        source: builtins.int = ...,
        request_id: builtins.int = ...,
        reply_id: builtins.int = ...,
        emoji: builtins.int = ...,
        bitfield: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_bitfield", b"_bitfield", "bitfield", b"bitfield"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_bitfield", b"_bitfield", "bitfield", b"bitfield", "dest", b"dest", "emoji", b"emoji", "payload", b"payload", "portnum", b"portnum", "reply_id", b"reply_id", "request_id", b"request_id", "source", b"source", "want_response", b"want_response"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_bitfield", b"_bitfield"]) -> typing.Literal["bitfield"] | None: ...

global___Data = Data

@typing.final
class KeyVerification(google.protobuf.message.Message):
    """
    The actual over-the-mesh message doing KeyVerification
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NONCE_FIELD_NUMBER: builtins.int
    HASH1_FIELD_NUMBER: builtins.int
    HASH2_FIELD_NUMBER: builtins.int
    nonce: builtins.int
    """
    random value Selected by the requesting node
    """
    hash1: builtins.bytes
    """
    The final authoritative hash, only to be sent by NodeA at the end of the handshake
    """
    hash2: builtins.bytes
    """
    The intermediary hash (actually derived from hash1),
    sent from NodeB to NodeA in response to the initial message.
    """
    def __init__(
        self,
        *,
        nonce: builtins.int = ...,
        hash1: builtins.bytes = ...,
        hash2: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["hash1", b"hash1", "hash2", b"hash2", "nonce", b"nonce"]) -> None: ...

global___KeyVerification = KeyVerification

@typing.final
class StoreForwardPlusPlus(google.protobuf.message.Message):
    """
    The actual over-the-mesh message doing store and forward++
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SFPP_message_type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SFPP_message_typeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StoreForwardPlusPlus._SFPP_message_type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CANON_ANNOUNCE: StoreForwardPlusPlus._SFPP_message_type.ValueType  # 0
        """
        Send an announcement of the canonical tip of a chain
        """
        CHAIN_QUERY: StoreForwardPlusPlus._SFPP_message_type.ValueType  # 1
        """
        Query whether a specific link is on the chain
        """
        LINK_REQUEST: StoreForwardPlusPlus._SFPP_message_type.ValueType  # 3
        """
        Request the next link in the chain
        """
        LINK_PROVIDE: StoreForwardPlusPlus._SFPP_message_type.ValueType  # 4
        """
        Provide a link to add to the chain
        """
        LINK_PROVIDE_FIRSTHALF: StoreForwardPlusPlus._SFPP_message_type.ValueType  # 5
        """
        If we must fragment, send the first half
        """
        LINK_PROVIDE_SECONDHALF: StoreForwardPlusPlus._SFPP_message_type.ValueType  # 6
        """
        If we must fragment, send the second half
        """

    class SFPP_message_type(_SFPP_message_type, metaclass=_SFPP_message_typeEnumTypeWrapper):
        """
        Enum of message types
        """

    CANON_ANNOUNCE: StoreForwardPlusPlus.SFPP_message_type.ValueType  # 0
    """
    Send an announcement of the canonical tip of a chain
    """
    CHAIN_QUERY: StoreForwardPlusPlus.SFPP_message_type.ValueType  # 1
    """
    Query whether a specific link is on the chain
    """
    LINK_REQUEST: StoreForwardPlusPlus.SFPP_message_type.ValueType  # 3
    """
    Request the next link in the chain
    """
    LINK_PROVIDE: StoreForwardPlusPlus.SFPP_message_type.ValueType  # 4
    """
    Provide a link to add to the chain
    """
    LINK_PROVIDE_FIRSTHALF: StoreForwardPlusPlus.SFPP_message_type.ValueType  # 5
    """
    If we must fragment, send the first half
    """
    LINK_PROVIDE_SECONDHALF: StoreForwardPlusPlus.SFPP_message_type.ValueType  # 6
    """
    If we must fragment, send the second half
    """

    SFPP_MESSAGE_TYPE_FIELD_NUMBER: builtins.int
    MESSAGE_HASH_FIELD_NUMBER: builtins.int
    COMMIT_HASH_FIELD_NUMBER: builtins.int
    ROOT_HASH_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    ENCAPSULATED_ID_FIELD_NUMBER: builtins.int
    ENCAPSULATED_TO_FIELD_NUMBER: builtins.int
    ENCAPSULATED_FROM_FIELD_NUMBER: builtins.int
    ENCAPSULATED_RXTIME_FIELD_NUMBER: builtins.int
    sfpp_message_type: global___StoreForwardPlusPlus.SFPP_message_type.ValueType
    """
    Which message type is this
    """
    message_hash: builtins.bytes
    """
    The hash of the specific message
    """
    commit_hash: builtins.bytes
    """
    The hash of a link on a chain
    """
    root_hash: builtins.bytes
    """
    the root hash of a chain
    """
    message: builtins.bytes
    """
    The encrypted bytes from a message
    """
    encapsulated_id: builtins.int
    """
    Message ID of the contained message
    """
    encapsulated_to: builtins.int
    """
    Destination of the contained message
    """
    encapsulated_from: builtins.int
    """
    Sender of the contained message
    """
    encapsulated_rxtime: builtins.int
    """
    The receive time of the message in question
    """
    def __init__(
        self,
        *,
        sfpp_message_type: global___StoreForwardPlusPlus.SFPP_message_type.ValueType = ...,
        message_hash: builtins.bytes = ...,
        commit_hash: builtins.bytes = ...,
        root_hash: builtins.bytes = ...,
        message: builtins.bytes = ...,
        encapsulated_id: builtins.int = ...,
        encapsulated_to: builtins.int = ...,
        encapsulated_from: builtins.int = ...,
        encapsulated_rxtime: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["commit_hash", b"commit_hash", "encapsulated_from", b"encapsulated_from", "encapsulated_id", b"encapsulated_id", "encapsulated_rxtime", b"encapsulated_rxtime", "encapsulated_to", b"encapsulated_to", "message", b"message", "message_hash", b"message_hash", "root_hash", b"root_hash", "sfpp_message_type", b"sfpp_message_type"]) -> None: ...

global___StoreForwardPlusPlus = StoreForwardPlusPlus

@typing.final
class Waypoint(google.protobuf.message.Message):
    """
    Waypoint message, used to share arbitrary locations across the mesh
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    LATITUDE_I_FIELD_NUMBER: builtins.int
    LONGITUDE_I_FIELD_NUMBER: builtins.int
    EXPIRE_FIELD_NUMBER: builtins.int
    LOCKED_TO_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ICON_FIELD_NUMBER: builtins.int
    id: builtins.int
    """
    Id of the waypoint
    """
    latitude_i: builtins.int
    """
    latitude_i
    """
    longitude_i: builtins.int
    """
    longitude_i
    """
    expire: builtins.int
    """
    Time the waypoint is to expire (epoch)
    """
    locked_to: builtins.int
    """
    If greater than zero, treat the value as a nodenum only allowing them to update the waypoint.
    If zero, the waypoint is open to be edited by any member of the mesh.
    """
    name: builtins.str
    """
    Name of the waypoint - max 30 chars
    """
    description: builtins.str
    """
    Description of the waypoint - max 100 chars
    """
    icon: builtins.int
    """
    Designator icon for the waypoint in the form of a unicode emoji
    """
    def __init__(
        self,
        *,
        id: builtins.int = ...,
        latitude_i: builtins.int | None = ...,
        longitude_i: builtins.int | None = ...,
        expire: builtins.int = ...,
        locked_to: builtins.int = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        icon: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_latitude_i", b"_latitude_i", "_longitude_i", b"_longitude_i", "latitude_i", b"latitude_i", "longitude_i", b"longitude_i"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_latitude_i", b"_latitude_i", "_longitude_i", b"_longitude_i", "description", b"description", "expire", b"expire", "icon", b"icon", "id", b"id", "latitude_i", b"latitude_i", "locked_to", b"locked_to", "longitude_i", b"longitude_i", "name", b"name"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_latitude_i", b"_latitude_i"]) -> typing.Literal["latitude_i"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_longitude_i", b"_longitude_i"]) -> typing.Literal["longitude_i"] | None: ...

global___Waypoint = Waypoint

@typing.final
class MqttClientProxyMessage(google.protobuf.message.Message):
    """
    This message will be proxied over the PhoneAPI for the client to deliver to the MQTT server
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOPIC_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    RETAINED_FIELD_NUMBER: builtins.int
    topic: builtins.str
    """
    The MQTT topic this message will be sent /received on
    """
    data: builtins.bytes
    """
    Bytes
    """
    text: builtins.str
    """
    Text
    """
    retained: builtins.bool
    """
    Whether the message should be retained (or not)
    """
    def __init__(
        self,
        *,
        topic: builtins.str = ...,
        data: builtins.bytes = ...,
        text: builtins.str = ...,
        retained: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["data", b"data", "payload_variant", b"payload_variant", "text", b"text"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "payload_variant", b"payload_variant", "retained", b"retained", "text", b"text", "topic", b"topic"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload_variant", b"payload_variant"]) -> typing.Literal["data", "text"] | None: ...

global___MqttClientProxyMessage = MqttClientProxyMessage

@typing.final
class MeshPacket(google.protobuf.message.Message):
    """
    A packet envelope sent/received over the mesh
    only payload_variant is sent in the payload portion of the LORA packet.
    The other fields are either not sent at all, or sent in the special 16 byte LORA header.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Priority:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PriorityEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MeshPacket._Priority.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSET: MeshPacket._Priority.ValueType  # 0
        """
        Treated as Priority.DEFAULT
        """
        MIN: MeshPacket._Priority.ValueType  # 1
        """
        TODO: REPLACE
        """
        BACKGROUND: MeshPacket._Priority.ValueType  # 10
        """
        Background position updates are sent with very low priority -
        if the link is super congested they might not go out at all
        """
        DEFAULT: MeshPacket._Priority.ValueType  # 64
        """
        This priority is used for most messages that don't have a priority set
        """
        RELIABLE: MeshPacket._Priority.ValueType  # 70
        """
        If priority is unset but the message is marked as want_ack,
        assume it is important and use a slightly higher priority
        """
        RESPONSE: MeshPacket._Priority.ValueType  # 80
        """
        If priority is unset but the packet is a response to a request, we want it to get there relatively quickly.
        Furthermore, responses stop relaying packets directed to a node early.
        """
        HIGH: MeshPacket._Priority.ValueType  # 100
        """
        Higher priority for specific message types (portnums) to distinguish between other reliable packets.
        """
        ALERT: MeshPacket._Priority.ValueType  # 110
        """
        Higher priority alert message used for critical alerts which take priority over other reliable packets.
        """
        ACK: MeshPacket._Priority.ValueType  # 120
        """
        Ack/naks are sent with very high priority to ensure that retransmission
        stops as soon as possible
        """
        MAX: MeshPacket._Priority.ValueType  # 127
        """
        TODO: REPLACE
        """

    class Priority(_Priority, metaclass=_PriorityEnumTypeWrapper):
        """
        The priority of this message for sending.
        Higher priorities are sent first (when managing the transmit queue).
        This field is never sent over the air, it is only used internally inside of a local device node.
        API clients (either on the local node or connected directly to the node)
        can set this parameter if necessary.
        (values must be <= 127 to keep protobuf field to one byte in size.
        Detailed background on this field:
        I noticed a funny side effect of lora being so slow: Usually when making
        a protocol there isn’t much need to use message priority to change the order
        of transmission (because interfaces are fairly fast).
        But for lora where packets can take a few seconds each, it is very important
        to make sure that critical packets are sent ASAP.
        In the case of meshtastic that means we want to send protocol acks as soon as possible
        (to prevent unneeded retransmissions), we want routing messages to be sent next,
        then messages marked as reliable and finally 'background' packets like periodic position updates.
        So I bit the bullet and implemented a new (internal - not sent over the air)
        field in MeshPacket called 'priority'.
        And the transmission queue in the router object is now a priority queue.
        """

    UNSET: MeshPacket.Priority.ValueType  # 0
    """
    Treated as Priority.DEFAULT
    """
    MIN: MeshPacket.Priority.ValueType  # 1
    """
    TODO: REPLACE
    """
    BACKGROUND: MeshPacket.Priority.ValueType  # 10
    """
    Background position updates are sent with very low priority -
    if the link is super congested they might not go out at all
    """
    DEFAULT: MeshPacket.Priority.ValueType  # 64
    """
    This priority is used for most messages that don't have a priority set
    """
    RELIABLE: MeshPacket.Priority.ValueType  # 70
    """
    If priority is unset but the message is marked as want_ack,
    assume it is important and use a slightly higher priority
    """
    RESPONSE: MeshPacket.Priority.ValueType  # 80
    """
    If priority is unset but the packet is a response to a request, we want it to get there relatively quickly.
    Furthermore, responses stop relaying packets directed to a node early.
    """
    HIGH: MeshPacket.Priority.ValueType  # 100
    """
    Higher priority for specific message types (portnums) to distinguish between other reliable packets.
    """
    ALERT: MeshPacket.Priority.ValueType  # 110
    """
    Higher priority alert message used for critical alerts which take priority over other reliable packets.
    """
    ACK: MeshPacket.Priority.ValueType  # 120
    """
    Ack/naks are sent with very high priority to ensure that retransmission
    stops as soon as possible
    """
    MAX: MeshPacket.Priority.ValueType  # 127
    """
    TODO: REPLACE
    """

    class _Delayed:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DelayedEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MeshPacket._Delayed.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NO_DELAY: MeshPacket._Delayed.ValueType  # 0
        """
        If unset, the message is being sent in real time.
        """
        DELAYED_BROADCAST: MeshPacket._Delayed.ValueType  # 1
        """
        The message is delayed and was originally a broadcast
        """
        DELAYED_DIRECT: MeshPacket._Delayed.ValueType  # 2
        """
        The message is delayed and was originally a direct message
        """

    class Delayed(_Delayed, metaclass=_DelayedEnumTypeWrapper):
        """
        Identify if this is a delayed packet
        """

    NO_DELAY: MeshPacket.Delayed.ValueType  # 0
    """
    If unset, the message is being sent in real time.
    """
    DELAYED_BROADCAST: MeshPacket.Delayed.ValueType  # 1
    """
    The message is delayed and was originally a broadcast
    """
    DELAYED_DIRECT: MeshPacket.Delayed.ValueType  # 2
    """
    The message is delayed and was originally a direct message
    """

    class _TransportMechanism:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TransportMechanismEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MeshPacket._TransportMechanism.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TRANSPORT_INTERNAL: MeshPacket._TransportMechanism.ValueType  # 0
        """
        The default case is that the node generated a packet itself
        """
        TRANSPORT_LORA: MeshPacket._TransportMechanism.ValueType  # 1
        """
        Arrived via the primary LoRa radio
        """
        TRANSPORT_LORA_ALT1: MeshPacket._TransportMechanism.ValueType  # 2
        """
        Arrived via a secondary LoRa radio
        """
        TRANSPORT_LORA_ALT2: MeshPacket._TransportMechanism.ValueType  # 3
        """
        Arrived via a tertiary LoRa radio
        """
        TRANSPORT_LORA_ALT3: MeshPacket._TransportMechanism.ValueType  # 4
        """
        Arrived via a quaternary LoRa radio
        """
        TRANSPORT_MQTT: MeshPacket._TransportMechanism.ValueType  # 5
        """
        Arrived via an MQTT connection
        """
        TRANSPORT_MULTICAST_UDP: MeshPacket._TransportMechanism.ValueType  # 6
        """
        Arrived via Multicast UDP
        """
        TRANSPORT_API: MeshPacket._TransportMechanism.ValueType  # 7
        """
        Arrived via API connection
        """

    class TransportMechanism(_TransportMechanism, metaclass=_TransportMechanismEnumTypeWrapper):
        """
        Enum to identify which transport mechanism this packet arrived over
        """

    TRANSPORT_INTERNAL: MeshPacket.TransportMechanism.ValueType  # 0
    """
    The default case is that the node generated a packet itself
    """
    TRANSPORT_LORA: MeshPacket.TransportMechanism.ValueType  # 1
    """
    Arrived via the primary LoRa radio
    """
    TRANSPORT_LORA_ALT1: MeshPacket.TransportMechanism.ValueType  # 2
    """
    Arrived via a secondary LoRa radio
    """
    TRANSPORT_LORA_ALT2: MeshPacket.TransportMechanism.ValueType  # 3
    """
    Arrived via a tertiary LoRa radio
    """
    TRANSPORT_LORA_ALT3: MeshPacket.TransportMechanism.ValueType  # 4
    """
    Arrived via a quaternary LoRa radio
    """
    TRANSPORT_MQTT: MeshPacket.TransportMechanism.ValueType  # 5
    """
    Arrived via an MQTT connection
    """
    TRANSPORT_MULTICAST_UDP: MeshPacket.TransportMechanism.ValueType  # 6
    """
    Arrived via Multicast UDP
    """
    TRANSPORT_API: MeshPacket.TransportMechanism.ValueType  # 7
    """
    Arrived via API connection
    """

    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    CHANNEL_FIELD_NUMBER: builtins.int
    DECODED_FIELD_NUMBER: builtins.int
    ENCRYPTED_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    RX_TIME_FIELD_NUMBER: builtins.int
    RX_SNR_FIELD_NUMBER: builtins.int
    HOP_LIMIT_FIELD_NUMBER: builtins.int
    WANT_ACK_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    RX_RSSI_FIELD_NUMBER: builtins.int
    DELAYED_FIELD_NUMBER: builtins.int
    VIA_MQTT_FIELD_NUMBER: builtins.int
    HOP_START_FIELD_NUMBER: builtins.int
    PUBLIC_KEY_FIELD_NUMBER: builtins.int
    PKI_ENCRYPTED_FIELD_NUMBER: builtins.int
    NEXT_HOP_FIELD_NUMBER: builtins.int
    RELAY_NODE_FIELD_NUMBER: builtins.int
    TX_AFTER_FIELD_NUMBER: builtins.int
    TRANSPORT_MECHANISM_FIELD_NUMBER: builtins.int
    to: builtins.int
    """
    The (immediate) destination for this packet
    If the value is 4,294,967,295 (maximum value of an unsigned 32bit integer), this indicates that the packet was
    not destined for a specific node, but for a channel as indicated by the value of `channel` below.
    If the value is another, this indicates that the packet was destined for a specific
    node (i.e. a kind of "Direct Message" to this node) and not broadcast on a channel.
    """
    channel: builtins.int
    """
    (Usually) If set, this indicates the index in the secondary_channels table that this packet was sent/received on.
    If unset, packet was on the primary channel.
    A particular node might know only a subset of channels in use on the mesh.
    Therefore channel_index is inherently a local concept and meaningless to send between nodes.
    Very briefly, while sending and receiving deep inside the device Router code, this field instead
    contains the 'channel hash' instead of the index.
    This 'trick' is only used while the payload_variant is an 'encrypted'.
    """
    encrypted: builtins.bytes
    """
    TODO: REPLACE
    """
    id: builtins.int
    """
    A unique ID for this packet.
    Always 0 for no-ack packets or non broadcast packets (and therefore take zero bytes of space).
    Otherwise a unique ID for this packet, useful for flooding algorithms.
    ID only needs to be unique on a _per sender_ basis, and it only
    needs to be unique for a few minutes (long enough to last for the length of
    any ACK or the completion of a mesh broadcast flood).
    Note: Our crypto implementation uses this id as well.
    See [crypto](/docs/overview/encryption) for details.
    """
    rx_time: builtins.int
    """
    The time this message was received by the esp32 (secs since 1970).
    Note: this field is _never_ sent on the radio link itself (to save space) Times
    are typically not sent over the mesh, but they will be added to any Packet
    (chain of SubPacket) sent to the phone (so the phone can know exact time of reception)
    """
    rx_snr: builtins.float
    """
    *Never* sent over the radio links.
    Set during reception to indicate the SNR of this packet.
    Used to collect statistics on current link quality.
    """
    hop_limit: builtins.int
    """
    If unset treated as zero (no forwarding, send to direct neighbor nodes only)
    if 1, allow hopping through one node, etc...
    For our usecase real world topologies probably have a max of about 3.
    This field is normally placed into a few of bits in the header.
    """
    want_ack: builtins.bool
    """
    This packet is being sent as a reliable message, we would prefer it to arrive at the destination.
    We would like to receive a ack packet in response.
    Broadcasts messages treat this flag specially: Since acks for broadcasts would
    rapidly flood the channel, the normal ack behavior is suppressed.
    Instead, the original sender listens to see if at least one node is rebroadcasting this packet (because naive flooding algorithm).
    If it hears that the odds (given typical LoRa topologies) the odds are very high that every node should eventually receive the message.
    So FloodingRouter.cpp generates an implicit ack which is delivered to the original sender.
    If after some time we don't hear anyone rebroadcast our packet, we will timeout and retransmit, using the regular resend logic.
    Note: This flag is normally sent in a flag bit in the header when sent over the wire
    """
    priority: global___MeshPacket.Priority.ValueType
    """
    The priority of this message for sending.
    See MeshPacket.Priority description for more details.
    """
    rx_rssi: builtins.int
    """
    rssi of received packet. Only sent to phone for dispay purposes.
    """
    delayed: global___MeshPacket.Delayed.ValueType
    """
    Describe if this message is delayed
    """
    via_mqtt: builtins.bool
    """
    Describes whether this packet passed via MQTT somewhere along the path it currently took.
    """
    hop_start: builtins.int
    """
    Hop limit with which the original packet started. Sent via LoRa using three bits in the unencrypted header.
    When receiving a packet, the difference between hop_start and hop_limit gives how many hops it traveled.
    """
    public_key: builtins.bytes
    """
    Records the public key the packet was encrypted with, if applicable.
    """
    pki_encrypted: builtins.bool
    """
    Indicates whether the packet was en/decrypted using PKI
    """
    next_hop: builtins.int
    """
    Last byte of the node number of the node that should be used as the next hop in routing.
    Set by the firmware internally, clients are not supposed to set this.
    """
    relay_node: builtins.int
    """
    Last byte of the node number of the node that will relay/relayed this packet.
    Set by the firmware internally, clients are not supposed to set this.
    """
    tx_after: builtins.int
    """
    *Never* sent over the radio links.
    Timestamp after which this packet may be sent.
    Set by the firmware internally, clients are not supposed to set this.
    """
    transport_mechanism: global___MeshPacket.TransportMechanism.ValueType
    """
    Indicates which transport mechanism this packet arrived over
    """
    @property
    def decoded(self) -> global___Data:
        """
        TODO: REPLACE
        """

    def __init__(
        self,
        *,
        to: builtins.int = ...,
        channel: builtins.int = ...,
        decoded: global___Data | None = ...,
        encrypted: builtins.bytes = ...,
        id: builtins.int = ...,
        rx_time: builtins.int = ...,
        rx_snr: builtins.float = ...,
        hop_limit: builtins.int = ...,
        want_ack: builtins.bool = ...,
        priority: global___MeshPacket.Priority.ValueType = ...,
        rx_rssi: builtins.int = ...,
        delayed: global___MeshPacket.Delayed.ValueType = ...,
        via_mqtt: builtins.bool = ...,
        hop_start: builtins.int = ...,
        public_key: builtins.bytes = ...,
        pki_encrypted: builtins.bool = ...,
        next_hop: builtins.int = ...,
        relay_node: builtins.int = ...,
        tx_after: builtins.int = ...,
        transport_mechanism: global___MeshPacket.TransportMechanism.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["decoded", b"decoded", "encrypted", b"encrypted", "payload_variant", b"payload_variant"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel", b"channel", "decoded", b"decoded", "delayed", b"delayed", "encrypted", b"encrypted", "from", b"from", "hop_limit", b"hop_limit", "hop_start", b"hop_start", "id", b"id", "next_hop", b"next_hop", "payload_variant", b"payload_variant", "pki_encrypted", b"pki_encrypted", "priority", b"priority", "public_key", b"public_key", "relay_node", b"relay_node", "rx_rssi", b"rx_rssi", "rx_snr", b"rx_snr", "rx_time", b"rx_time", "to", b"to", "transport_mechanism", b"transport_mechanism", "tx_after", b"tx_after", "via_mqtt", b"via_mqtt", "want_ack", b"want_ack"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload_variant", b"payload_variant"]) -> typing.Literal["decoded", "encrypted"] | None: ...

global___MeshPacket = MeshPacket

@typing.final
class NodeInfo(google.protobuf.message.Message):
    """
    The bluetooth to device link:
    Old BTLE protocol docs from TODO, merge in above and make real docs...
    use protocol buffers, and NanoPB
    messages from device to phone:
    POSITION_UPDATE (..., time)
    TEXT_RECEIVED(from, text, time)
    OPAQUE_RECEIVED(from, payload, time) (for signal messages or other applications)
    messages from phone to device:
    SET_MYID(id, human readable long, human readable short) (send down the unique ID
    string used for this node, a human readable string shown for that id, and a very
    short human readable string suitable for oled screen) SEND_OPAQUE(dest, payload)
    (for signal messages or other applications) SEND_TEXT(dest, text) Get all
    nodes() (returns list of nodes, with full info, last time seen, loc, battery
    level etc) SET_CONFIG (switches device to a new set of radio params and
    preshared key, drops all existing nodes, force our node to rejoin this new group)
    Full information about a node on the mesh
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NUM_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    POSITION_FIELD_NUMBER: builtins.int
    SNR_FIELD_NUMBER: builtins.int
    LAST_HEARD_FIELD_NUMBER: builtins.int
    DEVICE_METRICS_FIELD_NUMBER: builtins.int
    CHANNEL_FIELD_NUMBER: builtins.int
    VIA_MQTT_FIELD_NUMBER: builtins.int
    HOPS_AWAY_FIELD_NUMBER: builtins.int
    IS_FAVORITE_FIELD_NUMBER: builtins.int
    IS_IGNORED_FIELD_NUMBER: builtins.int
    IS_KEY_MANUALLY_VERIFIED_FIELD_NUMBER: builtins.int
    num: builtins.int
    """
    The node number
    """
    snr: builtins.float
    """
    Returns the Signal-to-noise ratio (SNR) of the last received message,
    as measured by the receiver. Return SNR of the last received message in dB
    """
    last_heard: builtins.int
    """
    TODO: REMOVE/INTEGRATE
    Not currently used (till full DSR deployment?) Our current preferred node node for routing - might be the same as num if
    we are direct neighbor or zero if we don't yet know a route to this node.
    fixed32 next_hop = 5;


    Set to indicate the last time we received a packet from this node
    """
    channel: builtins.int
    """
    local channel index we heard that node on. Only populated if its not the default channel.
    """
    via_mqtt: builtins.bool
    """
    True if we witnessed the node over MQTT instead of LoRA transport
    """
    hops_away: builtins.int
    """
    Number of hops away from us this node is (0 if direct neighbor)
    """
    is_favorite: builtins.bool
    """
    True if node is in our favorites list
    Persists between NodeDB internal clean ups
    """
    is_ignored: builtins.bool
    """
    True if node is in our ignored list
    Persists between NodeDB internal clean ups
    """
    is_key_manually_verified: builtins.bool
    """
    True if node public key has been verified.
    Persists between NodeDB internal clean ups
    LSB 0 of the bitfield
    """
    @property
    def user(self) -> global___User:
        """
        The user info for this node
        """

    @property
    def position(self) -> global___Position:
        """
        This position data. Note: before 1.2.14 we would also store the last time we've heard from this node in position.time, that is no longer true.
        Position.time now indicates the last time we received a POSITION from that node.
        """

    @property
    def device_metrics(self) -> meshtastic.protobuf.telemetry_pb2.DeviceMetrics:
        """
        The latest device metrics for the node.
        """

    def __init__(
        self,
        *,
        num: builtins.int = ...,
        user: global___User | None = ...,
        position: global___Position | None = ...,
        snr: builtins.float = ...,
        last_heard: builtins.int = ...,
        device_metrics: meshtastic.protobuf.telemetry_pb2.DeviceMetrics | None = ...,
        channel: builtins.int = ...,
        via_mqtt: builtins.bool = ...,
        hops_away: builtins.int | None = ...,
        is_favorite: builtins.bool = ...,
        is_ignored: builtins.bool = ...,
        is_key_manually_verified: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_hops_away", b"_hops_away", "device_metrics", b"device_metrics", "hops_away", b"hops_away", "position", b"position", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_hops_away", b"_hops_away", "channel", b"channel", "device_metrics", b"device_metrics", "hops_away", b"hops_away", "is_favorite", b"is_favorite", "is_ignored", b"is_ignored", "is_key_manually_verified", b"is_key_manually_verified", "last_heard", b"last_heard", "num", b"num", "position", b"position", "snr", b"snr", "user", b"user", "via_mqtt", b"via_mqtt"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_hops_away", b"_hops_away"]) -> typing.Literal["hops_away"] | None: ...

global___NodeInfo = NodeInfo

@typing.final
class MyNodeInfo(google.protobuf.message.Message):
    """
    Unique local debugging info for this node
    Note: we don't include position or the user info, because that will come in the
    Sent to the phone in response to WantNodes.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MY_NODE_NUM_FIELD_NUMBER: builtins.int
    REBOOT_COUNT_FIELD_NUMBER: builtins.int
    MIN_APP_VERSION_FIELD_NUMBER: builtins.int
    DEVICE_ID_FIELD_NUMBER: builtins.int
    PIO_ENV_FIELD_NUMBER: builtins.int
    FIRMWARE_EDITION_FIELD_NUMBER: builtins.int
    NODEDB_COUNT_FIELD_NUMBER: builtins.int
    my_node_num: builtins.int
    """
    Tells the phone what our node number is, default starting value is
    lowbyte of macaddr, but it will be fixed if that is already in use
    """
    reboot_count: builtins.int
    """
    The total number of reboots this node has ever encountered
    (well - since the last time we discarded preferences)
    """
    min_app_version: builtins.int
    """
    The minimum app version that can talk to this device.
    Phone/PC apps should compare this to their build number and if too low tell the user they must update their app
    """
    device_id: builtins.bytes
    """
    Unique hardware identifier for this device
    """
    pio_env: builtins.str
    """
    The PlatformIO environment used to build this firmware
    """
    firmware_edition: global___FirmwareEdition.ValueType
    """
    The indicator for whether this device is running event firmware and which
    """
    nodedb_count: builtins.int
    """
    The number of nodes in the nodedb.
    This is used by the phone to know how many NodeInfo packets to expect on want_config
    """
    def __init__(
        self,
        *,
        my_node_num: builtins.int = ...,
        reboot_count: builtins.int = ...,
        min_app_version: builtins.int = ...,
        device_id: builtins.bytes = ...,
        pio_env: builtins.str = ...,
        firmware_edition: global___FirmwareEdition.ValueType = ...,
        nodedb_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["device_id", b"device_id", "firmware_edition", b"firmware_edition", "min_app_version", b"min_app_version", "my_node_num", b"my_node_num", "nodedb_count", b"nodedb_count", "pio_env", b"pio_env", "reboot_count", b"reboot_count"]) -> None: ...

global___MyNodeInfo = MyNodeInfo

@typing.final
class LogRecord(google.protobuf.message.Message):
    """
    Debug output from the device.
    To minimize the size of records inside the device code, if a time/source/level is not set
    on the message it is assumed to be a continuation of the previously sent message.
    This allows the device code to use fixed maxlen 64 byte strings for messages,
    and then extend as needed by emitting multiple records.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Level:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _LevelEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[LogRecord._Level.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSET: LogRecord._Level.ValueType  # 0
        """
        Log levels, chosen to match python logging conventions.
        """
        CRITICAL: LogRecord._Level.ValueType  # 50
        """
        Log levels, chosen to match python logging conventions.
        """
        ERROR: LogRecord._Level.ValueType  # 40
        """
        Log levels, chosen to match python logging conventions.
        """
        WARNING: LogRecord._Level.ValueType  # 30
        """
        Log levels, chosen to match python logging conventions.
        """
        INFO: LogRecord._Level.ValueType  # 20
        """
        Log levels, chosen to match python logging conventions.
        """
        DEBUG: LogRecord._Level.ValueType  # 10
        """
        Log levels, chosen to match python logging conventions.
        """
        TRACE: LogRecord._Level.ValueType  # 5
        """
        Log levels, chosen to match python logging conventions.
        """

    class Level(_Level, metaclass=_LevelEnumTypeWrapper):
        """
        Log levels, chosen to match python logging conventions.
        """

    UNSET: LogRecord.Level.ValueType  # 0
    """
    Log levels, chosen to match python logging conventions.
    """
    CRITICAL: LogRecord.Level.ValueType  # 50
    """
    Log levels, chosen to match python logging conventions.
    """
    ERROR: LogRecord.Level.ValueType  # 40
    """
    Log levels, chosen to match python logging conventions.
    """
    WARNING: LogRecord.Level.ValueType  # 30
    """
    Log levels, chosen to match python logging conventions.
    """
    INFO: LogRecord.Level.ValueType  # 20
    """
    Log levels, chosen to match python logging conventions.
    """
    DEBUG: LogRecord.Level.ValueType  # 10
    """
    Log levels, chosen to match python logging conventions.
    """
    TRACE: LogRecord.Level.ValueType  # 5
    """
    Log levels, chosen to match python logging conventions.
    """

    MESSAGE_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    LEVEL_FIELD_NUMBER: builtins.int
    message: builtins.str
    """
    Log levels, chosen to match python logging conventions.
    """
    time: builtins.int
    """
    Seconds since 1970 - or 0 for unknown/unset
    """
    source: builtins.str
    """
    Usually based on thread name - if known
    """
    level: global___LogRecord.Level.ValueType
    """
    Not yet set
    """
    def __init__(
        self,
        *,
        message: builtins.str = ...,
        time: builtins.int = ...,
        source: builtins.str = ...,
        level: global___LogRecord.Level.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["level", b"level", "message", b"message", "source", b"source", "time", b"time"]) -> None: ...

global___LogRecord = LogRecord

@typing.final
class QueueStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RES_FIELD_NUMBER: builtins.int
    FREE_FIELD_NUMBER: builtins.int
    MAXLEN_FIELD_NUMBER: builtins.int
    MESH_PACKET_ID_FIELD_NUMBER: builtins.int
    res: builtins.int
    """Last attempt to queue status, ErrorCode"""
    free: builtins.int
    """Free entries in the outgoing queue"""
    maxlen: builtins.int
    """Maximum entries in the outgoing queue"""
    mesh_packet_id: builtins.int
    """What was mesh packet id that generated this response?"""
    def __init__(
        self,
        *,
        res: builtins.int = ...,
        free: builtins.int = ...,
        maxlen: builtins.int = ...,
        mesh_packet_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["free", b"free", "maxlen", b"maxlen", "mesh_packet_id", b"mesh_packet_id", "res", b"res"]) -> None: ...

global___QueueStatus = QueueStatus

@typing.final
class FromRadio(google.protobuf.message.Message):
    """
    Packets from the radio to the phone will appear on the fromRadio characteristic.
    It will support READ and NOTIFY. When a new packet arrives the device will BLE notify?
    It will sit in that descriptor until consumed by the phone,
    at which point the next item in the FIFO will be populated.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    PACKET_FIELD_NUMBER: builtins.int
    MY_INFO_FIELD_NUMBER: builtins.int
    NODE_INFO_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    LOG_RECORD_FIELD_NUMBER: builtins.int
    CONFIG_COMPLETE_ID_FIELD_NUMBER: builtins.int
    REBOOTED_FIELD_NUMBER: builtins.int
    MODULECONFIG_FIELD_NUMBER: builtins.int
    CHANNEL_FIELD_NUMBER: builtins.int
    QUEUESTATUS_FIELD_NUMBER: builtins.int
    XMODEMPACKET_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    MQTTCLIENTPROXYMESSAGE_FIELD_NUMBER: builtins.int
    FILEINFO_FIELD_NUMBER: builtins.int
    CLIENTNOTIFICATION_FIELD_NUMBER: builtins.int
    DEVICEUICONFIG_FIELD_NUMBER: builtins.int
    id: builtins.int
    """
    The packet id, used to allow the phone to request missing read packets from the FIFO,
    see our bluetooth docs
    """
    config_complete_id: builtins.int
    """
    Sent as true once the device has finished sending all of the responses to want_config
    recipient should check if this ID matches our original request nonce, if
    not, it means your config responses haven't started yet.
    NOTE: This ID must not change - to keep (minimal) compatibility with <1.2 version of android apps.
    """
    rebooted: builtins.bool
    """
    Sent to tell clients the radio has just rebooted.
    Set to true if present.
    Not used on all transports, currently just used for the serial console.
    NOTE: This ID must not change - to keep (minimal) compatibility with <1.2 version of android apps.
    """
    @property
    def packet(self) -> global___MeshPacket:
        """
        Log levels, chosen to match python logging conventions.
        """

    @property
    def my_info(self) -> global___MyNodeInfo:
        """
        Tells the phone what our node number is, can be -1 if we've not yet joined a mesh.
        NOTE: This ID must not change - to keep (minimal) compatibility with <1.2 version of android apps.
        """

    @property
    def node_info(self) -> global___NodeInfo:
        """
        One packet is sent for each node in the on radio DB
        starts over with the first node in our DB
        """

    @property
    def config(self) -> meshtastic.protobuf.config_pb2.Config:
        """
        Include a part of the config (was: RadioConfig radio)
        """

    @property
    def log_record(self) -> global___LogRecord:
        """
        Set to send debug console output over our protobuf stream
        """

    @property
    def moduleConfig(self) -> meshtastic.protobuf.module_config_pb2.ModuleConfig:
        """
        Include module config
        """

    @property
    def channel(self) -> meshtastic.protobuf.channel_pb2.Channel:
        """
        One packet is sent for each channel
        """

    @property
    def queueStatus(self) -> global___QueueStatus:
        """
        Queue status info
        """

    @property
    def xmodemPacket(self) -> meshtastic.protobuf.xmodem_pb2.XModem:
        """
        File Transfer Chunk
        """

    @property
    def metadata(self) -> global___DeviceMetadata:
        """
        Device metadata message
        """

    @property
    def mqttClientProxyMessage(self) -> global___MqttClientProxyMessage:
        """
        MQTT Client Proxy Message (device sending to client / phone for publishing to MQTT)
        """

    @property
    def fileInfo(self) -> global___FileInfo:
        """
        File system manifest messages
        """

    @property
    def clientNotification(self) -> global___ClientNotification:
        """
        Notification message to the client
        """

    @property
    def deviceuiConfig(self) -> meshtastic.protobuf.device_ui_pb2.DeviceUIConfig:
        """
        Persistent data for device-ui
        """

    def __init__(
        self,
        *,
        id: builtins.int = ...,
        packet: global___MeshPacket | None = ...,
        my_info: global___MyNodeInfo | None = ...,
        node_info: global___NodeInfo | None = ...,
        config: meshtastic.protobuf.config_pb2.Config | None = ...,
        log_record: global___LogRecord | None = ...,
        config_complete_id: builtins.int = ...,
        rebooted: builtins.bool = ...,
        moduleConfig: meshtastic.protobuf.module_config_pb2.ModuleConfig | None = ...,
        channel: meshtastic.protobuf.channel_pb2.Channel | None = ...,
        queueStatus: global___QueueStatus | None = ...,
        xmodemPacket: meshtastic.protobuf.xmodem_pb2.XModem | None = ...,
        metadata: global___DeviceMetadata | None = ...,
        mqttClientProxyMessage: global___MqttClientProxyMessage | None = ...,
        fileInfo: global___FileInfo | None = ...,
        clientNotification: global___ClientNotification | None = ...,
        deviceuiConfig: meshtastic.protobuf.device_ui_pb2.DeviceUIConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["channel", b"channel", "clientNotification", b"clientNotification", "config", b"config", "config_complete_id", b"config_complete_id", "deviceuiConfig", b"deviceuiConfig", "fileInfo", b"fileInfo", "log_record", b"log_record", "metadata", b"metadata", "moduleConfig", b"moduleConfig", "mqttClientProxyMessage", b"mqttClientProxyMessage", "my_info", b"my_info", "node_info", b"node_info", "packet", b"packet", "payload_variant", b"payload_variant", "queueStatus", b"queueStatus", "rebooted", b"rebooted", "xmodemPacket", b"xmodemPacket"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel", b"channel", "clientNotification", b"clientNotification", "config", b"config", "config_complete_id", b"config_complete_id", "deviceuiConfig", b"deviceuiConfig", "fileInfo", b"fileInfo", "id", b"id", "log_record", b"log_record", "metadata", b"metadata", "moduleConfig", b"moduleConfig", "mqttClientProxyMessage", b"mqttClientProxyMessage", "my_info", b"my_info", "node_info", b"node_info", "packet", b"packet", "payload_variant", b"payload_variant", "queueStatus", b"queueStatus", "rebooted", b"rebooted", "xmodemPacket", b"xmodemPacket"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload_variant", b"payload_variant"]) -> typing.Literal["packet", "my_info", "node_info", "config", "log_record", "config_complete_id", "rebooted", "moduleConfig", "channel", "queueStatus", "xmodemPacket", "metadata", "mqttClientProxyMessage", "fileInfo", "clientNotification", "deviceuiConfig"] | None: ...

global___FromRadio = FromRadio

@typing.final
class ClientNotification(google.protobuf.message.Message):
    """
    A notification message from the device to the client
    To be used for important messages that should to be displayed to the user
    in the form of push notifications or validation messages when saving
    invalid configuration.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPLY_ID_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    LEVEL_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    KEY_VERIFICATION_NUMBER_INFORM_FIELD_NUMBER: builtins.int
    KEY_VERIFICATION_NUMBER_REQUEST_FIELD_NUMBER: builtins.int
    KEY_VERIFICATION_FINAL_FIELD_NUMBER: builtins.int
    DUPLICATED_PUBLIC_KEY_FIELD_NUMBER: builtins.int
    LOW_ENTROPY_KEY_FIELD_NUMBER: builtins.int
    reply_id: builtins.int
    """
    The id of the packet we're notifying in response to
    """
    time: builtins.int
    """
    Seconds since 1970 - or 0 for unknown/unset
    """
    level: global___LogRecord.Level.ValueType
    """
    The level type of notification
    """
    message: builtins.str
    """
    The message body of the notification
    """
    @property
    def key_verification_number_inform(self) -> global___KeyVerificationNumberInform: ...
    @property
    def key_verification_number_request(self) -> global___KeyVerificationNumberRequest: ...
    @property
    def key_verification_final(self) -> global___KeyVerificationFinal: ...
    @property
    def duplicated_public_key(self) -> global___DuplicatedPublicKey: ...
    @property
    def low_entropy_key(self) -> global___LowEntropyKey: ...
    def __init__(
        self,
        *,
        reply_id: builtins.int | None = ...,
        time: builtins.int = ...,
        level: global___LogRecord.Level.ValueType = ...,
        message: builtins.str = ...,
        key_verification_number_inform: global___KeyVerificationNumberInform | None = ...,
        key_verification_number_request: global___KeyVerificationNumberRequest | None = ...,
        key_verification_final: global___KeyVerificationFinal | None = ...,
        duplicated_public_key: global___DuplicatedPublicKey | None = ...,
        low_entropy_key: global___LowEntropyKey | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_reply_id", b"_reply_id", "duplicated_public_key", b"duplicated_public_key", "key_verification_final", b"key_verification_final", "key_verification_number_inform", b"key_verification_number_inform", "key_verification_number_request", b"key_verification_number_request", "low_entropy_key", b"low_entropy_key", "payload_variant", b"payload_variant", "reply_id", b"reply_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_reply_id", b"_reply_id", "duplicated_public_key", b"duplicated_public_key", "key_verification_final", b"key_verification_final", "key_verification_number_inform", b"key_verification_number_inform", "key_verification_number_request", b"key_verification_number_request", "level", b"level", "low_entropy_key", b"low_entropy_key", "message", b"message", "payload_variant", b"payload_variant", "reply_id", b"reply_id", "time", b"time"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_reply_id", b"_reply_id"]) -> typing.Literal["reply_id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["payload_variant", b"payload_variant"]) -> typing.Literal["key_verification_number_inform", "key_verification_number_request", "key_verification_final", "duplicated_public_key", "low_entropy_key"] | None: ...

global___ClientNotification = ClientNotification

@typing.final
class KeyVerificationNumberInform(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NONCE_FIELD_NUMBER: builtins.int
    REMOTE_LONGNAME_FIELD_NUMBER: builtins.int
    SECURITY_NUMBER_FIELD_NUMBER: builtins.int
    nonce: builtins.int
    remote_longname: builtins.str
    security_number: builtins.int
    def __init__(
        self,
        *,
        nonce: builtins.int = ...,
        remote_longname: builtins.str = ...,
        security_number: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["nonce", b"nonce", "remote_longname", b"remote_longname", "security_number", b"security_number"]) -> None: ...

global___KeyVerificationNumberInform = KeyVerificationNumberInform

@typing.final
class KeyVerificationNumberRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NONCE_FIELD_NUMBER: builtins.int
    REMOTE_LONGNAME_FIELD_NUMBER: builtins.int
    nonce: builtins.int
    remote_longname: builtins.str
    def __init__(
        self,
        *,
        nonce: builtins.int = ...,
        remote_longname: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["nonce", b"nonce", "remote_longname", b"remote_longname"]) -> None: ...

global___KeyVerificationNumberRequest = KeyVerificationNumberRequest

@typing.final
class KeyVerificationFinal(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NONCE_FIELD_NUMBER: builtins.int
    REMOTE_LONGNAME_FIELD_NUMBER: builtins.int
    ISSENDER_FIELD_NUMBER: builtins.int
    VERIFICATION_CHARACTERS_FIELD_NUMBER: builtins.int
    nonce: builtins.int
    remote_longname: builtins.str
    isSender: builtins.bool
    verification_characters: builtins.str
    def __init__(
        self,
        *,
        nonce: builtins.int = ...,
        remote_longname: builtins.str = ...,
        isSender: builtins.bool = ...,
        verification_characters: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["isSender", b"isSender", "nonce", b"nonce", "remote_longname", b"remote_longname", "verification_characters", b"verification_characters"]) -> None: ...

global___KeyVerificationFinal = KeyVerificationFinal

@typing.final
class DuplicatedPublicKey(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DuplicatedPublicKey = DuplicatedPublicKey

@typing.final
class LowEntropyKey(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___LowEntropyKey = LowEntropyKey

@typing.final
class FileInfo(google.protobuf.message.Message):
    """
    Individual File info for the device
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_NAME_FIELD_NUMBER: builtins.int
    SIZE_BYTES_FIELD_NUMBER: builtins.int
    file_name: builtins.str
    """
    The fully qualified path of the file
    """
    size_bytes: builtins.int
    """
    The size of the file in bytes
    """
    def __init__(
        self,
        *,
        file_name: builtins.str = ...,
        size_bytes: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["file_name", b"file_name", "size_bytes", b"size_bytes"]) -> None: ...

global___FileInfo = FileInfo

@typing.final
class ToRadio(google.protobuf.message.Message):
    """
    Packets/commands to the radio will be written (reliably) to the toRadio characteristic.
    Once the write completes the phone can assume it is handled.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PACKET_FIELD_NUMBER: builtins.int
    WANT_CONFIG_ID_FIELD_NUMBER: builtins.int
    DISCONNECT_FIELD_NUMBER: builtins.int
    XMODEMPACKET_FIELD_NUMBER: builtins.int
    MQTTCLIENTPROXYMESSAGE_FIELD_NUMBER: builtins.int
    HEARTBEAT_FIELD_NUMBER: builtins.int
    want_config_id: builtins.int
    """
    Phone wants radio to send full node db to the phone, This is
    typically the first packet sent to the radio when the phone gets a
    bluetooth connection. The radio will respond by sending back a
    MyNodeInfo, a owner, a radio config and a series of
    FromRadio.node_infos, and config_complete
    the integer you write into this field will be reported back in the
    config_complete_id response this allows clients to never be confused by
    a stale old partially sent config.
    """
    disconnect: builtins.bool
    """
    Tell API server we are disconnecting now.
    This is useful for serial links where there is no hardware/protocol based notification that the client has dropped the link.
    (Sending this message is optional for clients)
    """
    @property
    def packet(self) -> global___MeshPacket:
        """
        Send this packet on the mesh
        """

    @property
    def xmodemPacket(self) -> meshtastic.protobuf.xmodem_pb2.XModem:
        """
        File Transfer Chunk
        """

    @property
    def mqttClientProxyMessage(self) -> global___MqttClientProxyMessage:
        """
        MQTT Client Proxy Message (for client / phone subscribed to MQTT sending to device)
        """

    @property
    def heartbeat(self) -> global___Heartbeat:
        """
        Heartbeat message (used to keep the device connection awake on serial)
        """

    def __init__(
        self,
        *,
        packet: global___MeshPacket | None = ...,
        want_config_id: builtins.int = ...,
        disconnect: builtins.bool = ...,
        xmodemPacket: meshtastic.protobuf.xmodem_pb2.XModem | None = ...,
        mqttClientProxyMessage: global___MqttClientProxyMessage | None = ...,
        heartbeat: global___Heartbeat | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["disconnect", b"disconnect", "heartbeat", b"heartbeat", "mqttClientProxyMessage", b"mqttClientProxyMessage", "packet", b"packet", "payload_variant", b"payload_variant", "want_config_id", b"want_config_id", "xmodemPacket", b"xmodemPacket"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["disconnect", b"disconnect", "heartbeat", b"heartbeat", "mqttClientProxyMessage", b"mqttClientProxyMessage", "packet", b"packet", "payload_variant", b"payload_variant", "want_config_id", b"want_config_id", "xmodemPacket", b"xmodemPacket"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload_variant", b"payload_variant"]) -> typing.Literal["packet", "want_config_id", "disconnect", "xmodemPacket", "mqttClientProxyMessage", "heartbeat"] | None: ...

global___ToRadio = ToRadio

@typing.final
class Compressed(google.protobuf.message.Message):
    """
    Compressed message payload
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PORTNUM_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    portnum: meshtastic.protobuf.portnums_pb2.PortNum.ValueType
    """
    PortNum to determine the how to handle the compressed payload.
    """
    data: builtins.bytes
    """
    Compressed data.
    """
    def __init__(
        self,
        *,
        portnum: meshtastic.protobuf.portnums_pb2.PortNum.ValueType = ...,
        data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "portnum", b"portnum"]) -> None: ...

global___Compressed = Compressed

@typing.final
class NeighborInfo(google.protobuf.message.Message):
    """
    Full info on edges for a single node
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODE_ID_FIELD_NUMBER: builtins.int
    LAST_SENT_BY_ID_FIELD_NUMBER: builtins.int
    NODE_BROADCAST_INTERVAL_SECS_FIELD_NUMBER: builtins.int
    NEIGHBORS_FIELD_NUMBER: builtins.int
    node_id: builtins.int
    """
    The node ID of the node sending info on its neighbors
    """
    last_sent_by_id: builtins.int
    """
    Field to pass neighbor info for the next sending cycle
    """
    node_broadcast_interval_secs: builtins.int
    """
    Broadcast interval of the represented node (in seconds)
    """
    @property
    def neighbors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Neighbor]:
        """
        The list of out edges from this node
        """

    def __init__(
        self,
        *,
        node_id: builtins.int = ...,
        last_sent_by_id: builtins.int = ...,
        node_broadcast_interval_secs: builtins.int = ...,
        neighbors: collections.abc.Iterable[global___Neighbor] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["last_sent_by_id", b"last_sent_by_id", "neighbors", b"neighbors", "node_broadcast_interval_secs", b"node_broadcast_interval_secs", "node_id", b"node_id"]) -> None: ...

global___NeighborInfo = NeighborInfo

@typing.final
class Neighbor(google.protobuf.message.Message):
    """
    A single edge in the mesh
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODE_ID_FIELD_NUMBER: builtins.int
    SNR_FIELD_NUMBER: builtins.int
    LAST_RX_TIME_FIELD_NUMBER: builtins.int
    NODE_BROADCAST_INTERVAL_SECS_FIELD_NUMBER: builtins.int
    node_id: builtins.int
    """
    Node ID of neighbor
    """
    snr: builtins.float
    """
    SNR of last heard message
    """
    last_rx_time: builtins.int
    """
    Reception time (in secs since 1970) of last message that was last sent by this ID.
    Note: this is for local storage only and will not be sent out over the mesh.
    """
    node_broadcast_interval_secs: builtins.int
    """
    Broadcast interval of this neighbor (in seconds).
    Note: this is for local storage only and will not be sent out over the mesh.
    """
    def __init__(
        self,
        *,
        node_id: builtins.int = ...,
        snr: builtins.float = ...,
        last_rx_time: builtins.int = ...,
        node_broadcast_interval_secs: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["last_rx_time", b"last_rx_time", "node_broadcast_interval_secs", b"node_broadcast_interval_secs", "node_id", b"node_id", "snr", b"snr"]) -> None: ...

global___Neighbor = Neighbor

@typing.final
class DeviceMetadata(google.protobuf.message.Message):
    """
    Device metadata response
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIRMWARE_VERSION_FIELD_NUMBER: builtins.int
    DEVICE_STATE_VERSION_FIELD_NUMBER: builtins.int
    CANSHUTDOWN_FIELD_NUMBER: builtins.int
    HASWIFI_FIELD_NUMBER: builtins.int
    HASBLUETOOTH_FIELD_NUMBER: builtins.int
    HASETHERNET_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    POSITION_FLAGS_FIELD_NUMBER: builtins.int
    HW_MODEL_FIELD_NUMBER: builtins.int
    HASREMOTEHARDWARE_FIELD_NUMBER: builtins.int
    HASPKC_FIELD_NUMBER: builtins.int
    EXCLUDED_MODULES_FIELD_NUMBER: builtins.int
    firmware_version: builtins.str
    """
    Device firmware version string
    """
    device_state_version: builtins.int
    """
    Device state version
    """
    canShutdown: builtins.bool
    """
    Indicates whether the device can shutdown CPU natively or via power management chip
    """
    hasWifi: builtins.bool
    """
    Indicates that the device has native wifi capability
    """
    hasBluetooth: builtins.bool
    """
    Indicates that the device has native bluetooth capability
    """
    hasEthernet: builtins.bool
    """
    Indicates that the device has an ethernet peripheral
    """
    role: meshtastic.protobuf.config_pb2.Config.DeviceConfig.Role.ValueType
    """
    Indicates that the device's role in the mesh
    """
    position_flags: builtins.int
    """
    Indicates the device's current enabled position flags
    """
    hw_model: global___HardwareModel.ValueType
    """
    Device hardware model
    """
    hasRemoteHardware: builtins.bool
    """
    Has Remote Hardware enabled
    """
    hasPKC: builtins.bool
    """
    Has PKC capabilities
    """
    excluded_modules: builtins.int
    """
    Bit field of boolean for excluded modules
    (bitwise OR of ExcludedModules)
    """
    def __init__(
        self,
        *,
        firmware_version: builtins.str = ...,
        device_state_version: builtins.int = ...,
        canShutdown: builtins.bool = ...,
        hasWifi: builtins.bool = ...,
        hasBluetooth: builtins.bool = ...,
        hasEthernet: builtins.bool = ...,
        role: meshtastic.protobuf.config_pb2.Config.DeviceConfig.Role.ValueType = ...,
        position_flags: builtins.int = ...,
        hw_model: global___HardwareModel.ValueType = ...,
        hasRemoteHardware: builtins.bool = ...,
        hasPKC: builtins.bool = ...,
        excluded_modules: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["canShutdown", b"canShutdown", "device_state_version", b"device_state_version", "excluded_modules", b"excluded_modules", "firmware_version", b"firmware_version", "hasBluetooth", b"hasBluetooth", "hasEthernet", b"hasEthernet", "hasPKC", b"hasPKC", "hasRemoteHardware", b"hasRemoteHardware", "hasWifi", b"hasWifi", "hw_model", b"hw_model", "position_flags", b"position_flags", "role", b"role"]) -> None: ...

global___DeviceMetadata = DeviceMetadata

@typing.final
class Heartbeat(google.protobuf.message.Message):
    """
    A heartbeat message is sent to the node from the client to keep the connection alive.
    This is currently only needed to keep serial connections alive, but can be used by any PhoneAPI.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NONCE_FIELD_NUMBER: builtins.int
    nonce: builtins.int
    """
    The nonce of the heartbeat message
    """
    def __init__(
        self,
        *,
        nonce: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["nonce", b"nonce"]) -> None: ...

global___Heartbeat = Heartbeat

@typing.final
class NodeRemoteHardwarePin(google.protobuf.message.Message):
    """
    RemoteHardwarePins associated with a node
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODE_NUM_FIELD_NUMBER: builtins.int
    PIN_FIELD_NUMBER: builtins.int
    node_num: builtins.int
    """
    The node_num exposing the available gpio pin
    """
    @property
    def pin(self) -> meshtastic.protobuf.module_config_pb2.RemoteHardwarePin:
        """
        The the available gpio pin for usage with RemoteHardware module
        """

    def __init__(
        self,
        *,
        node_num: builtins.int = ...,
        pin: meshtastic.protobuf.module_config_pb2.RemoteHardwarePin | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["pin", b"pin"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["node_num", b"node_num", "pin", b"pin"]) -> None: ...

global___NodeRemoteHardwarePin = NodeRemoteHardwarePin

@typing.final
class ChunkedPayload(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYLOAD_ID_FIELD_NUMBER: builtins.int
    CHUNK_COUNT_FIELD_NUMBER: builtins.int
    CHUNK_INDEX_FIELD_NUMBER: builtins.int
    PAYLOAD_CHUNK_FIELD_NUMBER: builtins.int
    payload_id: builtins.int
    """
    The ID of the entire payload
    """
    chunk_count: builtins.int
    """
    The total number of chunks in the payload
    """
    chunk_index: builtins.int
    """
    The current chunk index in the total
    """
    payload_chunk: builtins.bytes
    """
    The binary data of the current chunk
    """
    def __init__(
        self,
        *,
        payload_id: builtins.int = ...,
        chunk_count: builtins.int = ...,
        chunk_index: builtins.int = ...,
        payload_chunk: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["chunk_count", b"chunk_count", "chunk_index", b"chunk_index", "payload_chunk", b"payload_chunk", "payload_id", b"payload_id"]) -> None: ...

global___ChunkedPayload = ChunkedPayload

@typing.final
class resend_chunks(google.protobuf.message.Message):
    """
    Wrapper message for broken repeated oneof support
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHUNKS_FIELD_NUMBER: builtins.int
    @property
    def chunks(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        chunks: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["chunks", b"chunks"]) -> None: ...

global___resend_chunks = resend_chunks

@typing.final
class ChunkedPayloadResponse(google.protobuf.message.Message):
    """
    Responses to a ChunkedPayload request
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYLOAD_ID_FIELD_NUMBER: builtins.int
    REQUEST_TRANSFER_FIELD_NUMBER: builtins.int
    ACCEPT_TRANSFER_FIELD_NUMBER: builtins.int
    RESEND_CHUNKS_FIELD_NUMBER: builtins.int
    payload_id: builtins.int
    """
    The ID of the entire payload
    """
    request_transfer: builtins.bool
    """
    Request to transfer chunked payload
    """
    accept_transfer: builtins.bool
    """
    Accept the transfer chunked payload
    """
    @property
    def resend_chunks(self) -> global___resend_chunks:
        """
        Request missing indexes in the chunked payload
        """

    def __init__(
        self,
        *,
        payload_id: builtins.int = ...,
        request_transfer: builtins.bool = ...,
        accept_transfer: builtins.bool = ...,
        resend_chunks: global___resend_chunks | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["accept_transfer", b"accept_transfer", "payload_variant", b"payload_variant", "request_transfer", b"request_transfer", "resend_chunks", b"resend_chunks"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["accept_transfer", b"accept_transfer", "payload_id", b"payload_id", "payload_variant", b"payload_variant", "request_transfer", b"request_transfer", "resend_chunks", b"resend_chunks"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload_variant", b"payload_variant"]) -> typing.Literal["request_transfer", "accept_transfer", "resend_chunks"] | None: ...

global___ChunkedPayloadResponse = ChunkedPayloadResponse
