const tests = [
  [-0x80000000n, 0n, -0x80000000n],
  [-0x7fffffffn, 0n, -0x7fffffffn],
  [-0x7ffffffen, 0n, -0x7ffffffen],
  [-9n, 0n, -9n],
  [-8n, 0n, -8n],
  [-7n, 0n, -7n],
  [-6n, 0n, -6n],
  [-5n, 0n, -5n],
  [-4n, 0n, -4n],
  [-3n, 0n, -3n],
  [-2n, 0n, -2n],
  [-1n, 0n, -1n],
  [0n, 0n, 0n],
  [1n, 0n, 1n],
  [2n, 0n, 2n],
  [3n, 0n, 3n],
  [4n, 0n, 4n],
  [5n, 0n, 5n],
  [6n, 0n, 6n],
  [7n, 0n, 7n],
  [8n, 0n, 8n],
  [9n, 0n, 9n],
  [0x7ffffffen, 0n, 0x7ffffffen],
  [0x7fffffffn, 0n, 0x7fffffffn],
  [-0x80000000n, 1n, -0x40000000n],
  [-0x7fffffffn, 1n, -0x40000000n],
  [-0x7ffffffen, 1n, -0x3fffffffn],
  [-9n, 1n, -5n],
  [-8n, 1n, -4n],
  [-7n, 1n, -4n],
  [-6n, 1n, -3n],
  [-5n, 1n, -3n],
  [-4n, 1n, -2n],
  [-3n, 1n, -2n],
  [-2n, 1n, -1n],
  [-1n, 1n, -1n],
  [0n, 1n, 0n],
  [1n, 1n, 0n],
  [2n, 1n, 1n],
  [3n, 1n, 1n],
  [4n, 1n, 2n],
  [5n, 1n, 2n],
  [6n, 1n, 3n],
  [7n, 1n, 3n],
  [8n, 1n, 4n],
  [9n, 1n, 4n],
  [0x7ffffffen, 1n, 0x3fffffffn],
  [0x7fffffffn, 1n, 0x3fffffffn],
  [-0x80000000n, 2n, -0x20000000n],
  [-0x7fffffffn, 2n, -0x20000000n],
  [-0x7ffffffen, 2n, -0x20000000n],
  [-9n, 2n, -3n],
  [-8n, 2n, -2n],
  [-7n, 2n, -2n],
  [-6n, 2n, -2n],
  [-5n, 2n, -2n],
  [-4n, 2n, -1n],
  [-3n, 2n, -1n],
  [-2n, 2n, -1n],
  [-1n, 2n, -1n],
  [0n, 2n, 0n],
  [1n, 2n, 0n],
  [2n, 2n, 0n],
  [3n, 2n, 0n],
  [4n, 2n, 1n],
  [5n, 2n, 1n],
  [6n, 2n, 1n],
  [7n, 2n, 1n],
  [8n, 2n, 2n],
  [9n, 2n, 2n],
  [0x7ffffffen, 2n, 0x1fffffffn],
  [0x7fffffffn, 2n, 0x1fffffffn],
  [-0x80000000n, 3n, -0x10000000n],
  [-0x7fffffffn, 3n, -0x10000000n],
  [-0x7ffffffen, 3n, -0x10000000n],
  [-9n, 3n, -2n],
  [-8n, 3n, -1n],
  [-7n, 3n, -1n],
  [-6n, 3n, -1n],
  [-5n, 3n, -1n],
  [-4n, 3n, -1n],
  [-3n, 3n, -1n],
  [-2n, 3n, -1n],
  [-1n, 3n, -1n],
  [0n, 3n, 0n],
  [1n, 3n, 0n],
  [2n, 3n, 0n],
  [3n, 3n, 0n],
  [4n, 3n, 0n],
  [5n, 3n, 0n],
  [6n, 3n, 0n],
  [7n, 3n, 0n],
  [8n, 3n, 1n],
  [9n, 3n, 1n],
  [0x7ffffffen, 3n, 0xfffffffn],
  [0x7fffffffn, 3n, 0xfffffffn],
  [-0x80000000n, 4n, -0x8000000n],
  [-0x7fffffffn, 4n, -0x8000000n],
  [-0x7ffffffen, 4n, -0x8000000n],
  [-9n, 4n, -1n],
  [-8n, 4n, -1n],
  [-7n, 4n, -1n],
  [-6n, 4n, -1n],
  [-5n, 4n, -1n],
  [-4n, 4n, -1n],
  [-3n, 4n, -1n],
  [-2n, 4n, -1n],
  [-1n, 4n, -1n],
  [0n, 4n, 0n],
  [1n, 4n, 0n],
  [2n, 4n, 0n],
  [3n, 4n, 0n],
  [4n, 4n, 0n],
  [5n, 4n, 0n],
  [6n, 4n, 0n],
  [7n, 4n, 0n],
  [8n, 4n, 0n],
  [9n, 4n, 0n],
  [0x7ffffffen, 4n, 0x7ffffffn],
  [0x7fffffffn, 4n, 0x7ffffffn],
  [-0x80000000n, 0x1fn, -1n],
  [-0x7fffffffn, 0x1fn, -1n],
  [-0x7ffffffen, 0x1fn, -1n],
  [-9n, 0x1fn, -1n],
  [-8n, 0x1fn, -1n],
  [-7n, 0x1fn, -1n],
  [-6n, 0x1fn, -1n],
  [-5n, 0x1fn, -1n],
  [-4n, 0x1fn, -1n],
  [-3n, 0x1fn, -1n],
  [-2n, 0x1fn, -1n],
  [-1n, 0x1fn, -1n],
  [0n, 0x1fn, 0n],
  [1n, 0x1fn, 0n],
  [2n, 0x1fn, 0n],
  [3n, 0x1fn, 0n],
  [4n, 0x1fn, 0n],
  [5n, 0x1fn, 0n],
  [6n, 0x1fn, 0n],
  [7n, 0x1fn, 0n],
  [8n, 0x1fn, 0n],
  [9n, 0x1fn, 0n],
  [0x7ffffffen, 0x1fn, 0n],
  [0x7fffffffn, 0x1fn, 0n],
  [-0x80000000n, 0x20n, -1n],
  [-0x7fffffffn, 0x20n, -1n],
  [-0x7ffffffen, 0x20n, -1n],
  [-9n, 0x20n, -1n],
  [-8n, 0x20n, -1n],
  [-7n, 0x20n, -1n],
  [-6n, 0x20n, -1n],
  [-5n, 0x20n, -1n],
  [-4n, 0x20n, -1n],
  [-3n, 0x20n, -1n],
  [-2n, 0x20n, -1n],
  [-1n, 0x20n, -1n],
  [0n, 0x20n, 0n],
  [1n, 0x20n, 0n],
  [2n, 0x20n, 0n],
  [3n, 0x20n, 0n],
  [4n, 0x20n, 0n],
  [5n, 0x20n, 0n],
  [6n, 0x20n, 0n],
  [7n, 0x20n, 0n],
  [8n, 0x20n, 0n],
  [9n, 0x20n, 0n],
  [0x7ffffffen, 0x20n, 0n],
  [0x7fffffffn, 0x20n, 0n],
  [-0x80000000n, 0x3fn, -1n],
  [-0x7fffffffn, 0x3fn, -1n],
  [-0x7ffffffen, 0x3fn, -1n],
  [-9n, 0x3fn, -1n],
  [-8n, 0x3fn, -1n],
  [-7n, 0x3fn, -1n],
  [-6n, 0x3fn, -1n],
  [-5n, 0x3fn, -1n],
  [-4n, 0x3fn, -1n],
  [-3n, 0x3fn, -1n],
  [-2n, 0x3fn, -1n],
  [-1n, 0x3fn, -1n],
  [0n, 0x3fn, 0n],
  [1n, 0x3fn, 0n],
  [2n, 0x3fn, 0n],
  [3n, 0x3fn, 0n],
  [4n, 0x3fn, 0n],
  [5n, 0x3fn, 0n],
  [6n, 0x3fn, 0n],
  [7n, 0x3fn, 0n],
  [8n, 0x3fn, 0n],
  [9n, 0x3fn, 0n],
  [0x7ffffffen, 0x3fn, 0n],
  [0x7fffffffn, 0x3fn, 0n],
  [-0x80000000n, 0x40n, -1n],
  [-0x7fffffffn, 0x40n, -1n],
  [-0x7ffffffen, 0x40n, -1n],
  [-9n, 0x40n, -1n],
  [-8n, 0x40n, -1n],
  [-7n, 0x40n, -1n],
  [-6n, 0x40n, -1n],
  [-5n, 0x40n, -1n],
  [-4n, 0x40n, -1n],
  [-3n, 0x40n, -1n],
  [-2n, 0x40n, -1n],
  [-1n, 0x40n, -1n],
  [0n, 0x40n, 0n],
  [1n, 0x40n, 0n],
  [2n, 0x40n, 0n],
  [3n, 0x40n, 0n],
  [4n, 0x40n, 0n],
  [5n, 0x40n, 0n],
  [6n, 0x40n, 0n],
  [7n, 0x40n, 0n],
  [8n, 0x40n, 0n],
  [9n, 0x40n, 0n],
  [0x7ffffffen, 0x40n, 0n],
  [0x7fffffffn, 0x40n, 0n],
  [-9n, -1n, -0x12n],
  [-8n, -1n, -0x10n],
  [-7n, -1n, -0xen],
  [-6n, -1n, -0xcn],
  [-5n, -1n, -0xan],
  [-4n, -1n, -8n],
  [-3n, -1n, -6n],
  [-2n, -1n, -4n],
  [-1n, -1n, -2n],
  [0n, -1n, 0n],
  [1n, -1n, 2n],
  [2n, -1n, 4n],
  [3n, -1n, 6n],
  [4n, -1n, 8n],
  [5n, -1n, 0xan],
  [6n, -1n, 0xcn],
  [7n, -1n, 0xen],
  [8n, -1n, 0x10n],
  [9n, -1n, 0x12n],
  [-9n, -2n, -0x24n],
  [-8n, -2n, -0x20n],
  [-7n, -2n, -0x1cn],
  [-6n, -2n, -0x18n],
  [-5n, -2n, -0x14n],
  [-4n, -2n, -0x10n],
  [-3n, -2n, -0xcn],
  [-2n, -2n, -8n],
  [-1n, -2n, -4n],
  [0n, -2n, 0n],
  [1n, -2n, 4n],
  [2n, -2n, 8n],
  [3n, -2n, 0xcn],
  [4n, -2n, 0x10n],
  [5n, -2n, 0x14n],
  [6n, -2n, 0x18n],
  [7n, -2n, 0x1cn],
  [8n, -2n, 0x20n],
  [9n, -2n, 0x24n],
  [-9n, -3n, -0x48n],
  [-8n, -3n, -0x40n],
  [-7n, -3n, -0x38n],
  [-6n, -3n, -0x30n],
  [-5n, -3n, -0x28n],
  [-4n, -3n, -0x20n],
  [-3n, -3n, -0x18n],
  [-2n, -3n, -0x10n],
  [-1n, -3n, -8n],
  [0n, -3n, 0n],
  [1n, -3n, 8n],
  [2n, -3n, 0x10n],
  [3n, -3n, 0x18n],
  [4n, -3n, 0x20n],
  [5n, -3n, 0x28n],
  [6n, -3n, 0x30n],
  [7n, -3n, 0x38n],
  [8n, -3n, 0x40n],
  [9n, -3n, 0x48n],
  [-9n, -4n, -0x90n],
  [-8n, -4n, -0x80n],
  [-7n, -4n, -0x70n],
  [-6n, -4n, -0x60n],
  [-5n, -4n, -0x50n],
  [-4n, -4n, -0x40n],
  [-3n, -4n, -0x30n],
  [-2n, -4n, -0x20n],
  [-1n, -4n, -0x10n],
  [0n, -4n, 0n],
  [1n, -4n, 0x10n],
  [2n, -4n, 0x20n],
  [3n, -4n, 0x30n],
  [4n, -4n, 0x40n],
  [5n, -4n, 0x50n],
  [6n, -4n, 0x60n],
  [7n, -4n, 0x70n],
  [8n, -4n, 0x80n],
  [9n, -4n, 0x90n],
  [-1n, -0x1fn, -0x80000000n],
  [0n, -0x1fn, 0n],
  [0n, -0x20n, 0n],
  [0n, -0x3fn, 0n],
  [0n, -0x40n, 0n],
];

function f(tests) {
  for (let test of tests) {
    let lhs = test[0], rhs = test[1], expected = test[2];
    assertEq(BigInt.asIntN(32, lhs), lhs);
    assertEq(BigInt.asIntN(32, rhs), rhs);
    assertEq(BigInt.asIntN(32, expected), expected);

    assertEq(lhs >> rhs, expected);
  }
}

for (let i = 0; i < 10; ++i) {
  f(tests);
}
