/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.board;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class CardBox
extends AbstractTextBlock {
    private final Display label;
    private final ISkinParam skinParam;

    public CardBox(Display label, ISkinParam skinParam) {
        this.label = label;
        this.skinParam = skinParam;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(150.0, 70.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        URectangle rect = new URectangle(this.calculateDimension(ug.getStringBounder()));
        rect.setDeltaShadow(1.0);
        ug.apply(HColorUtils.BLACK).apply(HColorUtils.LIGHT_GRAY.bg()).draw(rect);
        this.label.create(FontConfiguration.blackBlueTrue(UFont.sansSerif(14)), HorizontalAlignment.LEFT, this.skinParam).drawU(ug.apply(new UTranslate(3.0, 3.0)));
    }
}

