# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from devtools_testutils.aio import recorded_by_proxy_async
from testpreparer import AIProjectPreparer
from testpreparer_async import AIProjectClientTestBaseAsync


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAIProjectEvaluationsOperationsAsync(AIProjectClientTestBaseAsync):
    @AIProjectPreparer()
    @recorded_by_proxy_async
    async def test_evaluations_get(self, aiproject_endpoint):
        client = self.create_async_client(endpoint=aiproject_endpoint)
        response = await client.evaluations.get(
            name="str",
        )

        # please add some check logic here by yourself
        # ...

    @AIProjectPreparer()
    @recorded_by_proxy_async
    async def test_evaluations_list(self, aiproject_endpoint):
        client = self.create_async_client(endpoint=aiproject_endpoint)
        response = client.evaluations.list()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @AIProjectPreparer()
    @recorded_by_proxy_async
    async def test_evaluations_create(self, aiproject_endpoint):
        client = self.create_async_client(endpoint=aiproject_endpoint)
        response = await client.evaluations.create(
            evaluation={
                "data": "input_data",
                "evaluators": {"str": {"id": "str", "dataMapping": {"str": "str"}, "initParams": {"str": {}}}},
                "id": "str",
                "description": "str",
                "displayName": "str",
                "properties": {"str": "str"},
                "status": "str",
                "tags": {"str": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @AIProjectPreparer()
    @recorded_by_proxy_async
    async def test_evaluations_create_agent_evaluation(self, aiproject_endpoint):
        client = self.create_async_client(endpoint=aiproject_endpoint)
        response = await client.evaluations.create_agent_evaluation(
            evaluation={
                "appInsightsConnectionString": "str",
                "evaluators": {"str": {"id": "str", "dataMapping": {"str": "str"}, "initParams": {"str": {}}}},
                "runId": "str",
                "redactionConfiguration": {"redactScoreProperties": bool},
                "samplingConfiguration": {"maxRequestRate": 0.0, "name": "str", "samplingPercent": 0.0},
                "threadId": "str",
            },
        )

        # please add some check logic here by yourself
        # ...
