/*
* Copyright (c) 2024-2026, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
//!
//! \file     nvlMediaKernel_av1ba.h
//! \brief    File holds the Firmware for the media kernels for HuC
//! \details  File holds the Firmware for the media kernels for HuC which is 
//!           a programmable Microcontroller added to the VDBox pipeline.
//!

/* Media Kernel Version - 20250916 */

#pragma once


/*==========================================================================================================================================================
Kernel begins from here. Do not remove this comment.
==========================================================================================================================================================*/

const uint32_t __MediaKernels_av1ba_nvl [] =
{
    0x00002000, 0x00000140, 0x00002ec0, 0x00000040,
    0x000011c0, 0x00002140, 0x00001200, 0x00000d00,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x672efcfa, 0x15010f66, 0x00002f00, 0x66c0200f,
    0x6601c883, 0xffffff25, 0xc0220f9f, 0x00b800eb,
    0xb8c08e00, 0xe88e0028, 0x8e0010b8, 0x0018b8d8,
    0x20b8d08e, 0x66e08e00, 0x000080ea, 0x90000800,
    0x2f10002f, 0x2e660000, 0x00841f0f, 0x00000000,
    0x00000000, 0x00000000, 0x2ec011c0, 0x00409b00,
    0x00002e40, 0x00409300, 0x00002000, 0x00409300,
    0x0000ffdf, 0x00cf9302, 0x2ec011c0, 0x00409300,
    0x001ffcbc, 0x0af6e800, 0xb8660000, 0xebf4dead,
    0xccccf4fd, 0x006afacf, 0x2ae9006a, 0xfa000001,
    0x016a006a, 0x000120e9, 0x006afa00, 0x16e9026a,
    0xfa000001, 0x036a006a, 0x00010ce9, 0x006afa00,
    0x02e9046a, 0xfa000001, 0x056a006a, 0x0000f8e9,
    0x006afa00, 0xeee9066a, 0xfa000000, 0x076a006a,
    0x0000e4e9, 0x086afa00, 0x0000dce9, 0x006afa00,
    0xd2e9096a, 0xfa000000, 0xcae90a6a, 0xfa000000,
    0xc2e90b6a, 0xfa000000, 0xbae90c6a, 0xfa000000,
    0xb2e90d6a, 0xfa000000, 0xaae90e6a, 0xfa000000,
    0x0f6a006a, 0x0000a0e9, 0x006afa00, 0x96e9106a,
    0xfa000000, 0x8ee9116a, 0xfa000000, 0x126a006a,
    0x000084e9, 0x006afa00, 0x7deb136a, 0x6a006afa,
    0xfa76eb14, 0x156a006a, 0x6afa6feb, 0xeb166a00,
    0x006afa68, 0x61eb176a, 0x6a006afa, 0xfa5aeb18,
    0x196a006a, 0x6afa53eb, 0xeb1a6a00, 0x006afa4c,
    0x45eb1b6a, 0x6a006afa, 0xfa3eeb1c, 0x1d6a006a,
    0x6afa37eb, 0xeb1e6a00, 0x006afa30, 0x29eb1f6a,
    0xd06860fa, 0xe8000000, 0x00000074, 0x6104c483,
    0x6a60facf, 0x0956e84c, 0xc4830000, 0xfacf6104,
    0xff68006a, 0xeb000000, 0x31e8600b, 0x61000000,
    0xcf08c483, 0x0056e860, 0x83610000, 0xcccf08c4,
    0x83e58955, 0xc76608ec, 0x07fff845, 0x40fa45c7,
    0x0f000021, 0x83f85d01, 0xc35d08c4, 0xcccccccc,
    0x83e58955, 0x458b08ec, 0x084d8d28, 0xff240c89,
    0x29408514, 0xc4830000, 0x90c35d08, 0x90909090,
    0x5de58955, 0x909090c3, 0x90909090, 0x90909090,
    0x5de58955, 0xccccccc3, 0xcccccccc, 0xcccccccc,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0xccccccc3, 0xcccccccc,
    0xb0e58955, 0xe6a1e6ff, 0x90c35d21, 0x90909090,
    0xb8e58955, 0x00020000, 0xe00380b9, 0x64c129fe,
    0xffff01c7, 0xe0b900ff, 0x29fee003, 0x01c764c1,
    0x00000001, 0xe00320b9, 0x64c129fe, 0x00d001c7,
    0xc35d0002, 0x90909090, 0x90909090, 0x90909090,
    0xb0e58955, 0xe6a1e6ff, 0x0000b821, 0x30b90002,
    0x29fee000, 0x098b64c1, 0xe000f0b9, 0x64c129fe,
    0x01ff01c7, 0xe0b90000, 0x29fee000, 0x01c764c1,
    0xffffffff, 0xe00080b9, 0x64c129fe, 0x000001c7,
    0x80b90000, 0x29fee003, 0x01c764c1, 0x00ffffff,
    0xe003e0b9, 0x64c129fe, 0x000101c7, 0x20b90000,
    0x29fee003, 0x01c764c1, 0x000200d0, 0xccccc35d,
    0x53e58955, 0x4d8b5657, 0x08458b10, 0x890c558b,
    0x03e783c7, 0x04be4574, 0x29000000, 0x89ce39fe,
    0x890277cf, 0x89f929f7, 0x74ff85c6, 0x90909009,
    0x4f461688, 0xcf89fa75, 0x7502efc1, 0x03e18327,
    0x0010840f, 0x90900000, 0x90909090, 0x90909090,
    0x49461688, 0x5f5efa75, 0x89c35d5b, 0xc1cf89c6,
    0xd97402ef, 0xc1c2b60f, 0xc38918e2, 0x0908e3c1,
    0xc1da09c2, 0xd00910e0, 0x90909090, 0x90909090,
    0xc6830689, 0xf8754f04, 0x8b08458b, 0xe1830c55,
    0xebbd7503, 0x909090c1, 0x90909090, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x0c558b10, 0x8908458b,
    0x03e683d6, 0xe783c789, 0x75fe3903, 0x74f68559,
    0x0004bb6e, 0xf3290000, 0xcf89cb39, 0xdf890277,
    0xc689f929, 0x840fff85, 0x0000000e, 0x90909090,
    0x881ab60f, 0x4f42461e, 0xcf89f675, 0x0f02efc1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x1e891a8b, 0x8304c683, 0x754f04c2, 0x03e183f3,
    0x0c75c985, 0xc68914eb, 0x840fc985, 0x0000000a,
    0x881ab60f, 0x4942461e, 0x5f5ef675, 0x89c35d5b,
    0xc1cf89c6, 0xc87502ef, 0x9090d3eb, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x0c558b10, 0x3908458b,
    0x8d7d76d0, 0xd6390834, 0xca017676, 0xe783d789,
    0x83f08903, 0xc73903e0, 0xff854875, 0xcf391e74,
    0x0277c889, 0xc129f889, 0x840fc085, 0x0000000c,
    0xff5ab60f, 0x4eff5e88, 0xf475484a, 0xe8c1c889,
    0x18840f02, 0x90000000, 0x90909090, 0x90909090,
    0x89fc7a8b, 0xc683fc7e, 0xfcc283fc, 0x83f17548,
    0xc98503e1, 0x0012840f, 0x90900000, 0x90909090,
    0xff42b60f, 0x4eff4688, 0xf475494a, 0x7aebf089,
    0xe683d689, 0x83c78903, 0xfe3903e7, 0xf6855875,
    0x04bb6d74, 0x29000000, 0x89cb39f3, 0x890277cf,
    0x89f929df, 0x0fff85c6, 0x00000d84, 0x90909000,
    0x881ab60f, 0x4f42461e, 0xcf89f675, 0x0f02efc1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x1e891a8b, 0x8304c683, 0x754f04c2, 0x03e183f3,
    0x0c75c985, 0xc68914eb, 0x840fc985, 0x0000000a,
    0x881ab60f, 0x4942461e, 0x5f5ef675, 0x89c35d5b,
    0xc1cf89c6, 0xc87502ef, 0x9090d3eb, 0x90909090,
    0x53e58955, 0x8b505657, 0xc985084d, 0x000002b8,
    0xdf840f00, 0x8b000000, 0xf6850c75, 0x00d4880f,
    0x558b0000, 0x76f23914, 0x83ca8960, 0x277403e2,
    0x000004bf, 0x39d72900, 0x77f289f7, 0x29fa8902,
    0x0fd285d6, 0x00000e84, 0x90909000, 0x90909090,
    0x410001c6, 0x89f9754a, 0x02eac1f2, 0x90900e74,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x0f03e683,
    0x00008184, 0x90909000, 0x90909090, 0x90909090,
    0x410001c6, 0xebf9754e, 0x105d8b6d, 0xe083c889,
    0xbe237403, 0x00000004, 0xd639c629, 0x0277d089,
    0xc229f089, 0x840fc085, 0x0000000a, 0x90909090,
    0x48411988, 0xd089fa75, 0x0f02e8c1, 0x00002784,
    0xf3b60f00, 0xe7c1df89, 0xf0758918, 0x08f065c1,
    0x7d03f709, 0x10e6c1f0, 0x9090fe09, 0x90909090,
    0xc1833189, 0xf8754804, 0xe283c031, 0x90077403,
    0x4a411988, 0xc483fa75, 0x5b5f5e04, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0xb8c98508, 0x00000002,
    0x00f1840f, 0x7d8b0000, 0x0fff850c, 0x0000e688,
    0x10758b00, 0x840ff685, 0x00000080, 0x3914558b,
    0x897977fa, 0x03e083f0, 0xe783cf89, 0x75f83903,
    0x74c0854f, 0x0004bf25, 0xc7290000, 0xd089d739,
    0xf8890277, 0xc085c229, 0x000c840f, 0x90900000,
    0x881eb60f, 0x48464119, 0xd089f675, 0x0f02e8c1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x39893e8b, 0x8304c183, 0x754804c6, 0x03e283f3,
    0xd285c031, 0x006d840f, 0x90900000, 0x90909090,
    0x881eb60f, 0x4a464119, 0x5bebf675, 0xe283ca89,
    0xbe247403, 0x00000004, 0xfe39d629, 0x0277fa89,
    0xd729f289, 0x840fd285, 0x0000000b, 0x90909090,
    0x410001c6, 0x89f9754a, 0x02eac1fa, 0x90900e74,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x0f03e783,
    0x00001284, 0x90909000, 0x90909090, 0x90909090,
    0x410001c6, 0x5ef9754f, 0xc35d5b5f, 0x90909090,
    0x57e58955, 0x08558b56, 0x02b8d285, 0x0f000000,
    0x00008284, 0x0c4d8b00, 0x7b78c985, 0x8510758b,
    0x8b1974f6, 0xcf39147d, 0xec831277, 0x52565704,
    0xfffc9be8, 0x10c483ff, 0x5bebc031, 0xe683d689,
    0xbf247403, 0x00000004, 0xcf39f729, 0x0277ce89,
    0xf129fe89, 0x840ff685, 0x0000000b, 0x90909090,
    0x420002c6, 0x89f9754e, 0x02eec1ce, 0x90900e74,
    0x000002c7, 0xc2830000, 0xf4754e04, 0x0f03e183,
    0x00001284, 0x90909000, 0x90909090, 0x90909090,
    0x420002c6, 0x5ef97549, 0xccc35d5f, 0xcccccccc,
    0xb8e58955, 0x00020000, 0x100100b9, 0x64c129ff,
    0x001501c7, 0x00b90000, 0x29ff1000, 0x0004bac1,
    0xc229ff10, 0x0002c764, 0x64000200, 0x200001c7,
    0x1cb90002, 0x29ff1000, 0x01c764c1, 0x00022000,
    0x100018b9, 0x64c129ff, 0x200001c7, 0x24b92002,
    0x29ff1000, 0x01c764c1, 0x20022000, 0x100020b9,
    0x64c129ff, 0x300001c7, 0x0cb92002, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100008b9, 0x64c129ff,
    0x000001c7, 0x14b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100010b9, 0x64c129ff, 0x000001c7,
    0x2cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100028b9, 0x64c129ff, 0x000001c7, 0x34b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100030b9,
    0x64c129ff, 0x000001c7, 0x3cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100038b9, 0x64c129ff,
    0x000001c7, 0x44b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100040b9, 0x64c129ff, 0x000001c7,
    0x4cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100048b9, 0x64c129ff, 0x000001c7, 0x54b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100050b9,
    0x64c129ff, 0x000001c7, 0x5cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100058b9, 0x64c129ff,
    0x000001c7, 0x64b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100060b9, 0x64c129ff, 0x000001c7,
    0x6cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100068b9, 0x64c129ff, 0x000001c7, 0x74b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100070b9,
    0x64c129ff, 0x000001c7, 0x7cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100078b9, 0x64c129ff,
    0x000001c7, 0xc35d0000, 0x90909090, 0x90909090,
    0x56e58955, 0xfe16e850, 0x3d80ffff, 0x00002101,
    0xe8057501, 0x000000b8, 0x6af8758d, 0x006a5604,
    0xc9e8006a, 0x83000003, 0x046a10c4, 0x6a006a56,
    0x045ae800, 0xc4830000, 0x56046a10, 0x006a006a,
    0x0003abe8, 0x10c48300, 0x020000b8, 0x00b0b900,
    0xc129fee0, 0x0001c764, 0x83000000, 0x5d5e04c4,
    0x909090c3, 0x90909090, 0x90909090, 0x90909090,
    0x83e58955, 0x55e808ec, 0xe8fffff6, 0xfffff820,
    0x020000b8, 0xd3b8b900, 0xc129ffe0, 0x4c01c764,
    0x90000000, 0x90909090, 0x90909090, 0x90909090,
    0xfcebf4fb, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0x8be58955, 0xc031084d, 0x0100b980, 0x72810000,
    0x0081c60c, 0x80000001, 0x000001b8, 0x90c35d00,
    0x53e58955, 0xec835657, 0x29c0a12c, 0x008b0000,
    0xb9ec4589, 0x00020000, 0xe0d000b8, 0x64c829ff,
    0xe181088b, 0x00ffffff, 0x8b088964, 0x0029c00d,
    0x00b98000, 0x81000001, 0x81c61372, 0x00000100,
    0x088b6480, 0x0000c981, 0x89640100, 0x03806808,
    0x40680000, 0x6a00002a, 0xe8046a00, 0x000002c0,
    0x8510c483, 0x61850fc0, 0xa1000002, 0x000029c0,
    0x0100b880, 0x0f000000, 0x00027884, 0xb9f63100,
    0x00020000, 0xe0d000ba, 0x89ca29ff, 0x45c7e055,
    0x000000d8, 0x003fe900, 0x90900000, 0x90909090,
    0x83ec7503, 0x01b800d2, 0x21000000, 0x01fa83c2,
    0x000000b8, 0xf7c01900, 0x89f009d0, 0x758bec45,
    0xc0a146e8, 0x0f000029, 0x010088b6, 0xce390000,
    0x0fd85d89, 0x00021c83, 0x40be8000, 0x0000002c,
    0x000000bf, 0x0000bb00, 0xf1890000, 0x0fe87589,
    0x00012084, 0xa1d23100, 0x000029c4, 0x31e44589,
    0xe9ff31db, 0x00000013, 0x90909090, 0x90909090,
    0x3840c383, 0xf5860fd1, 0x89000000, 0x458bd455,
    0x180c8dd8, 0x75ff406a, 0x006a51e4, 0x0001efe8,
    0x10c48300, 0x3e75c085, 0x84d4558b, 0xa15174d2,
    0x000029c4, 0x4589c931, 0x087803e4, 0xb8c1920f,
    0x00000001, 0xf983c121, 0x0000b901, 0xc9190000,
    0xcf09d1f7, 0x408eb60f, 0xfe00002c, 0x79c984c2,
    0x008ae99f, 0x4d8b0000, 0x018b64e0, 0x0000000d,
    0x01896401, 0x84d4558b, 0xb0850fd2, 0x90ffffff,
    0x408eb60f, 0x0f00002c, 0x2cc086b6, 0xf9800000,
    0x83037401, 0x458904c0, 0x29c4a1dc, 0xd2310000,
    0x03e44589, 0x920f0c78, 0x0001b8c2, 0xc2210000,
    0xc683f631, 0x0001b8ff, 0xd0830000, 0x74d285ff,
    0x89c28904, 0xdc7d03f7, 0xb800d283, 0x00000001,
    0xfa83c221, 0x0000ba01, 0xd2190000, 0xd709d2f7,
    0x8be8758b, 0xc2fed455, 0x890fc984, 0xffffff10,
    0x09e980b1, 0x90ffffff, 0x90909090, 0x90909090,
    0x0029c0a1, 0xb6b60f00, 0x00002d40, 0x920ffe01,
    0x01b880c1, 0x00000001, 0xd2311d75, 0x0f047803,
    0x01b8c292, 0x21000000, 0x01fa83c2, 0x000000b8,
    0xf7c01900, 0x89c709d0, 0x0cd089fa, 0xf0458880,
    0xe8c1f889, 0x88800c07, 0xf889f145, 0x0c0ee8c1,
    0xf2458880, 0xc888c031, 0xeac1c789, 0x7fe28015,
    0x8bf35588, 0x048be845, 0x002a4085, 0xec450300,
    0x4d8d046a, 0x6a5051f0, 0x0132e803, 0xc4830000,
    0x75c08510, 0x0001b827, 0xfa890000, 0xc031c221,
    0xb9ffc083, 0x00000001, 0x85ffd183, 0xed840fd2,
    0x89fffffd, 0xe9c689ca, 0xfffffde4, 0x64e04d8b,
    0x000d018b, 0x64010000, 0xc9eb0189, 0x020000b8,
    0xd000b900, 0xc129ffe0, 0x0d018b64, 0x01000000,
    0xa1018964, 0x000029c0, 0x0100b880, 0x0f000000,
    0xfffd8885, 0x0000b8ff, 0x00b90002, 0x29ffe0d0,
    0x018b64c1, 0x0000000d, 0x01896410, 0x5e2cc483,
    0xc35d5b5f, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0x53e58955, 0x758b5657, 0x89d23114, 0x0c7d03f7,
    0x83c1920f, 0xb800107d, 0x00000002, 0x5d8b7674,
    0x0ffb8308, 0xca886e77, 0x6875d285, 0x020000ba,
    0x0000b900, 0xd129ff10, 0x009d148b, 0x0100002e,
    0x128b64ca, 0xc09d0c03, 0x6400002d, 0xda29198b,
    0xfb814272, 0x00020000, 0x0036820f, 0xfa390000,
    0x002e820f, 0xf6850000, 0x0024840f, 0x5d030000,
    0x0000b80c, 0xc3290002, 0xd231c031, 0x90107d8b,
    0x64130c8d, 0x0c89098b, 0x04c28317, 0xf072f239,
    0xc03102eb, 0x5d5b5f5e, 0x909090c3, 0x90909090,
    0x53e58955, 0x7d8b5657, 0x0fff8308, 0x000002b8,
    0x8b7f7700, 0xc985104d, 0x558b7874, 0x0c550314,
    0x00be7072, 0xbb000200, 0xff100000, 0x348bf329,
    0x002e00bd, 0x64de0100, 0x1c03368b, 0x002dc0bd,
    0x3b8b6400, 0x0773fe29, 0x000002b8, 0x8143eb00,
    0x020000ff, 0x39f17200, 0x0002b8d6, 0x820f0000,
    0x0000002e, 0x8b138b64, 0xc0851445, 0x001e840f,
    0x55030000, 0x0000be0c, 0xf2290002, 0x9090f631,
    0x8d313c8b, 0x8964321c, 0x04c6833b, 0xf072c639,
    0x5f5ec031, 0x90c35d5b, 0x90909090, 0x90909090,
    0x53e58955, 0x7d8b5657, 0x0c5d8b14, 0x8b08458b,
    0x2dc08534, 0x00b80000, 0x29000200, 0x00c681c6,
    0x64ff1000, 0xdf01168b, 0x000002b8, 0x316e7200,
    0x0fda01c9, 0x01bbc192, 0x85000000, 0x8b5e75d9,
    0x0c8b084d, 0x002e008d, 0x0000bb00, 0xd9290002,
    0x0000c181, 0x8b64ff10, 0x368b6409, 0x3d72f129,
    0x3972f939, 0xb910458b, 0x00020000, 0xe0d300be,
    0x64ce29ff, 0x08ba1689, 0x29ffe0d3, 0x028964ca,
    0xe0d310b8, 0x8bc829ff, 0x89641455, 0xd314b810,
    0xc829ffe0, 0x0100c764, 0x31000000, 0x5b5f5ec0,
    0x9090c35d, 0x90909090, 0x90909090, 0x90909090,
    0x53e58955, 0x7d8b5657, 0x0c5d8b14, 0x8b08458b,
    0x2dc08534, 0x00b80000, 0x29000200, 0x00c681c6,
    0x64ff1000, 0xdf01168b, 0x000002b8, 0x316e7200,
    0x0fda01c9, 0x01bbc192, 0x85000000, 0x8b5e75d9,
    0x0c8b084d, 0x002e008d, 0x0000bb00, 0xd9290002,
    0x0000c181, 0x8b64ff10, 0x368b6409, 0x3d72f129,
    0x3972f939, 0xb910458b, 0x00020000, 0xe0d300be,
    0x64ce29ff, 0x08ba1689, 0x29ffe0d3, 0x028964ca,
    0xe0d310b8, 0x8bc829ff, 0x89641455, 0xd314b810,
    0xc829ffe0, 0x0300c764, 0x31000000, 0x5b5f5ec0,
    0xccccc35d, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0x00080095, 0x00008e00, 0x0008009f, 0x00008e00,
    0x000800a9, 0x00008e00, 0x000800b3, 0x00008e00,
    0x000800bd, 0x00008e00, 0x000800c7, 0x00008e00,
    0x000800d1, 0x00008e00, 0x000800db, 0x00008e00,
    0x000800e5, 0x00008e00, 0x000800ed, 0x00008e00,
    0x000800f7, 0x00008e00, 0x000800ff, 0x00008e00,
    0x00080107, 0x00008e00, 0x0008010f, 0x00008e00,
    0x00080117, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080129, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x000801b1, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x000801a0, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x000801bf, 0x00008e00,
    0x00000250, 0x00000260, 0x00000280, 0x00000270,
    0x00000290, 0x000002a0, 0x000002b0, 0x000002c0,
    0x000002d0, 0x000002e0, 0x000002f0, 0x00000300,
    0x00000310, 0x00000320, 0x00000330, 0x00000080,
    0x00000350, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00002000, 0x00002a00, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000004, 0x0000000c, 0x00000014, 0x0000001c,
    0x00000024, 0x0000002c, 0x00000034, 0x0000003c,
    0x00000044, 0x0000004c, 0x00000054, 0x0000005c,
    0x00000064, 0x0000006c, 0x00000074, 0x0000007c,
    0x00000000, 0x00000008, 0x00000010, 0x00000018,
    0x00000020, 0x00000028, 0x00000030, 0x00000038,
    0x00000040, 0x00000048, 0x00000050, 0x00000058,
    0x00000060, 0x00000068, 0x00000070, 0x00000078,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
};
