#!/bin/sh
# Copyright (C) 2025 Andres Salomon <dilinger@debian.org>
# License: GPLv2
#
# run this via `dbus-test-runner -m 120 --bus-type=both -t <script>` in podman


#DBG=-d
DBG=

set -e

sed -i 's/^#\[phonesim\]/[phonesim]/' /etc/ofono/phonesim.conf
sed -i 's/^#Address=/Address=/' /etc/ofono/phonesim.conf
sed -i 's/^#Port=/Port=/' /etc/ofono/phonesim.conf

MONIT_PID=""
if [ ! -z "$DBG" ]; then
    dbus-monitor --system &
    MONIT_PID=$!
fi

ofonod ${DBG} -n &
OFONO_PID=$!
sleep 1

xvfb-run ofono-phonesim -gui -p 12345 /usr/share/ofono-phonesim/default.xml &
PHONESIM_PID=$!
sleep 1

echo "enabling modem"
/usr/share/ofono/scripts/enable-modem
sleep 2

echo "powering up modem"
/usr/share/ofono/scripts/online-modem

# It takes a little while to detect the modem stuff. Without the delay,
# we're missing interfaces when we try tests and things go kablooey.
sleep 10

/usr/share/ofono/scripts/list-modems

#echo "running script"
#dbus-send --session --print-reply --dest=org.ofono.phonesim / org.ofono.phonesim.Script.SetPath string:/tmp
#dbus-send --session --print-reply --dest=org.ofono.phonesim / org.ofono.phonesim.Script.Run string:sms.js

kill -9 $PHONESIM_PID
killall Xvfb # xvfb-run starts multiple processes
kill -9 $OFONO_PID
[ ! -z "$MONIT_PID" ] && kill -9 $MONIT_PID
