# Contributing

Contributions are **welcome** and will be fully **credited**.

## Bug Report

We accept bug reports via issues created on [Github](https://github.com/thephpleague/uri-src/issues).

### Prior to submitting your report

- **Always search the issue or pull request list first** - The odds are good that if you've found a problem, someone else has found it, too.

- **Always try the [master branch](https://github.com/thephpleague/uri-src)** - to see if the reported bug has not already been fixed.

### When submitting your report

- **Open a new bug report for each issue.**

- **Write a clear summary in english** - A good summary should quickly and uniquely identify a bug report. It should explain the problem, not your suggested solution.

- **Be brief, but don't leave any important details out** - Tell us what you did, what you expected to happen, and what happened. Do not forget to mention your PHP version, the OS Platform and the package version you were using.

## Pull Request

We accept contributions via Pull Requests on [Github](https://github.com/thephpleague/uri-src/pull).

- **[PSR-12 Coding Standard](http://www.php-fig.org/psr/psr-12/)** - Your patch won't be accepted if it doesn't pass the package coding style test suite.

- **Add tests!** - Your patch won't be accepted if it doesn't have tests.

- **Document any change in behaviour** - Make sure the README and any other relevant documentation are kept up-to-date.

- **Consider our release cycle** - We try to follow semver. Randomly breaking public APIs is not an option.

- **Create topic branches** - Don't ask us to pull from your master branch.

- **One pull request per feature** - If you want to do more than one thing, send multiple pull requests.

- **Send coherent history** - Make sure each individual commit in your pull request is meaningful. If you had to make multiple intermediate commits while developing, please squash them before submitting.


## Running Tests

``` bash
$ composer test
```


**Happy coding**!
