# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.domain import Domain
from twilio.rest.numbers.v2 import V2


class Numbers(Domain):

    def __init__(self, twilio):
        """
        Initialize the Numbers Domain

        :returns: Domain for Numbers
        :rtype: twilio.rest.numbers.Numbers
        """
        super(Numbers, self).__init__(twilio)

        self.base_url = 'https://numbers.twilio.com'

        # Versions
        self._v2 = None

    @property
    def v2(self):
        """
        :returns: Version v2 of numbers
        :rtype: twilio.rest.numbers.v2.V2
        """
        if self._v2 is None:
            self._v2 = V2(self)
        return self._v2

    @property
    def regulatory_compliance(self):
        """
        :rtype: twilio.rest.numbers.v2.regulatory_compliance.RegulatoryComplianceList
        """
        return self.v2.regulatory_compliance

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Numbers>'
