############################################################################
#    Copyright (C) 2007 by Giovanni Bezicheri   #
#    ioannissecundi@gmail.com   #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

import sys
import os
import re
import glob
import commands

class GtkrcEngine:
	"""Manages gtkrc theme files"""
	def __init__(self):
		pass
	def setrc(self, file, theme):
		self.file = file
		self.theme = theme
		gtkrc = open(file, "r") # open file gtkrc
		self.rcstr = gtkrc.read() # read all content
		gtkrc.close
		# isolate murrine config section
		self.rcstr = re.compile('engine "murrine"[^}]*').search(self.rcstr).group()
	def writeChanges(self):
		# read config
		gtkrc = open(self.file, "r")
		config = gtkrc.read()
		gtkrc.close
		config = re.compile('engine "murrine"[^}]*').sub(self.rcstr, config)
		# hard write to file
		gtkrc = open(self.file, "w")
		config = gtkrc.write(config)
		gtkrc.close
	def getRcStyle(self):
		# return rc style
		gtkrc = open(self.file, "r")
		config = gtkrc.read()
		gtkrc.close
		config = re.compile('engine "murrine"[^}]*').sub(self.rcstr, config)
		return config
	def writeGnome(self):
		if str(commands.getoutput("gconftool-2 -g /desktop/gnome/interface/gtk_theme")) == self.theme:
			os.popen("gconftool-2 -u /desktop/gnome/interface/gtk_theme")
		os.popen("gconftool-2 -s -t string /desktop/gnome/interface/gtk_theme " + self.theme)
		
	def writeXfce(self):
		os.popen("xfce-setting-show ui")
	def writeGtk2(self):
		currdir = os.getcwd()
		os.chdir(os.environ.get("HOME")) # chdir ~
		for file in glob.glob('.gtkrc-2.0'):
			if str(file) == ".gtkrc-2.0":
				gtkrc2 = open(".gtkrc-2.0", "r")
				buff = gtkrc2.read()
				gtkrc2.close()
				buff = re.compile('include.*gtkrc\"').sub("include \"" + currdir + "/" + self.file + "\"", buff)
				gtkrc2 = open(".gtkrc-2.0", "w")
				gtkrc2.write(buff)
				gtkrc2.close()
		os.chdir(currdir)
	def setStyleOpt(self, opt, value):
		if opt == "glazestyle":
			self.setGlazeStyle(value)
		if opt == "roundnessstyle":
			self.setRoundnessStyle(value)
		if opt == "menubarstyle":
			self.setMenubarStyle(value)
		if opt == "menubaritemsstyle":
			self.setMenubaritemsStyle(value)
		if opt == "menuitemsstyle":
			self.setMenuitemsStyle(value)
		if opt == "listviewheadersstyle":
			self.setListviewheadersStyle(value)
		if opt == "listviewstyle":
			self.setListviewStyle(value)
		if opt == "scrollbarstyle":
			self.setScrollbarStyle(value)
		if opt == "animation":
			self.setAnimationsStyle(value)
		if opt == "gradients":
			self.setGradientsStyle(value)
		if opt == "contrast":
			self.setContrastStyle(value)
		if opt == "hilight_ratio":
			self.setHilightRatio(value)
		if opt == "menustyle":
			self.setMenuStyle(value)
		if opt == "scrollbar_color":
			self.setScrollbarColor(value)
	def setGlazeStyle(self, value):
		if re.compile('glazestyle\s*=\s*\d').search(self.rcstr) != None:
			self.rcstr = re.compile('glazestyle\s*=\s*\d').sub("glazestyle = " + value, self.rcstr)
		else:
			self.rcstr = self.rcstr + "     glazestyle = " + value + "\n   "
	def setRoundnessStyle(self, value):
		if re.compile('roundness\s*=\s*\d').search(self.rcstr) != None:
			self.rcstr = re.compile('roundness\s*=\s*\d').sub("roundness = " + value, self.rcstr)
		else:
			self.rcstr = self.rcstr + "     roundness = " + value + "\n   "
	def setMenubarStyle(self, value):
		if re.compile('menubarstyle\s*=\s*\d').search(self.rcstr) != None:
			self.rcstr = re.compile('menubarstyle\s*=\s*\d').sub("menubarstyle = " + value, self.rcstr)
		else:
			self.rcstr = self.rcstr + "     menubarstyle = " + value + "\n   "
	def setMenubaritemsStyle(self, value):
		if re.compile('menubaritemstyle\s*=\s*\d').search(self.rcstr) != None:
			self.rcstr = re.compile('menubaritemstyle\s*=\s*\d').sub("menubaritemstyle = " + value, self.rcstr)
		else:
			self.rcstr = self.rcstr + "     menubaritemstyle = " + value + "\n   "
	def setMenuitemsStyle(self, value):
		if re.compile('menuitemstyle\s*=\s*\d').search(self.rcstr) != None:
			self.rcstr = re.compile('menuitemstyle\s*=\s*\d').sub("menuitemstyle = " + value, self.rcstr)
		else:
			self.rcstr = self.rcstr + "     menuitemstyle = " + value + "\n   "
	def setListviewheadersStyle(self, value):
		if re.compile('listviewheaderstyle\s*=\s*\d').search(self.rcstr) != None:
			self.rcstr = re.compile('listviewheaderstyle\s*=\s*\d').sub("listviewheaderstyle = " + value, self.rcstr)
		else:
			self.rcstr = self.rcstr + "     listviewheaderstyle = " + value + "\n   "
	def setListviewStyle(self, value):
		if re.compile('listviewstyle\s*=\s*\d').search(self.rcstr) != None:
			self.rcstr = re.compile('listviewstyle\s*=\s*\d').sub("listviewstyle = " + value, self.rcstr)
		else:
			self.rcstr = self.rcstr + "     listviewstyle = " + value + "\n   "
	def setScrollbarStyle(self, value):
		if re.compile('scrollbarstyle\s*=\s*\d').search(self.rcstr) != None:
			self.rcstr = re.compile('scrollbarstyle\s*=\s*\d').sub("scrollbarstyle = " + value, self.rcstr)
		else:
			self.rcstr = self.rcstr + "     scrollbarstyle = " + value + "\n   "
	def setAnimationsStyle(self, value):
		if int(value) == 1:
			bool_value = "TRUE"
		else:
			bool_value = "FALSE"
		if re.compile('animation\s*=\s*(TRUE|FALSE)').search(self.rcstr) != None:
			self.rcstr = re.compile('animation\s*=\s*(TRUE|FALSE)').sub("animation = " + bool_value, self.rcstr)
		else:
			self.rcstr = self.rcstr + "     animation = " + bool_value + "\n   "
	def setGradientsStyle(self, value):
		if int(value) == 1:
			bool_value = "TRUE"
		else:
			bool_value = "FALSE"
		if re.compile('gradients\s*=\s*(TRUE|FALSE)').search(self.rcstr) != None:
			self.rcstr = re.compile('gradients\s*=\s*(TRUE|FALSE)').sub("gradients = " + bool_value, self.rcstr)
		else:
			self.rcstr = self.rcstr + "     gradients = " + bool_value + "\n   "
	def setContrastStyle(self, value):
		if re.compile('contrast\s*=\s*\d\.\d*').search(self.rcstr) != None:
			self.rcstr = re.compile('contrast\s*=\s*\d\.\d*').sub("contrast = " + value, self.rcstr)
		else:
			self.rcstr = self.rcstr + "     contrast = " + value + "\n   "
	def setHilightRatio(self, value):
		if re.compile('hilight_ratio\s*=\s*\d\.\d*').search(self.rcstr) != None:
			self.rcstr = re.compile('hilight_ratio\s*=\s*\d\.\d*').sub("hilight_ratio = " + value, self.rcstr)
		else:
			self.rcstr = self.rcstr + "     hilight_ratio = " + value + "\n   "
	def setMenuStyle(self, value):
		if re.compile('menustyle\s*=\s*\d').search(self.rcstr) != None:
			self.rcstr = re.compile('menustyle\s*=\s*\d').sub("menustyle = " + value, self.rcstr)
		else:
			self.rcstr = self.rcstr + "     menustyle = " + value + "\n   "
	def setScrollbarColor(self, value):
		if re.compile('scrollbar_color\s*=\s*\".*\"').search(self.rcstr) != None:
			self.rcstr = re.compile('scrollbar_color\s*=\s*\".*\"').sub("scrollbar_color = " + value, self.rcstr)
		else:
			self.rcstr = self.rcstr + "     scrollbar_color = " + value + "\n   "
	def getStyleOpt(self, opt):
		if opt == "glazestyle":
			return self.getGlazeStyle()
		if opt == "roundnessstyle":
			return self.getRoundnessStyle()
		if opt == "menubarstyle":
			return self.getMenubarStyle()
		if opt == "menubaritemsstyle":
			return self.getMenubaritemsStyle()
		if opt == "menuitemsstyle":
			return self.getMenuitemsStyle()
		if opt == "listviewheadersstyle":
			return self.getListviewheadersStyle()
		if opt == "listviewstyle":
			return self.getListviewStyle()
		if opt == "scrollbarstyle":
			return self.getScrollbarStyle()
		if opt == "animation":
			return self.getAnimationsStyle()
		if opt == "gradients":
			return self.getGradientsStyle()
		if opt == "contrast":
			return self.getContrastStyle()
		if opt == "hilight_ratio":
			return self.getHilightRatio()
		if opt == "menustyle":
			return self.getMenuStyle()
		if opt == "scrollbar_color":
			return self.getScrollbarColor()
	def getGlazeStyle(self):
		try:
			return re.compile('glazestyle\s*=\s*\d').search(self.rcstr).group()[-1]
		except AttributeError:
			return None
	def getRoundnessStyle(self):
		try:
			return re.compile('roundness\s*=\s*\d').search(self.rcstr).group()[-1]
		except AttributeError:
			return None
	def getMenubarStyle(self):
		try:
			return re.compile('menubarstyle\s*=\s*\d').search(self.rcstr).group()[-1]
		except AttributeError:
			return None
	def getMenubaritemsStyle(self):
		try:
			return re.compile('menubaritemstyle\s*=\s*\d').search(self.rcstr).group()[-1]
		except AttributeError:
			return None
	def getMenuitemsStyle(self):
		try:
			return re.compile('menuitemstyle\s*=\s*\d').search(self.rcstr).group()[-1]
		except AttributeError:
			return None
	def getListviewheadersStyle(self):
		try:
			return re.compile('listviewheaderstyle\s*=\s*\d').search(self.rcstr).group()[-1]
		except AttributeError:
			return None
	def getListviewStyle(self):
		try:
			return re.compile('listviewstyle\s*=\s*\d').search(self.rcstr).group()[-1]
		except AttributeError:
			return None
	def getScrollbarStyle(self):
		try:
			return re.compile('scrollbarstyle\s*=\s*\d').search(self.rcstr).group()[-1]
		except AttributeError:
			return None
	def getAnimationsStyle(self):
		try:
			if re.compile('animation\s*=\s*(TRUE|FALSE)').search(self.rcstr).group()[-4:] == "TRUE":
				return 1
			else:
				return 0
		except AttributeError:
			return None
	def getGradientsStyle(self):
		try:
			if re.compile('gradients\s*=\s*(TRUE|FALSE)').search(self.rcstr).group()[-4:] == "TRUE":
				return 1
			else:
				return 0
		except AttributeError:
			return None
	def getContrastStyle(self):
		try:
			return re.compile('\d\.\d*').findall(re.compile('contrast\s*=\s*\d\.\d*').search(self.rcstr).group())[0]
		except AttributeError:
			return None
	def getHilightRatio(self):
		try:
			return re.compile('\d\.\d*').findall(re.compile('hilight_ratio\s*=\s*\d\.\d*').search(self.rcstr).group())[0]
		except AttributeError:
			return None
	def getMenuStyle(self):
		try:
			return re.compile('menustyle\s*=\s*\d').search(self.rcstr).group()[-1]
		except AttributeError:
			return None
	def getScrollbarColor(self):
		try:
			return re.compile('scrollbar_color\s*=\s*\".*\"').search(self.rcstr).group()[-8:-1]
		except AttributeError:
			return None