
#include "config.h"

#include <glib.h>
#include <math.h>

#define SCALE 256

void
get_taps (double *taps, double x)
{
  taps[3] = x * x * (x - 1);
  taps[2] = x * (-x * x + x + 1);
  x = 1 - x;
  taps[1] = x * (-x * x + x + 1);
  taps[0] = x * x * (x - 1);
}

int
main (int argc, char *argv[])
{
  int i;

  g_print ("/* This file is autogenerated.  Do not edit.*/\n");
  g_print ("#include <glib.h>\n");
  g_print ("gint8 cog_resample_table_4tap[256][4] = {\n");
  for (i = 0; i < 256; i++) {
    double x = i / 256.0;
    double taps[4];
    int t[4];
    int sum;

    get_taps (taps, x);
    taps[0] *= SCALE;
    taps[1] *= SCALE;
    taps[2] *= SCALE;
    taps[3] *= SCALE;

    t[0] = floor (taps[0]);
    t[1] = floor (taps[1]);
    t[2] = floor (taps[2]);
    t[3] = floor (taps[3]);
    sum = t[0] + t[1] + t[2] + t[3];

    for (; sum < SCALE; sum++) {
      int i;
      double max = 0;
      int max_i = -1;
      for (i = 0; i < 4; i++) {
        if (max_i == -1 || (t[i] < taps[i] && (taps[i] - t[i]) > max)) {
          max_i = i;
          max = taps[i] - t[i];
        }
      }
      t[max_i]++;
    }
    sum = t[0] + t[1] + t[2] + t[3];

    g_print ("  { %d, %d, %d, %d }, /* %d %d */\n",
        t[0], t[1], t[2], t[3], t[2] + t[0], t[1] + t[3]);
#if 0
    g_print ("/* %.3f %.3f %.3f %.3f %d */\n",
        taps[0] - t[0], taps[1] - t[1], taps[2] - t[2], taps[3] - t[3], sum);
#endif
  }
  g_print ("};\n");
  g_print ("\n");

  return 0;
}
