/* valadelegatetype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valadelegatetype.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <vala/valasymbol.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>




struct _ValaDelegateTypePrivate {
	ValaDelegate* _delegate_symbol;
};

#define VALA_DELEGATE_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypePrivate))
enum  {
	VALA_DELEGATE_TYPE_DUMMY_PROPERTY
};
static gboolean vala_delegate_type_real_is_invokable (ValaDataType* base);
static ValaDataType* vala_delegate_type_real_get_return_type (ValaDataType* base);
static GeeList* vala_delegate_type_real_get_parameters (ValaDataType* base);
static char* vala_delegate_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope);
static ValaDataType* vala_delegate_type_real_copy (ValaDataType* base);
static char* vala_delegate_type_real_get_cname (ValaDataType* base);
static GeeList* vala_delegate_type_real_get_symbols (ValaDataType* base);
static char* vala_delegate_type_real_get_type_id (ValaDataType* base);
static gboolean vala_delegate_type_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static gpointer vala_delegate_type_parent_class = NULL;
static void vala_delegate_type_finalize (ValaCodeNode* obj);



ValaDelegateType* vala_delegate_type_construct (GType object_type, ValaDelegate* delegate_symbol) {
	ValaDelegateType* self;
	g_return_val_if_fail (delegate_symbol != NULL, NULL);
	self = (ValaDelegateType*) g_type_create_instance (object_type);
	vala_delegate_type_set_delegate_symbol (self, delegate_symbol);
	return self;
}


ValaDelegateType* vala_delegate_type_new (ValaDelegate* delegate_symbol) {
	return vala_delegate_type_construct (VALA_TYPE_DELEGATE_TYPE, delegate_symbol);
}


static gboolean vala_delegate_type_real_is_invokable (ValaDataType* base) {
	ValaDelegateType * self;
	self = (ValaDelegateType*) base;
	return TRUE;
}


static ValaDataType* vala_delegate_type_real_get_return_type (ValaDataType* base) {
	ValaDelegateType * self;
	ValaDataType* _tmp0;
	self = (ValaDelegateType*) base;
	_tmp0 = NULL;
	return (_tmp0 = vala_delegate_get_return_type (self->priv->_delegate_symbol), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
}


static GeeList* vala_delegate_type_real_get_parameters (ValaDataType* base) {
	ValaDelegateType * self;
	self = (ValaDelegateType*) base;
	return vala_delegate_get_parameters (self->priv->_delegate_symbol);
}


static char* vala_delegate_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope) {
	ValaDelegateType * self;
	char* s;
	self = (ValaDelegateType*) base;
	s = vala_symbol_get_full_name ((ValaSymbol*) self->priv->_delegate_symbol);
	if (vala_data_type_get_nullable ((ValaDataType*) self)) {
		char* _tmp0;
		_tmp0 = NULL;
		s = (_tmp0 = g_strconcat (s, "?", NULL), s = (g_free (s), NULL), _tmp0);
	}
	return s;
}


static ValaDataType* vala_delegate_type_real_copy (ValaDataType* base) {
	ValaDelegateType * self;
	self = (ValaDelegateType*) base;
	return (ValaDataType*) vala_delegate_type_new (self->priv->_delegate_symbol);
}


static char* vala_delegate_type_real_get_cname (ValaDataType* base) {
	ValaDelegateType * self;
	self = (ValaDelegateType*) base;
	return vala_typesymbol_get_cname ((ValaTypeSymbol*) self->priv->_delegate_symbol, FALSE);
}


static GeeList* vala_delegate_type_real_get_symbols (ValaDataType* base) {
	ValaDelegateType * self;
	GeeArrayList* symbols;
	self = (ValaDelegateType*) base;
	symbols = gee_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	gee_collection_add ((GeeCollection*) symbols, (ValaSymbol*) self->priv->_delegate_symbol);
	return (GeeList*) symbols;
}


static char* vala_delegate_type_real_get_type_id (ValaDataType* base) {
	ValaDelegateType * self;
	self = (ValaDelegateType*) base;
	return g_strdup ("G_TYPE_POINTER");
}


static gboolean vala_delegate_type_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaDelegateType * self;
	self = (ValaDelegateType*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	return vala_code_node_check ((ValaCodeNode*) self->priv->_delegate_symbol, analyzer);
}


ValaDelegate* vala_delegate_type_get_delegate_symbol (ValaDelegateType* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_delegate_symbol;
}


void vala_delegate_type_set_delegate_symbol (ValaDelegateType* self, ValaDelegate* value) {
	ValaDelegate* _tmp2;
	ValaDelegate* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_delegate_symbol = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_delegate_symbol == NULL) ? NULL : (self->priv->_delegate_symbol = (vala_code_node_unref (self->priv->_delegate_symbol), NULL)), _tmp2);
}


static void vala_delegate_type_class_init (ValaDelegateTypeClass * klass) {
	vala_delegate_type_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_delegate_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaDelegateTypePrivate));
	VALA_DATA_TYPE_CLASS (klass)->is_invokable = vala_delegate_type_real_is_invokable;
	VALA_DATA_TYPE_CLASS (klass)->get_return_type = vala_delegate_type_real_get_return_type;
	VALA_DATA_TYPE_CLASS (klass)->get_parameters = vala_delegate_type_real_get_parameters;
	VALA_DATA_TYPE_CLASS (klass)->to_qualified_string = vala_delegate_type_real_to_qualified_string;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_delegate_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_delegate_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_symbols = vala_delegate_type_real_get_symbols;
	VALA_DATA_TYPE_CLASS (klass)->get_type_id = vala_delegate_type_real_get_type_id;
	VALA_CODE_NODE_CLASS (klass)->check = vala_delegate_type_real_check;
}


static void vala_delegate_type_instance_init (ValaDelegateType * self) {
	self->priv = VALA_DELEGATE_TYPE_GET_PRIVATE (self);
}


static void vala_delegate_type_finalize (ValaCodeNode* obj) {
	ValaDelegateType * self;
	self = VALA_DELEGATE_TYPE (obj);
	(self->priv->_delegate_symbol == NULL) ? NULL : (self->priv->_delegate_symbol = (vala_code_node_unref (self->priv->_delegate_symbol), NULL));
	VALA_CODE_NODE_CLASS (vala_delegate_type_parent_class)->finalize (obj);
}


GType vala_delegate_type_get_type (void) {
	static GType vala_delegate_type_type_id = 0;
	if (vala_delegate_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDelegateTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_delegate_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDelegateType), 0, (GInstanceInitFunc) vala_delegate_type_instance_init, NULL };
		vala_delegate_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaDelegateType", &g_define_type_info, 0);
	}
	return vala_delegate_type_type_id;
}




