/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define GNOME_SCAN_TYPE_OPTION_WIDGET (gnome_scan_option_widget_get_type ())
#define GNOME_SCAN_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidget))
#define GNOME_SCAN_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))
#define GNOME_SCAN_IS_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_IS_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_OPTION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))

typedef struct _GnomeScanOptionWidget GnomeScanOptionWidget;
typedef struct _GnomeScanOptionWidgetClass GnomeScanOptionWidgetClass;
typedef struct _GnomeScanOptionWidgetPrivate GnomeScanOptionWidgetPrivate;

#define GNOME_SCAN_TYPE_CHECKBOX_WIDGET (gnome_scan_checkbox_widget_get_type ())
#define GNOME_SCAN_CHECKBOX_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_CHECKBOX_WIDGET, GnomeScanCheckboxWidget))
#define GNOME_SCAN_CHECKBOX_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_CHECKBOX_WIDGET, GnomeScanCheckboxWidgetClass))
#define GNOME_SCAN_IS_CHECKBOX_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_CHECKBOX_WIDGET))
#define GNOME_SCAN_IS_CHECKBOX_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_CHECKBOX_WIDGET))
#define GNOME_SCAN_CHECKBOX_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_CHECKBOX_WIDGET, GnomeScanCheckboxWidgetClass))

typedef struct _GnomeScanCheckboxWidget GnomeScanCheckboxWidget;
typedef struct _GnomeScanCheckboxWidgetClass GnomeScanCheckboxWidgetClass;
typedef struct _GnomeScanCheckboxWidgetPrivate GnomeScanCheckboxWidgetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;

#define GNOME_SCAN_TYPE_OPTION_BOOL (gnome_scan_option_bool_get_type ())
#define GNOME_SCAN_OPTION_BOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBool))
#define GNOME_SCAN_OPTION_BOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBoolClass))
#define GNOME_SCAN_IS_OPTION_BOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_BOOL))
#define GNOME_SCAN_IS_OPTION_BOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_BOOL))
#define GNOME_SCAN_OPTION_BOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBoolClass))

typedef struct _GnomeScanOptionBool GnomeScanOptionBool;
typedef struct _GnomeScanOptionBoolClass GnomeScanOptionBoolClass;

struct _GnomeScanOptionWidget {
	GtkHBox parent_instance;
	GnomeScanOptionWidgetPrivate * priv;
};

struct _GnomeScanOptionWidgetClass {
	GtkHBoxClass parent_class;
};

struct _GnomeScanCheckboxWidget {
	GnomeScanOptionWidget parent_instance;
	GnomeScanCheckboxWidgetPrivate * priv;
};

struct _GnomeScanCheckboxWidgetClass {
	GnomeScanOptionWidgetClass parent_class;
};

struct _GnomeScanCheckboxWidgetPrivate {
	GtkCheckButton* check;
};


static gpointer gnome_scan_checkbox_widget_parent_class = NULL;

GType gnome_scan_option_widget_get_type (void);
GType gnome_scan_checkbox_widget_get_type (void);
#define GNOME_SCAN_CHECKBOX_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_CHECKBOX_WIDGET, GnomeScanCheckboxWidgetPrivate))
enum  {
	GNOME_SCAN_CHECKBOX_WIDGET_DUMMY_PROPERTY
};
GType gnome_scan_option_get_type (void);
GnomeScanOption* gnome_scan_option_widget_get_option (GnomeScanOptionWidget* self);
GType gnome_scan_option_bool_get_type (void);
void gnome_scan_option_bool_set_value (GnomeScanOptionBool* self, gboolean value);
static void gnome_scan_checkbox_widget_update_option (GnomeScanCheckboxWidget* self);
gboolean gnome_scan_option_bool_get_value (GnomeScanOptionBool* self);
static void gnome_scan_checkbox_widget_update_widget (GnomeScanCheckboxWidget* self);
GnomeScanCheckboxWidget* gnome_scan_checkbox_widget_new (void);
GnomeScanCheckboxWidget* gnome_scan_checkbox_widget_construct (GType object_type);
void gnome_scan_option_widget_set_no_label (GnomeScanOptionWidget* self, gboolean value);
void gnome_scan_option_widget_set_expand (GnomeScanOptionWidget* self, gboolean value);
const char* gnome_scan_option_get_title (GnomeScanOption* self);
static void _gnome_scan_checkbox_widget_update_option_g_object_notify (GtkCheckButton* _sender, GParamSpec* pspec, gpointer self);
static void _gnome_scan_checkbox_widget_update_widget_g_object_notify (GnomeScanOption* _sender, GParamSpec* pspec, gpointer self);
static GObject * gnome_scan_checkbox_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gnome_scan_checkbox_widget_finalize (GObject* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gnome_scan_checkbox_widget_update_option (GnomeScanCheckboxWidget* self) {
	GnomeScanOption* _tmp0_;
	GnomeScanOptionBool* option;
	g_return_if_fail (self != NULL);
	option = _g_object_ref0 ((_tmp0_ = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_BOOL (_tmp0_) ? ((GnomeScanOptionBool*) _tmp0_) : NULL));
	g_object_freeze_notify ((GObject*) option);
	gnome_scan_option_bool_set_value (option, gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->check));
	g_object_thaw_notify ((GObject*) option);
	_g_object_unref0 (option);
}


static void gnome_scan_checkbox_widget_update_widget (GnomeScanCheckboxWidget* self) {
	GnomeScanOption* _tmp0_;
	GnomeScanOptionBool* option;
	g_return_if_fail (self != NULL);
	option = _g_object_ref0 ((_tmp0_ = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_BOOL (_tmp0_) ? ((GnomeScanOptionBool*) _tmp0_) : NULL));
	g_object_freeze_notify ((GObject*) option);
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->check, gnome_scan_option_bool_get_value (option));
	g_object_thaw_notify ((GObject*) option);
	_g_object_unref0 (option);
}


GnomeScanCheckboxWidget* gnome_scan_checkbox_widget_construct (GType object_type) {
	GnomeScanCheckboxWidget * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GnomeScanCheckboxWidget* gnome_scan_checkbox_widget_new (void) {
	return gnome_scan_checkbox_widget_construct (GNOME_SCAN_TYPE_CHECKBOX_WIDGET);
}


static void _gnome_scan_checkbox_widget_update_option_g_object_notify (GtkCheckButton* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_checkbox_widget_update_option (self);
}


static void _gnome_scan_checkbox_widget_update_widget_g_object_notify (GnomeScanOption* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_checkbox_widget_update_widget (self);
}


static GObject * gnome_scan_checkbox_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanCheckboxWidgetClass * klass;
	GObjectClass * parent_class;
	GnomeScanCheckboxWidget * self;
	klass = GNOME_SCAN_CHECKBOX_WIDGET_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_CHECKBOX_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_CHECKBOX_WIDGET (obj);
	{
		GtkCheckButton* _tmp0_;
		gnome_scan_option_widget_set_no_label ((GnomeScanOptionWidget*) self, TRUE);
		gnome_scan_option_widget_set_expand ((GnomeScanOptionWidget*) self, FALSE);
		self->priv->check = (_tmp0_ = g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new_with_label (gnome_scan_option_get_title (gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self)))), _g_object_unref0 (self->priv->check), _tmp0_);
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->check, TRUE, TRUE, (guint) 0);
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->check, gnome_scan_option_bool_get_value (GNOME_SCAN_OPTION_BOOL (gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self))));
		g_signal_connect_object ((GObject*) self->priv->check, "notify::active", (GCallback) _gnome_scan_checkbox_widget_update_option_g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), "notify::value", (GCallback) _gnome_scan_checkbox_widget_update_widget_g_object_notify, self, 0);
	}
	return obj;
}


static void gnome_scan_checkbox_widget_class_init (GnomeScanCheckboxWidgetClass * klass) {
	gnome_scan_checkbox_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanCheckboxWidgetPrivate));
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_checkbox_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_checkbox_widget_finalize;
}


static void gnome_scan_checkbox_widget_instance_init (GnomeScanCheckboxWidget * self) {
	self->priv = GNOME_SCAN_CHECKBOX_WIDGET_GET_PRIVATE (self);
}


static void gnome_scan_checkbox_widget_finalize (GObject* obj) {
	GnomeScanCheckboxWidget * self;
	self = GNOME_SCAN_CHECKBOX_WIDGET (obj);
	_g_object_unref0 (self->priv->check);
	G_OBJECT_CLASS (gnome_scan_checkbox_widget_parent_class)->finalize (obj);
}


GType gnome_scan_checkbox_widget_get_type (void) {
	static GType gnome_scan_checkbox_widget_type_id = 0;
	if (gnome_scan_checkbox_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanCheckboxWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_checkbox_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanCheckboxWidget), 0, (GInstanceInitFunc) gnome_scan_checkbox_widget_instance_init, NULL };
		gnome_scan_checkbox_widget_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION_WIDGET, "GnomeScanCheckboxWidget", &g_define_type_info, 0);
	}
	return gnome_scan_checkbox_widget_type_id;
}




