/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define GNOME_SCAN_TYPE_OPTION_WIDGET (gnome_scan_option_widget_get_type ())
#define GNOME_SCAN_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidget))
#define GNOME_SCAN_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))
#define GNOME_SCAN_IS_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_IS_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_OPTION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))

typedef struct _GnomeScanOptionWidget GnomeScanOptionWidget;
typedef struct _GnomeScanOptionWidgetClass GnomeScanOptionWidgetClass;
typedef struct _GnomeScanOptionWidgetPrivate GnomeScanOptionWidgetPrivate;

#define GNOME_SCAN_TYPE_COMBO_BOX_WIDGET (gnome_scan_combo_box_widget_get_type ())
#define GNOME_SCAN_COMBO_BOX_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET, GnomeScanComboBoxWidget))
#define GNOME_SCAN_COMBO_BOX_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET, GnomeScanComboBoxWidgetClass))
#define GNOME_SCAN_IS_COMBO_BOX_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET))
#define GNOME_SCAN_IS_COMBO_BOX_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET))
#define GNOME_SCAN_COMBO_BOX_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET, GnomeScanComboBoxWidgetClass))

typedef struct _GnomeScanComboBoxWidget GnomeScanComboBoxWidget;
typedef struct _GnomeScanComboBoxWidgetClass GnomeScanComboBoxWidgetClass;
typedef struct _GnomeScanComboBoxWidgetPrivate GnomeScanComboBoxWidgetPrivate;

#define GNOME_SCAN_COMBO_BOX_WIDGET_TYPE_COLUMN (gnome_scan_combo_box_widget_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;

#define GNOME_SCAN_TYPE_OPTION_ENUM (gnome_scan_option_enum_get_type ())
#define GNOME_SCAN_OPTION_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnum))
#define GNOME_SCAN_OPTION_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumClass))
#define GNOME_SCAN_IS_OPTION_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_ENUM))
#define GNOME_SCAN_IS_OPTION_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_ENUM))
#define GNOME_SCAN_OPTION_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumClass))

typedef struct _GnomeScanOptionEnum GnomeScanOptionEnum;
typedef struct _GnomeScanOptionEnumClass GnomeScanOptionEnumClass;

#define GNOME_SCAN_TYPE_ENUM_VALUE (gnome_scan_enum_value_get_type ())
typedef struct _GnomeScanEnumValue GnomeScanEnumValue;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GnomeScanOptionWidget {
	GtkHBox parent_instance;
	GnomeScanOptionWidgetPrivate * priv;
};

struct _GnomeScanOptionWidgetClass {
	GtkHBoxClass parent_class;
};

struct _GnomeScanComboBoxWidget {
	GnomeScanOptionWidget parent_instance;
	GnomeScanComboBoxWidgetPrivate * priv;
};

struct _GnomeScanComboBoxWidgetClass {
	GnomeScanOptionWidgetClass parent_class;
};

struct _GnomeScanComboBoxWidgetPrivate {
	GtkListStore* store;
	GtkComboBox* combo;
	GHashTable* strings;
};

typedef enum  {
	GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LABEL,
	GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LENGTH
} GnomeScanComboBoxWidgetColumn;

struct _GnomeScanEnumValue {
	GValue value;
	char* label;
	char* domain;
};


static gpointer gnome_scan_combo_box_widget_parent_class = NULL;

GType gnome_scan_option_widget_get_type (void);
GType gnome_scan_combo_box_widget_get_type (void);
#define GNOME_SCAN_COMBO_BOX_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET, GnomeScanComboBoxWidgetPrivate))
enum  {
	GNOME_SCAN_COMBO_BOX_WIDGET_DUMMY_PROPERTY
};
static GType gnome_scan_combo_box_widget_column_get_type (void);
GType gnome_scan_option_get_type (void);
GnomeScanOption* gnome_scan_option_widget_get_option (GnomeScanOptionWidget* self);
GType gnome_scan_option_enum_get_type (void);
GType gnome_scan_enum_value_get_type (void);
GnomeScanEnumValue* gnome_scan_enum_value_dup (const GnomeScanEnumValue* self);
void gnome_scan_enum_value_free (GnomeScanEnumValue* self);
void gnome_scan_enum_value_copy (const GnomeScanEnumValue* self, GnomeScanEnumValue* dest);
void gnome_scan_enum_value_destroy (GnomeScanEnumValue* self);
GSList* gnome_scan_option_enum_get_values (GnomeScanOptionEnum* self);
void gnome_scan_option_enum_set_value (GnomeScanOptionEnum* self, GnomeScanEnumValue* value);
static void gnome_scan_combo_box_widget_on_combo_changed (GnomeScanComboBoxWidget* self);
void gnome_scan_option_enum_get_value (GnomeScanOptionEnum* self, GnomeScanEnumValue* result);
static void gnome_scan_combo_box_widget_on_option_changed (GnomeScanComboBoxWidget* self);
GnomeScanComboBoxWidget* gnome_scan_combo_box_widget_new (void);
GnomeScanComboBoxWidget* gnome_scan_combo_box_widget_construct (GType object_type);
static void _gnome_scan_combo_box_widget_on_combo_changed_g_object_notify (GtkComboBox* _sender, GParamSpec* pspec, gpointer self);
static void _gnome_scan_combo_box_widget_on_option_changed_g_object_notify (GnomeScanOptionEnum* _sender, GParamSpec* pspec, gpointer self);
static GObject * gnome_scan_combo_box_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gnome_scan_combo_box_widget_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);




static GType gnome_scan_combo_box_widget_column_get_type (void) {
	static GType gnome_scan_combo_box_widget_column_type_id = 0;
	if (G_UNLIKELY (gnome_scan_combo_box_widget_column_type_id == 0)) {
		static const GEnumValue values[] = {{GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LABEL, "GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LABEL", "label"}, {GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LENGTH, "GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LENGTH", "length"}, {0, NULL, NULL}};
		gnome_scan_combo_box_widget_column_type_id = g_enum_register_static ("GnomeScanComboBoxWidgetColumn", values);
	}
	return gnome_scan_combo_box_widget_column_type_id;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gnome_scan_combo_box_widget_on_combo_changed (GnomeScanComboBoxWidget* self) {
	GtkTreeIter iter = {0};
	const char* label;
	GnomeScanOption* _tmp0_;
	GnomeScanOptionEnum* option;
	g_return_if_fail (self != NULL);
	label = NULL;
	gtk_combo_box_get_active_iter (self->priv->combo, &iter);
	gtk_tree_model_get ((GtkTreeModel*) self->priv->store, &iter, GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LABEL, &label, -1);
	g_object_freeze_notify ((GObject*) gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self));
	option = _g_object_ref0 ((_tmp0_ = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_ENUM (_tmp0_) ? ((GnomeScanOptionEnum*) _tmp0_) : NULL));
	{
		GSList* value_collection;
		GSList* value_it;
		value_collection = gnome_scan_option_enum_get_values (option);
		for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
			GnomeScanEnumValue _tmp1_ = {0};
			GnomeScanEnumValue value;
			value = (gnome_scan_enum_value_copy (&(*((GnomeScanEnumValue*) value_it->data)), &_tmp1_), _tmp1_);
			{
				if (_vala_strcmp0 (value.label, label) == 0) {
					gnome_scan_option_enum_set_value (option, &value);
				}
				gnome_scan_enum_value_destroy (&value);
			}
		}
	}
	g_object_thaw_notify ((GObject*) option);
	_g_object_unref0 (option);
}


static void gnome_scan_combo_box_widget_on_option_changed (GnomeScanComboBoxWidget* self) {
	GtkTreeIter iter = {0};
	GnomeScanOption* _tmp0_;
	GnomeScanOptionEnum* option;
	GnomeScanEnumValue _tmp1_ = {0};
	char* str;
	g_return_if_fail (self != NULL);
	option = _g_object_ref0 ((_tmp0_ = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_ENUM (_tmp0_) ? ((GnomeScanOptionEnum*) _tmp0_) : NULL));
	str = g_strdup ((const char*) g_hash_table_lookup (self->priv->strings, (gnome_scan_option_enum_get_value (option, &_tmp1_), _tmp1_).label));
	if (str == NULL) {
		GnomeScanEnumValue _tmp2_ = {0};
		g_debug ("gnome-scan-combo-box-widget.vala:93: No path for '%s' value", (gnome_scan_option_enum_get_value (option, &_tmp2_), _tmp2_).label);
		_g_object_unref0 (option);
		_g_free0 (str);
		return;
	}
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->store, &iter, str);
	g_object_freeze_notify ((GObject*) self->priv->combo);
	gtk_combo_box_set_active_iter (self->priv->combo, &iter);
	g_object_thaw_notify ((GObject*) self->priv->combo);
	_g_object_unref0 (option);
	_g_free0 (str);
}


GnomeScanComboBoxWidget* gnome_scan_combo_box_widget_construct (GType object_type) {
	GnomeScanComboBoxWidget * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GnomeScanComboBoxWidget* gnome_scan_combo_box_widget_new (void) {
	return gnome_scan_combo_box_widget_construct (GNOME_SCAN_TYPE_COMBO_BOX_WIDGET);
}


static void _gnome_scan_combo_box_widget_on_combo_changed_g_object_notify (GtkComboBox* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_combo_box_widget_on_combo_changed (self);
}


static void _gnome_scan_combo_box_widget_on_option_changed_g_object_notify (GnomeScanOptionEnum* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_combo_box_widget_on_option_changed (self);
}


static GObject * gnome_scan_combo_box_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanComboBoxWidgetClass * klass;
	GObjectClass * parent_class;
	GnomeScanComboBoxWidget * self;
	klass = GNOME_SCAN_COMBO_BOX_WIDGET_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_COMBO_BOX_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_COMBO_BOX_WIDGET (obj);
	{
		GtkTreeIter iter = {0};
		GtkCellRenderer* renderer;
		GHashTable* _tmp0_;
		GtkListStore* _tmp1_;
		GtkComboBox* _tmp2_;
		GtkCellRenderer* _tmp3_;
		GnomeScanOption* _tmp4_;
		GnomeScanOptionEnum* option;
		GnomeScanEnumValue _tmp5_ = {0};
		GnomeScanEnumValue curval;
		renderer = NULL;
		self->priv->strings = (_tmp0_ = g_hash_table_new (g_str_hash, g_str_equal), _g_hash_table_unref0 (self->priv->strings), _tmp0_);
		self->priv->store = (_tmp1_ = gtk_list_store_new ((gint) GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LENGTH, G_TYPE_STRING, NULL), _g_object_unref0 (self->priv->store), _tmp1_);
		self->priv->combo = (_tmp2_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) self->priv->store)), _g_object_unref0 (self->priv->combo), _tmp2_);
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->combo, FALSE, TRUE, (guint) 0);
		renderer = (_tmp3_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp3_);
		gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combo, renderer, TRUE);
		gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combo, renderer, "text", GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LABEL, NULL);
		option = _g_object_ref0 ((_tmp4_ = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_ENUM (_tmp4_) ? ((GnomeScanOptionEnum*) _tmp4_) : NULL));
		curval = (gnome_scan_option_enum_get_value (option, &_tmp5_), _tmp5_);
		{
			GSList* value_collection;
			GSList* value_it;
			value_collection = gnome_scan_option_enum_get_values (option);
			for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
				GnomeScanEnumValue _tmp6_ = {0};
				GnomeScanEnumValue value;
				value = (gnome_scan_enum_value_copy (&(*((GnomeScanEnumValue*) value_it->data)), &_tmp6_), _tmp6_);
				{
					gtk_list_store_append (self->priv->store, &iter);
					gtk_list_store_set (self->priv->store, &iter, GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LABEL, value.label, -1);
					g_hash_table_insert (self->priv->strings, g_strdup (value.label), gtk_tree_model_get_string_from_iter ((GtkTreeModel*) self->priv->store, &iter));
					if (_vala_strcmp0 (value.label, curval.label) == 0) {
						gtk_combo_box_set_active_iter (self->priv->combo, &iter);
					}
					gnome_scan_enum_value_destroy (&value);
				}
			}
		}
		g_signal_connect_object ((GObject*) self->priv->combo, "notify::active", (GCallback) _gnome_scan_combo_box_widget_on_combo_changed_g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) option, "notify::value", (GCallback) _gnome_scan_combo_box_widget_on_option_changed_g_object_notify, self, 0);
		if (g_slist_length (gnome_scan_option_enum_get_values (option)) <= 1) {
			gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
		}
		_g_object_unref0 (renderer);
		_g_object_unref0 (option);
	}
	return obj;
}


static void gnome_scan_combo_box_widget_class_init (GnomeScanComboBoxWidgetClass * klass) {
	gnome_scan_combo_box_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanComboBoxWidgetPrivate));
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_combo_box_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_combo_box_widget_finalize;
}


static void gnome_scan_combo_box_widget_instance_init (GnomeScanComboBoxWidget * self) {
	self->priv = GNOME_SCAN_COMBO_BOX_WIDGET_GET_PRIVATE (self);
}


static void gnome_scan_combo_box_widget_finalize (GObject* obj) {
	GnomeScanComboBoxWidget * self;
	self = GNOME_SCAN_COMBO_BOX_WIDGET (obj);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->combo);
	_g_hash_table_unref0 (self->priv->strings);
	G_OBJECT_CLASS (gnome_scan_combo_box_widget_parent_class)->finalize (obj);
}


GType gnome_scan_combo_box_widget_get_type (void) {
	static GType gnome_scan_combo_box_widget_type_id = 0;
	if (gnome_scan_combo_box_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanComboBoxWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_combo_box_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanComboBoxWidget), 0, (GInstanceInitFunc) gnome_scan_combo_box_widget_instance_init, NULL };
		gnome_scan_combo_box_widget_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION_WIDGET, "GnomeScanComboBoxWidget", &g_define_type_info, 0);
	}
	return gnome_scan_combo_box_widget_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




