/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define GNOME_SCAN_TYPE_PAGES (gnome_scan_pages_get_type ())

#define GNOME_SCAN_TYPE_DIALOG (gnome_scan_dialog_get_type ())
#define GNOME_SCAN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_DIALOG, GnomeScanDialog))
#define GNOME_SCAN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_DIALOG, GnomeScanDialogClass))
#define GNOME_SCAN_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_DIALOG))
#define GNOME_SCAN_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_DIALOG))
#define GNOME_SCAN_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_DIALOG, GnomeScanDialogClass))

typedef struct _GnomeScanDialog GnomeScanDialog;
typedef struct _GnomeScanDialogClass GnomeScanDialogClass;
typedef struct _GnomeScanDialogPrivate GnomeScanDialogPrivate;

#define GNOME_SCAN_TYPE_JOB (gnome_scan_job_get_type ())
#define GNOME_SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_JOB, GnomeScanJob))
#define GNOME_SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_JOB, GnomeScanJobClass))
#define GNOME_SCAN_IS_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_JOB))
#define GNOME_SCAN_IS_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_JOB))
#define GNOME_SCAN_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_JOB, GnomeScanJobClass))

typedef struct _GnomeScanJob GnomeScanJob;
typedef struct _GnomeScanJobClass GnomeScanJobClass;

#define GNOME_SCAN_TYPE_ACQUISITION_WIDGET (gnome_scan_acquisition_widget_get_type ())
#define GNOME_SCAN_ACQUISITION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_ACQUISITION_WIDGET, GnomeScanAcquisitionWidget))
#define GNOME_SCAN_ACQUISITION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_ACQUISITION_WIDGET, GnomeScanAcquisitionWidgetClass))
#define GNOME_SCAN_IS_ACQUISITION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_ACQUISITION_WIDGET))
#define GNOME_SCAN_IS_ACQUISITION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_ACQUISITION_WIDGET))
#define GNOME_SCAN_ACQUISITION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_ACQUISITION_WIDGET, GnomeScanAcquisitionWidgetClass))

typedef struct _GnomeScanAcquisitionWidget GnomeScanAcquisitionWidget;
typedef struct _GnomeScanAcquisitionWidgetClass GnomeScanAcquisitionWidgetClass;

#define GNOME_SCAN_TYPE_NODE (gnome_scan_node_get_type ())
#define GNOME_SCAN_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_NODE, GnomeScanNode))
#define GNOME_SCAN_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_NODE, GnomeScanNodeClass))
#define GNOME_SCAN_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_NODE))
#define GNOME_SCAN_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_NODE))
#define GNOME_SCAN_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_NODE, GnomeScanNodeClass))

typedef struct _GnomeScanNode GnomeScanNode;
typedef struct _GnomeScanNodeClass GnomeScanNodeClass;

#define GNOME_SCAN_TYPE_SCANNER_SELECTOR (gnome_scan_scanner_selector_get_type ())
#define GNOME_SCAN_SCANNER_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SCANNER_SELECTOR, GnomeScanScannerSelector))
#define GNOME_SCAN_SCANNER_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SCANNER_SELECTOR, GnomeScanScannerSelectorClass))
#define GNOME_SCAN_IS_SCANNER_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SCANNER_SELECTOR))
#define GNOME_SCAN_IS_SCANNER_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SCANNER_SELECTOR))
#define GNOME_SCAN_SCANNER_SELECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SCANNER_SELECTOR, GnomeScanScannerSelectorClass))

typedef struct _GnomeScanScannerSelector GnomeScanScannerSelector;
typedef struct _GnomeScanScannerSelectorClass GnomeScanScannerSelectorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gdk_cursor_unref0(var) ((var == NULL) ? NULL : (var = (gdk_cursor_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GNOME_SCAN_TYPE_OPTION_PAGE (gnome_scan_option_page_get_type ())
#define GNOME_SCAN_OPTION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_PAGE, GnomeScanOptionPage))
#define GNOME_SCAN_OPTION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_PAGE, GnomeScanOptionPageClass))
#define GNOME_SCAN_IS_OPTION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_PAGE))
#define GNOME_SCAN_IS_OPTION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_PAGE))
#define GNOME_SCAN_OPTION_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_PAGE, GnomeScanOptionPageClass))

typedef struct _GnomeScanOptionPage GnomeScanOptionPage;
typedef struct _GnomeScanOptionPageClass GnomeScanOptionPageClass;

#define GNOME_SCAN_TYPE_OPTION_HPAGE (gnome_scan_option_hpage_get_type ())
#define GNOME_SCAN_OPTION_HPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_HPAGE, GnomeScanOptionHPage))
#define GNOME_SCAN_OPTION_HPAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_HPAGE, GnomeScanOptionHPageClass))
#define GNOME_SCAN_IS_OPTION_HPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_HPAGE))
#define GNOME_SCAN_IS_OPTION_HPAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_HPAGE))
#define GNOME_SCAN_OPTION_HPAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_HPAGE, GnomeScanOptionHPageClass))

typedef struct _GnomeScanOptionHPage GnomeScanOptionHPage;
typedef struct _GnomeScanOptionHPageClass GnomeScanOptionHPageClass;

#define GNOME_SCAN_TYPE_OPTION_VPAGE (gnome_scan_option_vpage_get_type ())
#define GNOME_SCAN_OPTION_VPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_VPAGE, GnomeScanOptionVPage))
#define GNOME_SCAN_OPTION_VPAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_VPAGE, GnomeScanOptionVPageClass))
#define GNOME_SCAN_IS_OPTION_VPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_VPAGE))
#define GNOME_SCAN_IS_OPTION_VPAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_VPAGE))
#define GNOME_SCAN_OPTION_VPAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_VPAGE, GnomeScanOptionVPageClass))

typedef struct _GnomeScanOptionVPage GnomeScanOptionVPage;
typedef struct _GnomeScanOptionVPageClass GnomeScanOptionVPageClass;

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;

#define GNOME_SCAN_TYPE_OPTION_HINT (gnome_scan_option_hint_get_type ())

#define GNOME_SCAN_TYPE_SCANNER (gnome_scan_scanner_get_type ())
#define GNOME_SCAN_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SCANNER, GnomeScanScanner))
#define GNOME_SCAN_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SCANNER, GnomeScanScannerClass))
#define GNOME_SCAN_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SCANNER))
#define GNOME_SCAN_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SCANNER))
#define GNOME_SCAN_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SCANNER, GnomeScanScannerClass))

typedef struct _GnomeScanScanner GnomeScanScanner;
typedef struct _GnomeScanScannerClass GnomeScanScannerClass;

#define GNOME_SCAN_TYPE_SINK (gnome_scan_sink_get_type ())
#define GNOME_SCAN_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SINK, GnomeScanSink))
#define GNOME_SCAN_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SINK, GnomeScanSinkClass))
#define GNOME_SCAN_IS_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SINK))
#define GNOME_SCAN_IS_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SINK))
#define GNOME_SCAN_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SINK, GnomeScanSinkClass))

typedef struct _GnomeScanSink GnomeScanSink;
typedef struct _GnomeScanSinkClass GnomeScanSinkClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GNOME_SCAN_TYPE_STATUS (gnome_scan_status_get_type ())

typedef enum  {
	GNOME_SCAN_PAGES_GENERAL,
	GNOME_SCAN_PAGES_FRONT_SCANNER,
	GNOME_SCAN_PAGES_FRONT_SINK,
	GNOME_SCAN_PAGES_PREVIEW,
	GNOME_SCAN_PAGES_ADVANCED,
	GNOME_SCAN_PAGES_PROCESSING,
	GNOME_SCAN_PAGES_OUTPUT,
	GNOME_SCAN_PAGES_ACQUISITION,
	GNOME_SCAN_PAGES_LAST
} GnomeScanPages;

struct _GnomeScanDialog {
	GtkWindow parent_instance;
	GnomeScanDialogPrivate * priv;
};

struct _GnomeScanDialogClass {
	GtkWindowClass parent_class;
};

struct _GnomeScanDialogPrivate {
	GnomeScanJob* _job;
	GtkNotebook* notebook;
	GtkBox* acquisition_page;
	GnomeScanAcquisitionWidget* acquisitor;
	GtkButton* bcancel;
	GtkButton* bclose;
	GtkButton* bscan;
	GtkButton* bnext;
	GtkButton* bback;
	GtkWidget** pages;
	gint pages_length1;
	gint pages_size;
	GnomeScanNode* scanner;
	GnomeScanScannerSelector* selector;
};

typedef enum  {
	GNOME_SCAN_OPTION_HINT_HIDDEN,
	GNOME_SCAN_OPTION_HINT_PRIMARY,
	GNOME_SCAN_OPTION_HINT_SECONDARY,
	GNOME_SCAN_OPTION_HINT_PREVIEW,
	GNOME_SCAN_OPTION_HINT_REPEAT
} GnomeScanOptionHint;

typedef enum  {
	GNOME_SCAN_STATUS_UNKNOWN = 0,
	GNOME_SCAN_STATUS_FAILED = 100,
	GNOME_SCAN_STATUS_INITIALIZING = 200,
	GNOME_SCAN_STATUS_BUSY = 300,
	GNOME_SCAN_STATUS_UNCONFIGURED = 400,
	GNOME_SCAN_STATUS_READY = 500,
	GNOME_SCAN_STATUS_PROCESSING = 600,
	GNOME_SCAN_STATUS_DONE = 700
} GnomeScanStatus;


static gpointer gnome_scan_dialog_parent_class = NULL;

GType gnome_scan_pages_get_type (void);
GType gnome_scan_dialog_get_type (void);
GType gnome_scan_job_get_type (void);
GType gnome_scan_acquisition_widget_get_type (void);
GType gnome_scan_node_get_type (void);
GType gnome_scan_scanner_selector_get_type (void);
#define GNOME_SCAN_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_DIALOG, GnomeScanDialogPrivate))
enum  {
	GNOME_SCAN_DIALOG_DUMMY_PROPERTY,
	GNOME_SCAN_DIALOG_JOB
};
void gnome_scan_dialog_set_job (GnomeScanDialog* self, GnomeScanJob* value);
GnomeScanDialog* gnome_scan_dialog_new (GtkWindow* parent, GnomeScanJob* job);
GnomeScanDialog* gnome_scan_dialog_construct (GType object_type, GtkWindow* parent, GnomeScanJob* job);
void gnome_scan_scanner_selector_probe_scanners (GnomeScanScannerSelector* self);
static void gnome_scan_dialog_init_buttons (GnomeScanDialog* self);
void gnome_scan_dialog_run (GnomeScanDialog* self);
static GtkButton* gnome_scan_dialog_add_button (GnomeScanDialog* self, GtkBox* button_box, const char* stock_id);
static void gnome_scan_dialog_on_button_close_clicked (GnomeScanDialog* self, GtkButton* button);
static void _gnome_scan_dialog_on_button_close_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void gnome_scan_dialog_on_button_scan_clicked (GnomeScanDialog* self, GtkButton* button);
static void _gnome_scan_dialog_on_button_scan_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void gnome_scan_dialog_on_button_back_clicked (GnomeScanDialog* self, GtkButton* button);
static void _gnome_scan_dialog_on_button_back_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void gnome_scan_dialog_on_button_cancel_clicked (GnomeScanDialog* self, GtkButton* button);
static void _gnome_scan_dialog_on_button_cancel_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void gnome_scan_dialog_on_button_next_clicked (GnomeScanDialog* self, GtkButton* button);
static void _gnome_scan_dialog_on_button_next_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void gnome_scan_dialog_add_buttons (GnomeScanDialog* self, GtkBox* container);
static void gnome_scan_dialog_build_general_tab (GnomeScanDialog* self);
static void gnome_scan_dialog_build_scanner_page (GnomeScanDialog* self);
static void gnome_scan_dialog_build_sink_page (GnomeScanDialog* self);
static void gnome_scan_dialog_build_option_page (GnomeScanDialog* self, GnomeScanPages page_id);
static void gnome_scan_dialog_build_acquisition_page (GnomeScanDialog* self);
char* gnome_scan_enum_get_nick (GType enum_type, gint value);
static GtkWidget* gnome_scan_dialog_build_page (GnomeScanDialog* self, GnomeScanPages page_id);
GnomeScanJob* gnome_scan_dialog_get_job (GnomeScanDialog* self);
GnomeScanScannerSelector* gnome_scan_scanner_selector_new (GnomeScanJob* job);
GnomeScanScannerSelector* gnome_scan_scanner_selector_construct (GType object_type, GnomeScanJob* job);
static void gnome_scan_dialog_on_probe_done (GnomeScanDialog* self, GnomeScanScannerSelector* selector);
static void _gnome_scan_dialog_on_probe_done_gnome_scan_scanner_selector_probe_done (GnomeScanScannerSelector* _sender, gpointer self);
static void gnome_scan_dialog_append_page (GnomeScanDialog* self, gint tab, const char* label, GtkContainer* page);
GnomeScanOptionHPage* gnome_scan_option_hpage_new (void);
GnomeScanOptionHPage* gnome_scan_option_hpage_construct (GType object_type);
GType gnome_scan_option_page_get_type (void);
GType gnome_scan_option_hpage_get_type (void);
GnomeScanAcquisitionWidget* gnome_scan_acquisition_widget_new (GnomeScanJob* job, const char* primary, const char* secondary, const char* icon_name);
GnomeScanAcquisitionWidget* gnome_scan_acquisition_widget_construct (GType object_type, GnomeScanJob* job, const char* primary, const char* secondary, const char* icon_name);
GnomeScanOptionVPage* gnome_scan_option_vpage_new (gboolean scrolled);
GnomeScanOptionVPage* gnome_scan_option_vpage_construct (GType object_type, gboolean scrolled);
GType gnome_scan_option_vpage_get_type (void);
GType gnome_scan_option_get_type (void);
GSList* gnome_scan_node_get_options (GnomeScanNode* self);
GType gnome_scan_option_hint_get_type (void);
GnomeScanOptionHint gnome_scan_option_get_hint (GnomeScanOption* self);
static GnomeScanPages gnome_scan_dialog_get_page_id_for_option (GnomeScanDialog* self, GnomeScanNode* node, GnomeScanOption* option);
void gnome_scan_option_page_pack_option (GnomeScanOptionPage* self, GnomeScanOption* option);
static void gnome_scan_dialog_build_node_ui (GnomeScanDialog* self, GnomeScanNode* node);
void gnome_scan_option_page_unpack_option (GnomeScanOptionPage* self, GnomeScanOption* option);
static void gnome_scan_dialog_destroy_node_ui (GnomeScanDialog* self, GnomeScanNode* node);
const char* gnome_scan_option_get_name (GnomeScanOption* self);
GType gnome_scan_scanner_get_type (void);
GType gnome_scan_sink_get_type (void);
gboolean gnome_scan_acquisition_widget_monitor_job (GnomeScanAcquisitionWidget* self);
static gboolean _gnome_scan_acquisition_widget_monitor_job_gsource_func (gpointer self);
static void* gnome_scan_dialog_job_run_thread (GnomeScanDialog* self);
static void* _gnome_scan_dialog_job_run_thread_gthread_func (gpointer self);
static void gnome_scan_dialog_scan (GnomeScanDialog* self);
static void gnome_scan_dialog_back (GnomeScanDialog* self);
static void gnome_scan_dialog_close (GnomeScanDialog* self);
void gnome_scan_job_run (GnomeScanJob* self);
GnomeScanScanner* gnome_scan_job_get_scanner (GnomeScanJob* self);
static void gnome_scan_dialog_on_scanner_selected (GnomeScanDialog* self, GnomeScanJob* job, GParamSpec* pspec);
GType gnome_scan_status_get_type (void);
GnomeScanStatus gnome_scan_job_get_status (GnomeScanJob* self);
static void gnome_scan_dialog_on_status_changed (GnomeScanDialog* self, GnomeScanJob* job, GParamSpec* pspec);
void gnome_scan_job_cancel (GnomeScanJob* self);
void gnome_scan_job_end (GnomeScanJob* self);
static gboolean gnome_scan_dialog_on_window_delete_event (GnomeScanDialog* self, GnomeScanDialog* window, GdkEvent* evt);
static gboolean _gnome_scan_dialog_on_window_delete_event_gtk_widget_delete_event (GnomeScanDialog* _sender, GdkEvent* event, gpointer self);
static void _gnome_scan_dialog_on_scanner_selected_g_object_notify (GnomeScanJob* _sender, GParamSpec* pspec, gpointer self);
static void _gnome_scan_dialog_on_status_changed_g_object_notify (GnomeScanJob* _sender, GParamSpec* pspec, gpointer self);
GnomeScanSink* gnome_scan_job_get_sink (GnomeScanJob* self);
static GObject * gnome_scan_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gnome_scan_dialog_finalize (GObject* obj);
static void gnome_scan_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);




GType gnome_scan_pages_get_type (void) {
	static GType gnome_scan_pages_type_id = 0;
	if (G_UNLIKELY (gnome_scan_pages_type_id == 0)) {
		static const GEnumValue values[] = {{GNOME_SCAN_PAGES_GENERAL, "GNOME_SCAN_PAGES_GENERAL", "general"}, {GNOME_SCAN_PAGES_FRONT_SCANNER, "GNOME_SCAN_PAGES_FRONT_SCANNER", "front-scanner"}, {GNOME_SCAN_PAGES_FRONT_SINK, "GNOME_SCAN_PAGES_FRONT_SINK", "front-sink"}, {GNOME_SCAN_PAGES_PREVIEW, "GNOME_SCAN_PAGES_PREVIEW", "preview"}, {GNOME_SCAN_PAGES_ADVANCED, "GNOME_SCAN_PAGES_ADVANCED", "advanced"}, {GNOME_SCAN_PAGES_PROCESSING, "GNOME_SCAN_PAGES_PROCESSING", "processing"}, {GNOME_SCAN_PAGES_OUTPUT, "GNOME_SCAN_PAGES_OUTPUT", "output"}, {GNOME_SCAN_PAGES_ACQUISITION, "GNOME_SCAN_PAGES_ACQUISITION", "acquisition"}, {GNOME_SCAN_PAGES_LAST, "GNOME_SCAN_PAGES_LAST", "last"}, {0, NULL, NULL}};
		gnome_scan_pages_type_id = g_enum_register_static ("GnomeScanPages", values);
	}
	return gnome_scan_pages_type_id;
}


GnomeScanDialog* gnome_scan_dialog_construct (GType object_type, GtkWindow* parent, GnomeScanJob* job) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanDialog * self;
	g_return_val_if_fail (job != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "job";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_JOB);
	g_value_set_object (&__params_it->value, job);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	if (parent != NULL) {
		gtk_window_set_transient_for ((GtkWindow*) self, parent);
		g_object_set ((GtkWindow*) self, "window-position", GTK_WIN_POS_CENTER_ON_PARENT, NULL);
	}
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanDialog* gnome_scan_dialog_new (GtkWindow* parent, GnomeScanJob* job) {
	return gnome_scan_dialog_construct (GNOME_SCAN_TYPE_DIALOG, parent, job);
}


void gnome_scan_dialog_run (GnomeScanDialog* self) {
	GdkCursor* _tmp0_;
	g_return_if_fail (self != NULL);
	gnome_scan_scanner_selector_probe_scanners (self->priv->selector);
	gnome_scan_dialog_init_buttons (self);
	gtk_widget_show_all ((GtkWidget*) self);
	gdk_window_set_cursor (((GtkWidget*) self)->window, _tmp0_ = gdk_cursor_new (GDK_WATCH));
	_gdk_cursor_unref0 (_tmp0_);
	gtk_main ();
}


static void _gnome_scan_dialog_on_button_close_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gnome_scan_dialog_on_button_close_clicked (self, _sender);
}


static void _gnome_scan_dialog_on_button_scan_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gnome_scan_dialog_on_button_scan_clicked (self, _sender);
}


static void _gnome_scan_dialog_on_button_back_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gnome_scan_dialog_on_button_back_clicked (self, _sender);
}


static void _gnome_scan_dialog_on_button_cancel_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gnome_scan_dialog_on_button_cancel_clicked (self, _sender);
}


static void _gnome_scan_dialog_on_button_next_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gnome_scan_dialog_on_button_next_clicked (self, _sender);
}


static void gnome_scan_dialog_add_buttons (GnomeScanDialog* self, GtkBox* container) {
	GtkButtonBox* button_box;
	GtkButtonBox* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	button_box = NULL;
	button_box = (_tmp0_ = (GtkButtonBox*) g_object_ref_sink ((GtkHButtonBox*) gtk_hbutton_box_new ()), _g_object_unref0 (button_box), _tmp0_);
	gtk_box_set_spacing ((GtkBox*) button_box, 6);
	g_object_set (button_box, "layout-style", GTK_BUTTONBOX_END, NULL);
	gtk_box_pack_start (container, (GtkWidget*) button_box, FALSE, TRUE, (guint) 0);
	self->priv->bclose = (_tmp1_ = gnome_scan_dialog_add_button (self, (GtkBox*) button_box, GTK_STOCK_CLOSE), _g_object_unref0 (self->priv->bclose), _tmp1_);
	g_signal_connect_object (self->priv->bclose, "clicked", (GCallback) _gnome_scan_dialog_on_button_close_clicked_gtk_button_clicked, self, 0);
	self->priv->bscan = (_tmp2_ = gnome_scan_dialog_add_button (self, (GtkBox*) button_box, GTK_STOCK_APPLY), _g_object_unref0 (self->priv->bscan), _tmp2_);
	g_signal_connect_object (self->priv->bscan, "clicked", (GCallback) _gnome_scan_dialog_on_button_scan_clicked_gtk_button_clicked, self, 0);
	self->priv->bback = (_tmp3_ = gnome_scan_dialog_add_button (self, (GtkBox*) button_box, GTK_STOCK_EDIT), _g_object_unref0 (self->priv->bback), _tmp3_);
	g_signal_connect_object (self->priv->bback, "clicked", (GCallback) _gnome_scan_dialog_on_button_back_clicked_gtk_button_clicked, self, 0);
	self->priv->bcancel = (_tmp4_ = gnome_scan_dialog_add_button (self, (GtkBox*) button_box, GTK_STOCK_CANCEL), _g_object_unref0 (self->priv->bcancel), _tmp4_);
	g_signal_connect_object (self->priv->bcancel, "clicked", (GCallback) _gnome_scan_dialog_on_button_cancel_clicked_gtk_button_clicked, self, 0);
	self->priv->bnext = (_tmp5_ = gnome_scan_dialog_add_button (self, (GtkBox*) button_box, GTK_STOCK_GO_FORWARD), _g_object_unref0 (self->priv->bnext), _tmp5_);
	g_signal_connect_object (self->priv->bnext, "clicked", (GCallback) _gnome_scan_dialog_on_button_next_clicked_gtk_button_clicked, self, 0);
	_g_object_unref0 (button_box);
}


static GtkButton* gnome_scan_dialog_add_button (GnomeScanDialog* self, GtkBox* button_box, const char* stock_id) {
	GtkButton* result;
	GtkButton* button;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (button_box != NULL, NULL);
	g_return_val_if_fail (stock_id != NULL, NULL);
	button = g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock (stock_id));
	g_object_set ((GtkWidget*) button, "sensitive", FALSE, NULL);
	gtk_box_pack_start (button_box, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
	result = button;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GtkWidget* gnome_scan_dialog_build_page (GnomeScanDialog* self, GnomeScanPages page_id) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (GTK_IS_WIDGET (self->priv->pages[(gint) page_id])) {
		result = _g_object_ref0 (self->priv->pages[(gint) page_id]);
		return result;
	}
	switch (page_id) {
		case GNOME_SCAN_PAGES_GENERAL:
		{
			gnome_scan_dialog_build_general_tab (self);
			break;
		}
		case GNOME_SCAN_PAGES_FRONT_SCANNER:
		{
			gnome_scan_dialog_build_scanner_page (self);
			break;
		}
		case GNOME_SCAN_PAGES_FRONT_SINK:
		{
			gnome_scan_dialog_build_sink_page (self);
			break;
		}
		case GNOME_SCAN_PAGES_ADVANCED:
		case GNOME_SCAN_PAGES_PROCESSING:
		case GNOME_SCAN_PAGES_OUTPUT:
		{
			gnome_scan_dialog_build_option_page (self, page_id);
			break;
		}
		case GNOME_SCAN_PAGES_ACQUISITION:
		{
			gnome_scan_dialog_build_acquisition_page (self);
			break;
		}
		default:
		{
			char* _tmp0_;
			g_warning ("gnome-scan-dialog.vala:181: Don't know how to build %s page", _tmp0_ = gnome_scan_enum_get_nick (GNOME_SCAN_TYPE_PAGES, (gint) page_id));
			_g_free0 (_tmp0_);
			break;
		}
	}
	result = _g_object_ref0 (self->priv->pages[(gint) page_id]);
	return result;
}


static void _gnome_scan_dialog_on_probe_done_gnome_scan_scanner_selector_probe_done (GnomeScanScannerSelector* _sender, gpointer self) {
	gnome_scan_dialog_on_probe_done (self, _sender);
}


static void gnome_scan_dialog_build_general_tab (GnomeScanDialog* self) {
	GtkVPaned* paned;
	GnomeScanScannerSelector* _tmp0_;
	GtkVBox* box;
	g_return_if_fail (self != NULL);
	paned = g_object_ref_sink ((GtkVPaned*) gtk_vpaned_new ());
	self->priv->selector = (_tmp0_ = g_object_ref_sink (gnome_scan_scanner_selector_new (self->priv->_job)), _g_object_unref0 (self->priv->selector), _tmp0_);
	gtk_container_set_border_width ((GtkContainer*) self->priv->selector, (guint) 6);
	g_signal_connect_object (self->priv->selector, "probe-done", (GCallback) _gnome_scan_dialog_on_probe_done_gnome_scan_scanner_selector_probe_done, self, 0);
	gtk_paned_pack1 ((GtkPaned*) paned, (GtkWidget*) self->priv->selector, TRUE, FALSE);
	gtk_container_set_border_width ((GtkContainer*) paned, (guint) 6);
	box = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	gtk_container_set_border_width ((GtkContainer*) box, (guint) 6);
	gtk_paned_pack2 ((GtkPaned*) paned, (GtkWidget*) box, FALSE, FALSE);
	gnome_scan_dialog_append_page (self, (gint) GNOME_SCAN_PAGES_GENERAL, _ ("_General"), (GtkContainer*) paned);
	_g_object_unref0 (paned);
	_g_object_unref0 (box);
}


static void gnome_scan_dialog_build_scanner_page (GnomeScanDialog* self) {
	GnomeScanOptionPage* opage;
	GtkWidget* _tmp0_;
	GtkPaned* paned;
	GtkWidget* _tmp1_;
	GtkBox* box;
	g_return_if_fail (self != NULL);
	opage = (GnomeScanOptionPage*) g_object_ref_sink (gnome_scan_option_hpage_new ());
	paned = _g_object_ref0 ((_tmp0_ = self->priv->pages[(gint) GNOME_SCAN_PAGES_GENERAL], GTK_IS_PANED (_tmp0_) ? ((GtkPaned*) _tmp0_) : NULL));
	box = _g_object_ref0 ((_tmp1_ = gtk_paned_get_child2 (paned), GTK_IS_BOX (_tmp1_) ? ((GtkBox*) _tmp1_) : NULL));
	gtk_box_pack_start (box, (GtkWidget*) opage, FALSE, TRUE, (guint) 0);
	gnome_scan_dialog_append_page (self, (gint) GNOME_SCAN_PAGES_FRONT_SCANNER, NULL, (GtkContainer*) opage);
	_g_object_unref0 (opage);
	_g_object_unref0 (paned);
	_g_object_unref0 (box);
}


static void gnome_scan_dialog_build_sink_page (GnomeScanDialog* self) {
	GnomeScanOptionPage* opage;
	GtkWidget* _tmp0_;
	GtkPaned* paned;
	GtkWidget* _tmp1_;
	GtkBox* box;
	g_return_if_fail (self != NULL);
	opage = (GnomeScanOptionPage*) g_object_ref_sink (gnome_scan_option_hpage_new ());
	paned = (_tmp0_ = self->priv->pages[(gint) GNOME_SCAN_PAGES_GENERAL], GTK_IS_PANED (_tmp0_) ? ((GtkPaned*) _tmp0_) : NULL);
	box = (_tmp1_ = gtk_paned_get_child2 (paned), GTK_IS_BOX (_tmp1_) ? ((GtkBox*) _tmp1_) : NULL);
	gtk_box_pack_start (box, (GtkWidget*) opage, FALSE, TRUE, (guint) 0);
	gnome_scan_dialog_append_page (self, (gint) GNOME_SCAN_PAGES_FRONT_SINK, NULL, (GtkContainer*) opage);
	_g_object_unref0 (opage);
}


static void gnome_scan_dialog_build_acquisition_page (GnomeScanDialog* self) {
	GnomeScanAcquisitionWidget* _tmp0_;
	GnomeScanOptionVPage* _tmp1_;
	GtkContainer* page;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->acquisitor = (_tmp0_ = g_object_ref_sink (gnome_scan_acquisition_widget_new (self->priv->_job, _ ("Acquisition"), _ ("The software now acquires and processes images according to settings."), "scanner")), _g_object_unref0 (self->priv->acquisitor), _tmp0_);
	gtk_box_pack_start (self->priv->acquisition_page, (GtkWidget*) self->priv->acquisitor, TRUE, TRUE, (guint) 0);
	page = (_tmp1_ = g_object_ref_sink (gnome_scan_option_vpage_new (FALSE)), GTK_IS_CONTAINER (_tmp1_) ? ((GtkContainer*) _tmp1_) : NULL);
	gtk_container_set_border_width (page, (guint) 12);
	gtk_box_pack_start (self->priv->acquisition_page, (GtkWidget*) page, FALSE, TRUE, (guint) 0);
	self->priv->pages[(gint) GNOME_SCAN_PAGES_ACQUISITION] = (_tmp2_ = _g_object_ref0 ((GtkWidget*) page), _g_object_unref0 (self->priv->pages[(gint) GNOME_SCAN_PAGES_ACQUISITION]), _tmp2_);
	_g_object_unref0 (page);
}


static void gnome_scan_dialog_build_option_page (GnomeScanDialog* self, GnomeScanPages page_id) {
	char* label;
	GnomeScanOptionVPage* _tmp3_;
	g_return_if_fail (self != NULL);
	label = NULL;
	switch (page_id) {
		case GNOME_SCAN_PAGES_ADVANCED:
		{
			char* _tmp0_;
			label = (_tmp0_ = g_strdup (_ ("_Advanced")), _g_free0 (label), _tmp0_);
			break;
		}
		case GNOME_SCAN_PAGES_PROCESSING:
		{
			char* _tmp1_;
			label = (_tmp1_ = g_strdup (_ ("_Processing")), _g_free0 (label), _tmp1_);
			break;
		}
		case GNOME_SCAN_PAGES_OUTPUT:
		{
			char* _tmp2_;
			label = (_tmp2_ = g_strdup (_ ("_Output")), _g_free0 (label), _tmp2_);
			break;
		}
		default:
		{
			_g_free0 (label);
			return;
		}
	}
	gnome_scan_dialog_append_page (self, (gint) page_id, label, (GtkContainer*) (_tmp3_ = g_object_ref_sink (gnome_scan_option_vpage_new (TRUE))));
	_g_object_unref0 (_tmp3_);
	_g_free0 (label);
}


static void gnome_scan_dialog_append_page (GnomeScanDialog* self, gint tab, const char* label, GtkContainer* page) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	if (self->priv->pages[tab] != NULL) {
		return;
	}
	if (label != NULL) {
		GtkWidget* tab_label;
		tab_label = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new_with_mnemonic (label));
		if (gtk_container_get_border_width (page) == 0) {
			gtk_container_set_border_width (page, (guint) 12);
		}
		gtk_notebook_append_page (self->priv->notebook, (GtkWidget*) page, tab_label);
		_g_object_unref0 (tab_label);
	}
	self->priv->pages[tab] = (_tmp0_ = _g_object_ref0 ((GtkWidget*) page), _g_object_unref0 (self->priv->pages[tab]), _tmp0_);
	gtk_widget_show_all ((GtkWidget*) page);
}


static void gnome_scan_dialog_build_node_ui (GnomeScanDialog* self, GnomeScanNode* node) {
	GnomeScanPages page_id;
	GnomeScanOptionPage* page;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	page_id = 0;
	page = NULL;
	{
		GSList* option_collection;
		GSList* option_it;
		option_collection = gnome_scan_node_get_options (node);
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			GnomeScanOption* option;
			option = (GnomeScanOption*) option_it->data;
			{
				GnomeScanOptionPage* _tmp1_;
				GtkWidget* _tmp0_;
				if (gnome_scan_option_get_hint (option) == GNOME_SCAN_OPTION_HINT_HIDDEN) {
					continue;
				}
				page_id = gnome_scan_dialog_get_page_id_for_option (self, node, option);
				page = (_tmp1_ = (_tmp0_ = gnome_scan_dialog_build_page (self, page_id), GNOME_SCAN_IS_OPTION_PAGE (_tmp0_) ? ((GnomeScanOptionPage*) _tmp0_) : NULL), _g_object_unref0 (page), _tmp1_);
				if (!GNOME_SCAN_IS_OPTION_PAGE (page)) {
					continue;
				}
				gnome_scan_option_page_pack_option (page, option);
				gtk_widget_show_all ((GtkWidget*) page);
			}
		}
	}
	_g_object_unref0 (page);
}


static void gnome_scan_dialog_destroy_node_ui (GnomeScanDialog* self, GnomeScanNode* node) {
	GnomeScanPages page_id;
	GnomeScanOptionPage* page;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	page_id = GNOME_SCAN_PAGES_ADVANCED;
	page = NULL;
	{
		GSList* option_collection;
		GSList* option_it;
		option_collection = gnome_scan_node_get_options (node);
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			GnomeScanOption* option;
			option = (GnomeScanOption*) option_it->data;
			{
				GtkWidget* _tmp0_;
				if (gnome_scan_option_get_hint (option) == GNOME_SCAN_OPTION_HINT_HIDDEN) {
					continue;
				}
				page_id = gnome_scan_dialog_get_page_id_for_option (self, node, option);
				page = (_tmp0_ = self->priv->pages[(gint) page_id], GNOME_SCAN_IS_OPTION_PAGE (_tmp0_) ? ((GnomeScanOptionPage*) _tmp0_) : NULL);
				gnome_scan_option_page_unpack_option (page, option);
				gtk_widget_show_all ((GtkWidget*) page);
			}
		}
	}
}


static GnomeScanPages gnome_scan_dialog_get_page_id_for_option (GnomeScanDialog* self, GnomeScanNode* node, GnomeScanOption* option) {
	GnomeScanPages result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (node != NULL, 0);
	g_return_val_if_fail (option != NULL, 0);
	switch (gnome_scan_option_get_hint (option)) {
		case GNOME_SCAN_OPTION_HINT_HIDDEN:
		{
			g_warning ("gnome-scan-dialog.vala:311: Option %s of node %s is hidden.", g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) node)), gnome_scan_option_get_name (option));
			result = GNOME_SCAN_PAGES_LAST;
			return result;
		}
		case GNOME_SCAN_OPTION_HINT_PRIMARY:
		case GNOME_SCAN_OPTION_HINT_REPEAT:
		{
			if (GNOME_SCAN_IS_SCANNER (node)) {
				result = GNOME_SCAN_PAGES_FRONT_SCANNER;
				return result;
			} else {
				if (GNOME_SCAN_IS_SINK (node)) {
					result = GNOME_SCAN_PAGES_FRONT_SINK;
					return result;
				} else {
					result = GNOME_SCAN_PAGES_ADVANCED;
					return result;
				}
			}
		}
		case GNOME_SCAN_OPTION_HINT_SECONDARY:
		{
			result = GNOME_SCAN_PAGES_ADVANCED;
			return result;
		}
		case GNOME_SCAN_OPTION_HINT_PREVIEW:
		{
			result = GNOME_SCAN_PAGES_PREVIEW;
			return result;
		}
	}
	result = GNOME_SCAN_PAGES_ADVANCED;
	return result;
}


static void gnome_scan_dialog_init_buttons (GnomeScanDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->bclose, FALSE);
	gtk_widget_show ((GtkWidget*) self->priv->bclose);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->bscan, FALSE);
	gtk_widget_show ((GtkWidget*) self->priv->bscan);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->bback, TRUE);
	gtk_widget_hide ((GtkWidget*) self->priv->bback);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->bcancel, TRUE);
	gtk_widget_hide ((GtkWidget*) self->priv->bcancel);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->bnext, TRUE);
	gtk_widget_hide ((GtkWidget*) self->priv->bnext);
}


static gboolean _gnome_scan_acquisition_widget_monitor_job_gsource_func (gpointer self) {
	return gnome_scan_acquisition_widget_monitor_job (self);
}


static void* _gnome_scan_dialog_job_run_thread_gthread_func (gpointer self) {
	return gnome_scan_dialog_job_run_thread (self);
}


static void gnome_scan_dialog_scan (GnomeScanDialog* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		g_timeout_add_full (0, (guint) 42, _gnome_scan_acquisition_widget_monitor_job_gsource_func, g_object_ref (self->priv->acquisitor), g_object_unref);
		g_thread_create (_gnome_scan_dialog_job_run_thread_gthread_func, self, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch4_g_thread_error;
			}
			goto __finally4;
		}
	}
	goto __finally4;
	__catch4_g_thread_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("gnome-scan-dialog.vala:352: Unable to create thread for acquiring");
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void gnome_scan_dialog_back (GnomeScanDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->notebook, FALSE);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->acquisition_page, TRUE);
	gtk_widget_hide ((GtkWidget*) self->priv->acquisition_page);
	gnome_scan_dialog_init_buttons (self);
	gtk_widget_show_all ((GtkWidget*) self->priv->notebook);
}


static void gnome_scan_dialog_close (GnomeScanDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_main_quit ();
}


static void* gnome_scan_dialog_job_run_thread (GnomeScanDialog* self) {
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	gnome_scan_job_run (self->priv->_job);
	result = NULL;
	return result;
}


static void gnome_scan_dialog_on_probe_done (GnomeScanDialog* self, GnomeScanScannerSelector* selector) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (selector != NULL);
	gdk_window_set_cursor (((GtkWidget*) self)->window, NULL);
}


static void gnome_scan_dialog_on_scanner_selected (GnomeScanDialog* self, GnomeScanJob* job, GParamSpec* pspec) {
	GnomeScanNode* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (job != NULL);
	g_return_if_fail (pspec != NULL);
	if (GNOME_SCAN_NODE (gnome_scan_job_get_scanner (job)) == self->priv->scanner) {
		return;
	}
	if (self->priv->scanner != NULL) {
		gnome_scan_dialog_destroy_node_ui (self, self->priv->scanner);
	}
	self->priv->scanner = (_tmp0_ = _g_object_ref0 ((GnomeScanNode*) gnome_scan_job_get_scanner (job)), _g_object_unref0 (self->priv->scanner), _tmp0_);
	if (self->priv->scanner != NULL) {
		gnome_scan_dialog_build_node_ui (self, self->priv->scanner);
	}
}


static void gnome_scan_dialog_on_status_changed (GnomeScanDialog* self, GnomeScanJob* job, GParamSpec* pspec) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (job != NULL);
	g_return_if_fail (pspec != NULL);
	g_debug ("gnome-scan-dialog.vala:400: job status updated to %s", _tmp0_ = gnome_scan_enum_get_nick (GNOME_SCAN_TYPE_STATUS, (gint) gnome_scan_job_get_status (job)));
	_g_free0 (_tmp0_);
	switch (gnome_scan_job_get_status (job)) {
		case GNOME_SCAN_STATUS_UNCONFIGURED:
		{
			g_object_set ((GtkWidget*) self->priv->bclose, "sensitive", TRUE, NULL);
			g_object_set ((GtkWidget*) self->priv->bscan, "sensitive", FALSE, NULL);
			break;
		}
		case GNOME_SCAN_STATUS_READY:
		{
			g_object_set ((GtkWidget*) self->priv->bclose, "sensitive", TRUE, NULL);
			g_object_set ((GtkWidget*) self->priv->bscan, "sensitive", TRUE, NULL);
			break;
		}
		case GNOME_SCAN_STATUS_PROCESSING:
		{
			g_object_set ((GtkWidget*) self->priv->bclose, "sensitive", FALSE, NULL);
			g_object_set ((GtkWidget*) self->priv->bscan, "sensitive", FALSE, NULL);
			gtk_widget_set_no_show_all ((GtkWidget*) self->priv->bscan, TRUE);
			gtk_widget_hide ((GtkWidget*) self->priv->bscan);
			gtk_widget_set_no_show_all ((GtkWidget*) self->priv->bcancel, FALSE);
			g_object_set ((GtkWidget*) self->priv->bcancel, "sensitive", TRUE, NULL);
			gtk_widget_set_no_show_all ((GtkWidget*) self->priv->bnext, FALSE);
			g_object_set ((GtkWidget*) self->priv->bnext, "sensitive", FALSE, NULL);
			gtk_widget_set_no_show_all ((GtkWidget*) self->priv->bback, FALSE);
			g_object_set ((GtkWidget*) self->priv->bback, "sensitive", FALSE, NULL);
			break;
		}
		case GNOME_SCAN_STATUS_DONE:
		{
			g_object_set ((GtkWidget*) self->priv->bclose, "sensitive", TRUE, NULL);
			g_object_set ((GtkWidget*) self->priv->bback, "sensitive", TRUE, NULL);
			g_object_set ((GtkWidget*) self->priv->bcancel, "sensitive", FALSE, NULL);
			g_object_set ((GtkWidget*) self->priv->bnext, "sensitive", TRUE, NULL);
			g_object_set ((GtkWidget*) self->priv->bscan, "sensitive", TRUE, NULL);
			break;
		}
		case GNOME_SCAN_STATUS_FAILED:
		{
			break;
		}
		default:
		{
			break;
		}
	}
	gtk_widget_show_all ((GtkWidget*) self);
}


static void gnome_scan_dialog_on_button_scan_clicked (GnomeScanDialog* self, GtkButton* button) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = gnome_scan_dialog_build_page (self, GNOME_SCAN_PAGES_ACQUISITION);
	_g_object_unref0 (_tmp0_);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->notebook, TRUE);
	gtk_widget_hide ((GtkWidget*) self->priv->notebook);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->acquisition_page, FALSE);
	gtk_widget_show_all ((GtkWidget*) self);
	gnome_scan_dialog_scan (self);
}


static void gnome_scan_dialog_on_button_next_clicked (GnomeScanDialog* self, GtkButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gnome_scan_dialog_scan (self);
}


static void gnome_scan_dialog_on_button_cancel_clicked (GnomeScanDialog* self, GtkButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gnome_scan_job_cancel (self->priv->_job);
	gnome_scan_dialog_back (self);
}


static void gnome_scan_dialog_on_button_back_clicked (GnomeScanDialog* self, GtkButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gnome_scan_job_end (self->priv->_job);
	gnome_scan_dialog_back (self);
}


static void gnome_scan_dialog_on_button_close_clicked (GnomeScanDialog* self, GtkButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gnome_scan_job_end (self->priv->_job);
	gnome_scan_dialog_close (self);
}


static gboolean gnome_scan_dialog_on_window_delete_event (GnomeScanDialog* self, GnomeScanDialog* window, GdkEvent* evt) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	gnome_scan_dialog_close (self);
	result = FALSE;
	return result;
}


GnomeScanJob* gnome_scan_dialog_get_job (GnomeScanDialog* self) {
	GnomeScanJob* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_job;
	return result;
}


void gnome_scan_dialog_set_job (GnomeScanDialog* self, GnomeScanJob* value) {
	GnomeScanJob* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_job = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_job), _tmp0_);
	g_object_notify ((GObject *) self, "job");
}


static gboolean _gnome_scan_dialog_on_window_delete_event_gtk_widget_delete_event (GnomeScanDialog* _sender, GdkEvent* event, gpointer self) {
	return gnome_scan_dialog_on_window_delete_event (self, _sender, event);
}


static void _gnome_scan_dialog_on_scanner_selected_g_object_notify (GnomeScanJob* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_dialog_on_scanner_selected (self, _sender, pspec);
}


static void _gnome_scan_dialog_on_status_changed_g_object_notify (GnomeScanJob* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_dialog_on_status_changed (self, _sender, pspec);
}


static GObject * gnome_scan_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanDialogClass * klass;
	GObjectClass * parent_class;
	GnomeScanDialog * self;
	klass = GNOME_SCAN_DIALOG_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_DIALOG));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_DIALOG (obj);
	{
		GtkBox* box;
		GtkBox* _tmp0_;
		GtkNotebook* _tmp1_;
		GtkBox* _tmp2_;
		GtkWidget** _tmp3_;
		box = NULL;
		gtk_container_set_border_width ((GtkContainer*) self, (guint) 6);
		g_object_set ((GtkWindow*) self, "default-width", 320, NULL);
		g_object_set ((GtkWindow*) self, "default-height", 440, NULL);
		gtk_window_set_icon_name ((GtkWindow*) self, "scanner");
		gtk_window_set_title ((GtkWindow*) self, _ ("Scan"));
		g_object_set ((GtkWindow*) self, "window-position", GTK_WIN_POS_CENTER, NULL);
		g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) _gnome_scan_dialog_on_window_delete_event_gtk_widget_delete_event, self, 0);
		gtk_window_set_type_hint ((GtkWindow*) self, GDK_WINDOW_TYPE_HINT_DIALOG);
		g_signal_connect_object ((GObject*) self->priv->_job, "notify::scanner", (GCallback) _gnome_scan_dialog_on_scanner_selected_g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) self->priv->_job, "notify::status", (GCallback) _gnome_scan_dialog_on_status_changed_g_object_notify, self, 0);
		box = (_tmp0_ = (GtkBox*) g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6)), _g_object_unref0 (box), _tmp0_);
		gtk_container_set_border_width ((GtkContainer*) box, (guint) 6);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
		self->priv->notebook = (_tmp1_ = g_object_ref_sink ((GtkNotebook*) gtk_notebook_new ()), _g_object_unref0 (self->priv->notebook), _tmp1_);
		gtk_container_set_border_width ((GtkContainer*) self->priv->notebook, (guint) 6);
		gtk_box_pack_start (box, (GtkWidget*) self->priv->notebook, TRUE, TRUE, (guint) 0);
		self->priv->acquisition_page = (_tmp2_ = (GtkBox*) g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6)), _g_object_unref0 (self->priv->acquisition_page), _tmp2_);
		gtk_widget_set_no_show_all ((GtkWidget*) self->priv->acquisition_page, TRUE);
		gtk_box_pack_start (box, (GtkWidget*) self->priv->acquisition_page, TRUE, TRUE, (guint) 0);
		self->priv->pages = (_tmp3_ = g_new0 (GtkWidget*, ((gint) GNOME_SCAN_PAGES_LAST) + 1), self->priv->pages = (_vala_array_free (self->priv->pages, self->priv->pages_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->pages_length1 = (gint) GNOME_SCAN_PAGES_LAST, self->priv->pages_size = self->priv->pages_length1, _tmp3_);
		gnome_scan_dialog_build_general_tab (self);
		gnome_scan_dialog_build_scanner_page (self);
		gnome_scan_dialog_build_node_ui (self, (GnomeScanNode*) gnome_scan_job_get_sink (self->priv->_job));
		gnome_scan_dialog_add_buttons (self, box);
		_g_object_unref0 (box);
	}
	return obj;
}


static void gnome_scan_dialog_class_init (GnomeScanDialogClass * klass) {
	gnome_scan_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanDialogPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_DIALOG_JOB, g_param_spec_object ("job", "job", "job", GNOME_SCAN_TYPE_JOB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void gnome_scan_dialog_instance_init (GnomeScanDialog * self) {
	self->priv = GNOME_SCAN_DIALOG_GET_PRIVATE (self);
	self->priv->scanner = NULL;
}


static void gnome_scan_dialog_finalize (GObject* obj) {
	GnomeScanDialog * self;
	self = GNOME_SCAN_DIALOG (obj);
	_g_object_unref0 (self->priv->_job);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->acquisition_page);
	_g_object_unref0 (self->priv->acquisitor);
	_g_object_unref0 (self->priv->bcancel);
	_g_object_unref0 (self->priv->bclose);
	_g_object_unref0 (self->priv->bscan);
	_g_object_unref0 (self->priv->bnext);
	_g_object_unref0 (self->priv->bback);
	self->priv->pages = (_vala_array_free (self->priv->pages, self->priv->pages_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->scanner);
	_g_object_unref0 (self->priv->selector);
	G_OBJECT_CLASS (gnome_scan_dialog_parent_class)->finalize (obj);
}


GType gnome_scan_dialog_get_type (void) {
	static GType gnome_scan_dialog_type_id = 0;
	if (gnome_scan_dialog_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanDialog), 0, (GInstanceInitFunc) gnome_scan_dialog_instance_init, NULL };
		gnome_scan_dialog_type_id = g_type_register_static (GTK_TYPE_WINDOW, "GnomeScanDialog", &g_define_type_info, 0);
	}
	return gnome_scan_dialog_type_id;
}


static void gnome_scan_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanDialog * self;
	self = GNOME_SCAN_DIALOG (object);
	switch (property_id) {
		case GNOME_SCAN_DIALOG_JOB:
		g_value_set_object (value, gnome_scan_dialog_get_job (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanDialog * self;
	self = GNOME_SCAN_DIALOG (object);
	switch (property_id) {
		case GNOME_SCAN_DIALOG_JOB:
		gnome_scan_dialog_set_job (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




