/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>


#define GNOME_SCAN_TYPE_OPTION_WIDGET (gnome_scan_option_widget_get_type ())
#define GNOME_SCAN_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidget))
#define GNOME_SCAN_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))
#define GNOME_SCAN_IS_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_IS_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_OPTION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))

typedef struct _GnomeScanOptionWidget GnomeScanOptionWidget;
typedef struct _GnomeScanOptionWidgetClass GnomeScanOptionWidgetClass;
typedef struct _GnomeScanOptionWidgetPrivate GnomeScanOptionWidgetPrivate;

#define GNOME_SCAN_TYPE_SCALE_WIDGET (gnome_scan_scale_widget_get_type ())
#define GNOME_SCAN_SCALE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SCALE_WIDGET, GnomeScanScaleWidget))
#define GNOME_SCAN_SCALE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SCALE_WIDGET, GnomeScanScaleWidgetClass))
#define GNOME_SCAN_IS_SCALE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SCALE_WIDGET))
#define GNOME_SCAN_IS_SCALE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SCALE_WIDGET))
#define GNOME_SCAN_SCALE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SCALE_WIDGET, GnomeScanScaleWidgetClass))

typedef struct _GnomeScanScaleWidget GnomeScanScaleWidget;
typedef struct _GnomeScanScaleWidgetClass GnomeScanScaleWidgetClass;
typedef struct _GnomeScanScaleWidgetPrivate GnomeScanScaleWidgetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;

#define GNOME_SCAN_TYPE_OPTION_NUMBER (gnome_scan_option_number_get_type ())
#define GNOME_SCAN_OPTION_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_NUMBER, GnomeScanOptionNumber))
#define GNOME_SCAN_OPTION_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_NUMBER, GnomeScanOptionNumberClass))
#define GNOME_SCAN_IS_OPTION_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_NUMBER))
#define GNOME_SCAN_IS_OPTION_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_NUMBER))
#define GNOME_SCAN_OPTION_NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_NUMBER, GnomeScanOptionNumberClass))

typedef struct _GnomeScanOptionNumber GnomeScanOptionNumber;
typedef struct _GnomeScanOptionNumberClass GnomeScanOptionNumberClass;

#define GNOME_SCAN_TYPE_RANGE (gnome_scan_range_get_type ())
typedef struct _GnomeScanRange GnomeScanRange;

struct _GnomeScanOptionWidget {
	GtkHBox parent_instance;
	GnomeScanOptionWidgetPrivate * priv;
};

struct _GnomeScanOptionWidgetClass {
	GtkHBoxClass parent_class;
};

struct _GnomeScanScaleWidget {
	GnomeScanOptionWidget parent_instance;
	GnomeScanScaleWidgetPrivate * priv;
};

struct _GnomeScanScaleWidgetClass {
	GnomeScanOptionWidgetClass parent_class;
};

struct _GnomeScanScaleWidgetPrivate {
	GtkAdjustment* adj;
};

struct _GnomeScanRange {
	double min;
	double step;
	double max;
};


static gpointer gnome_scan_scale_widget_parent_class = NULL;

GType gnome_scan_option_widget_get_type (void);
GType gnome_scan_scale_widget_get_type (void);
#define GNOME_SCAN_SCALE_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_SCALE_WIDGET, GnomeScanScaleWidgetPrivate))
enum  {
	GNOME_SCAN_SCALE_WIDGET_DUMMY_PROPERTY
};
GType gnome_scan_option_get_type (void);
GnomeScanOption* gnome_scan_option_widget_get_option (GnomeScanOptionWidget* self);
GType gnome_scan_option_number_get_type (void);
double gnome_scan_option_number_get_value (GnomeScanOptionNumber* self);
static void gnome_scan_scale_widget_on_option_value_changed (GnomeScanScaleWidget* self);
void gnome_scan_option_number_set_value (GnomeScanOptionNumber* self, double value);
static void gnome_scan_scale_widget_on_adj_value_changed (GnomeScanScaleWidget* self);
GnomeScanScaleWidget* gnome_scan_scale_widget_new (void);
GnomeScanScaleWidget* gnome_scan_scale_widget_construct (GType object_type);
void gnome_scan_option_widget_set_expand (GnomeScanOptionWidget* self, gboolean value);
void gnome_scan_option_widget_set_no_label (GnomeScanOptionWidget* self, gboolean value);
GType gnome_scan_range_get_type (void);
GnomeScanRange* gnome_scan_range_dup (const GnomeScanRange* self);
void gnome_scan_range_free (GnomeScanRange* self);
void gnome_scan_option_number_get_range (GnomeScanOptionNumber* self, GnomeScanRange* result);
static void _gnome_scan_scale_widget_on_adj_value_changed_g_object_notify (GtkAdjustment* _sender, GParamSpec* pspec, gpointer self);
static void _gnome_scan_scale_widget_on_option_value_changed_g_object_notify (GnomeScanOptionNumber* _sender, GParamSpec* pspec, gpointer self);
static GObject * gnome_scan_scale_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gnome_scan_scale_widget_finalize (GObject* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gnome_scan_scale_widget_on_option_value_changed (GnomeScanScaleWidget* self) {
	GnomeScanOption* _tmp0_;
	GnomeScanOptionNumber* option;
	g_return_if_fail (self != NULL);
	option = _g_object_ref0 ((_tmp0_ = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_NUMBER (_tmp0_) ? ((GnomeScanOptionNumber*) _tmp0_) : NULL));
	gtk_adjustment_set_value (self->priv->adj, gnome_scan_option_number_get_value (option));
	_g_object_unref0 (option);
}


static void gnome_scan_scale_widget_on_adj_value_changed (GnomeScanScaleWidget* self) {
	GnomeScanOption* _tmp0_;
	GnomeScanOptionNumber* option;
	g_return_if_fail (self != NULL);
	option = _g_object_ref0 ((_tmp0_ = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_NUMBER (_tmp0_) ? ((GnomeScanOptionNumber*) _tmp0_) : NULL));
	gnome_scan_option_number_set_value (option, gtk_adjustment_get_value (self->priv->adj));
	_g_object_unref0 (option);
}


GnomeScanScaleWidget* gnome_scan_scale_widget_construct (GType object_type) {
	GnomeScanScaleWidget * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GnomeScanScaleWidget* gnome_scan_scale_widget_new (void) {
	return gnome_scan_scale_widget_construct (GNOME_SCAN_TYPE_SCALE_WIDGET);
}


static void _gnome_scan_scale_widget_on_adj_value_changed_g_object_notify (GtkAdjustment* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_scale_widget_on_adj_value_changed (self);
}


static void _gnome_scan_scale_widget_on_option_value_changed_g_object_notify (GnomeScanOptionNumber* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_scale_widget_on_option_value_changed (self);
}


static GObject * gnome_scan_scale_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanScaleWidgetClass * klass;
	GObjectClass * parent_class;
	GnomeScanScaleWidget * self;
	klass = GNOME_SCAN_SCALE_WIDGET_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_SCALE_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_SCALE_WIDGET (obj);
	{
		GtkSpinButton* spin;
		GtkScale* scale;
		gint digits;
		GnomeScanOption* _tmp0_;
		GnomeScanOptionNumber* option;
		GtkAdjustment* _tmp5_;
		GnomeScanRange _tmp1_ = {0};
		GnomeScanRange _tmp2_ = {0};
		GnomeScanRange _tmp3_ = {0};
		GnomeScanRange _tmp4_ = {0};
		GnomeScanRange _tmp6_ = {0};
		GtkScale* _tmp7_;
		GnomeScanRange _tmp8_ = {0};
		GnomeScanRange _tmp9_ = {0};
		GtkSpinButton* _tmp11_;
		GnomeScanRange _tmp10_ = {0};
		GnomeScanRange _tmp12_ = {0};
		GnomeScanRange _tmp13_ = {0};
		gnome_scan_option_widget_set_expand ((GnomeScanOptionWidget*) self, FALSE);
		gnome_scan_option_widget_set_no_label ((GnomeScanOptionWidget*) self, FALSE);
		spin = NULL;
		scale = NULL;
		digits = 0;
		option = _g_object_ref0 ((_tmp0_ = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_NUMBER (_tmp0_) ? ((GnomeScanOptionNumber*) _tmp0_) : NULL));
		self->priv->adj = (_tmp5_ = g_object_ref_sink ((GtkAdjustment*) gtk_adjustment_new (gnome_scan_option_number_get_value (option), (gnome_scan_option_number_get_range (option, &_tmp1_), _tmp1_).min, (gnome_scan_option_number_get_range (option, &_tmp2_), _tmp2_).max, (gnome_scan_option_number_get_range (option, &_tmp3_), _tmp3_).step, (gnome_scan_option_number_get_range (option, &_tmp4_), _tmp4_).step, (double) 0)), _g_object_unref0 (self->priv->adj), _tmp5_);
		if ((gnome_scan_option_number_get_range (option, &_tmp6_), _tmp6_).step < 1.0) {
			digits = 2;
		}
		scale = (_tmp7_ = (GtkScale*) g_object_ref_sink ((GtkHScale*) gtk_hscale_new (self->priv->adj)), _g_object_unref0 (scale), _tmp7_);
		gtk_range_set_increments ((GtkRange*) scale, (gnome_scan_option_number_get_range (option, &_tmp8_), _tmp8_).step, (gnome_scan_option_number_get_range (option, &_tmp9_), _tmp9_).step);
		gtk_scale_set_draw_value (scale, FALSE);
		gtk_range_set_update_policy ((GtkRange*) scale, GTK_UPDATE_DISCONTINUOUS);
		gtk_scale_set_digits (scale, digits);
		spin = (_tmp11_ = g_object_ref_sink ((GtkSpinButton*) gtk_spin_button_new (self->priv->adj, (gnome_scan_option_number_get_range (option, &_tmp10_), _tmp10_).step, (guint) digits)), _g_object_unref0 (spin), _tmp11_);
		gtk_spin_button_set_increments (spin, (gnome_scan_option_number_get_range (option, &_tmp12_), _tmp12_).step, (gnome_scan_option_number_get_range (option, &_tmp13_), _tmp13_).step);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_IF_VALID);
		gtk_spin_button_set_snap_to_ticks (spin, TRUE);
		gtk_spin_button_set_numeric (spin, TRUE);
		gtk_spin_button_set_wrap (spin, TRUE);
		g_signal_connect_object ((GObject*) self->priv->adj, "notify::value", (GCallback) _gnome_scan_scale_widget_on_adj_value_changed_g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) option, "notify::value", (GCallback) _gnome_scan_scale_widget_on_option_value_changed_g_object_notify, self, 0);
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) scale, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) spin, FALSE, TRUE, (guint) 0);
		_g_object_unref0 (spin);
		_g_object_unref0 (scale);
		_g_object_unref0 (option);
	}
	return obj;
}


static void gnome_scan_scale_widget_class_init (GnomeScanScaleWidgetClass * klass) {
	gnome_scan_scale_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanScaleWidgetPrivate));
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_scale_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_scale_widget_finalize;
}


static void gnome_scan_scale_widget_instance_init (GnomeScanScaleWidget * self) {
	self->priv = GNOME_SCAN_SCALE_WIDGET_GET_PRIVATE (self);
}


static void gnome_scan_scale_widget_finalize (GObject* obj) {
	GnomeScanScaleWidget * self;
	self = GNOME_SCAN_SCALE_WIDGET (obj);
	_g_object_unref0 (self->priv->adj);
	G_OBJECT_CLASS (gnome_scan_scale_widget_parent_class)->finalize (obj);
}


GType gnome_scan_scale_widget_get_type (void) {
	static GType gnome_scan_scale_widget_type_id = 0;
	if (gnome_scan_scale_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanScaleWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_scale_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanScaleWidget), 0, (GInstanceInitFunc) gnome_scan_scale_widget_instance_init, NULL };
		gnome_scan_scale_widget_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION_WIDGET, "GnomeScanScaleWidget", &g_define_type_info, 0);
	}
	return gnome_scan_scale_widget_type_id;
}




