/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2006, Mr Jamie McCracken (jamiemcc@gnome.org)
 * Copyright (C) 2008, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#ifndef __LIBTRACKER_FTS_PARSER_H__
#define __LIBTRACKER_FTS_PARSER_H__

#include <glib.h>

#include <libtracker-common/tracker-language.h>

G_BEGIN_DECLS

typedef struct TrackerParser TrackerParser;

TrackerParser *tracker_parser_new	      (TrackerLanguage *language,
					       gint		max_word_length,
					       gint		min_word_length);
void	       tracker_parser_reset	      (TrackerParser   *parser,
					       const gchar     *txt,
					       gint		txt_size,
					       gboolean		delimit_words,
					       gboolean		enable_stemmer,
					       gboolean		enable_stop_words,
					       gboolean		parse_reserved_words);
const gchar *  tracker_parser_next	      (TrackerParser   *parser,
					       gint	       *position,
					       gint	       *byte_offset_start,
					       gint	       *byte_offset_end,
					       gboolean        *stop_word,
					       gint	       *word_length);
gchar *        tracker_parser_process_word    (TrackerParser   *parser,
					       const char      *word,
					       gint		length,
					       gboolean		do_strip);
void	       tracker_parser_free	      (TrackerParser   *parser);

G_END_DECLS

#endif /* __LIBTRACKER_FTS_PARSER_H__ */
