/* command-signals.c generated by valac 0.12.0, the Vala compiler
 * generated from command-signals.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <readline/readline.h>


#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
typedef struct _FolksInspectCommandPrivate FolksInspectCommandPrivate;

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS (folks_inspect_commands_signals_get_type ())
#define FOLKS_INSPECT_COMMANDS_SIGNALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignals))
#define FOLKS_INSPECT_COMMANDS_SIGNALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignalsClass))
#define FOLKS_INSPECT_COMMANDS_IS_SIGNALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS))
#define FOLKS_INSPECT_COMMANDS_IS_SIGNALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS))
#define FOLKS_INSPECT_COMMANDS_SIGNALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignalsClass))

typedef struct _FolksInspectCommandsSignals FolksInspectCommandsSignals;
typedef struct _FolksInspectCommandsSignalsClass FolksInspectCommandsSignalsClass;
typedef struct _FolksInspectCommandsSignalsPrivate FolksInspectCommandsSignalsPrivate;

#define FOLKS_INSPECT_TYPE_SIGNAL_MANAGER (folks_inspect_signal_manager_get_type ())
#define FOLKS_INSPECT_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManager))
#define FOLKS_INSPECT_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_SIGNAL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))

typedef struct _FolksInspectSignalManager FolksInspectSignalManager;
typedef struct _FolksInspectSignalManagerClass FolksInspectSignalManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _FolksInspectCommand {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectCommandPrivate * priv;
	FolksInspectClient* client;
};

struct _FolksInspectCommandClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectCommand *self);
	void (*run) (FolksInspectCommand* self, const gchar* command_string);
	gchar** (*complete_subcommand) (FolksInspectCommand* self, const gchar* subcommand);
	const gchar* (*get_name) (FolksInspectCommand* self);
	const gchar* (*get_description) (FolksInspectCommand* self);
	const gchar* (*get_help) (FolksInspectCommand* self);
};

struct _FolksInspectCommandsSignals {
	FolksInspectCommand parent_instance;
	FolksInspectCommandsSignalsPrivate * priv;
};

struct _FolksInspectCommandsSignalsClass {
	FolksInspectCommandClass parent_class;
};


static gpointer folks_inspect_commands_signals_parent_class = NULL;

gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
GType folks_inspect_client_get_type (void) G_GNUC_CONST;
GType folks_inspect_commands_signals_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_INSPECT_COMMANDS_SIGNALS_DUMMY_PROPERTY
};
FolksInspectCommandsSignals* folks_inspect_commands_signals_new (FolksInspectClient* client);
FolksInspectCommandsSignals* folks_inspect_commands_signals_construct (GType object_type, FolksInspectClient* client);
FolksInspectCommand* folks_inspect_command_construct (GType object_type, FolksInspectClient* client);
static void folks_inspect_commands_signals_real_run (FolksInspectCommand* base, const gchar* command_string);
GType folks_inspect_signal_manager_get_type (void) G_GNUC_CONST;
FolksInspectSignalManager* folks_inspect_client_get_signal_manager (FolksInspectClient* self);
void folks_inspect_signal_manager_list_signals (FolksInspectSignalManager* self, GType class_type, GObject* class_instance);
void folks_inspect_utils_print_line (const gchar* format, ...);
static gboolean folks_inspect_commands_signals_parse_signal_id (FolksInspectCommandsSignals* self, const gchar* input, GType* class_type, GObject** class_instance, gchar** signal_name, gchar** detail_string);
guint folks_inspect_signal_manager_connect_to_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string);
guint folks_inspect_signal_manager_disconnect_from_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string);
void folks_inspect_signal_manager_show_signal_details (FolksInspectSignalManager* self, GType class_type, const gchar* signal_name, const gchar* detail_string);
static gchar** folks_inspect_commands_signals_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1);
gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state);
static gchar* _folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a);
static gchar** _vala_array_dup6 (gchar** self, int length);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


FolksInspectCommandsSignals* folks_inspect_commands_signals_construct (GType object_type, FolksInspectClient* client) {
	FolksInspectCommandsSignals* self = NULL;
	g_return_val_if_fail (client != NULL, NULL);
	self = (FolksInspectCommandsSignals*) folks_inspect_command_construct (object_type, client);
	return self;
}


FolksInspectCommandsSignals* folks_inspect_commands_signals_new (FolksInspectClient* client) {
	return folks_inspect_commands_signals_construct (FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, client);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void folks_inspect_commands_signals_real_run (FolksInspectCommand* base, const gchar* command_string) {
	FolksInspectCommandsSignals * self;
	self = (FolksInspectCommandsSignals*) base;
	if (command_string == NULL) {
		FolksInspectSignalManager* _tmp0_ = NULL;
		_tmp0_ = folks_inspect_client_get_signal_manager (((FolksInspectCommand*) self)->client);
		folks_inspect_signal_manager_list_signals (_tmp0_, G_TYPE_INVALID, NULL);
	} else {
		gchar** _tmp1_;
		gchar** _tmp2_ = NULL;
		gchar** parts;
		gint parts_length1;
		gint _parts_size_;
		GType class_type = 0UL;
		GObject* class_instance = NULL;
		gchar* signal_name = NULL;
		gchar* detail_string = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = _tmp1_ = g_strsplit (command_string, " ", 2);
		parts = _tmp2_;
		parts_length1 = _vala_array_length (_tmp1_);
		_parts_size_ = _vala_array_length (_tmp1_);
		if (parts_length1 < 1) {
			folks_inspect_utils_print_line ("Unrecognised 'signals' command '%s'.", command_string);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			return;
		}
		if (g_strcmp0 (parts[0], "connect") == 0) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = g_strcmp0 (parts[0], "disconnect") == 0;
		}
		if (_tmp3_) {
			gboolean _tmp4_ = FALSE;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			GType _tmp9_;
			GObject* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gboolean _tmp13_;
			gboolean _tmp14_;
			if (parts[1] == NULL) {
				_tmp4_ = TRUE;
			} else {
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				_tmp5_ = string_strip (parts[1]);
				_tmp6_ = _tmp5_;
				_tmp4_ = g_strcmp0 (_tmp6_, "") == 0;
				_g_free0 (_tmp6_);
			}
			if (_tmp4_) {
				folks_inspect_utils_print_line ("Unrecognised signal identifier '%s'.", parts[1]);
				_g_free0 (detail_string);
				_g_free0 (signal_name);
				_g_object_unref0 (class_instance);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				return;
			}
			_tmp7_ = string_strip (parts[1]);
			_tmp8_ = _tmp7_;
			_tmp13_ = folks_inspect_commands_signals_parse_signal_id (self, _tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
			class_type = _tmp9_;
			_g_object_unref0 (class_instance);
			class_instance = _tmp10_;
			_g_free0 (signal_name);
			signal_name = _tmp11_;
			_g_free0 (detail_string);
			detail_string = _tmp12_;
			_tmp14_ = _tmp13_ == FALSE;
			_g_free0 (_tmp8_);
			if (_tmp14_) {
				_g_free0 (detail_string);
				_g_free0 (signal_name);
				_g_object_unref0 (class_instance);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				return;
			}
			if (g_strcmp0 (parts[0], "connect") == 0) {
				FolksInspectSignalManager* _tmp15_ = NULL;
				guint _tmp16_;
				guint signal_count;
				_tmp15_ = folks_inspect_client_get_signal_manager (((FolksInspectCommand*) self)->client);
				_tmp16_ = folks_inspect_signal_manager_connect_to_signal (_tmp15_, class_type, class_instance, signal_name, detail_string);
				signal_count = _tmp16_;
				folks_inspect_utils_print_line ("Connected to %u signals.", signal_count);
			} else {
				FolksInspectSignalManager* _tmp17_ = NULL;
				guint _tmp18_;
				guint signal_count;
				_tmp17_ = folks_inspect_client_get_signal_manager (((FolksInspectCommand*) self)->client);
				_tmp18_ = folks_inspect_signal_manager_disconnect_from_signal (_tmp17_, class_type, class_instance, signal_name, detail_string);
				signal_count = _tmp18_;
				folks_inspect_utils_print_line ("Disconnected from %u signals.", signal_count);
			}
		} else {
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			GType _tmp21_;
			GObject* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gboolean _tmp25_;
			gboolean _tmp26_;
			_tmp19_ = string_strip (parts[0]);
			_tmp20_ = _tmp19_;
			_tmp25_ = folks_inspect_commands_signals_parse_signal_id (self, _tmp20_, &_tmp21_, &_tmp22_, &_tmp23_, &_tmp24_);
			class_type = _tmp21_;
			_g_object_unref0 (class_instance);
			class_instance = _tmp22_;
			_g_free0 (signal_name);
			signal_name = _tmp23_;
			_g_free0 (detail_string);
			detail_string = _tmp24_;
			_tmp26_ = _tmp25_ == FALSE;
			_g_free0 (_tmp20_);
			if (_tmp26_) {
				_g_free0 (detail_string);
				_g_free0 (signal_name);
				_g_object_unref0 (class_instance);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				return;
			}
			if (signal_name == NULL) {
				FolksInspectSignalManager* _tmp27_ = NULL;
				_tmp27_ = folks_inspect_client_get_signal_manager (((FolksInspectCommand*) self)->client);
				folks_inspect_signal_manager_list_signals (_tmp27_, class_type, class_instance);
			} else {
				FolksInspectSignalManager* _tmp29_ = NULL;
				if (class_type == G_TYPE_INVALID) {
					GType _tmp28_;
					_tmp28_ = G_TYPE_FROM_INSTANCE (class_instance);
					class_type = _tmp28_;
				}
				_tmp29_ = folks_inspect_client_get_signal_manager (((FolksInspectCommand*) self)->client);
				folks_inspect_signal_manager_show_signal_details (_tmp29_, class_type, signal_name, detail_string);
			}
		}
		_g_free0 (detail_string);
		_g_free0 (signal_name);
		_g_object_unref0 (class_instance);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	}
}


static gchar* _folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a) {
	gchar* result;
	result = folks_inspect_utils_backend_name_completion_cb (str, a);
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar** folks_inspect_commands_signals_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1) {
	FolksInspectCommandsSignals * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	self = (FolksInspectCommandsSignals*) base;
	g_return_val_if_fail (subcommand != NULL, NULL);
	_tmp1_ = _tmp0_ = rl_completion_matches (subcommand, _folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t);
	_tmp2_ = (_tmp3_ = _tmp1_, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup6 (_tmp3_, _vala_array_length (_tmp0_)));
	_tmp4_ = _tmp2_;
	*result_length1 = _vala_array_length (_tmp0_);
	result = _tmp4_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean folks_inspect_commands_signals_parse_signal_id (FolksInspectCommandsSignals* self, const gchar* input, GType* class_type, GObject** class_instance, gchar** signal_name, gchar** detail_string) {
	GType _class_type = 0UL;
	GObject* _class_instance = NULL;
	gchar* _signal_name = NULL;
	gchar* _detail_string = NULL;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	gchar* _tmp3_;
	gchar* class_name_or_instance;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* signal_name_inner;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* detail_string_inner;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (input != NULL, FALSE);
	if (input != NULL) {
		_tmp0_ = g_strcmp0 (input, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	g_assert (_tmp0_);
	_tmp2_ = _tmp1_ = g_strsplit (input, "::", 3);
	parts = _tmp2_;
	parts_length1 = _vala_array_length (_tmp1_);
	_parts_size_ = _vala_array_length (_tmp1_);
	_tmp3_ = g_strdup (parts[0]);
	class_name_or_instance = _tmp3_;
	if (parts_length1 > 1) {
		_tmp4_ = parts[1];
	} else {
		_tmp4_ = NULL;
	}
	_tmp5_ = g_strdup (_tmp4_);
	signal_name_inner = _tmp5_;
	if (parts_length1 > 2) {
		_tmp6_ = parts[2];
	} else {
		_tmp6_ = NULL;
	}
	_tmp7_ = g_strdup (_tmp6_);
	detail_string_inner = _tmp7_;
	if (g_strcmp0 (signal_name_inner, "") == 0) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = g_strcmp0 (detail_string_inner, "") == 0;
	}
	if (_tmp8_) {
		folks_inspect_utils_print_line ("Invalid signal identifier '%s'.", input);
		result = FALSE;
		_g_free0 (detail_string_inner);
		_g_free0 (signal_name_inner);
		_g_free0 (class_name_or_instance);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		if (class_type) {
			*class_type = _class_type;
		}
		if (class_instance) {
			*class_instance = _class_instance;
		} else {
			_g_object_unref0 (_class_instance);
		}
		if (signal_name) {
			*signal_name = _signal_name;
		} else {
			_g_free0 (_signal_name);
		}
		if (detail_string) {
			*detail_string = _detail_string;
		} else {
			_g_free0 (_detail_string);
		}
		return result;
	}
	_tmp11_ = strlen (class_name_or_instance);
	if (_tmp11_ > 2) {
		gchar _tmp12_;
		_tmp12_ = string_get (class_name_or_instance, (glong) 0);
		_tmp10_ = _tmp12_ == '0';
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		gchar _tmp13_;
		_tmp13_ = string_get (class_name_or_instance, (glong) 1);
		_tmp9_ = _tmp13_ == 'x';
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gulong _tmp14_;
		gulong address;
		GObject* _tmp15_;
		GType _tmp16_;
		gboolean _tmp17_;
		_tmp14_ = strtoul (class_name_or_instance, NULL, 16);
		address = _tmp14_;
		_tmp15_ = _g_object_ref0 (G_OBJECT (address));
		_g_object_unref0 (_class_instance);
		_class_instance = _tmp15_;
		_tmp16_ = G_TYPE_FROM_INSTANCE (_class_instance);
		_tmp17_ = G_TYPE_IS_OBJECT (_tmp16_);
		g_assert (_tmp17_);
	} else {
		GType _tmp18_;
		gboolean _tmp19_ = FALSE;
		_tmp18_ = g_type_from_name (class_name_or_instance);
		_class_type = _tmp18_;
		if (_class_type == G_TYPE_INVALID) {
			_tmp19_ = TRUE;
		} else {
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_;
			_tmp21_ = G_TYPE_IS_INSTANTIATABLE (_class_type);
			if (_tmp21_ == FALSE) {
				gboolean _tmp22_;
				_tmp22_ = G_TYPE_IS_INTERFACE (_class_type);
				_tmp20_ = _tmp22_ == FALSE;
			} else {
				_tmp20_ = FALSE;
			}
			_tmp19_ = _tmp20_;
		}
		if (_tmp19_) {
			folks_inspect_utils_print_line ("Unrecognised class name '%s'.", class_name_or_instance);
			result = FALSE;
			_g_free0 (detail_string_inner);
			_g_free0 (signal_name_inner);
			_g_free0 (class_name_or_instance);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			if (class_type) {
				*class_type = _class_type;
			}
			if (class_instance) {
				*class_instance = _class_instance;
			} else {
				_g_object_unref0 (_class_instance);
			}
			if (signal_name) {
				*signal_name = _signal_name;
			} else {
				_g_free0 (_signal_name);
			}
			if (detail_string) {
				*detail_string = _detail_string;
			} else {
				_g_free0 (_detail_string);
			}
			return result;
		}
	}
	_tmp23_ = g_strdup (signal_name_inner);
	_g_free0 (_signal_name);
	_signal_name = _tmp23_;
	_tmp24_ = g_strdup (detail_string_inner);
	_g_free0 (_detail_string);
	_detail_string = _tmp24_;
	result = TRUE;
	_g_free0 (detail_string_inner);
	_g_free0 (signal_name_inner);
	_g_free0 (class_name_or_instance);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	if (class_type) {
		*class_type = _class_type;
	}
	if (class_instance) {
		*class_instance = _class_instance;
	} else {
		_g_object_unref0 (_class_instance);
	}
	if (signal_name) {
		*signal_name = _signal_name;
	} else {
		_g_free0 (_signal_name);
	}
	if (detail_string) {
		*detail_string = _detail_string;
	} else {
		_g_free0 (_detail_string);
	}
	return result;
}


static const gchar* folks_inspect_commands_signals_real_get_name (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsSignals* self;
	self = (FolksInspectCommandsSignals*) base;
	result = "signals";
	return result;
}


static const gchar* folks_inspect_commands_signals_real_get_description (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsSignals* self;
	self = (FolksInspectCommandsSignals*) base;
	result = "Allow connection to and display of signals emitted by " "libfolks.";
	return result;
}


static const gchar* folks_inspect_commands_signals_real_get_help (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsSignals* self;
	self = (FolksInspectCommandsSignals*) base;
	result = "signals                                            " "List signals we're currently connected to.\n" "signals connect [class name]                       " "Connect to all the signals on all the instances of that " "class.\n" "signals connect [class name]::[signal name]        " "Connect to the given signal on all the instances of that " "class.\n" "signals connect [object pointer]                   " "Connect to all the signals on a particular class instance.\n" "signals connect [object pointer]::[signal name]    " "Connect to the given signal on a particular class instance.\n" "signals disconnect                                 " "(As for 'connect'.)\n" "signals [class name]                               " "List all the signals on all the instances of that class, " "highlighting the ones we're currently connected to.\n" "signals [object pointer]                           " "List all the signals on a particular class instance, " "highlighting the ones we're currently connected to.\n" "signals [class name]::[signal name]                " "Show the details of this signal.\n" "signals [object pointer]::[signal name]            " "Show the details of this signal.";
	return result;
}


static void folks_inspect_commands_signals_class_init (FolksInspectCommandsSignalsClass * klass) {
	folks_inspect_commands_signals_parent_class = g_type_class_peek_parent (klass);
	FOLKS_INSPECT_COMMAND_CLASS (klass)->run = folks_inspect_commands_signals_real_run;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->complete_subcommand = folks_inspect_commands_signals_real_complete_subcommand;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_name = folks_inspect_commands_signals_real_get_name;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_description = folks_inspect_commands_signals_real_get_description;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_help = folks_inspect_commands_signals_real_get_help;
}


static void folks_inspect_commands_signals_instance_init (FolksInspectCommandsSignals * self) {
}


GType folks_inspect_commands_signals_get_type (void) {
	static volatile gsize folks_inspect_commands_signals_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_commands_signals_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectCommandsSignalsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_commands_signals_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectCommandsSignals), 0, (GInstanceInitFunc) folks_inspect_commands_signals_instance_init, NULL };
		GType folks_inspect_commands_signals_type_id;
		folks_inspect_commands_signals_type_id = g_type_register_static (FOLKS_INSPECT_TYPE_COMMAND, "FolksInspectCommandsSignals", &g_define_type_info, 0);
		g_once_init_leave (&folks_inspect_commands_signals_type_id__volatile, folks_inspect_commands_signals_type_id);
	}
	return folks_inspect_commands_signals_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



