import os
import sys
import gtk
import gtk.glade
import gobject
import gnome
import gettext

gtdomain = "pybackpack"
localedir = "/usr/share/locale"
gettext.install(gtdomain, localedir, unicode=True)
gtk.glade.bindtextdomain(gtdomain, localedir)
gtk.glade.textdomain(gtdomain)

import version
import backupsets
import rdiff_interface
from gui import Gui

class BackupTool:
    def __init__(self):
        gnome.program_init(version.APPNAME, version.VERSION)

        self.homedir = os.environ['HOME']
        self.configpath = os.path.join(self.homedir, '.'+version.APPPATH)

        # Find the user's backup sets
        self.backupsets = backupsets.BackupSets(self.configpath)
        
        # connect signals to handler functions
        self.gui = Gui(self.backupsets)

        # create a backup set called 'home' that
        # contains the user's entire home directory
        homeexists = False
        for s in self.backupsets:
            if s.name == _('home'):
                homeexists = True
                break
        if not homeexists:
            buset = backupsets.BackupSet(self.backupsets.configpath)
            buset.name = _('home')
            buset.desc = _("A complete backup of your home directory.")
            buset.files_include = [self.homedir]
            buset.dest = 'cdrw://'
            buset.path = 'home'
            buset.write()
            self.backupsets.add(buset)

        # populate the list of recently used backup/restore locations
        try:
            for line in open(os.path.join(self.configpath, "backup_mru")).readlines():
                gui.add_prev_dest(line)
            for line in open(os.path.join(self.configpath, "restore_src")).readlines():
                gui.add_prev_restore_loc(line)
        except IOError, e:
            pass #if the file doesn't exist, don't panic!
        
        # detect what CD burners are available
        self.gui.find_cd_burners()
        
def StartUp():
    pbp = BackupTool()
    gtk.main()

