/* ****************************************************************************
 *
 * Copyright (c) Microsoft Corporation. 
 *
 * This source code is subject to terms and conditions of the Microsoft Public License. A 
 * copy of the license can be found in the License.html file at the root of this distribution. If 
 * you cannot locate the  Microsoft Public License, please send an email to 
 * dlr@microsoft.com. By using this source code in any fashion, you are agreeing to be bound 
 * by the terms of the Microsoft Public License.
 *
 * You must not remove this notice, or any other, from this software.
 *
 *
 * ***************************************************************************/
using System; using Microsoft;


#if CODEPLEX_40
namespace System.Linq.Expressions {
#else
namespace Microsoft.Linq.Expressions {
#endif

    internal static partial class Strings {
        private static string FormatString(string format, params object[] args) {
            return string.Format(System.Globalization.CultureInfo.CurrentCulture, format, args);
        }
    }
    
    #region Generated Exception Factory

    // *** BEGIN GENERATED CODE ***
    // generated by function: gen_expr_factory_core from: generate_exception_factory.py

    /// <summary>
    ///    Strongly-typed and parameterized string factory.
    /// </summary>

    internal static partial class Strings {
        /// <summary>
        /// A string like  "Method precondition violated"
        /// </summary>
        internal static string MethodPreconditionViolated {
            get {
                return "Method precondition violated";
            }
        }

        /// <summary>
        /// A string like  "Invalid argument value"
        /// </summary>
        internal static string InvalidArgumentValue {
            get {
                return "Invalid argument value";
            }
        }

        /// <summary>
        /// A string like  "Non-empty collection required"
        /// </summary>
        internal static string NonEmptyCollectionRequired {
            get {
                return "Non-empty collection required";
            }
        }

        /// <summary>
        /// A string like  "Argument count must be greater than number of named arguments."
        /// </summary>
        internal static string ArgCntMustBeGreaterThanNameCnt {
            get {
                return "Argument count must be greater than number of named arguments.";
            }
        }

        /// <summary>
        /// A string like  "reducible nodes must override Expression.Reduce()"
        /// </summary>
        internal static string ReducibleMustOverrideReduce {
            get {
                return "reducible nodes must override Expression.Reduce()";
            }
        }

        /// <summary>
        /// A string like  "node cannot reduce to itself or null"
        /// </summary>
        internal static string MustReduceToDifferent {
            get {
                return "node cannot reduce to itself or null";
            }
        }

        /// <summary>
        /// A string like  "cannot assign from the reduced node type to the original node type"
        /// </summary>
        internal static string ReducedNotCompatible {
            get {
                return "cannot assign from the reduced node type to the original node type";
            }
        }

        /// <summary>
        /// A string like  "Setter must have parameters."
        /// </summary>
        internal static string SetterHasNoParams {
            get {
                return "Setter must have parameters.";
            }
        }

        /// <summary>
        /// A string like  "Property cannot have a managed pointer type."
        /// </summary>
        internal static string PropertyCannotHaveRefType {
            get {
                return "Property cannot have a managed pointer type.";
            }
        }

        /// <summary>
        /// A string like  "Indexing parameters of getter and setter must match."
        /// </summary>
        internal static string IndexesOfSetGetMustMatch {
            get {
                return "Indexing parameters of getter and setter must match.";
            }
        }

        /// <summary>
        /// A string like  "Accessor method should not have VarArgs."
        /// </summary>
        internal static string AccessorsCannotHaveVarArgs {
            get {
                return "Accessor method should not have VarArgs.";
            }
        }

        /// <summary>
        /// A string like  "Accessor indexes cannot be passed ByRef."
        /// </summary>
        internal static string AccessorsCannotHaveByRefArgs {
            get {
                return "Accessor indexes cannot be passed ByRef.";
            }
        }

        /// <summary>
        /// A string like  "Bounds count cannot be less than 1"
        /// </summary>
        internal static string BoundsCannotBeLessThanOne {
            get {
                return "Bounds count cannot be less than 1";
            }
        }

        /// <summary>
        /// A string like  "type must not be ByRef"
        /// </summary>
        internal static string TypeMustNotBeByRef {
            get {
                return "type must not be ByRef";
            }
        }

        /// <summary>
        /// A string like  "Type doesn't have constructor with a given signature"
        /// </summary>
        internal static string TypeDoesNotHaveConstructorForTheSignature {
            get {
                return "Type doesn't have constructor with a given signature";
            }
        }

        /// <summary>
        /// A string like  "Count must be non-negative."
        /// </summary>
        internal static string CountCannotBeNegative {
            get {
                return "Count must be non-negative.";
            }
        }

        /// <summary>
        /// A string like  "arrayType must be an array type"
        /// </summary>
        internal static string ArrayTypeMustBeArray {
            get {
                return "arrayType must be an array type";
            }
        }

        /// <summary>
        /// A string like  "Setter should have void type."
        /// </summary>
        internal static string SetterMustBeVoid {
            get {
                return "Setter should have void type.";
            }
        }

        /// <summary>
        /// A string like  "Property type must match the value type of setter"
        /// </summary>
        internal static string PropertyTyepMustMatchSetter {
            get {
                return "Property type must match the value type of setter";
            }
        }

        /// <summary>
        /// A string like  "Both accessors must be static."
        /// </summary>
        internal static string BothAccessorsMustBeStatic {
            get {
                return "Both accessors must be static.";
            }
        }

        /// <summary>
        /// A string like  "Static field requires null instance, non-static field requires non-null instance."
        /// </summary>
        internal static string OnlyStaticFieldsHaveNullInstance {
            get {
                return "Static field requires null instance, non-static field requires non-null instance.";
            }
        }

        /// <summary>
        /// A string like  "Static property requires null instance, non-static property requires non-null instance."
        /// </summary>
        internal static string OnlyStaticPropertiesHaveNullInstance {
            get {
                return "Static property requires null instance, non-static property requires non-null instance.";
            }
        }

        /// <summary>
        /// A string like  "Static method requires null instance, non-static method requires non-null instance."
        /// </summary>
        internal static string OnlyStaticMethodsHaveNullInstance {
            get {
                return "Static method requires null instance, non-static method requires non-null instance.";
            }
        }

        /// <summary>
        /// A string like  "Property cannot have a void type."
        /// </summary>
        internal static string PropertyTypeCannotBeVoid {
            get {
                return "Property cannot have a void type.";
            }
        }

        /// <summary>
        /// A string like  "Can only unbox from an object or interface type to a value type."
        /// </summary>
        internal static string InvalidUnboxType {
            get {
                return "Can only unbox from an object or interface type to a value type.";
            }
        }

        /// <summary>
        /// A string like  "Expression must be readable"
        /// </summary>
        internal static string ExpressionMustBeReadable {
            get {
                return "Expression must be readable";
            }
        }

        /// <summary>
        /// A string like  "Expression must be writeable"
        /// </summary>
        internal static string ExpressionMustBeWriteable {
            get {
                return "Expression must be writeable";
            }
        }

        /// <summary>
        /// A string like  "Argument must not have a value type."
        /// </summary>
        internal static string ArgumentMustNotHaveValueType {
            get {
                return "Argument must not have a value type.";
            }
        }

        /// <summary>
        /// A string like  "must be reducible node"
        /// </summary>
        internal static string MustBeReducible {
            get {
                return "must be reducible node";
            }
        }

        /// <summary>
        /// A string like  "All test values must have the same type."
        /// </summary>
        internal static string AllTestValuesMustHaveSameType {
            get {
                return "All test values must have the same type.";
            }
        }

        /// <summary>
        /// A string like  "All case bodies and the default body must have the same type."
        /// </summary>
        internal static string AllCaseBodiesMustHaveSameType {
            get {
                return "All case bodies and the default body must have the same type.";
            }
        }

        /// <summary>
        /// A string like  "Default body must be supplied if case bodies are not System.Void."
        /// </summary>
        internal static string DefaultBodyMustBeSupplied {
            get {
                return "Default body must be supplied if case bodies are not System.Void.";
            }
        }

        /// <summary>
        /// A string like  "MethodBuilder does not have a valid TypeBuilder"
        /// </summary>
        internal static string MethodBuilderDoesNotHaveTypeBuilder {
            get {
                return "MethodBuilder does not have a valid TypeBuilder";
            }
        }

        /// <summary>
        /// A string like  "Type must be derived from System.Delegate"
        /// </summary>
        internal static string TypeMustBeDerivedFromSystemDelegate {
            get {
                return "Type must be derived from System.Delegate";
            }
        }

        /// <summary>
        /// A string like  "Argument type cannot be void"
        /// </summary>
        internal static string ArgumentTypeCannotBeVoid {
            get {
                return "Argument type cannot be void";
            }
        }

        /// <summary>
        /// A string like  "Label type must be System.Void if an expression is not supplied"
        /// </summary>
        internal static string LabelMustBeVoidOrHaveExpression {
            get {
                return "Label type must be System.Void if an expression is not supplied";
            }
        }

        /// <summary>
        /// A string like  "Type must be System.Void for this label argument"
        /// </summary>
        internal static string LabelTypeMustBeVoid {
            get {
                return "Type must be System.Void for this label argument";
            }
        }

        /// <summary>
        /// A string like  "Quoted expression must be a lambda"
        /// </summary>
        internal static string QuotedExpressionMustBeLambda {
            get {
                return "Quoted expression must be a lambda";
            }
        }

        /// <summary>
        /// A string like  "Variable '{0}' uses unsupported type '{1}'. Reference types are not supported for variables."
        /// </summary>
        internal static string VariableMustNotBeByRef(object p0, object p1) {
            return FormatString("Variable '{0}' uses unsupported type '{1}'. Reference types are not supported for variables.", p0, p1);
        }

        /// <summary>
        /// A string like  "Found duplicate parameter '{0}'. Each ParameterExpression in the list must be a unique object."
        /// </summary>
        internal static string DuplicateVariable(object p0) {
            return FormatString("Found duplicate parameter '{0}'. Each ParameterExpression in the list must be a unique object.", p0);
        }

        /// <summary>
        /// A string like  "Start and End must be well ordered"
        /// </summary>
        internal static string StartEndMustBeOrdered {
            get {
                return "Start and End must be well ordered";
            }
        }

        /// <summary>
        /// A string like  "fault cannot be used with catch or finally clauses"
        /// </summary>
        internal static string FaultCannotHaveCatchOrFinally {
            get {
                return "fault cannot be used with catch or finally clauses";
            }
        }

        /// <summary>
        /// A string like  "try must have at least one catch, finally, or fault clause"
        /// </summary>
        internal static string TryMustHaveCatchFinallyOrFault {
            get {
                return "try must have at least one catch, finally, or fault clause";
            }
        }

        /// <summary>
        /// A string like  "Body of catch must have the same type as body of try."
        /// </summary>
        internal static string BodyOfCatchMustHaveSameTypeAsBodyOfTry {
            get {
                return "Body of catch must have the same type as body of try.";
            }
        }

        /// <summary>
        /// A string like  "Extension node must override the property {0}."
        /// </summary>
        internal static string ExtensionNodeMustOverrideProperty(object p0) {
            return FormatString("Extension node must override the property {0}.", p0);
        }

        /// <summary>
        /// A string like  "User-defined operator method '{0}' must be static."
        /// </summary>
        internal static string UserDefinedOperatorMustBeStatic(object p0) {
            return FormatString("User-defined operator method '{0}' must be static.", p0);
        }

        /// <summary>
        /// A string like  "User-defined operator method '{0}' must not be void."
        /// </summary>
        internal static string UserDefinedOperatorMustNotBeVoid(object p0) {
            return FormatString("User-defined operator method '{0}' must not be void.", p0);
        }

        /// <summary>
        /// A string like  "No coercion operator is defined between types '{0}' and '{1}'."
        /// </summary>
        internal static string CoercionOperatorNotDefined(object p0, object p1) {
            return FormatString("No coercion operator is defined between types '{0}' and '{1}'.", p0, p1);
        }

        /// <summary>
        /// A string like  "The result type '{0}' of the dynamic binding produced by binder '{1}' is not compatible with the result type '{2}' expected by the call site."
        /// </summary>
        internal static string DynamicBinderResultNotAssignable(object p0, object p1, object p2) {
            return FormatString("The result type '{0}' of the dynamic binding produced by binder '{1}' is not compatible with the result type '{2}' expected by the call site.", p0, p1, p2);
        }

        /// <summary>
        /// A string like  "The result type '{0}' of the dynamic binding produced by the object with type '{1}' for the binder '{2}' is not compatible with the result type '{3}' expected by the call site."
        /// </summary>
        internal static string DynamicObjectResultNotAssignable(object p0, object p1, object p2, object p3) {
            return FormatString("The result type '{0}' of the dynamic binding produced by the object with type '{1}' for the binder '{2}' is not compatible with the result type '{3}' expected by the call site.", p0, p1, p2, p3);
        }

        /// <summary>
        /// A string like  "The result of the dynamic binding produced by the object with type '{0}' for the binder '{1}' needs at least one restriction."
        /// </summary>
        internal static string DynamicBindingNeedsRestrictions(object p0, object p1) {
            return FormatString("The result of the dynamic binding produced by the object with type '{0}' for the binder '{1}' needs at least one restriction.", p0, p1);
        }

        /// <summary>
        /// A string like  "The result type '{0}' of the binder '{1}' is not compatible with the result type '{2}' expected by the call site."
        /// </summary>
        internal static string BinderNotCompatibleWithCallSite(object p0, object p1, object p2) {
            return FormatString("The result type '{0}' of the binder '{1}' is not compatible with the result type '{2}' expected by the call site.", p0, p1, p2);
        }

        /// <summary>
        /// A string like  "The unary operator {0} is not defined for the type '{1}'."
        /// </summary>
        internal static string UnaryOperatorNotDefined(object p0, object p1) {
            return FormatString("The unary operator {0} is not defined for the type '{1}'.", p0, p1);
        }

        /// <summary>
        /// A string like  "The binary operator {0} is not defined for the types '{1}' and '{2}'."
        /// </summary>
        internal static string BinaryOperatorNotDefined(object p0, object p1, object p2) {
            return FormatString("The binary operator {0} is not defined for the types '{1}' and '{2}'.", p0, p1, p2);
        }

        /// <summary>
        /// A string like  "Reference equality is not defined for the types '{0}' and '{1}'."
        /// </summary>
        internal static string ReferenceEqualityNotDefined(object p0, object p1) {
            return FormatString("Reference equality is not defined for the types '{0}' and '{1}'.", p0, p1);
        }

        /// <summary>
        /// A string like  "The operands for operator '{0}' do not match the parameters of method '{1}'."
        /// </summary>
        internal static string OperandTypesDoNotMatchParameters(object p0, object p1) {
            return FormatString("The operands for operator '{0}' do not match the parameters of method '{1}'.", p0, p1);
        }

        /// <summary>
        /// A string like  "The return type of overload method for operator '{0}' does not match the parameter type of conversion method '{1}'."
        /// </summary>
        internal static string OverloadOperatorTypeDoesNotMatchConversionType(object p0, object p1) {
            return FormatString("The return type of overload method for operator '{0}' does not match the parameter type of conversion method '{1}'.", p0, p1);
        }

        /// <summary>
        /// A string like  "Conversion is not supported for arithmetic types without operator overloading."
        /// </summary>
        internal static string ConversionIsNotSupportedForArithmeticTypes {
            get {
                return "Conversion is not supported for arithmetic types without operator overloading.";
            }
        }

        /// <summary>
        /// A string like  "Argument must be array"
        /// </summary>
        internal static string ArgumentMustBeArray {
            get {
                return "Argument must be array";
            }
        }

        /// <summary>
        /// A string like  "Argument must be boolean"
        /// </summary>
        internal static string ArgumentMustBeBoolean {
            get {
                return "Argument must be boolean";
            }
        }

        /// <summary>
        /// A string like  "The user-defined equality method '{0}' must return a boolean value."
        /// </summary>
        internal static string EqualityMustReturnBoolean(object p0) {
            return FormatString("The user-defined equality method '{0}' must return a boolean value.", p0);
        }

        /// <summary>
        /// A string like  "Argument must be either a FieldInfo or PropertyInfo"
        /// </summary>
        internal static string ArgumentMustBeFieldInfoOrPropertInfo {
            get {
                return "Argument must be either a FieldInfo or PropertyInfo";
            }
        }

        /// <summary>
        /// A string like  "Argument must be either a FieldInfo, PropertyInfo or MethodInfo"
        /// </summary>
        internal static string ArgumentMustBeFieldInfoOrPropertInfoOrMethod {
            get {
                return "Argument must be either a FieldInfo, PropertyInfo or MethodInfo";
            }
        }

        /// <summary>
        /// A string like  "Argument must be an instance member"
        /// </summary>
        internal static string ArgumentMustBeInstanceMember {
            get {
                return "Argument must be an instance member";
            }
        }

        /// <summary>
        /// A string like  "Argument must be of an integer type"
        /// </summary>
        internal static string ArgumentMustBeInteger {
            get {
                return "Argument must be of an integer type";
            }
        }

        /// <summary>
        /// A string like  "Argument for array index must be of type Int32"
        /// </summary>
        internal static string ArgumentMustBeArrayIndexType {
            get {
                return "Argument for array index must be of type Int32";
            }
        }

        /// <summary>
        /// A string like  "Argument must be single dimensional array type"
        /// </summary>
        internal static string ArgumentMustBeSingleDimensionalArrayType {
            get {
                return "Argument must be single dimensional array type";
            }
        }

        /// <summary>
        /// A string like  "Argument types do not match"
        /// </summary>
        internal static string ArgumentTypesMustMatch {
            get {
                return "Argument types do not match";
            }
        }

        /// <summary>
        /// A string like  "Cannot auto initialize elements of value type through property '{0}', use assignment instead"
        /// </summary>
        internal static string CannotAutoInitializeValueTypeElementThroughProperty(object p0) {
            return FormatString("Cannot auto initialize elements of value type through property '{0}', use assignment instead", p0);
        }

        /// <summary>
        /// A string like  "Cannot auto initialize members of value type through property '{0}', use assignment instead"
        /// </summary>
        internal static string CannotAutoInitializeValueTypeMemberThroughProperty(object p0) {
            return FormatString("Cannot auto initialize members of value type through property '{0}', use assignment instead", p0);
        }

        /// <summary>
        /// A string like  "The type used in TypeAs Expression must be of reference or nullable type, {0} is neither"
        /// </summary>
        internal static string IncorrectTypeForTypeAs(object p0) {
            return FormatString("The type used in TypeAs Expression must be of reference or nullable type, {0} is neither", p0);
        }

        /// <summary>
        /// A string like  "Coalesce used with type that cannot be null"
        /// </summary>
        internal static string CoalesceUsedOnNonNullType {
            get {
                return "Coalesce used with type that cannot be null";
            }
        }

        /// <summary>
        /// A string like  "An expression of type '{0}' cannot be used to initialize an array of type '{1}'"
        /// </summary>
        internal static string ExpressionTypeCannotInitializeArrayType(object p0, object p1) {
            return FormatString("An expression of type '{0}' cannot be used to initialize an array of type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "Expression of type '{0}' cannot be used for constructor parameter of type '{1}'"
        /// </summary>
        internal static string ExpressionTypeDoesNotMatchConstructorParameter(object p0, object p1) {
            return FormatString("Expression of type '{0}' cannot be used for constructor parameter of type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  " Argument type '{0}' does not match the corresponding member type '{1}'"
        /// </summary>
        internal static string ArgumentTypeDoesNotMatchMember(object p0, object p1) {
            return FormatString(" Argument type '{0}' does not match the corresponding member type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  " The member '{0}' is not declared on type '{1}' being created"
        /// </summary>
        internal static string ArgumentMemberNotDeclOnType(object p0, object p1) {
            return FormatString(" The member '{0}' is not declared on type '{1}' being created", p0, p1);
        }

        /// <summary>
        /// A string like  "Expression of type '{0}' cannot be used for parameter of type '{1}' of method '{2}'"
        /// </summary>
        internal static string ExpressionTypeDoesNotMatchMethodParameter(object p0, object p1, object p2) {
            return FormatString("Expression of type '{0}' cannot be used for parameter of type '{1}' of method '{2}'", p0, p1, p2);
        }

        /// <summary>
        /// A string like  "Expression of type '{0}' cannot be used for parameter of type '{1}'"
        /// </summary>
        internal static string ExpressionTypeDoesNotMatchParameter(object p0, object p1) {
            return FormatString("Expression of type '{0}' cannot be used for parameter of type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "Expression of type '{0}' cannot be used for return type '{1}'"
        /// </summary>
        internal static string ExpressionTypeDoesNotMatchReturn(object p0, object p1) {
            return FormatString("Expression of type '{0}' cannot be used for return type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "Expression of type '{0}' cannot be used for assignment to type '{1}'"
        /// </summary>
        internal static string ExpressionTypeDoesNotMatchAssignment(object p0, object p1) {
            return FormatString("Expression of type '{0}' cannot be used for assignment to type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "Expression of type '{0}' cannot be used for label of type '{1}'"
        /// </summary>
        internal static string ExpressionTypeDoesNotMatchLabel(object p0, object p1) {
            return FormatString("Expression of type '{0}' cannot be used for label of type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "Expression of type '{0}' cannot be invoked"
        /// </summary>
        internal static string ExpressionTypeNotInvocable(object p0) {
            return FormatString("Expression of type '{0}' cannot be invoked", p0);
        }

        /// <summary>
        /// A string like  "Field '{0}' is not defined for type '{1}'"
        /// </summary>
        internal static string FieldNotDefinedForType(object p0, object p1) {
            return FormatString("Field '{0}' is not defined for type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "Instance field '{0}' is not defined for type '{1}'"
        /// </summary>
        internal static string InstanceFieldNotDefinedForType(object p0, object p1) {
            return FormatString("Instance field '{0}' is not defined for type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "Field '{0}.{1}' is not defined for type '{2}'"
        /// </summary>
        internal static string FieldInfoNotDefinedForType(object p0, object p1, object p2) {
            return FormatString("Field '{0}.{1}' is not defined for type '{2}'", p0, p1, p2);
        }

        /// <summary>
        /// A string like  "Incorrect number of indexes"
        /// </summary>
        internal static string IncorrectNumberOfIndexes {
            get {
                return "Incorrect number of indexes";
            }
        }

        /// <summary>
        /// A string like  "Incorrect number of arguments supplied for lambda invocation"
        /// </summary>
        internal static string IncorrectNumberOfLambdaArguments {
            get {
                return "Incorrect number of arguments supplied for lambda invocation";
            }
        }

        /// <summary>
        /// A string like  "Incorrect number of parameters supplied for lambda declaration"
        /// </summary>
        internal static string IncorrectNumberOfLambdaDeclarationParameters {
            get {
                return "Incorrect number of parameters supplied for lambda declaration";
            }
        }

        /// <summary>
        /// A string like  "Incorrect number of arguments supplied for call to method '{0}'"
        /// </summary>
        internal static string IncorrectNumberOfMethodCallArguments(object p0) {
            return FormatString("Incorrect number of arguments supplied for call to method '{0}'", p0);
        }

        /// <summary>
        /// A string like  "Incorrect number of arguments for constructor"
        /// </summary>
        internal static string IncorrectNumberOfConstructorArguments {
            get {
                return "Incorrect number of arguments for constructor";
            }
        }

        /// <summary>
        /// A string like  " Incorrect number of members for constructor"
        /// </summary>
        internal static string IncorrectNumberOfMembersForGivenConstructor {
            get {
                return " Incorrect number of members for constructor";
            }
        }

        /// <summary>
        /// A string like  "Incorrect number of arguments for the given members "
        /// </summary>
        internal static string IncorrectNumberOfArgumentsForMembers {
            get {
                return "Incorrect number of arguments for the given members ";
            }
        }

        /// <summary>
        /// A string like  "Lambda type parameter must be derived from System.Delegate"
        /// </summary>
        internal static string LambdaTypeMustBeDerivedFromSystemDelegate {
            get {
                return "Lambda type parameter must be derived from System.Delegate";
            }
        }

        /// <summary>
        /// A string like  "Member '{0}' not field or property"
        /// </summary>
        internal static string MemberNotFieldOrProperty(object p0) {
            return FormatString("Member '{0}' not field or property", p0);
        }

        /// <summary>
        /// A string like  "Method {0} contains generic parameters"
        /// </summary>
        internal static string MethodContainsGenericParameters(object p0) {
            return FormatString("Method {0} contains generic parameters", p0);
        }

        /// <summary>
        /// A string like  "Method {0} is a generic method definition"
        /// </summary>
        internal static string MethodIsGeneric(object p0) {
            return FormatString("Method {0} is a generic method definition", p0);
        }

        /// <summary>
        /// A string like  "The method '{0}.{1}' is not a property accessor"
        /// </summary>
        internal static string MethodNotPropertyAccessor(object p0, object p1) {
            return FormatString("The method '{0}.{1}' is not a property accessor", p0, p1);
        }

        /// <summary>
        /// A string like  "The property '{0}' has no 'get' accessor"
        /// </summary>
        internal static string PropertyDoesNotHaveGetter(object p0) {
            return FormatString("The property '{0}' has no 'get' accessor", p0);
        }

        /// <summary>
        /// A string like  "The property '{0}' has no 'set' accessor"
        /// </summary>
        internal static string PropertyDoesNotHaveSetter(object p0) {
            return FormatString("The property '{0}' has no 'set' accessor", p0);
        }

        /// <summary>
        /// A string like  "The property '{0}' has no 'get' or 'set' accessors"
        /// </summary>
        internal static string PropertyDoesNotHaveAccessor(object p0) {
            return FormatString("The property '{0}' has no 'get' or 'set' accessors", p0);
        }

        /// <summary>
        /// A string like  "'{0}' is not a member of type '{1}'"
        /// </summary>
        internal static string NotAMemberOfType(object p0, object p1) {
            return FormatString("'{0}' is not a member of type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "The operator '{0}' is not implemented for type '{1}'"
        /// </summary>
        internal static string OperatorNotImplementedForType(object p0, object p1) {
            return FormatString("The operator '{0}' is not implemented for type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "ParameterExpression of type '{0}' cannot be used for delegate parameter of type '{1}'"
        /// </summary>
        internal static string ParameterExpressionNotValidAsDelegate(object p0, object p1) {
            return FormatString("ParameterExpression of type '{0}' cannot be used for delegate parameter of type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "Property '{0}' is not defined for type '{1}'"
        /// </summary>
        internal static string PropertyNotDefinedForType(object p0, object p1) {
            return FormatString("Property '{0}' is not defined for type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "Instance property '{0}' is not defined for type '{1}'"
        /// </summary>
        internal static string InstancePropertyNotDefinedForType(object p0, object p1) {
            return FormatString("Instance property '{0}' is not defined for type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "Instance property '{0}' that takes no argument is not defined for type '{1}'"
        /// </summary>
        internal static string InstancePropertyWithoutParameterNotDefinedForType(object p0, object p1) {
            return FormatString("Instance property '{0}' that takes no argument is not defined for type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "Instance property '{0}{1}' is not defined for type '{2}'"
        /// </summary>
        internal static string InstancePropertyWithSpecifiedParametersNotDefinedForType(object p0, object p1, object p2) {
            return FormatString("Instance property '{0}{1}' is not defined for type '{2}'", p0, p1, p2);
        }

        /// <summary>
        /// A string like  "Method '{0}' declared on type '{1}' cannot be called with instance of type '{2}'"
        /// </summary>
        internal static string InstanceAndMethodTypeMismatch(object p0, object p1, object p2) {
            return FormatString("Method '{0}' declared on type '{1}' cannot be called with instance of type '{2}'", p0, p1, p2);
        }

        /// <summary>
        /// A string like  "Type {0} contains generic parameters"
        /// </summary>
        internal static string TypeContainsGenericParameters(object p0) {
            return FormatString("Type {0} contains generic parameters", p0);
        }

        /// <summary>
        /// A string like  "Type {0} is a generic type definition"
        /// </summary>
        internal static string TypeIsGeneric(object p0) {
            return FormatString("Type {0} is a generic type definition", p0);
        }

        /// <summary>
        /// A string like  "Type '{0}' does not have a default constructor"
        /// </summary>
        internal static string TypeMissingDefaultConstructor(object p0) {
            return FormatString("Type '{0}' does not have a default constructor", p0);
        }

        /// <summary>
        /// A string like  "List initializers must contain at least one initializer"
        /// </summary>
        internal static string ListInitializerWithZeroMembers {
            get {
                return "List initializers must contain at least one initializer";
            }
        }

        /// <summary>
        /// A string like  "Element initializer method must be named 'Add'"
        /// </summary>
        internal static string ElementInitializerMethodNotAdd {
            get {
                return "Element initializer method must be named 'Add'";
            }
        }

        /// <summary>
        /// A string like  "Parameter '{0}' of element initializer method '{1}' must not be a pass by reference parameter"
        /// </summary>
        internal static string ElementInitializerMethodNoRefOutParam(object p0, object p1) {
            return FormatString("Parameter '{0}' of element initializer method '{1}' must not be a pass by reference parameter", p0, p1);
        }

        /// <summary>
        /// A string like  "Element initializer method must have at least 1 parameter"
        /// </summary>
        internal static string ElementInitializerMethodWithZeroArgs {
            get {
                return "Element initializer method must have at least 1 parameter";
            }
        }

        /// <summary>
        /// A string like  "Element initializer method must be an instance method"
        /// </summary>
        internal static string ElementInitializerMethodStatic {
            get {
                return "Element initializer method must be an instance method";
            }
        }

        /// <summary>
        /// A string like  "Type '{0}' is not IEnumerable"
        /// </summary>
        internal static string TypeNotIEnumerable(object p0) {
            return FormatString("Type '{0}' is not IEnumerable", p0);
        }

        /// <summary>
        /// A string like  "Type parameter is {0}. Expected a delegate."
        /// </summary>
        internal static string TypeParameterIsNotDelegate(object p0) {
            return FormatString("Type parameter is {0}. Expected a delegate.", p0);
        }

        /// <summary>
        /// A string like  "Unexpected coalesce operator."
        /// </summary>
        internal static string UnexpectedCoalesceOperator {
            get {
                return "Unexpected coalesce operator.";
            }
        }

        /// <summary>
        /// A string like  "Cannot cast from type '{0}' to type '{1}"
        /// </summary>
        internal static string InvalidCast(object p0, object p1) {
            return FormatString("Cannot cast from type '{0}' to type '{1}", p0, p1);
        }

        /// <summary>
        /// A string like  "Unhandled binary: {0}"
        /// </summary>
        internal static string UnhandledBinary(object p0) {
            return FormatString("Unhandled binary: {0}", p0);
        }

        /// <summary>
        /// A string like  "Unhandled binding "
        /// </summary>
        internal static string UnhandledBinding {
            get {
                return "Unhandled binding ";
            }
        }

        /// <summary>
        /// A string like  "Unhandled Binding Type: {0}"
        /// </summary>
        internal static string UnhandledBindingType(object p0) {
            return FormatString("Unhandled Binding Type: {0}", p0);
        }

        /// <summary>
        /// A string like  "Unhandled convert: {0}"
        /// </summary>
        internal static string UnhandledConvert(object p0) {
            return FormatString("Unhandled convert: {0}", p0);
        }

        /// <summary>
        /// A string like  "Unhandled Expression Type: {0}"
        /// </summary>
        internal static string UnhandledExpressionType(object p0) {
            return FormatString("Unhandled Expression Type: {0}", p0);
        }

        /// <summary>
        /// A string like  "Unhandled unary: {0}"
        /// </summary>
        internal static string UnhandledUnary(object p0) {
            return FormatString("Unhandled unary: {0}", p0);
        }

        /// <summary>
        /// A string like  "Unknown binding type"
        /// </summary>
        internal static string UnknownBindingType {
            get {
                return "Unknown binding type";
            }
        }

        /// <summary>
        /// A string like  "The user-defined operator method '{1}' for operator '{0}' must have identical parameter and return types."
        /// </summary>
        internal static string UserDefinedOpMustHaveConsistentTypes(object p0, object p1) {
            return FormatString("The user-defined operator method '{1}' for operator '{0}' must have identical parameter and return types.", p0, p1);
        }

        /// <summary>
        /// A string like  "The user-defined operator method '{1}' for operator '{0}' must return the same type as its parameter or a derived type."
        /// </summary>
        internal static string UserDefinedOpMustHaveValidReturnType(object p0, object p1) {
            return FormatString("The user-defined operator method '{1}' for operator '{0}' must return the same type as its parameter or a derived type.", p0, p1);
        }

        /// <summary>
        /// A string like  "The user-defined operator method '{1}' for operator '{0}' must have associated boolean True and False operators."
        /// </summary>
        internal static string LogicalOperatorMustHaveBooleanOperators(object p0, object p1) {
            return FormatString("The user-defined operator method '{1}' for operator '{0}' must have associated boolean True and False operators.", p0, p1);
        }

        /// <summary>
        /// A string like  "No method '{0}' exists on type '{1}'."
        /// </summary>
        internal static string MethodDoesNotExistOnType(object p0, object p1) {
            return FormatString("No method '{0}' exists on type '{1}'.", p0, p1);
        }

        /// <summary>
        /// A string like  "No method '{0}' on type '{1}' is compatible with the supplied arguments."
        /// </summary>
        internal static string MethodWithArgsDoesNotExistOnType(object p0, object p1) {
            return FormatString("No method '{0}' on type '{1}' is compatible with the supplied arguments.", p0, p1);
        }

        /// <summary>
        /// A string like  "No generic method '{0}' on type '{1}' is compatible with the supplied type arguments and arguments. No type arguments should be provided if the method is non-generic. "
        /// </summary>
        internal static string GenericMethodWithArgsDoesNotExistOnType(object p0, object p1) {
            return FormatString("No generic method '{0}' on type '{1}' is compatible with the supplied type arguments and arguments. No type arguments should be provided if the method is non-generic. ", p0, p1);
        }

        /// <summary>
        /// A string like  "More than one method '{0}' on type '{1}' is compatible with the supplied arguments."
        /// </summary>
        internal static string MethodWithMoreThanOneMatch(object p0, object p1) {
            return FormatString("More than one method '{0}' on type '{1}' is compatible with the supplied arguments.", p0, p1);
        }

        /// <summary>
        /// A string like  "More than one property '{0}' on type '{1}' is compatible with the supplied arguments."
        /// </summary>
        internal static string PropertyWithMoreThanOneMatch(object p0, object p1) {
            return FormatString("More than one property '{0}' on type '{1}' is compatible with the supplied arguments.", p0, p1);
        }

        /// <summary>
        /// A string like  "An incorrect number of type args were specified for the declaration of a Func type."
        /// </summary>
        internal static string IncorrectNumberOfTypeArgsForFunc {
            get {
                return "An incorrect number of type args were specified for the declaration of a Func type.";
            }
        }

        /// <summary>
        /// A string like  "An incorrect number of type args were specified for the declaration of an Action type."
        /// </summary>
        internal static string IncorrectNumberOfTypeArgsForAction {
            get {
                return "An incorrect number of type args were specified for the declaration of an Action type.";
            }
        }

        /// <summary>
        /// A string like  "Argument type cannot be System.Void."
        /// </summary>
        internal static string ArgumentCannotBeOfTypeVoid {
            get {
                return "Argument type cannot be System.Void.";
            }
        }

        /// <summary>
        /// A string like  "More than one key matching '{0}' was found in the ExpandoObject."
        /// </summary>
        internal static string AmbiguousMatchInExpandoObject(object p0) {
            return FormatString("More than one key matching '{0}' was found in the ExpandoObject.", p0);
        }

        /// <summary>
        /// A string like  "An element with the same key '{0}' already exists in the ExpandoObject."
        /// </summary>
        internal static string SameKeyExistsInExpando(object p0) {
            return FormatString("An element with the same key '{0}' already exists in the ExpandoObject.", p0);
        }

        /// <summary>
        /// A string like  "The specified key '{0}' does not exist in the ExpandoObject."
        /// </summary>
        internal static string KeyDoesNotExistInExpando(object p0) {
            return FormatString("The specified key '{0}' does not exist in the ExpandoObject.", p0);
        }

        /// <summary>
        /// A string like  "No or Invalid rule produced"
        /// </summary>
        internal static string NoOrInvalidRuleProduced {
            get {
                return "No or Invalid rule produced";
            }
        }

        /// <summary>
        /// A string like  "First argument of delegate must be CallSite"
        /// </summary>
        internal static string FirstArgumentMustBeCallSite {
            get {
                return "First argument of delegate must be CallSite";
            }
        }

        /// <summary>
        /// A string like  "Bind cannot return null."
        /// </summary>
        internal static string BindingCannotBeNull {
            get {
                return "Bind cannot return null.";
            }
        }

        /// <summary>
        /// A string like  "Invalid operation: '{0}'"
        /// </summary>
        internal static string InvalidOperation(object p0) {
            return FormatString("Invalid operation: '{0}'", p0);
        }

        /// <summary>
        /// A string like  "{0} must be greater than or equal to {1}"
        /// </summary>
        internal static string OutOfRange(object p0, object p1) {
            return FormatString("{0} must be greater than or equal to {1}", p0, p1);
        }

        /// <summary>
        /// A string like  "Queue empty."
        /// </summary>
        internal static string QueueEmpty {
            get {
                return "Queue empty.";
            }
        }

        /// <summary>
        /// A string like  "Cannot redefine label '{0}' in an inner block."
        /// </summary>
        internal static string LabelTargetAlreadyDefined(object p0) {
            return FormatString("Cannot redefine label '{0}' in an inner block.", p0);
        }

        /// <summary>
        /// A string like  "Cannot jump to undefined label '{0}'."
        /// </summary>
        internal static string LabelTargetUndefined(object p0) {
            return FormatString("Cannot jump to undefined label '{0}'.", p0);
        }

        /// <summary>
        /// A string like  "Control cannot leave a finally block."
        /// </summary>
        internal static string ControlCannotLeaveFinally {
            get {
                return "Control cannot leave a finally block.";
            }
        }

        /// <summary>
        /// A string like  "Control cannot leave a filter test."
        /// </summary>
        internal static string ControlCannotLeaveFilterTest {
            get {
                return "Control cannot leave a filter test.";
            }
        }

        /// <summary>
        /// A string like  "Cannot jump to ambiguous label '{0}'."
        /// </summary>
        internal static string AmbiguousJump(object p0) {
            return FormatString("Cannot jump to ambiguous label '{0}'.", p0);
        }

        /// <summary>
        /// A string like  "Control cannot enter a try block."
        /// </summary>
        internal static string ControlCannotEnterTry {
            get {
                return "Control cannot enter a try block.";
            }
        }

        /// <summary>
        /// A string like  "Control cannot enter an expression--only statements can be jumped into."
        /// </summary>
        internal static string ControlCannotEnterExpression {
            get {
                return "Control cannot enter an expression--only statements can be jumped into.";
            }
        }

        /// <summary>
        /// A string like  "Cannot jump to non-local label '{0}' with a value. Only jumps to labels defined in outer blocks can pass values."
        /// </summary>
        internal static string NonLocalJumpWithValue(object p0) {
            return FormatString("Cannot jump to non-local label '{0}' with a value. Only jumps to labels defined in outer blocks can pass values.", p0);
        }

        /// <summary>
        /// A string like  "Extension should have been reduced."
        /// </summary>
        internal static string ExtensionNotReduced {
            get {
                return "Extension should have been reduced.";
            }
        }

        /// <summary>
        /// A string like  "CompileToMethod cannot compile constant '{0}' because it is a non-trivial value, such as a live object. Instead, create an expression tree that can construct this value."
        /// </summary>
        internal static string CannotCompileConstant(object p0) {
            return FormatString("CompileToMethod cannot compile constant '{0}' because it is a non-trivial value, such as a live object. Instead, create an expression tree that can construct this value.", p0);
        }

        /// <summary>
        /// A string like  "Dynamic expressions are not supported by CompileToMethod. Instead, create an expression tree that uses System.Runtime.CompilerServices.CallSite."
        /// </summary>
        internal static string CannotCompileDynamic {
            get {
                return "Dynamic expressions are not supported by CompileToMethod. Instead, create an expression tree that uses System.Runtime.CompilerServices.CallSite.";
            }
        }

        /// <summary>
        /// A string like  "Invalid lvalue for assignment: {0}."
        /// </summary>
        internal static string InvalidLvalue(object p0) {
            return FormatString("Invalid lvalue for assignment: {0}.", p0);
        }

        /// <summary>
        /// A string like  "Invalid member type: {0}."
        /// </summary>
        internal static string InvalidMemberType(object p0) {
            return FormatString("Invalid member type: {0}.", p0);
        }

        /// <summary>
        /// A string like  "unknown lift type: '{0}'."
        /// </summary>
        internal static string UnknownLiftType(object p0) {
            return FormatString("unknown lift type: '{0}'.", p0);
        }

        /// <summary>
        /// A string like  "Invalid output directory."
        /// </summary>
        internal static string InvalidOutputDir {
            get {
                return "Invalid output directory.";
            }
        }

        /// <summary>
        /// A string like  "Invalid assembly name or file extension."
        /// </summary>
        internal static string InvalidAsmNameOrExtension {
            get {
                return "Invalid assembly name or file extension.";
            }
        }

        /// <summary>
        /// A string like  "Collection is read-only."
        /// </summary>
        internal static string CollectionReadOnly {
            get {
                return "Collection is read-only.";
            }
        }

        /// <summary>
        /// A string like  "Cannot create instance of {0} because it contains generic parameters"
        /// </summary>
        internal static string IllegalNewGenericParams(object p0) {
            return FormatString("Cannot create instance of {0} because it contains generic parameters", p0);
        }

        /// <summary>
        /// A string like  "variable '{0}' of type '{1}' referenced from scope '{2}', but it is not defined"
        /// </summary>
        internal static string UndefinedVariable(object p0, object p1, object p2) {
            return FormatString("variable '{0}' of type '{1}' referenced from scope '{2}', but it is not defined", p0, p1, p2);
        }

        /// <summary>
        /// A string like  "Cannot close over byref parameter '{0}' referenced in lambda '{1}'"
        /// </summary>
        internal static string CannotCloseOverByRef(object p0, object p1) {
            return FormatString("Cannot close over byref parameter '{0}' referenced in lambda '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "Unexpected VarArgs call to method '{0}'"
        /// </summary>
        internal static string UnexpectedVarArgsCall(object p0) {
            return FormatString("Unexpected VarArgs call to method '{0}'", p0);
        }

        /// <summary>
        /// A string like  "Rethrow statement is valid only inside a Catch block."
        /// </summary>
        internal static string RethrowRequiresCatch {
            get {
                return "Rethrow statement is valid only inside a Catch block.";
            }
        }

        /// <summary>
        /// A string like  "Try expression is not allowed inside a filter body."
        /// </summary>
        internal static string TryNotAllowedInFilter {
            get {
                return "Try expression is not allowed inside a filter body.";
            }
        }

        /// <summary>
        /// A string like  "When called from '{0}', rewriting a node of type '{1}' must return a non-null value of the same type. Alternatively, override '{2}' and change it to not visit children of this type."
        /// </summary>
        internal static string MustRewriteToSameNode(object p0, object p1, object p2) {
            return FormatString("When called from '{0}', rewriting a node of type '{1}' must return a non-null value of the same type. Alternatively, override '{2}' and change it to not visit children of this type.", p0, p1, p2);
        }

        /// <summary>
        /// A string like  "Rewriting child expression from type '{0}' to type '{1}' is not allowed, because it would change the meaning of the operation. If this is intentional, override '{2}' and change it to allow this rewrite."
        /// </summary>
        internal static string MustRewriteChildToSameType(object p0, object p1, object p2) {
            return FormatString("Rewriting child expression from type '{0}' to type '{1}' is not allowed, because it would change the meaning of the operation. If this is intentional, override '{2}' and change it to allow this rewrite.", p0, p1, p2);
        }

        /// <summary>
        /// A string like  "Rewritten expression calls operator method '{0}', but the original node had no operator method. If this is is intentional, override '{1}' and change it to allow this rewrite."
        /// </summary>
        internal static string MustRewriteWithoutMethod(object p0, object p1) {
            return FormatString("Rewritten expression calls operator method '{0}', but the original node had no operator method. If this is is intentional, override '{1}' and change it to allow this rewrite.", p0, p1);
        }

        /// <summary>
        /// A string like  "The value null is not of type '{0}' and cannot be used in this collection."
        /// </summary>
        internal static string InvalidNullValue(object p0) {
            return FormatString("The value null is not of type '{0}' and cannot be used in this collection.", p0);
        }

        /// <summary>
        /// A string like  "The value '{0}' is not of type '{1}' and cannot be used in this collection."
        /// </summary>
        internal static string InvalidObjectType(object p0, object p1) {
            return FormatString("The value '{0}' is not of type '{1}' and cannot be used in this collection.", p0, p1);
        }

        /// <summary>
        /// A string like  "TryExpression is not supported as an argument to method '{0}' because it has an argument with by-ref type. Construct the tree so the TryExpression is not nested inside of this expression."
        /// </summary>
        internal static string TryNotSupportedForMethodsWithRefArgs(object p0) {
            return FormatString("TryExpression is not supported as an argument to method '{0}' because it has an argument with by-ref type. Construct the tree so the TryExpression is not nested inside of this expression.", p0);
        }

        /// <summary>
        /// A string like  "TryExpression is not supported as a child expression when accessing a member on type '{0}' because it is a value type. Construct the tree so the TryExpression is not nested inside of this expression."
        /// </summary>
        internal static string TryNotSupportedForValueTypeInstances(object p0) {
            return FormatString("TryExpression is not supported as a child expression when accessing a member on type '{0}' because it is a value type. Construct the tree so the TryExpression is not nested inside of this expression.", p0);
        }

        /// <summary>
        /// A string like  "Collection was modified; enumeration operation may not execute."
        /// </summary>
        internal static string CollectionModifiedWhileEnumerating {
            get {
                return "Collection was modified; enumeration operation may not execute.";
            }
        }

        /// <summary>
        /// A string like  "Enumeration has either not started or has already finished."
        /// </summary>
        internal static string EnumerationIsDone {
            get {
                return "Enumeration has either not started or has already finished.";
            }
        }

        /// <summary>
        /// A string like  "Dynamic operations can only be performed in homogenous AppDomain."
        /// </summary>
        internal static string HomogenousAppDomainRequired {
            get {
                return "Dynamic operations can only be performed in homogenous AppDomain.";
            }
        }

        /// <summary>
        /// A string like  "Test value of type '{0}' cannot be used for the comparison method parameter of type '{1}'"
        /// </summary>
        internal static string TestValueTypeDoesNotMatchComparisonMethodParameter(object p0, object p1) {
            return FormatString("Test value of type '{0}' cannot be used for the comparison method parameter of type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "Switch value of type '{0}' cannot be used for the comparison method parameter of type '{1}'"
        /// </summary>
        internal static string SwitchValueTypeDoesNotMatchComparisonMethodParameter(object p0, object p1) {
            return FormatString("Switch value of type '{0}' cannot be used for the comparison method parameter of type '{1}'", p0, p1);
        }

        /// <summary>
        /// A string like  "An IDynamicMetaObjectProvider {0} created an invalid DynamicMetaObject instance."
        /// </summary>
        internal static string InvalidMetaObjectCreated(object p0) {
            return FormatString("An IDynamicMetaObjectProvider {0} created an invalid DynamicMetaObject instance.", p0);
        }

        /// <summary>
        /// A string like  "DebugInfoGenerator created by CreatePdbGenerator can only be used with LambdaExpression.CompileToMethod."
        /// </summary>
        internal static string PdbGeneratorNeedsExpressionCompiler {
            get {
                return "DebugInfoGenerator created by CreatePdbGenerator can only be used with LambdaExpression.CompileToMethod.";
            }
        }

    }
    /// <summary>
    ///    Strongly-typed and parameterized exception factory.
    /// </summary>

    internal static partial class Error {
        /// <summary>
        /// ArgumentException with message like "Variable '{0}' uses unsupported type '{1}'. Reference types are not supported for variables."
        /// </summary>
        internal static Exception VariableMustNotBeByRef(object p0, object p1) {
            return new ArgumentException(Strings.VariableMustNotBeByRef(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Found duplicate parameter '{0}'. Each ParameterExpression in the list must be a unique object."
        /// </summary>
        internal static Exception DuplicateVariable(object p0) {
            return new ArgumentException(Strings.DuplicateVariable(p0));
        }

        /// <summary>
        /// ArgumentException with message like "Start and End must be well ordered"
        /// </summary>
        internal static Exception StartEndMustBeOrdered() {
            return new ArgumentException(Strings.StartEndMustBeOrdered);
        }

        /// <summary>
        /// ArgumentException with message like "fault cannot be used with catch or finally clauses"
        /// </summary>
        internal static Exception FaultCannotHaveCatchOrFinally() {
            return new ArgumentException(Strings.FaultCannotHaveCatchOrFinally);
        }

        /// <summary>
        /// ArgumentException with message like "try must have at least one catch, finally, or fault clause"
        /// </summary>
        internal static Exception TryMustHaveCatchFinallyOrFault() {
            return new ArgumentException(Strings.TryMustHaveCatchFinallyOrFault);
        }

        /// <summary>
        /// ArgumentException with message like "Body of catch must have the same type as body of try."
        /// </summary>
        internal static Exception BodyOfCatchMustHaveSameTypeAsBodyOfTry() {
            return new ArgumentException(Strings.BodyOfCatchMustHaveSameTypeAsBodyOfTry);
        }

        /// <summary>
        /// InvalidOperationException with message like "Extension node must override the property {0}."
        /// </summary>
        internal static Exception ExtensionNodeMustOverrideProperty(object p0) {
            return new InvalidOperationException(Strings.ExtensionNodeMustOverrideProperty(p0));
        }

        /// <summary>
        /// ArgumentException with message like "User-defined operator method '{0}' must be static."
        /// </summary>
        internal static Exception UserDefinedOperatorMustBeStatic(object p0) {
            return new ArgumentException(Strings.UserDefinedOperatorMustBeStatic(p0));
        }

        /// <summary>
        /// ArgumentException with message like "User-defined operator method '{0}' must not be void."
        /// </summary>
        internal static Exception UserDefinedOperatorMustNotBeVoid(object p0) {
            return new ArgumentException(Strings.UserDefinedOperatorMustNotBeVoid(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "No coercion operator is defined between types '{0}' and '{1}'."
        /// </summary>
        internal static Exception CoercionOperatorNotDefined(object p0, object p1) {
            return new InvalidOperationException(Strings.CoercionOperatorNotDefined(p0, p1));
        }

        /// <summary>
        /// InvalidCastException with message like "The result type '{0}' of the dynamic binding produced by binder '{1}' is not compatible with the result type '{2}' expected by the call site."
        /// </summary>
        internal static Exception DynamicBinderResultNotAssignable(object p0, object p1, object p2) {
            return new InvalidCastException(Strings.DynamicBinderResultNotAssignable(p0, p1, p2));
        }

        /// <summary>
        /// InvalidCastException with message like "The result type '{0}' of the dynamic binding produced by the object with type '{1}' for the binder '{2}' is not compatible with the result type '{3}' expected by the call site."
        /// </summary>
        internal static Exception DynamicObjectResultNotAssignable(object p0, object p1, object p2, object p3) {
            return new InvalidCastException(Strings.DynamicObjectResultNotAssignable(p0, p1, p2, p3));
        }

        /// <summary>
        /// InvalidOperationException with message like "The result of the dynamic binding produced by the object with type '{0}' for the binder '{1}' needs at least one restriction."
        /// </summary>
        internal static Exception DynamicBindingNeedsRestrictions(object p0, object p1) {
            return new InvalidOperationException(Strings.DynamicBindingNeedsRestrictions(p0, p1));
        }

        /// <summary>
        /// InvalidOperationException with message like "The result type '{0}' of the binder '{1}' is not compatible with the result type '{2}' expected by the call site."
        /// </summary>
        internal static Exception BinderNotCompatibleWithCallSite(object p0, object p1, object p2) {
            return new InvalidOperationException(Strings.BinderNotCompatibleWithCallSite(p0, p1, p2));
        }

        /// <summary>
        /// InvalidOperationException with message like "The unary operator {0} is not defined for the type '{1}'."
        /// </summary>
        internal static Exception UnaryOperatorNotDefined(object p0, object p1) {
            return new InvalidOperationException(Strings.UnaryOperatorNotDefined(p0, p1));
        }

        /// <summary>
        /// InvalidOperationException with message like "The binary operator {0} is not defined for the types '{1}' and '{2}'."
        /// </summary>
        internal static Exception BinaryOperatorNotDefined(object p0, object p1, object p2) {
            return new InvalidOperationException(Strings.BinaryOperatorNotDefined(p0, p1, p2));
        }

        /// <summary>
        /// InvalidOperationException with message like "Reference equality is not defined for the types '{0}' and '{1}'."
        /// </summary>
        internal static Exception ReferenceEqualityNotDefined(object p0, object p1) {
            return new InvalidOperationException(Strings.ReferenceEqualityNotDefined(p0, p1));
        }

        /// <summary>
        /// InvalidOperationException with message like "The operands for operator '{0}' do not match the parameters of method '{1}'."
        /// </summary>
        internal static Exception OperandTypesDoNotMatchParameters(object p0, object p1) {
            return new InvalidOperationException(Strings.OperandTypesDoNotMatchParameters(p0, p1));
        }

        /// <summary>
        /// InvalidOperationException with message like "The return type of overload method for operator '{0}' does not match the parameter type of conversion method '{1}'."
        /// </summary>
        internal static Exception OverloadOperatorTypeDoesNotMatchConversionType(object p0, object p1) {
            return new InvalidOperationException(Strings.OverloadOperatorTypeDoesNotMatchConversionType(p0, p1));
        }

        /// <summary>
        /// InvalidOperationException with message like "Conversion is not supported for arithmetic types without operator overloading."
        /// </summary>
        internal static Exception ConversionIsNotSupportedForArithmeticTypes() {
            return new InvalidOperationException(Strings.ConversionIsNotSupportedForArithmeticTypes);
        }

        /// <summary>
        /// ArgumentException with message like "Argument must be array"
        /// </summary>
        internal static Exception ArgumentMustBeArray() {
            return new ArgumentException(Strings.ArgumentMustBeArray);
        }

        /// <summary>
        /// ArgumentException with message like "Argument must be boolean"
        /// </summary>
        internal static Exception ArgumentMustBeBoolean() {
            return new ArgumentException(Strings.ArgumentMustBeBoolean);
        }

        /// <summary>
        /// ArgumentException with message like "The user-defined equality method '{0}' must return a boolean value."
        /// </summary>
        internal static Exception EqualityMustReturnBoolean(object p0) {
            return new ArgumentException(Strings.EqualityMustReturnBoolean(p0));
        }

        /// <summary>
        /// ArgumentException with message like "Argument must be either a FieldInfo or PropertyInfo"
        /// </summary>
        internal static Exception ArgumentMustBeFieldInfoOrPropertInfo() {
            return new ArgumentException(Strings.ArgumentMustBeFieldInfoOrPropertInfo);
        }

        /// <summary>
        /// ArgumentException with message like "Argument must be either a FieldInfo, PropertyInfo or MethodInfo"
        /// </summary>
        internal static Exception ArgumentMustBeFieldInfoOrPropertInfoOrMethod() {
            return new ArgumentException(Strings.ArgumentMustBeFieldInfoOrPropertInfoOrMethod);
        }

        /// <summary>
        /// ArgumentException with message like "Argument must be an instance member"
        /// </summary>
        internal static Exception ArgumentMustBeInstanceMember() {
            return new ArgumentException(Strings.ArgumentMustBeInstanceMember);
        }

        /// <summary>
        /// ArgumentException with message like "Argument must be of an integer type"
        /// </summary>
        internal static Exception ArgumentMustBeInteger() {
            return new ArgumentException(Strings.ArgumentMustBeInteger);
        }

        /// <summary>
        /// ArgumentException with message like "Argument for array index must be of type Int32"
        /// </summary>
        internal static Exception ArgumentMustBeArrayIndexType() {
            return new ArgumentException(Strings.ArgumentMustBeArrayIndexType);
        }

        /// <summary>
        /// ArgumentException with message like "Argument must be single dimensional array type"
        /// </summary>
        internal static Exception ArgumentMustBeSingleDimensionalArrayType() {
            return new ArgumentException(Strings.ArgumentMustBeSingleDimensionalArrayType);
        }

        /// <summary>
        /// ArgumentException with message like "Argument types do not match"
        /// </summary>
        internal static Exception ArgumentTypesMustMatch() {
            return new ArgumentException(Strings.ArgumentTypesMustMatch);
        }

        /// <summary>
        /// InvalidOperationException with message like "Cannot auto initialize elements of value type through property '{0}', use assignment instead"
        /// </summary>
        internal static Exception CannotAutoInitializeValueTypeElementThroughProperty(object p0) {
            return new InvalidOperationException(Strings.CannotAutoInitializeValueTypeElementThroughProperty(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "Cannot auto initialize members of value type through property '{0}', use assignment instead"
        /// </summary>
        internal static Exception CannotAutoInitializeValueTypeMemberThroughProperty(object p0) {
            return new InvalidOperationException(Strings.CannotAutoInitializeValueTypeMemberThroughProperty(p0));
        }

        /// <summary>
        /// ArgumentException with message like "The type used in TypeAs Expression must be of reference or nullable type, {0} is neither"
        /// </summary>
        internal static Exception IncorrectTypeForTypeAs(object p0) {
            return new ArgumentException(Strings.IncorrectTypeForTypeAs(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "Coalesce used with type that cannot be null"
        /// </summary>
        internal static Exception CoalesceUsedOnNonNullType() {
            return new InvalidOperationException(Strings.CoalesceUsedOnNonNullType);
        }

        /// <summary>
        /// InvalidOperationException with message like "An expression of type '{0}' cannot be used to initialize an array of type '{1}'"
        /// </summary>
        internal static Exception ExpressionTypeCannotInitializeArrayType(object p0, object p1) {
            return new InvalidOperationException(Strings.ExpressionTypeCannotInitializeArrayType(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Expression of type '{0}' cannot be used for constructor parameter of type '{1}'"
        /// </summary>
        internal static Exception ExpressionTypeDoesNotMatchConstructorParameter(object p0, object p1) {
            return new ArgumentException(Strings.ExpressionTypeDoesNotMatchConstructorParameter(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like " Argument type '{0}' does not match the corresponding member type '{1}'"
        /// </summary>
        internal static Exception ArgumentTypeDoesNotMatchMember(object p0, object p1) {
            return new ArgumentException(Strings.ArgumentTypeDoesNotMatchMember(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like " The member '{0}' is not declared on type '{1}' being created"
        /// </summary>
        internal static Exception ArgumentMemberNotDeclOnType(object p0, object p1) {
            return new ArgumentException(Strings.ArgumentMemberNotDeclOnType(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Expression of type '{0}' cannot be used for parameter of type '{1}' of method '{2}'"
        /// </summary>
        internal static Exception ExpressionTypeDoesNotMatchMethodParameter(object p0, object p1, object p2) {
            return new ArgumentException(Strings.ExpressionTypeDoesNotMatchMethodParameter(p0, p1, p2));
        }

        /// <summary>
        /// ArgumentException with message like "Expression of type '{0}' cannot be used for parameter of type '{1}'"
        /// </summary>
        internal static Exception ExpressionTypeDoesNotMatchParameter(object p0, object p1) {
            return new ArgumentException(Strings.ExpressionTypeDoesNotMatchParameter(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Expression of type '{0}' cannot be used for return type '{1}'"
        /// </summary>
        internal static Exception ExpressionTypeDoesNotMatchReturn(object p0, object p1) {
            return new ArgumentException(Strings.ExpressionTypeDoesNotMatchReturn(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Expression of type '{0}' cannot be used for assignment to type '{1}'"
        /// </summary>
        internal static Exception ExpressionTypeDoesNotMatchAssignment(object p0, object p1) {
            return new ArgumentException(Strings.ExpressionTypeDoesNotMatchAssignment(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Expression of type '{0}' cannot be used for label of type '{1}'"
        /// </summary>
        internal static Exception ExpressionTypeDoesNotMatchLabel(object p0, object p1) {
            return new ArgumentException(Strings.ExpressionTypeDoesNotMatchLabel(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Expression of type '{0}' cannot be invoked"
        /// </summary>
        internal static Exception ExpressionTypeNotInvocable(object p0) {
            return new ArgumentException(Strings.ExpressionTypeNotInvocable(p0));
        }

        /// <summary>
        /// ArgumentException with message like "Field '{0}' is not defined for type '{1}'"
        /// </summary>
        internal static Exception FieldNotDefinedForType(object p0, object p1) {
            return new ArgumentException(Strings.FieldNotDefinedForType(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Instance field '{0}' is not defined for type '{1}'"
        /// </summary>
        internal static Exception InstanceFieldNotDefinedForType(object p0, object p1) {
            return new ArgumentException(Strings.InstanceFieldNotDefinedForType(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Field '{0}.{1}' is not defined for type '{2}'"
        /// </summary>
        internal static Exception FieldInfoNotDefinedForType(object p0, object p1, object p2) {
            return new ArgumentException(Strings.FieldInfoNotDefinedForType(p0, p1, p2));
        }

        /// <summary>
        /// ArgumentException with message like "Incorrect number of indexes"
        /// </summary>
        internal static Exception IncorrectNumberOfIndexes() {
            return new ArgumentException(Strings.IncorrectNumberOfIndexes);
        }

        /// <summary>
        /// InvalidOperationException with message like "Incorrect number of arguments supplied for lambda invocation"
        /// </summary>
        internal static Exception IncorrectNumberOfLambdaArguments() {
            return new InvalidOperationException(Strings.IncorrectNumberOfLambdaArguments);
        }

        /// <summary>
        /// ArgumentException with message like "Incorrect number of parameters supplied for lambda declaration"
        /// </summary>
        internal static Exception IncorrectNumberOfLambdaDeclarationParameters() {
            return new ArgumentException(Strings.IncorrectNumberOfLambdaDeclarationParameters);
        }

        /// <summary>
        /// ArgumentException with message like "Incorrect number of arguments supplied for call to method '{0}'"
        /// </summary>
        internal static Exception IncorrectNumberOfMethodCallArguments(object p0) {
            return new ArgumentException(Strings.IncorrectNumberOfMethodCallArguments(p0));
        }

        /// <summary>
        /// ArgumentException with message like "Incorrect number of arguments for constructor"
        /// </summary>
        internal static Exception IncorrectNumberOfConstructorArguments() {
            return new ArgumentException(Strings.IncorrectNumberOfConstructorArguments);
        }

        /// <summary>
        /// ArgumentException with message like " Incorrect number of members for constructor"
        /// </summary>
        internal static Exception IncorrectNumberOfMembersForGivenConstructor() {
            return new ArgumentException(Strings.IncorrectNumberOfMembersForGivenConstructor);
        }

        /// <summary>
        /// ArgumentException with message like "Incorrect number of arguments for the given members "
        /// </summary>
        internal static Exception IncorrectNumberOfArgumentsForMembers() {
            return new ArgumentException(Strings.IncorrectNumberOfArgumentsForMembers);
        }

        /// <summary>
        /// ArgumentException with message like "Lambda type parameter must be derived from System.Delegate"
        /// </summary>
        internal static Exception LambdaTypeMustBeDerivedFromSystemDelegate() {
            return new ArgumentException(Strings.LambdaTypeMustBeDerivedFromSystemDelegate);
        }

        /// <summary>
        /// ArgumentException with message like "Member '{0}' not field or property"
        /// </summary>
        internal static Exception MemberNotFieldOrProperty(object p0) {
            return new ArgumentException(Strings.MemberNotFieldOrProperty(p0));
        }

        /// <summary>
        /// ArgumentException with message like "Method {0} contains generic parameters"
        /// </summary>
        internal static Exception MethodContainsGenericParameters(object p0) {
            return new ArgumentException(Strings.MethodContainsGenericParameters(p0));
        }

        /// <summary>
        /// ArgumentException with message like "Method {0} is a generic method definition"
        /// </summary>
        internal static Exception MethodIsGeneric(object p0) {
            return new ArgumentException(Strings.MethodIsGeneric(p0));
        }

        /// <summary>
        /// ArgumentException with message like "The method '{0}.{1}' is not a property accessor"
        /// </summary>
        internal static Exception MethodNotPropertyAccessor(object p0, object p1) {
            return new ArgumentException(Strings.MethodNotPropertyAccessor(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "The property '{0}' has no 'get' accessor"
        /// </summary>
        internal static Exception PropertyDoesNotHaveGetter(object p0) {
            return new ArgumentException(Strings.PropertyDoesNotHaveGetter(p0));
        }

        /// <summary>
        /// ArgumentException with message like "The property '{0}' has no 'set' accessor"
        /// </summary>
        internal static Exception PropertyDoesNotHaveSetter(object p0) {
            return new ArgumentException(Strings.PropertyDoesNotHaveSetter(p0));
        }

        /// <summary>
        /// ArgumentException with message like "The property '{0}' has no 'get' or 'set' accessors"
        /// </summary>
        internal static Exception PropertyDoesNotHaveAccessor(object p0) {
            return new ArgumentException(Strings.PropertyDoesNotHaveAccessor(p0));
        }

        /// <summary>
        /// ArgumentException with message like "'{0}' is not a member of type '{1}'"
        /// </summary>
        internal static Exception NotAMemberOfType(object p0, object p1) {
            return new ArgumentException(Strings.NotAMemberOfType(p0, p1));
        }

        /// <summary>
        /// NotImplementedException with message like "The operator '{0}' is not implemented for type '{1}'"
        /// </summary>
        internal static Exception OperatorNotImplementedForType(object p0, object p1) {
            return new NotImplementedException(Strings.OperatorNotImplementedForType(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "ParameterExpression of type '{0}' cannot be used for delegate parameter of type '{1}'"
        /// </summary>
        internal static Exception ParameterExpressionNotValidAsDelegate(object p0, object p1) {
            return new ArgumentException(Strings.ParameterExpressionNotValidAsDelegate(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Property '{0}' is not defined for type '{1}'"
        /// </summary>
        internal static Exception PropertyNotDefinedForType(object p0, object p1) {
            return new ArgumentException(Strings.PropertyNotDefinedForType(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Instance property '{0}' is not defined for type '{1}'"
        /// </summary>
        internal static Exception InstancePropertyNotDefinedForType(object p0, object p1) {
            return new ArgumentException(Strings.InstancePropertyNotDefinedForType(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Instance property '{0}' that takes no argument is not defined for type '{1}'"
        /// </summary>
        internal static Exception InstancePropertyWithoutParameterNotDefinedForType(object p0, object p1) {
            return new ArgumentException(Strings.InstancePropertyWithoutParameterNotDefinedForType(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Instance property '{0}{1}' is not defined for type '{2}'"
        /// </summary>
        internal static Exception InstancePropertyWithSpecifiedParametersNotDefinedForType(object p0, object p1, object p2) {
            return new ArgumentException(Strings.InstancePropertyWithSpecifiedParametersNotDefinedForType(p0, p1, p2));
        }

        /// <summary>
        /// ArgumentException with message like "Method '{0}' declared on type '{1}' cannot be called with instance of type '{2}'"
        /// </summary>
        internal static Exception InstanceAndMethodTypeMismatch(object p0, object p1, object p2) {
            return new ArgumentException(Strings.InstanceAndMethodTypeMismatch(p0, p1, p2));
        }

        /// <summary>
        /// ArgumentException with message like "Type {0} contains generic parameters"
        /// </summary>
        internal static Exception TypeContainsGenericParameters(object p0) {
            return new ArgumentException(Strings.TypeContainsGenericParameters(p0));
        }

        /// <summary>
        /// ArgumentException with message like "Type {0} is a generic type definition"
        /// </summary>
        internal static Exception TypeIsGeneric(object p0) {
            return new ArgumentException(Strings.TypeIsGeneric(p0));
        }

        /// <summary>
        /// ArgumentException with message like "Type '{0}' does not have a default constructor"
        /// </summary>
        internal static Exception TypeMissingDefaultConstructor(object p0) {
            return new ArgumentException(Strings.TypeMissingDefaultConstructor(p0));
        }

        /// <summary>
        /// ArgumentException with message like "List initializers must contain at least one initializer"
        /// </summary>
        internal static Exception ListInitializerWithZeroMembers() {
            return new ArgumentException(Strings.ListInitializerWithZeroMembers);
        }

        /// <summary>
        /// ArgumentException with message like "Element initializer method must be named 'Add'"
        /// </summary>
        internal static Exception ElementInitializerMethodNotAdd() {
            return new ArgumentException(Strings.ElementInitializerMethodNotAdd);
        }

        /// <summary>
        /// ArgumentException with message like "Parameter '{0}' of element initializer method '{1}' must not be a pass by reference parameter"
        /// </summary>
        internal static Exception ElementInitializerMethodNoRefOutParam(object p0, object p1) {
            return new ArgumentException(Strings.ElementInitializerMethodNoRefOutParam(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Element initializer method must have at least 1 parameter"
        /// </summary>
        internal static Exception ElementInitializerMethodWithZeroArgs() {
            return new ArgumentException(Strings.ElementInitializerMethodWithZeroArgs);
        }

        /// <summary>
        /// ArgumentException with message like "Element initializer method must be an instance method"
        /// </summary>
        internal static Exception ElementInitializerMethodStatic() {
            return new ArgumentException(Strings.ElementInitializerMethodStatic);
        }

        /// <summary>
        /// ArgumentException with message like "Type '{0}' is not IEnumerable"
        /// </summary>
        internal static Exception TypeNotIEnumerable(object p0) {
            return new ArgumentException(Strings.TypeNotIEnumerable(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "Type parameter is {0}. Expected a delegate."
        /// </summary>
        internal static Exception TypeParameterIsNotDelegate(object p0) {
            return new InvalidOperationException(Strings.TypeParameterIsNotDelegate(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "Unexpected coalesce operator."
        /// </summary>
        internal static Exception UnexpectedCoalesceOperator() {
            return new InvalidOperationException(Strings.UnexpectedCoalesceOperator);
        }

        /// <summary>
        /// InvalidOperationException with message like "Cannot cast from type '{0}' to type '{1}"
        /// </summary>
        internal static Exception InvalidCast(object p0, object p1) {
            return new InvalidOperationException(Strings.InvalidCast(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Unhandled binary: {0}"
        /// </summary>
        internal static Exception UnhandledBinary(object p0) {
            return new ArgumentException(Strings.UnhandledBinary(p0));
        }

        /// <summary>
        /// ArgumentException with message like "Unhandled binding "
        /// </summary>
        internal static Exception UnhandledBinding() {
            return new ArgumentException(Strings.UnhandledBinding);
        }

        /// <summary>
        /// ArgumentException with message like "Unhandled Binding Type: {0}"
        /// </summary>
        internal static Exception UnhandledBindingType(object p0) {
            return new ArgumentException(Strings.UnhandledBindingType(p0));
        }

        /// <summary>
        /// ArgumentException with message like "Unhandled convert: {0}"
        /// </summary>
        internal static Exception UnhandledConvert(object p0) {
            return new ArgumentException(Strings.UnhandledConvert(p0));
        }

        /// <summary>
        /// ArgumentException with message like "Unhandled Expression Type: {0}"
        /// </summary>
        internal static Exception UnhandledExpressionType(object p0) {
            return new ArgumentException(Strings.UnhandledExpressionType(p0));
        }

        /// <summary>
        /// ArgumentException with message like "Unhandled unary: {0}"
        /// </summary>
        internal static Exception UnhandledUnary(object p0) {
            return new ArgumentException(Strings.UnhandledUnary(p0));
        }

        /// <summary>
        /// ArgumentException with message like "Unknown binding type"
        /// </summary>
        internal static Exception UnknownBindingType() {
            return new ArgumentException(Strings.UnknownBindingType);
        }

        /// <summary>
        /// ArgumentException with message like "The user-defined operator method '{1}' for operator '{0}' must have identical parameter and return types."
        /// </summary>
        internal static Exception UserDefinedOpMustHaveConsistentTypes(object p0, object p1) {
            return new ArgumentException(Strings.UserDefinedOpMustHaveConsistentTypes(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "The user-defined operator method '{1}' for operator '{0}' must return the same type as its parameter or a derived type."
        /// </summary>
        internal static Exception UserDefinedOpMustHaveValidReturnType(object p0, object p1) {
            return new ArgumentException(Strings.UserDefinedOpMustHaveValidReturnType(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "The user-defined operator method '{1}' for operator '{0}' must have associated boolean True and False operators."
        /// </summary>
        internal static Exception LogicalOperatorMustHaveBooleanOperators(object p0, object p1) {
            return new ArgumentException(Strings.LogicalOperatorMustHaveBooleanOperators(p0, p1));
        }

        /// <summary>
        /// InvalidOperationException with message like "No method '{0}' exists on type '{1}'."
        /// </summary>
        internal static Exception MethodDoesNotExistOnType(object p0, object p1) {
            return new InvalidOperationException(Strings.MethodDoesNotExistOnType(p0, p1));
        }

        /// <summary>
        /// InvalidOperationException with message like "No method '{0}' on type '{1}' is compatible with the supplied arguments."
        /// </summary>
        internal static Exception MethodWithArgsDoesNotExistOnType(object p0, object p1) {
            return new InvalidOperationException(Strings.MethodWithArgsDoesNotExistOnType(p0, p1));
        }

        /// <summary>
        /// InvalidOperationException with message like "No generic method '{0}' on type '{1}' is compatible with the supplied type arguments and arguments. No type arguments should be provided if the method is non-generic. "
        /// </summary>
        internal static Exception GenericMethodWithArgsDoesNotExistOnType(object p0, object p1) {
            return new InvalidOperationException(Strings.GenericMethodWithArgsDoesNotExistOnType(p0, p1));
        }

        /// <summary>
        /// InvalidOperationException with message like "More than one method '{0}' on type '{1}' is compatible with the supplied arguments."
        /// </summary>
        internal static Exception MethodWithMoreThanOneMatch(object p0, object p1) {
            return new InvalidOperationException(Strings.MethodWithMoreThanOneMatch(p0, p1));
        }

        /// <summary>
        /// InvalidOperationException with message like "More than one property '{0}' on type '{1}' is compatible with the supplied arguments."
        /// </summary>
        internal static Exception PropertyWithMoreThanOneMatch(object p0, object p1) {
            return new InvalidOperationException(Strings.PropertyWithMoreThanOneMatch(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "An incorrect number of type args were specified for the declaration of a Func type."
        /// </summary>
        internal static Exception IncorrectNumberOfTypeArgsForFunc() {
            return new ArgumentException(Strings.IncorrectNumberOfTypeArgsForFunc);
        }

        /// <summary>
        /// ArgumentException with message like "An incorrect number of type args were specified for the declaration of an Action type."
        /// </summary>
        internal static Exception IncorrectNumberOfTypeArgsForAction() {
            return new ArgumentException(Strings.IncorrectNumberOfTypeArgsForAction);
        }

        /// <summary>
        /// ArgumentException with message like "Argument type cannot be System.Void."
        /// </summary>
        internal static Exception ArgumentCannotBeOfTypeVoid() {
            return new ArgumentException(Strings.ArgumentCannotBeOfTypeVoid);
        }

        /// <summary>
        /// System.Reflection.AmbiguousMatchException with message like "More than one key matching '{0}' was found in the ExpandoObject."
        /// </summary>
        internal static Exception AmbiguousMatchInExpandoObject(object p0) {
            return new System.Reflection.AmbiguousMatchException(Strings.AmbiguousMatchInExpandoObject(p0));
        }

        /// <summary>
        /// ArgumentException with message like "An element with the same key '{0}' already exists in the ExpandoObject."
        /// </summary>
        internal static Exception SameKeyExistsInExpando(object p0) {
            return new ArgumentException(Strings.SameKeyExistsInExpando(p0));
        }

        /// <summary>
        /// System.Collections.Generic.KeyNotFoundException with message like "The specified key '{0}' does not exist in the ExpandoObject."
        /// </summary>
        internal static Exception KeyDoesNotExistInExpando(object p0) {
            return new System.Collections.Generic.KeyNotFoundException(Strings.KeyDoesNotExistInExpando(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "No or Invalid rule produced"
        /// </summary>
        internal static Exception NoOrInvalidRuleProduced() {
            return new InvalidOperationException(Strings.NoOrInvalidRuleProduced);
        }

        /// <summary>
        /// ArgumentException with message like "First argument of delegate must be CallSite"
        /// </summary>
        internal static Exception FirstArgumentMustBeCallSite() {
            return new ArgumentException(Strings.FirstArgumentMustBeCallSite);
        }

        /// <summary>
        /// InvalidOperationException with message like "Bind cannot return null."
        /// </summary>
        internal static Exception BindingCannotBeNull() {
            return new InvalidOperationException(Strings.BindingCannotBeNull);
        }

        /// <summary>
        /// ArgumentException with message like "Invalid operation: '{0}'"
        /// </summary>
        internal static Exception InvalidOperation(object p0) {
            return new ArgumentException(Strings.InvalidOperation(p0));
        }

        /// <summary>
        /// ArgumentOutOfRangeException with message like "{0} must be greater than or equal to {1}"
        /// </summary>
        internal static Exception OutOfRange(object p0, object p1) {
            return new ArgumentOutOfRangeException(Strings.OutOfRange(p0, p1));
        }

        /// <summary>
        /// InvalidOperationException with message like "Queue empty."
        /// </summary>
        internal static Exception QueueEmpty() {
            return new InvalidOperationException(Strings.QueueEmpty);
        }

        /// <summary>
        /// InvalidOperationException with message like "Cannot redefine label '{0}' in an inner block."
        /// </summary>
        internal static Exception LabelTargetAlreadyDefined(object p0) {
            return new InvalidOperationException(Strings.LabelTargetAlreadyDefined(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "Cannot jump to undefined label '{0}'."
        /// </summary>
        internal static Exception LabelTargetUndefined(object p0) {
            return new InvalidOperationException(Strings.LabelTargetUndefined(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "Control cannot leave a finally block."
        /// </summary>
        internal static Exception ControlCannotLeaveFinally() {
            return new InvalidOperationException(Strings.ControlCannotLeaveFinally);
        }

        /// <summary>
        /// InvalidOperationException with message like "Control cannot leave a filter test."
        /// </summary>
        internal static Exception ControlCannotLeaveFilterTest() {
            return new InvalidOperationException(Strings.ControlCannotLeaveFilterTest);
        }

        /// <summary>
        /// InvalidOperationException with message like "Cannot jump to ambiguous label '{0}'."
        /// </summary>
        internal static Exception AmbiguousJump(object p0) {
            return new InvalidOperationException(Strings.AmbiguousJump(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "Control cannot enter a try block."
        /// </summary>
        internal static Exception ControlCannotEnterTry() {
            return new InvalidOperationException(Strings.ControlCannotEnterTry);
        }

        /// <summary>
        /// InvalidOperationException with message like "Control cannot enter an expression--only statements can be jumped into."
        /// </summary>
        internal static Exception ControlCannotEnterExpression() {
            return new InvalidOperationException(Strings.ControlCannotEnterExpression);
        }

        /// <summary>
        /// InvalidOperationException with message like "Cannot jump to non-local label '{0}' with a value. Only jumps to labels defined in outer blocks can pass values."
        /// </summary>
        internal static Exception NonLocalJumpWithValue(object p0) {
            return new InvalidOperationException(Strings.NonLocalJumpWithValue(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "Extension should have been reduced."
        /// </summary>
        internal static Exception ExtensionNotReduced() {
            return new InvalidOperationException(Strings.ExtensionNotReduced);
        }

        /// <summary>
        /// InvalidOperationException with message like "CompileToMethod cannot compile constant '{0}' because it is a non-trivial value, such as a live object. Instead, create an expression tree that can construct this value."
        /// </summary>
        internal static Exception CannotCompileConstant(object p0) {
            return new InvalidOperationException(Strings.CannotCompileConstant(p0));
        }

        /// <summary>
        /// NotSupportedException with message like "Dynamic expressions are not supported by CompileToMethod. Instead, create an expression tree that uses System.Runtime.CompilerServices.CallSite."
        /// </summary>
        internal static Exception CannotCompileDynamic() {
            return new NotSupportedException(Strings.CannotCompileDynamic);
        }

        /// <summary>
        /// InvalidOperationException with message like "Invalid lvalue for assignment: {0}."
        /// </summary>
        internal static Exception InvalidLvalue(object p0) {
            return new InvalidOperationException(Strings.InvalidLvalue(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "Invalid member type: {0}."
        /// </summary>
        internal static Exception InvalidMemberType(object p0) {
            return new InvalidOperationException(Strings.InvalidMemberType(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "unknown lift type: '{0}'."
        /// </summary>
        internal static Exception UnknownLiftType(object p0) {
            return new InvalidOperationException(Strings.UnknownLiftType(p0));
        }

        /// <summary>
        /// ArgumentException with message like "Invalid output directory."
        /// </summary>
        internal static Exception InvalidOutputDir() {
            return new ArgumentException(Strings.InvalidOutputDir);
        }

        /// <summary>
        /// ArgumentException with message like "Invalid assembly name or file extension."
        /// </summary>
        internal static Exception InvalidAsmNameOrExtension() {
            return new ArgumentException(Strings.InvalidAsmNameOrExtension);
        }

        /// <summary>
        /// NotSupportedException with message like "Collection is read-only."
        /// </summary>
        internal static Exception CollectionReadOnly() {
            return new NotSupportedException(Strings.CollectionReadOnly);
        }

        /// <summary>
        /// ArgumentException with message like "Cannot create instance of {0} because it contains generic parameters"
        /// </summary>
        internal static Exception IllegalNewGenericParams(object p0) {
            return new ArgumentException(Strings.IllegalNewGenericParams(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "variable '{0}' of type '{1}' referenced from scope '{2}', but it is not defined"
        /// </summary>
        internal static Exception UndefinedVariable(object p0, object p1, object p2) {
            return new InvalidOperationException(Strings.UndefinedVariable(p0, p1, p2));
        }

        /// <summary>
        /// InvalidOperationException with message like "Cannot close over byref parameter '{0}' referenced in lambda '{1}'"
        /// </summary>
        internal static Exception CannotCloseOverByRef(object p0, object p1) {
            return new InvalidOperationException(Strings.CannotCloseOverByRef(p0, p1));
        }

        /// <summary>
        /// InvalidOperationException with message like "Unexpected VarArgs call to method '{0}'"
        /// </summary>
        internal static Exception UnexpectedVarArgsCall(object p0) {
            return new InvalidOperationException(Strings.UnexpectedVarArgsCall(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "Rethrow statement is valid only inside a Catch block."
        /// </summary>
        internal static Exception RethrowRequiresCatch() {
            return new InvalidOperationException(Strings.RethrowRequiresCatch);
        }

        /// <summary>
        /// InvalidOperationException with message like "Try expression is not allowed inside a filter body."
        /// </summary>
        internal static Exception TryNotAllowedInFilter() {
            return new InvalidOperationException(Strings.TryNotAllowedInFilter);
        }

        /// <summary>
        /// InvalidOperationException with message like "When called from '{0}', rewriting a node of type '{1}' must return a non-null value of the same type. Alternatively, override '{2}' and change it to not visit children of this type."
        /// </summary>
        internal static Exception MustRewriteToSameNode(object p0, object p1, object p2) {
            return new InvalidOperationException(Strings.MustRewriteToSameNode(p0, p1, p2));
        }

        /// <summary>
        /// InvalidOperationException with message like "Rewriting child expression from type '{0}' to type '{1}' is not allowed, because it would change the meaning of the operation. If this is intentional, override '{2}' and change it to allow this rewrite."
        /// </summary>
        internal static Exception MustRewriteChildToSameType(object p0, object p1, object p2) {
            return new InvalidOperationException(Strings.MustRewriteChildToSameType(p0, p1, p2));
        }

        /// <summary>
        /// InvalidOperationException with message like "Rewritten expression calls operator method '{0}', but the original node had no operator method. If this is is intentional, override '{1}' and change it to allow this rewrite."
        /// </summary>
        internal static Exception MustRewriteWithoutMethod(object p0, object p1) {
            return new InvalidOperationException(Strings.MustRewriteWithoutMethod(p0, p1));
        }

        /// <summary>
        /// ArgumentNullException with message like "The value null is not of type '{0}' and cannot be used in this collection."
        /// </summary>
        internal static Exception InvalidNullValue(object p0) {
            return new ArgumentNullException(Strings.InvalidNullValue(p0));
        }

        /// <summary>
        /// ArgumentException with message like "The value '{0}' is not of type '{1}' and cannot be used in this collection."
        /// </summary>
        internal static Exception InvalidObjectType(object p0, object p1) {
            return new ArgumentException(Strings.InvalidObjectType(p0, p1));
        }

        /// <summary>
        /// NotSupportedException with message like "TryExpression is not supported as an argument to method '{0}' because it has an argument with by-ref type. Construct the tree so the TryExpression is not nested inside of this expression."
        /// </summary>
        internal static Exception TryNotSupportedForMethodsWithRefArgs(object p0) {
            return new NotSupportedException(Strings.TryNotSupportedForMethodsWithRefArgs(p0));
        }

        /// <summary>
        /// NotSupportedException with message like "TryExpression is not supported as a child expression when accessing a member on type '{0}' because it is a value type. Construct the tree so the TryExpression is not nested inside of this expression."
        /// </summary>
        internal static Exception TryNotSupportedForValueTypeInstances(object p0) {
            return new NotSupportedException(Strings.TryNotSupportedForValueTypeInstances(p0));
        }

        /// <summary>
        /// InvalidOperationException with message like "Collection was modified; enumeration operation may not execute."
        /// </summary>
        internal static Exception CollectionModifiedWhileEnumerating() {
            return new InvalidOperationException(Strings.CollectionModifiedWhileEnumerating);
        }

        /// <summary>
        /// InvalidOperationException with message like "Enumeration has either not started or has already finished."
        /// </summary>
        internal static Exception EnumerationIsDone() {
            return new InvalidOperationException(Strings.EnumerationIsDone);
        }

        /// <summary>
        /// InvalidOperationException with message like "Dynamic operations can only be performed in homogenous AppDomain."
        /// </summary>
        internal static Exception HomogenousAppDomainRequired() {
            return new InvalidOperationException(Strings.HomogenousAppDomainRequired);
        }

        /// <summary>
        /// ArgumentException with message like "Test value of type '{0}' cannot be used for the comparison method parameter of type '{1}'"
        /// </summary>
        internal static Exception TestValueTypeDoesNotMatchComparisonMethodParameter(object p0, object p1) {
            return new ArgumentException(Strings.TestValueTypeDoesNotMatchComparisonMethodParameter(p0, p1));
        }

        /// <summary>
        /// ArgumentException with message like "Switch value of type '{0}' cannot be used for the comparison method parameter of type '{1}'"
        /// </summary>
        internal static Exception SwitchValueTypeDoesNotMatchComparisonMethodParameter(object p0, object p1) {
            return new ArgumentException(Strings.SwitchValueTypeDoesNotMatchComparisonMethodParameter(p0, p1));
        }

        /// <summary>
        /// InvalidOperationException with message like "An IDynamicMetaObjectProvider {0} created an invalid DynamicMetaObject instance."
        /// </summary>
        internal static Exception InvalidMetaObjectCreated(object p0) {
            return new InvalidOperationException(Strings.InvalidMetaObjectCreated(p0));
        }

        /// <summary>
        /// NotSupportedException with message like "DebugInfoGenerator created by CreatePdbGenerator can only be used with LambdaExpression.CompileToMethod."
        /// </summary>
        internal static Exception PdbGeneratorNeedsExpressionCompiler() {
            return new NotSupportedException(Strings.PdbGeneratorNeedsExpressionCompiler);
        }

    }

    // *** END GENERATED CODE ***

    #endregion

}
