/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	

	$Id: Lister.h,v 1.24.10.6 1999/10/11 04:44:40 philipn Exp $
____________________________________________________________________________*/
#pragma message( "Compiling " __FILE__ ) 
#pragma message( "Last modified on " __TIMESTAMP__ ) 

#pragma once

#include <windows.h>
#include "Define.h"

/*Window procedure function prototypes*/
LRESULT		CALLBACK WndProc			(HWND,
										UINT,
										WPARAM,
										LPARAM);

BOOL		CALLBACK ListerDlgProc		(HWND,
										UINT,
										WPARAM,
										LPARAM);

BOOL		CALLBACK HelpDlgProc		(HWND,
										UINT,
										WPARAM,
										LPARAM);

/*Message handler function prototypes*/
void		Lister_OnDestroy			(HWND);

BOOL		Lister_OnCreate				(HWND,
										LPCREATESTRUCT);

BOOL		Lister_InitDialog			(HWND,
										HWND,
										LPARAM);

BOOL		Lister_OnCommand			(HWND,
										int,
										HWND,
										UINT);

/*Function prototypes*/
BOOL		SetSelectedItems			(HWND,
										 BOOL);

BOOL		SetSelectedItems95			(HWND);

BOOL		SetRealMac					();

BOOL		CreateImageList				();

BOOL		IsCorrectVersion			(void);

LPTSTR		GetTxtAfterLastSlash		(LPTSTR);

LPTSTR		GetTxtAfterFirstSlash		(LPTSTR);

BOOL		BindReview					(HWND);

static
HKEY		sParseRegKeyString			(LPSTR,
										 LPSTR*);

BOOL		CopyRegistryKeyValues		(LPSTR,
										 LPSTR);

BOOL		AmIBoundToTcpip95			(char *);

BOOL		AmIBoundToPGP95				(char *);

BOOL		AmIBoundToTcpipNT			(UINT);

BOOL		AmIBoundToPGPNT				(UINT);

BOOL		ConfigSystemNetTrans		(void);

BOOL		ConfigSystemNet				(void);

BOOL		ConfigEnumNet				(void);

BOOL		ConfigEnumNetwork			(void);

BOOL		Remove95					(char *,
										 int);

BOOL		StopService					(LPSTR);

BOOL		AddStringToMultiString		(HKEY,
										 LPSTR,
										 LPSTR);

BOOL		DeleteStringFromMultiString (HKEY,
										 LPSTR,
										 LPSTR);

BOOL		RebootYesNo					();

BOOL		MultiStrStrCmp				(LPSTR, 
										 LPSTR);

char*		SetExePath					();

BOOL		DisableExtraProtocols		(LPSTR);

BOOL		NeedReboot					();

int			RemoveService				(LPSTR);

int			CreatePGPTransportService	(LPSTR);

int			CreatePGPDriverService		(LPSTR, LPSTR, LPSTR, LPSTR);

BOOL		LinkPGPTransportService		();

BOOL		LinkPGPDriverService		(LPSTR);

BOOL		SetDriverParms				(UINT,
										 UINT);

UINT		GetFreeInstanceNumber		(UINT);

DWORD		RegDeleteKeyNT				(HKEY hStartKey,
										 LPTSTR pKeyName);

void		ErrorReport					(LPSTR Err,
										 LPSTR Function);

BOOL		RemovePGPnetServices		();

void		RemovePGPnetSoftwareLinkKeys ();

BOOL		MyCreateBackupKey			(HKEY hKey,
										 LPSTR Key,
										 LPSTR Subkey,
										 UINT Instance);

BOOL		RemoveNetworkCardEntries		();

BOOL		CreateLanSoftwareDriverLinkage	();

BOOL		CreateWanSoftwareDriverLinkage	();

BOOL		CreateTransportDriverLinkage	();

BOOL		DisableProtocols				(UINT CardIndex);

BOOL		RefreshProtocols				();

BOOL		DisableUsFromUs					(LPSTR);

BOOL		CopyWINS						(LPSTR, LPSTR);

BOOL		CreateExportedDriver			(LPSTR);

LPSTR	  	BuildDependOnService			(HWND hListControl);

BOOL		ManualCreatePGPDriverService	(LPSTR KeyName,
											LPSTR DRIVERNAME,
											LPSTR DisplayName,
											LPSTR pGroup,
											LPSTR pDependonService);

void		DeleteRebindKey					();

void		AddRebindKey					();

BOOL		ManualCreatePGPTransportService	(LPSTR DRIVERNAME);

/*NetSetupReviewBindings function prototype*/
typedef int __stdcall NetReviewFunc		(/*Handle of parent window*/
										HWND hwndParent, 
										/*Mode flags*/
										DWORD dwBindFlags);

/*struct for NT 4.0 adapters*/
typedef struct
{
	char CardName[MAX_NAME_LENGTH];
	DWORD AdapterNumber;
	BOOL IsWan;
	BOOL Useable;
	BOOL TCPIPBound;
	BOOL PGPnetBound;
	char ProductName[MAX_NAME_LENGTH];
	char ServiceName[MAX_NAME_LENGTH];
	char AllCapsServiceName[MAX_NAME_LENGTH];
	char RealMac[MAX_NAME_LENGTH];
	UINT InstanceNumber;
} * LPAdapterNT, AdapterNT;

/*struct for our NT 4.0 adapters*/
typedef struct
{
	char CardName[EXPORTEDNAMELENGTH];
} * LPExportedCardsNT, ExportedCardsNT;

/*struct for 95/98 adapters*/
typedef struct
{
	char CardName[MAX_NAME_LENGTH];
	char Path[_MAX_PATH];
	char NetSlot[5];
	char TransSlot[5];
	char EnumNetSlot[5];
	char RealMac[5];
} * LPAdapter95, Adapter95;

Adapter95 gAdapterList95[50];
AdapterNT gAdapterListNT[50];
ExportedCardsNT gOurCardList[20];
	
/*struct for registry searching*/
typedef struct _RegSearchState RegSearchState;

struct _RegSearchState
{
	RegSearchState *nextState;

	HKEY hKey;
	DWORD dwKeyIndex;
	DWORD dwValueIndex;
	BOOL bMatch;
};

/*
	RegistrySearch: Looks for a registry key with a certain value name
	                and data value. You can call this function until
					it quits returning TRUE.

	szName		- Value name to search for
	szValue		- Data value to search for (must be a string)
	szSubKey	- Initialize to "", if RegistrySearch returns TRUE,
				  this will hold the subkey where the match was found
	pState		- Pointer to the search state
*/

BOOL RegistrySearch(char *szName,
					char *szValue, 
					char *szSubKey,
					RegSearchState *pState);

/*
	FreeRegSearchState: Frees the search state structure. Call this
	                    function after finishing with the RegistrySearch
						function.

	pState	- Pointer to the search state
*/

void FreeRegSearchState(RegSearchState *pState);
