/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	

	$Id: Util.c,v 1.5.2.5 1999/10/11 04:44:40 philipn Exp $
____________________________________________________________________________*/
#pragma message( "Compiling " __FILE__ ) 
#pragma message( "Last modified on " __TIMESTAMP__ ) 

#include <windows.h>
#include "globals.h"
#include "Define.h"



/*___________________________________________________________________________
 *	error reporter
 */
void ErrorReport(LPSTR Err, LPSTR Function) 
{
	LPSTR lpstrMessage;

	/*allocate memory*/
	lpstrMessage = malloc (ERR_STRING);
	/*clear memory*/
	ZeroMemory (lpstrMessage, ERR_STRING);

	/*build err message*/
	strcpy (lpstrMessage, Err);
	strcat (lpstrMessage, " ");
	strcat (lpstrMessage, Function);

	/*display err*/
	MessageBox (NULL, lpstrMessage, szAppName, 0 | MB_ICONERROR);
	
	/*cleanup*/
	if (lpstrMessage)
		free (lpstrMessage);

	return;
}

/*___________________________________________________________________________
 *	Check for correct version of Windows
 */
BOOL IsCorrectVersion(VOID) 
{
	OSVERSIONINFO osid;

	osid.dwOSVersionInfoSize = sizeof (osid);
	GetVersionEx (&osid);
	bIsNT = FALSE;

	switch (osid.dwPlatformId) 
	{
		case VER_PLATFORM_WIN32s :
			return FALSE;

		/*Windows 95*/
		case VER_PLATFORM_WIN32_WINDOWS :
 			return TRUE;

		/*Windows NT*/
		case VER_PLATFORM_WIN32_NT :
		{
			if (osid.dwMajorVersion >= 4) 
			{
				bIsNT = TRUE;
				return TRUE;
			}
			return FALSE;
		}
		default:
			return FALSE;
	}
}


/*___________________________________________________________________________
 *recursive registry key deletion
 */
DWORD RegDeleteKeyNT(HKEY hStartKey, LPTSTR pKeyName)
{
	HKEY    hOpenKey	= NULL;
	LPTSTR  pSubKey		= NULL;
	DWORD   dwRtn;
	DWORD	dwSubKeyLength;    
	TCHAR   szSubKey [MAX_PATH];

	/*clear memory*/
	ZeroMemory (szSubKey, MAX_PATH);

	if (pKeyName && lstrlen(pKeyName))
	{
		if ((dwRtn = RegOpenKeyEx(hStartKey, pKeyName,
			0, KEY_ALL_ACCESS, &hOpenKey)) == ERROR_SUCCESS)
		{
		while (dwRtn == ERROR_SUCCESS)            
		{
			dwSubKeyLength = MAX_PATH;
			dwRtn = RegEnumKeyEx(hOpenKey, 0, szSubKey, &dwSubKeyLength,
							NULL, NULL, NULL, NULL);
			if(dwRtn == ERROR_NO_MORE_ITEMS)
            {
				if (hOpenKey)
				{
					RegCloseKey (hOpenKey);
					hOpenKey = NULL;
				}
				/*delete the current key*/
				dwRtn = RegDeleteKey(hStartKey, pKeyName);
				break;
			}
			else if (dwRtn == ERROR_SUCCESS)
			{
				dwRtn = RegDeleteKeyNT (hOpenKey, szSubKey);
			}
		}
		/*Do not save return code because error	has already occured*/
		}
	}
	else
		dwRtn = ERROR_BADKEY;      
		return dwRtn;
}


/*___________________________________________________________________________
 *	add specified string to existing multistring value
 */
BOOL
AddStringToMultiString (
		HKEY	hkey,
		LPSTR	szValue,
		LPSTR	szString)
{
	BOOL	bReturn			= FALSE;
	DWORD	dwSizeTotal;
	DWORD	dwSize;
	DWORD	dwType;
	DWORD	dwNewEntrySize;
	BYTE*	pBuffer;
	BYTE*	tmppBuffer;
	BYTE*	tmppBufferHead;
	unsigned int		index;
	int		count;

	/*get type and length of existing string*/
	if (ERROR_SUCCESS == RegQueryValueEx (
							hkey,
							szValue,
							NULL,
							&dwType,
							NULL,
							&dwSize))
	{
		/*verify type*/
		if (dwType == REG_MULTI_SZ)
		{
			/* compute new length and allocate buffer*/
			dwNewEntrySize = lstrlen (szString)+1;
			dwSizeTotal = dwSize + lstrlen (szString) + 1;
			pBuffer = malloc (dwSizeTotal);
			ZeroMemory(pBuffer, dwSizeTotal);
			tmppBuffer = malloc (dwSizeTotal);
			ZeroMemory(tmppBuffer, dwSizeTotal);
			tmppBufferHead = tmppBuffer;

			if (pBuffer)
			{
				/*get existing data and copy*/
				RegQueryValueEx (
							hkey,
							szValue,
							NULL,
							&dwType,
							pBuffer, 
							&dwSize);

				/*append new string*/
				lstrcpy (tmppBuffer, szString);
				/*tmppBuffer += (strlen(szString)+1);*/
				count = 0;
				for (index = dwNewEntrySize; index <= dwSizeTotal; index++)
				{
					tmppBuffer[index] = pBuffer [count];
					count ++;
				}

				/*write the new string back to the registry*/
				if (ERROR_SUCCESS == RegSetValueEx (
										hkey,
										szValue,
										0,
										REG_MULTI_SZ,
										tmppBufferHead,
										dwSizeTotal))
				{
					bReturn = TRUE;
				}
				if (pBuffer)
					free (pBuffer);
			}
		}
	}
	return bReturn;
}

 
/*___________________________________________________________________________
 *	delete all occurances of specified string from multistring value
 */
BOOL
DeleteStringFromMultiString (
		HKEY	hkey,
		LPSTR	szValue,
		LPSTR	szString)
{
	BOOL	bReturn			= FALSE;
	BYTE*	pBuffer;
	BYTE*	pSrc;
	BYTE*	pDst;
	DWORD	dwSize;
	DWORD	dwType;

	/*get type and length of existing string*/
	if (ERROR_SUCCESS == RegQueryValueEx (
							hkey,
							szValue,
							NULL,
							&dwType,
							NULL,
							&dwSize))
	{
		/*verify type*/
		if (dwType == REG_MULTI_SZ)
		{
			/*allocate buffer*/
			pBuffer = malloc (dwSize);
			if (pBuffer)
			{
				/*get existing data*/
				RegQueryValueEx (
							hkey,
							szValue,
							NULL,
							&dwType,
							pBuffer,
							&dwSize);

				/*kill all instances of specified string*/
				pSrc = pDst = pBuffer;
				while (*pSrc) 
				{
					if (!strstr (pSrc, szString))
					{
						dwSize = lstrlen (pSrc);

						lstrcpy (pDst, pSrc);

						pDst += lstrlen (pDst) +1;
						pSrc += dwSize +1;
					}
					else
					{
						pSrc += lstrlen (pSrc) +1;
					}
				}

				/*add the final NULL*/
				*pDst = '\0';
				dwSize = pDst - pBuffer +1;

				/*write the new string back to the registry*/
				if (ERROR_SUCCESS == RegSetValueEx (
										hkey,
										szValue,
										0,
										REG_MULTI_SZ,
										pBuffer,
										dwSize))
				{
					bReturn = TRUE;
				}

				free (pBuffer);
			}
		}
	}

	return bReturn;
}


void
DeleteRebindKey (){
	HKEY		NCPAkey	= NULL;

	if (bIsNT){
		/*delete the key that causes a rebind*/
		RegOpenKeyEx (HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Ncpa\\CurrentVersion",
			0, KEY_ALL_ACCESS, &NCPAkey);
		DeleteStringFromMultiString (NCPAkey, "ReviewPrograms",
		"PGPRebind.inf");
		RegCloseKey(NCPAkey);
	}
	return;
}


void
AddRebindKey (){
	HKEY		NCPAkey	= NULL;

	if (bIsNT){
		/*add the key that causes a rebind*/
		RegOpenKeyEx (HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Ncpa\\CurrentVersion",
			0, KEY_ALL_ACCESS, &NCPAkey);
		AddStringToMultiString (NCPAkey, "ReviewPrograms",
		"PGPRebind.inf");
		RegCloseKey(NCPAkey);
	}
	return;
}



















