/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	

	$Id: removent.c,v 1.18.10.4 1999/08/26 20:46:59 philipn Exp $
____________________________________________________________________________*/
#pragma message( "Compiling " __FILE__ ) 
#pragma message( "Last modified on " __TIMESTAMP__ ) 

#include <windows.h>
#include "Define.h"
#include "globals.h"
#include "lister.h"


/*___________________________________________________________________________
 *	removes pgpnet driver and transport services	
 */
BOOL RemovePGPnetServices ()
{
	HKEY hOpenServiceKey = NULL;
	BOOL bErr = TRUE;
	UINT i;
	DWORD nMaxSubkeyKeyLen;
	DWORD SavednMaxSubkeyKeyLen;
	DWORD nSubKeys;
	LPSTR lpSubkey;


	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, SERVICESSUBKEY,0, KEY_ALL_ACCESS, &hOpenServiceKey) == ERROR_SUCCESS)
	{
		/*Determine number of keys to enumerate*/
		RegQueryInfoKey(hOpenServiceKey, NULL, NULL, NULL,  &nSubKeys, 
					&nMaxSubkeyKeyLen, NULL, NULL, NULL,
					NULL, NULL, NULL);	

		/*allocate memory for subkey*/
		lpSubkey = malloc (nMaxSubkeyKeyLen + 1);

		for (i = 0; i < nSubKeys; i++)
		{
			/*clear memory*/
			ZeroMemory (lpSubkey, nMaxSubkeyKeyLen + 1);
			/*save of maxsubkeylength*/
			SavednMaxSubkeyKeyLen = nMaxSubkeyKeyLen + 1;
			/*enumerate through the reg. keys*/
			RegEnumKeyEx(hOpenServiceKey, i, lpSubkey, 
					&SavednMaxSubkeyKeyLen, NULL, NULL,
					NULL, NULL);
			/*check if the service is PGPnet*/
			if (strstr (lpSubkey, "PGPMac") != NULL)
			{
				/*delete key (if left behind)*/
				RegDeleteKeyNT (hOpenServiceKey, lpSubkey);
				/*decrement the counter because a delete occured*/
				i--;
			}
		}
	}
	else
		ErrorReport (ERROPENSERVICEKEY, "RemovePGPnetServices()");

	/*cleanup*/
	if (lpSubkey)
		free (lpSubkey);
	if (hOpenServiceKey)
		RegCloseKey (hOpenServiceKey);

	return bErr;
}


/*___________________________________________________________________________
 *	removes pgpnet networkcard entries	
 */
BOOL RemoveNetworkCardEntries ()
{
	#define SIZEOFPGPNETTESTVALUE	10

	HKEY hOpenNetCardKey = NULL;
	HKEY hOpenNetCardInstanceKey = NULL;
	BOOL bErr = TRUE;
	UINT i;
	DWORD nMaxSubkeyKeyLen;
	DWORD SavednMaxSubkeyKeyLen;
	DWORD nSubKeys;
	DWORD dwType;
	DWORD dwSize;
	LPSTR lpSubkey;
	LPSTR pScratchBuffer;
	
	
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, NETWORKCARDSKEY,0, KEY_ALL_ACCESS, &hOpenNetCardKey)
					== ERROR_SUCCESS)
	{
		/*Determine number of keys to enumerate*/
		RegQueryInfoKey(hOpenNetCardKey, NULL, NULL, NULL,  &nSubKeys, 
					&nMaxSubkeyKeyLen, NULL, NULL, NULL,
					NULL, NULL, NULL);	

		/*allocate memory for subkey*/
		lpSubkey = malloc (nMaxSubkeyKeyLen + 1);
		pScratchBuffer = malloc (SIZEOFPGPNETTESTVALUE);

		for (i = 0; i < nSubKeys; i++)
		{
			/*clear memory*/
			ZeroMemory (lpSubkey, nMaxSubkeyKeyLen + 1);
			ZeroMemory (pScratchBuffer, SIZEOFPGPNETTESTVALUE);
			dwSize = SIZEOFPGPNETTESTVALUE;
			/*save of maxsubkeylength*/
			SavednMaxSubkeyKeyLen = nMaxSubkeyKeyLen + 1;
			/*enumerate through the reg. keys*/
			RegEnumKeyEx(hOpenNetCardKey, i, lpSubkey, 
					&SavednMaxSubkeyKeyLen, NULL, NULL,
					NULL, NULL);
			/*open the net card instance*/
			if (RegOpenKeyEx(hOpenNetCardKey, lpSubkey,0, KEY_ALL_ACCESS, &hOpenNetCardInstanceKey)
						== ERROR_SUCCESS)
			{
				/*check if this is one of ours*/
				if (RegQueryValueEx (hOpenNetCardInstanceKey, "PGPnet", NULL, &dwType,
						pScratchBuffer, &dwSize) == ERROR_SUCCESS)
				{
					if (hOpenNetCardInstanceKey)
						RegCloseKey (hOpenNetCardInstanceKey);
					/*delete key*/
					RegDeleteKeyNT (hOpenNetCardKey, lpSubkey);
					/*decrement the counter because a delete occured*/
					i--;
				}
				else
					/*cleanup*/
					if (hOpenNetCardInstanceKey)
						RegCloseKey (hOpenNetCardInstanceKey);
			}
		}
	}
	else
		ErrorReport (ERRGETTINGNUMNETCARDS, "RemoveNetworkCardEntries ()");

	/*cleanup*/
	if (pScratchBuffer)
		free (pScratchBuffer);
	if (lpSubkey)
		free (lpSubkey);
	if (hOpenNetCardKey)
		RegCloseKey (hOpenNetCardKey);

	return bErr;
}


/*___________________________________________________________________________
 *	removes pgpnet driver and transport services	
 */
void RemovePGPnetSoftwareLinkKeys ()
{
	#define PGPMACLINKAGE		"SOFTWARE\\Network Associates\\ZZPGPMac"
	#define PGPMACMPLINKAGE		"SOFTWARE\\Network Associates\\ZZPGPMacMP"
	#define WANPGPMACMPLINKAGE	"SOFTWARE\\Network Associates\\NdisWanZZPGPMacMP"	
	
	/*remove SOFTWARE linkage keys*/
	RegDeleteKeyNT (HKEY_LOCAL_MACHINE, PGPMACLINKAGE);
	RegDeleteKeyNT (HKEY_LOCAL_MACHINE, PGPMACMPLINKAGE);
	RegDeleteKeyNT (HKEY_LOCAL_MACHINE, WANPGPMACMPLINKAGE);
	return;
}


/*___________________________________________________________________________
 *	Code to delete a service (ServiceName) 	
 */
int RemoveService (LPSTR ServiceName)
{
	SC_HANDLE service = NULL;
	SC_HANDLE schSCMan = NULL;
	SERVICE_STATUS stat;
	int bail = 0;
	int	err;

		
	schSCMan = OpenSCManager(0, 0, SC_MANAGER_CREATE_SERVICE);

	/*Get the service handle*/
	service = OpenService(schSCMan, ServiceName, SERVICE_ALL_ACCESS);
	if (!service)
	{
		goto cleanup;
	}
			
	/*Stop the service*/
querystate:
	err = QueryServiceStatus (service, &stat);
		
	if (stat.dwCurrentState != SERVICE_STOPPED)
	{
		err = ControlService(service, SERVICE_CONTROL_STOP, &stat);
		Sleep(500);	
		bail ++;
		if (bail < 20)
			goto querystate;
	}

	err = DeleteService(service);
	
cleanup:
	if (service)
		CloseServiceHandle (service);	
	if (schSCMan)
		CloseServiceHandle (schSCMan);

	return err;
}


/*___________________________________________________________________________
 *	Code to stop a running service so it can be removed 	
 */
INT StopService (LPSTR ServiceName)
{
	SERVICE_STATUS STATUS;
	SC_HANDLE hSCManager;
	SC_HANDLE hService;
	int iReturn;

	hSCManager = NULL;
	hService = NULL;
	iReturn = FALSE;

	
	hSCManager = OpenSCManager	(NULL, NULL, SC_MANAGER_ALL_ACCESS);

	hService = OpenService	(hSCManager, ServiceName,SERVICE_ALL_ACCESS | DELETE);

	iReturn = ControlService(hService, SERVICE_CONTROL_STOP, &STATUS);

	iReturn = DeleteService(hService);

	CloseServiceHandle (hService);
	CloseServiceHandle (hSCManager);

	return TRUE;
}


/*___________________________________________________________________________
 *	Find if stringb is in multistringa
 */
BOOL MultiStrStrCmp (LPSTR multistringa, LPSTR stringb)
{
	int	strlength;
	int	count;


compare:
	if (strstr(multistringa, stringb) == NULL)
	{
		strlength = strlen (multistringa);
		for (count = 0; count <= strlength; count++)
			*multistringa++;

		if (*multistringa == '\0')
			/*we are at the end of the multisting*/
			return FALSE;
		else
			goto compare;
	}
	else
		return TRUE;
}


/*___________________________________________________________________________
 *	retores protocols disabled during configuration
 *  (used when uninstalled)
 */
BOOL RefreshProtocols ()
{
	#define PROTOBACKUP		"SOFTWARE\\Network Associates\\PGP\\PGPnet\\ProtocolBackup"
	#define DISABLETCPIP	"SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Linkage\\Disabled"
	#define DISABLENETBT	"SYSTEM\\CurrentControlSet\\Services\\NetBT\\Linkage\\Disabled"

	HKEY hTCPipKey = NULL;
	HKEY hNetBTKey = NULL;
	HKEY hProtBack = NULL; 
	BOOL berr = TRUE;
	DWORD nValues; 
	DWORD nValueNameLen;
	DWORD nValueNameLenb;
	DWORD dwIndex;
	LPSTR pValueBuffer;

	/*open the tcpip disable key*/
	RegOpenKeyEx (HKEY_LOCAL_MACHINE, DISABLETCPIP, 0, KEY_ALL_ACCESS, &hTCPipKey);
	/*open the netbt disable key*/
	RegOpenKeyEx (HKEY_LOCAL_MACHINE, DISABLENETBT, 0, KEY_ALL_ACCESS, &hNetBTKey);

	/*open the prtocol backup key*/
	if (RegOpenKeyEx (HKEY_LOCAL_MACHINE, PROTOBACKUP, 0, KEY_ALL_ACCESS, &hProtBack)
				== ERROR_SUCCESS)
	{
		/*Determine number of values to enumerate*/
		RegQueryInfoKey(hProtBack, NULL, NULL, NULL, NULL, 
						NULL, NULL, &nValues, &nValueNameLen,
						NULL, NULL, NULL);
		/*Retrieve Registry values*/
		pValueBuffer = malloc(nValueNameLen + 1);
		for (dwIndex = 0; dwIndex < nValues; dwIndex++)
		{
			/*save off copy of length*/
			nValueNameLenb = nValueNameLen + 1;
			/*clear buffer*/
			ZeroMemory(pValueBuffer,(nValueNameLen + 1)); 
			/*get next value*/
			RegEnumValue(hProtBack, dwIndex, pValueBuffer, 
					&nValueNameLenb, NULL, NULL, NULL, NULL); 

			DeleteStringFromMultiString (hTCPipKey, "Bind", pValueBuffer);
			DeleteStringFromMultiString (hNetBTKey, "Bind", pValueBuffer);
		}

	}

	/*cleanup*/
	if (hProtBack)
		RegCloseKey (hProtBack);
	if (hTCPipKey)
		RegCloseKey (hTCPipKey);
	if (hNetBTKey)
		RegCloseKey (hNetBTKey);
	if (pValueBuffer)
		free (pValueBuffer);

	#undef PROTOBACKUP
	#undef ENABLETCPIP
	#undef ENABLENETBT

	return berr;
}




/*****************************************************************************/
/*if (iReturn == 0)
{
	char szText[256];
	wsprintf(szText, "Error code: %d", GetLastError());
	MessageBox(NULL, szText, "Delete Service", MB_OK);
}*/



