#!/bin/sh
# build.sh - a simple script to control the 
#     checkout / configure / make / install
# For PGP for the folks doing walkthroughs and testing.  Always assumes
# you want to do a full build from the ground up, otherwise you would
# have typed make, right?
# 
# Solaris x86 hint: successful build requires GNU make and GNU as.
# make sure these are on your path _before_ the ones in /usr/ccs/bin


[ -d $HOME/test ] || mkdir $HOME/test
[ -d $HOME/test/bin ] || mkdir $HOME/test/bin

mywd=`pwd`
CHECKOUT="libs/pfl libs/pgpcdk libs/network clients/pgp/shared clients/pgp/cmdline"
MODULES="libs/pfl libs/pgpcdk clients/pgp/shared clients/pgp/cmdline"


mlist=`for x in $CHECKOUT ; do 
        [ -d $x ] || echo $x 
        done`

[ -z "$mlist" ] || cvs checkout $mlist

for x in $MODULES ; do 
        cd $x;
	make distclean || make clean
	[ -x configure ] || chmod +x configure unix/config/config.sub unix/config/config.guess unix/config/install-sh
        ./configure --prefix=$HOME/test
        make -e OPT=-O DEBUG=0 headers && make -e OPT=-O DEBUG=0 && make -e OPT=-O DEBUG=0 install
	[ -d unix/ui ] && { cd unix/ui ; make -e DEBUG=0 OPT=-O; cd ../.. ; }
        cd $mywd
done


