{+//____________________________________________________________________________ }
{-Copyright (C) 1996-1998 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: C3poinc.pas,v 1.5.12.2 1999/08/27 22:00:46 build Exp $ }
{=____________________________________________________________________________ }


unit C3poinc;

interface

uses
  OleAuto,{comobj,comserv,} Windows, SysUtils;

{***********************************************************
   Object Name:   TGWCommand

   Description:   This object defines an instance of a command

************************************************************}
type
  TGWCommand = class(TAutoObject)
  private
    function GetBaseCmd: Variant;
    function GetLongPrompt : string;
    function GetParameters : integer;
    function GetPersistentID : string;
    function GetToolTip : string;

  public

  automated
    property BaseCmd: Variant read GetBaseCmd;
    property LongPrompt: string read GetLongPrompt;
    property Parameters: integer read GetParameters;
    property PersistentID: string read GetPersistentID;
    property ToolTip: string read GetToolTip;
    procedure Execute;
    procedure Help;
    procedure Undo;
    function Validate: longint;

  end;


{***********************************************************
   Object Name:  TIconFactory

   Description:  This interface is used to retrieve icons that represent the
                 state of C3PO record types.

************************************************************}
TIconFactory = class(TAutoObject)
  private

  public

  automated
    procedure GetIcons(ObjClass: string;
                       var pIconFile: string;
                       var plUnOpenIcon: longint;
                       var plOpenIcon: longint);

  end;

{***********************************************************
   Object Name:  TEventMonitor

   Description:  This interface is passed to monitor "low level" actions
                 that occur in GW.

************************************************************}
TEventMonitor = class(TAutoObject)
  private

  public

  automated
    procedure Notify(Context: string; evt: variant);

  end;

 {***********************************************************
   Object Name:  TCommandFactory

   Description:  This interface is used to manage commands in GroupWise.
                 A command occurs in multiple locations including the Menu and
                 Toolbar.

   Comments:     Modification of the menus is done according to the following algorithm:
                   0 CommandFactory::Init() called once, long before any menu modifications actually occur.
                   1 Menu Load from disk
                   2 Send menu out to C3PO servers (CommandFactory::CustomizeMenu())
                   3 At INIT_MENU_POPUP time
                      Call CommandFactory::CustomizeMenu() for all interested C3PO servers (i.e. those
                      that returned TRUE to the initial call to CustomizeMenu() ).
                   4 Validate the menu


************************************************************}
  TCommandFactory = class(TAutoObject)
  private

  public

  automated
    function BuildCommand( Context: string;
                           PersistentID: string;
                           BaseCommand: variant;
                           Parms: variant): variant;

    procedure CustomizeContextMenu( Context: string;
                                    GWMenu: variant);

    function CustomizeMenu( Context: string;
                            GWMenu: variant): wordbool;

    function CustomizeToolBar( Context: string;
                               GWToolbar: variant): wordbool;

    function Init(lcid: longint): longint;

    function WantCommand( Context: string;
                          PersistentID: string): wordbool;

  end;

{***********************************************************
   Object Name:  TC3POServer

   Description:  Every C3PO must support this interface.  It is used to
                 initialize the C3PO.

************************************************************}
  TC3POServer = class(TAutoObject)
  private
    function GetCommandFactory : variant;
    function GetDescription : string;
    function GetEventMonitor : variant;
    function GetIconFactory : variant;

  public

  automated

    { Automated declarations }
    property CommandFactory: variant read GetCommandFactory;
    property Description: string read GetDescription;
    property EventMonitor: variant read GetEventMonitor;
    property IconFactory: variant read GetIconFactory;
    function CanShutdown: wordbool;
    procedure DeInit;
    procedure Init(Manager: variant);
  end;

const

{Command Validate}
    eGW_CMDVAL_ALWAYS = 1;
    eGW_CMDVAL_CHECKED = 2;
    eGW_CMDVAL_DISABLED = 4;

{CommandFactory.Init }
    eGW_CMDINIT_MENUS = 1;
    eGW_CMDINIT_TOOLBARS = 4;
    eGW_CMDINIT_CONTEXT_MENUS = 16;
    eGW_CMDINIT_NO_PREDEFINED = 32;

{Menu positions}
    {Main Menu}
    eGW_MAINMENU_FILEMENU = 1;
    eGW_MAINMENU_EDITMENU = 2;
    eGW_MAINMENU_VIEWMENU = 3;
    eGW_MAINMENU_ACTIONSMENU = 4;
    eGW_MAINMENU_TOOLSMENU = 5;
    eGW_MAINMENU_WINDOWMENU = 6;
    eGW_MAINMENU_HELPMENU = 7;

    {File Menu}
    eGW_FILEMENU_NEWMENU = 1;
    eGW_FILEMENU_OPENARCHIVE = 2;
    eGW_FILEMENU_OPENVIEW = 3;
    eGW_FILEMENU_SAVEAS = 4;
    eGW_FILEMENU_IMPORTDOCUMENTS = 5;
    eGW_FILEMENU_PROXY = 6;
    eGW_FILEMENU_SHARING = 7;
    eGW_FILEMENU_PROPERTIES = 8;
    eGW_FILEMENU_PRINT = 10;
    eGW_FILEMENU_PRINTCALENDAR = 11;
    eGW_FILEMENU_EXIT = 13;

    {Edit Menu}
    eGW_EDITMENU_CUT = 1;
    eGW_EDITMENU_COPY = 2;
    eGW_EDITMENU_PASTE = 3;
    eGW_EDITMENU_SELECTALL = 4;
    eGW_EDITMENU_DELETE = 6;
    eGW_EDITMENU_UNDELETE = 7;
    eGW_EDITMENU_EMPTYTRASH = 8;
    eGW_EDITMENU_CHANGE = 9;
    eGW_EDITMENU_FOLDERS = 11;
    eGW_EDITMENU_MOVELINK = 12;
    eGW_EDITMENU_FINDTEXT = 14;
    eGW_EDITMENU_FINDNEXT = 15;
    eGW_EDITMENU_FINDPREVIOUS = 16;

    {View Menu}
    eGW_VIEWMENU_TOOLBAR = 1;
    eGW_VIEWMENU_FOLDERLIST = 2;
    eGW_VIEWMENU_QUICKVIEWER = 3;
    eGW_VIEWMENU_DETAILS = 5;
    eGW_VIEWMENU_THREADS = 6;
    eGW_VIEWMENU_CALENDAR = 7;
    eGW_VIEWMENU_RECEIVEDITEMS = 9;
    eGW_VIEWMENU_SENTITEMS = 10;
    eGW_VIEWMENU_PERSONALITEMS = 11;
    eGW_VIEWMENU_DRAFTITEMS = 12;
    eGW_VIEWMENU_SORT = 14;
    eGW_VIEWMENU_FILTER = 15;
    eGW_VIEWMENU_REFRESH = 17;

    {Action Menu}
    eGW_ACTIONMENU_OPEN = 1;
    eGW_ACTIONMENU_VIEW = 2;
    eGW_ACTIONMENU_REPLY = 4;
    eGW_ACTIONMENU_FORWARD = 5;
    eGW_ACTIONMENU_ACCEPT = 6;
    eGW_ACTIONMENU_DECLINE = 7;
    eGW_ACTIONMENU_DELEGATE = 8;
    eGW_ACTIONMENU_RESEND = 9;
    eGW_ACTIONMENU_ARCHIVE = 10;
    eGW_ACTIONMENU_VERSIONLIST = 12;
    eGW_ACTIONMENU_COPYDOCUMENT = 13;
    eGW_ACTIONMENU_CHECKOUT = 14;
    eGW_ACTIONMENU_CHECKIN = 15;
    eGW_ACTIONMENU_SETALARM = 17;
    eGW_ACTIONMENU_MARKPRIVATE = 18;
    eGW_ACTIONMENU_MARKCOMPLETED = 19;
    eGW_ACTIONMENU_READLATER = 20;

    {Tools Menu}
    eGW_TOOLSMENU_ADDRESSBOOK = 1;
    eGW_TOOLSMENU_CONVERSATIONPLACE = 2;
    eGW_TOOLSMENU_DIALSENDER = 3;
    eGW_TOOLSMENU_RULES = 5;
    eGW_TOOLSMENU_FIND = 6;
    eGW_TOOLSMENU_BUSYSEARCH = 7;
    eGW_TOOLSMENU_HITTHEROAD = 8;
    eGW_TOOLSMENU_OPTIONS = 10;

    {Window Menu}
    eGW_WINDOWMENU_MINIMIZE = 1;
    eGW_WINDOWMENU_CLOSE = 2;
    eGW_WINDOWMENU_NEWMAINWINDOW = 4;
    eGW_WINDOWMENU_CALENDAR = 5;

    {Help Menu}
    eGW_HELPMENU_HELPTOPICS = 1;
    eGW_HELPMENU_GUIDE = 2;
    eGW_HELPMENU_INOTHERWORDS = 3;
    eGW_HELPMENU_ABOUT = 5;

    {New Menu}
    eGW_NEWMENU_MAIL = 1;
    eGW_NEWMENU_APPOINTMENT = 2;
    eGW_NEWMENU_TASK = 3;
    eGW_NEWMENU_NOTE = 4;
    eGW_NEWMENU_DISCUSSION = 5;
    eGW_NEWMENU_PHONEMESSAGE = 6;
    eGW_NEWMENU_DOCUMENT = 8;
    eGW_NEWMENU_DOCUMENTVERSION = 9;
    eGW_NEWMENU_DOCUMENTREFERENCE = 10;
    eGW_NEWMENU_FOLDER = 12;

    {Change To Menu}
    eGW_CHANGETOMENU_MAIL = 1;
    eGW_CHANGETOMENU_APPOINTMENT = 2;
    eGW_CHANGETOMENU_TASK = 3;
    eGW_CHANGETOMENU_NOTE = 4;
    eGW_CHANGETOMENU_PHONEMESSAGE = 5;
    eGW_CHANGETOMENU_MORE = 7;

{Prebuilt Command ID's}
    eGW_CMDID_ACCEPT =         'GW#C#ACCEPT';
    eGW_CMDID_ARCHIVE =        'GW#C#ARCHIVE';
    eGW_CMDID_COMPLETE =       'GW#C#COMPLETE';
    eGW_CMDID_COMPOSE =        'GW#C#COMPOSE';
    eGW_CMDID_DECLINE =        'GW#C#DECLINE';
    eGW_CMDID_DELEGATE =       'GW#C#DELEGATE';
    eGW_CMDID_DELETE =         'GW#C#DELETE';
    eGW_CMDID_DOC_CHECKIN =    'GW#C#DOC_CHECKIN';
    eGW_CMDID_DOC_CHECKOUT =   'GW#C#DOC_CHECKOUT';
    eGW_CMDID_DOC_RESETINUSE = 'GW#C#DOC_RESETINUSE';
    eGW_CMDID_FORWARD =        'GW#C#FORWARD';
    eGW_CMDID_INFO =           'GW#C#INFO';
    eGW_CMDID_OPEN =           'GW#C#OPEN';
    eGW_CMDID_PRINT =          'GW#C#PRINT';
    eGW_CMDID_PROPERTIES =     'GW#C#PROPERTIES';
    eGW_CMDID_REPLY =          'GW#C#REPLY';
    eGW_CMDID_RESEND =         'GW#C#RESEND';
    eGW_CMDID_SAVE =           'GW#C#SAVE';
    eGW_CMDID_SAVEAS =         'GW#C#SAVEAS';
    eGW_CMDID_SETALARMS =      'GW#C#SETALARMS';
    eGW_CMDID_UNDELETE =       'GW#C#UNDELETE';
    eGW_CMDID_VIEW =           'GW#C#VIEW';

{Event Command ID's}
    eGW_CMDEVTID_ONREADY = 'GW#E#0';
    eGW_CMDEVTID_NEWMESSAGE = 'GW#E#1';
       eGW_CMDEVTID_ONSHUTDOWN = 'GW#E#2';

                      EVT_GROUPWISE_SEND_ITEM		      = $1;
                      EVT_GROUPWISE_CANCEL_ITEM		      = $2;
                      EVT_GROUPWISE_CLOSE_ITEM		      = $4;
                      EVT_GROUPWISE_PACKAGING_ITEM	      = $8;
                      EVT_GROUPWISE_PACKAGING_ITEM_CANCELED    = $10;
                      EVT_GROUPWISE_SEND_ITEM_COMPLETED	      = $20;


implementation

{ TGWCommand routines}

{***********************************************************
   Name:       TGWCommand.GetBaseCmd

   Description: This routine should get the Base Command and return it as a
                TGWCommand.

   In:          none

   Out:         TGWCommand : variant

   Comments:

************************************************************}
function TGWCommand.GetBaseCmd : Variant;
begin
     Result := TRUE;

end;

{***********************************************************
   Name:       TGWCommand.GetLongPrompt

   Description: This routine should return the long prompt for the GWCommand.

   In:          none

   Out:         Longpromt: string

   Comments:

************************************************************}
function TGWCommand.GetLongPrompt : string;
begin
     Result := 'TRUE';
end;

{***********************************************************
   Name:       TGWCommand.GetParameters

   Description: This is for later use. (Always null)

   In:          none

   Out:         none

   Comments:

************************************************************}
function TGWCommand.GetParameters : integer;
begin
     Result := 0;
end;

{***********************************************************
   Name:       TGWCommand.GetPersistentID

   Description: This routine should return the persistent ID
                for the command.

   In:          none

   Out:         PersistentID: string

   Comments:

************************************************************}
function TGWCommand.GetPersistentID : string;
begin
     Result := '';
end;

{***********************************************************
   Name:       TGWCommand.GetToolTip

   Description: This routine should return the tool tip for custom toolbar
                commands only.

   In:          none

   Out:         ToolTip: string

   Comments: Only commands genertated and placed on the toolbar with
   CommandFactory.Customise Toolbar(or explicitly added by the user) have
   this method invoked.
************************************************************}
function TGWCommand.GetToolTip : string;
begin
     Result := 'TRUE';
end;

{***********************************************************
   Name:       TGWCommand.Execute

   Description: This routine should execute the command.

   In:          none

   Out:         none

   Comments:    At this point the processing of the command is the C3po's
                responsiblity.
************************************************************}
procedure TGWCommand.Execute;
begin

end;

{***********************************************************
   Name:       TGWCommand.Help

   Description: Invokes help for the GWCommand.

   In:          none

   Out:         none

   Comments: In the GroupWise 5 implementation, the client never invokes this method.
             C3po servers are still required to implement it, however, since other
             (add on) C3po clients may invoke it.

************************************************************}
procedure TGWCommand.Help;
begin

end;

{***********************************************************
   Name:       TGWCommand.Undo

   Description: Required method. Never called in XTD.

   In:          none

   Out:         none

   Comments: Required method. Never called in GroupWise 5.

************************************************************}
procedure TGWCommand.Undo;
begin

end;

{***********************************************************
   Name:         TGWCommand.Validate

   Description:  This interface is called to determine the state of a C3po
                 command. Determining the state is termed the validation.
                 The command is assumed by default to be in an enabled, unchecked,
                 visible state. The C3po provider can then modify that assumption
                 by returning flags. The available flags are:

                     eGW_CMDVAL_ALWAYS - The command is always in the same state
                                         and there is no need to validate it again.
                     eGW_CMDVAL_CHECKED - The command has a check mark.
                     eGW_CMDVAL_DISABLED - The command is disabled.


   In:           none

   Out:          none

   Comments: Validate applies only to commands put onto the toolbar or menu by the
             C3po server. Predifined commands do not cause this method to be involked.

************************************************************}
function TGWCommand.Validate: longint;
begin
     Result := eGW_CMDVAL_ALWAYS;
end;

{TIconFactory routines}

{***********************************************************
   Name:         TIconFactory.GetIcons

   Description:  This interface is used to retrieve icons that
                 represent the state of the C3po record types.

   In:           ObjClass: string - String of the object class


   Out:          pIconFile: string - Name of the file containing the icons(.dll or .exe)
                 plUnOpenIcon: longint - Index value of the unopen icon
                 plOpenIcon: longint - Index value of the open icon

   Comments: The plUnOpenIcon and plOpenIcon parameters are icon index values within
             the module (.exe or .dll) named by the pIconFile parameter.  Returning
             a value of -1 indicates that a default icon should be used.  Any other
             negative index value indicates a resource ID by taking the absolute value
             of the number.  The IconFactory object does not support inheritance.
             That is, there is no mechanism for two C3POs to both offer icons for
             the same record.  The C3PO system will simply use the first C3PO it finds.

             The icons retrieved are presumed to contain multiple image sizes.  The
             appropriate size is used by GroupWise as needed.  The current C3PO
             specification does not allow the C3PO to specify specific icon overlays (
             such as the attachment clip).

************************************************************}
procedure TIconFactory.GetIcons( ObjClass: string;
                                 var pIconFile: string;
                                 var plUnOpenIcon: longint;
                                 var plOpenIcon: longint);
begin

end;

{TEventMonitor routines}

{***********************************************************
   Name:         TEventMonitor.Notify

   Description: This interface is passed to monitor "low level" actions that occur in GW.
                Such as:
                eGW_CMDEVTID_NEWMESAGE = Indicates that an item has been delivered
                                         to the GroupWise mailbox.
                eGW_CMDEVTID_ONREADY = This notification occurs during the GroupWise
                                       initialization procedure, just after GroupWise
                                       is initialized. The following services are
                                       running at the time this method is called:
                                       DDE server
                                       OLE objects registered and placed in the COM running object table

                eGW_CMDEVTID_ONSHUTDOWN = Simply a notification to the C3PO server
                                          that shutdown is occurring.  System services
                                          are still available when this notification
                                          is received.  Immediately after returning
                                          from this method call, however, the C3PO
                                          should assume that the calling client has
                                          shutdown.  If the calling client is the
                                          last client to use the C3PO manager, calls
                                          to the manager will fail after this call
                                          has returned.

   In:          Context: string - Class of the object
   
                evt: variant - Is an GWEvent. The GwEvent object defines an instance of an event.
                                It is subclassed by GWClientState. For more information see the documentation.

   Out:          none

   Comments:

************************************************************}
procedure TEventMonitor.Notify( Context: string;
                                evt: variant);
begin

end;

{TCommandFactory routines}

{***********************************************************
   Name:         TCommandFactory.BuildCommand

   Description:  This method is invoked to create a Command object. The C3po cannot assume
                 that Command::WantComand has been called before this method is invoked.

   In:           Context: string - This is the context for the command. The context string
                                   contains either the class of a GW data object(e.g. GW.MESSAGE.MAIL.X)
                                   or the class of the specific user interface(e.g. GW.APPLICATION.BROWSER).
                 PersistentID: string - This can be either a "pre-defined" ID or is an ID provided in a previous run of GW.
                 BaseCommand: variant - The command being overridden.
                 parms: variant - The parameter list of the command.

   Out:          GWCommand: variant - The command object of the command being overridden.

   Comments:     Each time the BuildCommand is invoked, the C3po should return a new instance of a GWCommand
                 object. This is neccessary because BuildCommand can be called recursively.

************************************************************}
function TCommandFactory.BuildCommand( Context: string;
                                       PersistentID: string;
                                       BaseCommand: variant;
                                       parms: variant): variant;
begin

end;

{***********************************************************
   Name:         TCommandFactory.CustomizeContextMenu

   Description:  Method to Customize a Context Menu

   In:           Context: string - The context string is the class of the object
                                   owning the menu. For example, ObjClass would
                                   contain "GW.MESSAGE.MAIL" for the mail messages.

                 GWMenu: variant - The context menu to be modified.


   Out:          none

   Comments:

************************************************************}
procedure TCommandFactory.CustomizeContextMenu( Context: string;
                                                GWMenu: variant);
begin

end;

{***********************************************************
   Name:         TCommandFactory.CustomizeMenu

   Description:  Method to customise the menu.

   In:           Context: string - The context string property is the class of the
                                   containing window.  For example "GW.APPLICATION.BROWSER"
                 GWMenu: variant - The main menu object being modified.

   Out:          wordbool - The return value indicates whether the modifications to the
                 menu were "volatile".  If the return value is TRUE, CustomizeMenu()
                 will continue to be called each time the menu may need to be updated
                 e.g. at each popup creation).  Otherwise, C3PO servers can safely
                 assume that CustomizeMenu is called only once for any single instance
                 of a menu.  This simplifies the resulting code because there is
                 no need to check for commands that might already be on the menu.
                 That is, the C3PO's command are guaranteed to be absent from the
                 menu at the time of the first CustomizeMenu call.


   Comments:

************************************************************}
function TCommandFactory.CustomizeMenu( Context: string;
                                        GWMenu: variant): wordbool;
begin

end;

{***********************************************************
   Name:         TCommandFactory.CustomizeToolBar

   Description:  Method to customize the toolbar. The C3po must assume that its commands are absent from
                 the toolbar. For example, when a toolbar has been saved and restored in another session
                 of GruopWise, the commands can be put back onto the toolbar w/out any intervening calls to
                 CustomizeToolbar. For that reason, the C3po should query, the toolbar first before adding
                 anything to the toolbar window.

   In:           Context: string - Contains the class of the containing window.
                 GWToolbar: variant - Contains the GWToolbar object to be modified.

   Out:          wordbool - Returning TRUE from this method indicates that the toolbar modifications were
                            'volatile'. In that case, each time the toolbar is validated in the UI, the
                            CommandFactory::CustomizeToolbar method will be called.
   Comments:

************************************************************}
function TCommandFactory.CustomizeToolBar( Context: string;
                                           GWToolbar: variant): wordbool;
begin

end;

{***********************************************************
   Name:         TCommandFactory.Init

   Description:  This method is the first method of Command::Factory called. It is used to tell
                 GroupWise what UI items will be modified.

   In:           lcid: longint - This is the locale ID of the application driving the C3po.

   Out:          The C3po server returns any combination of the following bits:
   
                 eGW_CMDINIT_MENUS  - The C3po intends to modify the menus (CustomizeMenu Interface)
                 eGW_CMDINIT_TOOLBARS  - The C3po intends to modify the toolbar (CustomizeMenu Interface)
                 eGW_CMDINIT_CONTEXT_MENUS - The C3po intends to modify the context menus (CustomizeMenu Interface)
                 eGW_CMDINIT_NO_PREDEFINED - Optimization flag that indicates the C3po will never respond to
                                             predefined commands. Returning this flag will supress calls to the
                                             WantCommand method for predefined commands.


   Comments:

************************************************************}
function TCommandFactory.Init(lcid: longint): longint;
begin

end;

{***********************************************************
   Name:         TCommandFactory.WantCommand

   Description:  This method is used to query the C3po for it's intention to
                 support a predefined command.

   In:           Context: string - This is the actual object class
                                   associates with the command.
                 PersistentID: string - This can be either a "pre-defined"
                                        ID or is an ID provided in a previous
                                        run of GW.

   Out:          True - I do want to support this predefined command
                 FALSE - I do not want to support this predefined command


   Comments:

************************************************************}
function TCommandFactory.WantCommand( Context: string;
                                      PersistentID: string): wordbool;
begin

end;

{TC3POServer routines}

{***********************************************************
   Name:         TC3POServer.GetCommandFactory

   Description:  This property returns the CommandFactory for the C3PO.  The
                 C3PO server may return NULL.


   In:           none

   Out:          CommandFactory object or null in not supported

   Comments:

************************************************************}
function TC3POServer.GetCommandFactory : variant;
begin
     Result := NULL;
end;

{***********************************************************
   Name:         TC3POServer.GetDescription

   Description:  Returns a human readable description of the C3PO server.

   In:           none

   Out:          string

   Comments:

************************************************************}
function TC3POServer.GetDescription : string;
begin
     Result := NULL;
end;

{***********************************************************
   Name:         TC3POServer.GetEventMonitor

   Description:  This property returns the event monitor for the C3PO.  The
                 C3PO server may return NULL.


   In:           none

   Out:          EventMonitor object or null if not supported

   Comments:

************************************************************}
function TC3POServer.GetEventMonitor : variant;
begin
     Result := NULL;
end;

{***********************************************************
   Name:         TC3POServer.GetIconFactory

   Description:  This property returns the IconFactory for the C3PO.  The C3PO
                 server may return NULL.


   In:           none

   Out:          IconFactory object or null if not supported


   Comments:

************************************************************}
function TC3POServer.GetIconFactory : variant;
begin
     Result := NULL;
end;

{***********************************************************
   Name:         TC3POServer.CanShutdown

   Description:  This method is invoked to query whether the C3PO server can
                 shutdown.  Typically, this is used when the C3PO server has a
                 window open on the UI screen and is not in a state where shutdown
                 is possible.  Each C3PO server is guaranteed to have CanShutdown
                 queried at least once before the C3PO system shuts down.

                 Semantically, CanShutdown is a request from the C3POManager to
                 a given C3PO.  It's not a request for shutting down a C3PO as
                 much as it is a request to shutdown the C3POManager and consequently
                 disconnect the C3PO.  Typically, a C3PO would shutdown along
                 with the C3POManager, but this is not strictly required.

                 No particular C3PO order can be relied on for querying the CanShutdown property.

   In:           none

   Out:          TRUE if it is OK to shutdown
                 FALSE if it is not OK to shutdown

   Comments:

************************************************************}
function TC3POServer.CanShutdown: wordbool;
begin
     Result := TRUE;
end;

{***********************************************************
   Name:         TC3POServer.DeInit

   Description:  Terminates the relationship of the C3PO Manager with the C3PO
                 server.  Note that this is a separate issue from the shutdown
                 sequence (including shutdown events).  For example, a C3PO may
                 be unloaded from memory as a runtime optimization.  In that
                 scenario, the C3PO server first receives CanShutdown() calls
                 followed by DeInit()  the C3PO is unloaded, but the client
                 application has not necessarilly terminated.

                 The C3POManager pointer passed in to C3POServer::Init() is
                 still valid during this call.  However, when DeInit() returns,
                 the C3POManager pointer is not guaranteed to be valid.  The
                 C3POServer must release all holds to the C3POManager during
                 the DeInit call.

                 One DeInit call will be issued to the C3POServer for each C3PO
                 Client using the C3PO system.  C3POs that wish to be capable of
                 loading into multiple Clients (irrespective of process boundaries)
                 should be multiple-instance OLE servers.  That is, a new C3POServer
                 object should be created for each C3POManager that wished to
                 use the services of the C3PO.  By tracking the Manager pointer
                 for each C3POServer, the C3PO can sort out which requests are
                 being issued from which clients.


   In:           none

   Out:          none

   Comments:

************************************************************}
procedure TC3POServer.DeInit;
begin

end;

{***********************************************************
   Name:         TC3POServer.Init

   Description:  This method is the first method invoked in the C3POServer object
                 when loading a C3PO server.  If the server fails this call
                 (via the HRESULT), the C3PO server is unloaded.

                 One Init call will be issued to the C3POServer for each C3PO
                 Client using the C3PO system.  C3POs that wish to be capable of
                 loading into multiple Clients (irrespective of process boundaries)
                 should be multiple-instance OLE servers.  That is, a new C3POServer
                 object should be created for each C3POManager that wished to use
                 the services of the C3PO.  By tracking the Manager pointer for
                 each C3POServer, the C3PO can sort out which requests are being
                 issued from which clients.

                 The Manager object is valid until a future DeInit() call.
                 That is, the C3PO does not need to AddRef() this object but can
                 simply store it for the life of the C3PO (until DeInit is called).



   In:           Manager: variant - C3POManager object

   Out:          none

   Comments:

************************************************************}
procedure TC3POServer.Init(Manager: variant);
begin

end;

End.

