{+//____________________________________________________________________________ }
{-Copyright (C) 1996-1998 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: ENCRYPT.pas,v 1.9.12.2 1999/08/27 22:00:46 build Exp $ }
{=____________________________________________________________________________ }
unit Encrypt;

interface


uses dialogs, DdeMan,  StdCtrls, Controls, Buttons, ExtCtrls,sysutils,inifiles,WinTypes, WinProcs, Classes,
Graphics, Forms, wpcom32, pgpexsdk,autoscale,clipbrd;

resourcestring
notextwarn='There is no message text to encrypt.';
notext='You must type some text or attach a file in order to encrypt';
attacherror='There was an error encrypting an attachment.  The message was not fully encrypted.';
noencrypt='You have attached one or more mail items or OLE objects that cannot be encrypted.  They will be sent unencrypted.';
docrefmess='You have attached a document reference called "%s" which is linked to the Groupwise database.  Do you wish to encrypt it?  You will lose the link to Groupwise and the encrypted file will be a static copy.';
messageonly='If you attached a message, only the main body will be encrypted, and it will be in WP format.';
messagebodyonly='MESSAGE BODY ONLY SIGNED';
toolong='The message is very long.  Anything over 25k will be truncated.  Click OK to continue or cancel to change the message.';
const settextsize=35000;

type
TFooClass = class(TControl);
  TEncryptForm = class(TForm)
    Panel1: TPanel;
    EOption: TRadioGroup;
    Panel2: TPanel;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    procedure FormCreate
  (Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private

    { Private declarations }
  public
      function c3poencrypt(onetimeencrypt,selectedonly:boolean):integer;
    { Public declarations }
  end;


var
  EncryptForm: TEncryptForm;
  windir:string;



const maxreadlen=32767;
procedure fixquotes(var fixtext:string);
function checkinternal(owner,test:string):boolean;
function gwlen(var text:string):integer;

implementation

uses tempform,  Pgp2;

{$R *.DFM}


(*----------------------------------
Name: CheckInternal

Description: compares 2 addresses to see if they are both in the same domain

In: owner - String containing the first address
    test - string containing the second address

Out: NONE

Returns: true if the same domain, false otherwise

-------------------------------------------*)
function checkinternal(owner,test:string):boolean; //false if external;true if internal
var parseowner,parsetest:string;
begin
if pos('@',test)=0 then begin
result:=false;
(*{$IFDEF GW52}
result:= false;
{$ELSE}
parseowner:=getaddress(owner);
parsetest:=getaddress(test);
if pos('@',test)=0 then result:=false else
result:=(comparetext(copy(parseowner,pos('@',parseowner)+1,length(parseowner)-pos('@',parseowner)),copy(parsetest,pos('@',parsetest)+1,length(parsetest)-pos('@',parsetest)))=0)
{$ENDIF}*)
end else
begin
result:=(comparetext(copy(owner,pos('@',owner)+1,length(owner)-pos('@',owner)),copy(test,pos('@',test)+1,length(test)-pos('@',test)))=0)
end;
{if pos('@',test)>0 then result:=false else
result:=true;}
end;



procedure log(const logdat:string);
var runfile:string;ini:textfile;
begin
  runfile:='c:\pgpgw.log';
{  deletefile(runfile);}
  try
  assignfile(ini,runfile);
   append(ini);
   writeln(ini,logdat);
   finally
     closefile(ini);
  end;
  end;


var PGPGWProg,PGPGWPath:string;

(*----------------------------------
Name: processname

Description: separates the path and filename in a full file location

In: name - string containing full file name and path

Out: fname - string containing the name
     fpath - string containing the path

Returns: NONE

-------------------------------------------*)
procedure processname(name:string; var fname,fpath:string);
begin
     fname := ExtractFileName(name);
     fpath := ExtractFilePath(name);
end;


procedure setup;
var
   Tmpname:string;
   ini:textfile;
   com:string;
   tpath,tprog:string;
   sysdir,PGPGWPathN,prog :array[0..255] of char;
   len:word;
   inifile:tinifile;
begin
   Tmpname:=ParamStr(0);
   processname(tmpname,PGPGWProg,PGPGWPath);
   form2.show;
   application.processmessages;
     setforegroundwindow(application.handle);
end;



procedure TEncryptForm.FormCreate(Sender: TObject); //set up form for different screen resolutions
   var
   tmpname,parmstr:string;
   lines : integer;
   ini:textfile;
   cd:longint;
   lang:array[0..2] of char;
   i,err:longint;
   tpath,tprog:string;
sysdir:array[0..255] of char;
inifile:tinifile;
begin
     {if (Screen.PixelsPerInch <> cPixelsPerInch) then
         for i := ControlCount - 1 downto 0 do
              TFooClass(Controls[i]).Font.Height :=
               (trunc(cFontHeight/Font.Height)) *
                 TFooClass(Controls[i]).Font.Height;}
geautoscale(encryptform);                 
err:=1;
   end;



(*----------------------------------
Name: encrypttext

Description: encrypts a block in memory; figures out special options such as
             internal only and selected text only

In: tmpfile - string containing text to encrypt
    selectedonly - boolean that is true if the text was selected in the message
                                and false if the text represents the entire message

Out: tmpfile - string containing encrypted text (if successful)
             - contains original text if not successful

Returns: true is successful (no errors); false otherwise

-------------------------------------------*)
function encrypttext(var tmpfile:string;selectedonly:boolean):boolean;
var
num:string; pass:string;dontencrypt:boolean;
begin
     dontencrypt:=form1.isinternal and (not selectedonly);
{     if tmpfile='' then begin
     if (form1.pgp.encryptone) or (selectedonly and (encryptform.eoption.itemindex in [0,1])) then
     begin
     num:='0';
     form1.WPO.CommandString := 'ItemAttachmentGetCount("X00")'; //how many attachments
     num := form1.WPO.CommandReturn;
     if num ='0' then begin //if no attachments
        MessageDlg(notext,mtError, [mbOK], 0);
        result:=false;
     end; end else
          if form1.PGP.encrypt(tmpfile,encryptform.eoption.itemindex,false,dontencrypt) =0
            then begin result:=true;
              end
            else result:=false;
     end else         }
     if form1.PGP.encrypt(tmpfile,encryptform.eoption.itemindex,false,dontencrypt) =0
            then begin result:=true;
              end
            else result:=false;

end;


(*----------------------------------
Name: encryptfile

Description: encrypts a file on disk; figures out special options such as
             internal only and selected text only

In: tmpfile - string containing file to encrypt
    selectedonly - boolean that is true if the text was selected in the message
                                and false if the text represents the entire message

Out: tmpfile - string containing encrypted file name (if successful)
             - contains original file name if not successful

Returns: true is successful (no errors); false otherwise

-------------------------------------------*)
function encryptfile(var tmpfile:string):boolean;
var
num:integer; ext,pass:string;
begin
 begin
        if form1.PGP.encrypt(tmpfile,encryptform.eoption.itemindex,true,false) =0
                then begin result:=true;
                end
                 else result:=false;
                 end;
end;

(*----------------------------------
Name: fixquotes

Description: utility that adds a second " mark next to every " mark
             necessary before sending any quoted text to Groupwise via wpo.commandstring

In: fixtext -string containing text to modify

Out: fixtext - modified text

Returns:

-------------------------------------------*)
procedure fixquotes(var fixtext:string);
var holder:string;count:integer;
begin
   holder:=fixtext;
   fixtext:='';
   for count:=1 to length(holder) do begin
   if holder[count]<>'"' then
   fixtext:=fixtext+holder[count] else
   fixtext:=fixtext+holder[count]+'"';
   end;

end;

(*----------------------------------
Name: encryptattach2

Description: handles encryption of all attachments to a message

In: messageid - string containing the messageid to handle
              - always 'X00' right now, but may be a draft message in the future

Out: NONE

Returns: boolean - true if successful (no error or cancel) and false otherwise

-------------------------------------------*)
function encryptattach2(messageid:string):boolean;
var
count,classid, numdocs,doc:integer;
 templist,namelist:pstring;
dispname,fname,fpath, num,parmstr,tmpfile:string;
classlist:^integer;
atts,ver,attachmess:variant;
outfile:textfile;
messtosave:string;
origfile,filemess:string;
start,counter:integer;
checked,doencrypt:boolean;
res:word;
begin
     num:='0';
     form1.WPO.CommandString := 'ItemAttachmentGetCount("'+messageid+'")'; //how many attachments
     num := form1.WPO.CommandReturn;
result:=true;
checked:=false;

if num <> '0' then begin //if more than one attachment
numdocs:=strtoint(num);

namelist:=allocmem(sizeof(pstring)*(numdocs)); //allocate list of names
templist:=namelist;
for doc := 0 to (numdocs-1) do
begin
form1.wpo.commandstring:='itemattachmentgetname("'+messageid+'";'+inttostr(doc)+')';//get the attachment name
dispname:=form1.wpo.commandreturn;
if pos('Token failed',dispname)>0 then //the token will fail if it is an OLE object
begin
if not checked then begin //checked is set for the first "bad" attachment
res:=MessageDlg(noencrypt,mtWarning, [mbOK,mbCancel], 0);//ask whether to drop the attachment or send unencrypted
checked:=true;
end;
case res of
mrCancel:begin result:=false;freemem(namelist);exit;end; //exit out if cancel
mrYes:begin filemess:='BADFILE';templist^:=filemess; end;//signify dropping the message
mrOK:begin filemess:='GOODFILE';templist^:=filemess; end;//signify sending unencrypted
end;
doencrypt:=false;//don't encrypt this attachment
end else
if pos('\',dispname)>0 then begin //this will be true if the attachment is a regular attachment
processname(dispname,fname,fpath);//get the name, save the file, and set the encrypt flag on for this attachment
tmpfile:=form1.pgp.pgppath+fname;
{form1.pgp.wipefile(tmpfile);}
if fileexists(tmpfile) then begin
form1.killlist.items.add(tmpfile);
insert('#',tmpfile,pos(extractfileext(tmpfile),tmpfile));
end;
form1.wpo.CommandString := 'ItemAttachmentSaveAs ("'+messageid+'";'+inttostr(doc)+';"' + tmpfile + '")';
if pos('Token failed',form1.wpo.commandreturn)>0 then begin
   filemess:='GOODFILE';
   templist^:=filemess;
   doencrypt:=false; end else
   begin
doencrypt:=true;
templist^:=tmpfile;
end;
end else
begin //we will get here if the attachment is a message or document reference
attachmess :=unassigned;
try
attachmess:=account.getmessage(widestring(dispname));//get the attachment message
except try attachmess:=account.getmessage(dispname);except end; end;
form1.wpo.commandstring:='itemattachmentgetdisplayname("'+messageid+'";'+inttostr(doc)+')';
dispname:=attachmess.subject.plaintext{form1.wpo.commandreturn};
processname(dispname,fname,fpath);
tmpfile:=form1.pgp.pgppath+fname;
doencrypt:=false;
{$IFDEF GW52}
if (not varisnull(attachmess)) and (not varisempty(attachmess)) then begin
if (comparetext(copy(attachmess.classname,1,28),'GW.MESSAGE.DOCUMENTREFERENCE')=0) then//see if the attachment is a document reference
{$ELSE}
if (not varisnull(attachmess)) and (not varisempty(attachmess)) then begin
if (comparetext(copy(attachmess.classname,1,28),'GW.MESSAGE.DOCUMENTREFERENCE')=0) then//see if the attachment is a document reference
(*form1.pgp.wipefile(tmpfile);
form1.wpo.CommandString := 'ItemAttachmentSaveAs ("'+messageid+'";'+inttostr(doc)+';"' + tmpfile + '")';
doencrypt:=true;
if pos('Token failed',form1.wpo.commandreturn)=0 then*)
{$ENDIF}
begin
if  messagedlg(format(docrefmess,[dispname]),mtconfirmation,[mbYes,mbno],0) = mrno then begin  //if it is a document reference but the document does not leave - don't encrypt
filemess:='GOODFILE';
templist^:=filemess;
doencrypt:=false;
end else begin //if it is a document reference and is going external, save it out to disk for encryption
templist^:=tmpfile;
{$IFDEF GW52}
ver:=attachmess.documentversion;
form1.pgp.wipefile(tmpfile);
ver.copyout(tmpfile);
doencrypt:=true;
{$ELSE}
ver:=attachmess.documentversion;
form1.pgp.wipefile(tmpfile);
ver.copyout(tmpfile);
doencrypt:=true;
{res:=MessageDlg(messageonly,mtconfirmation, [mbOK], 0);}
{$ENDIF}
end;
end else
begin //if it is not a document reference then ask whether to send the message unencrypted or to drop it
if not checked then begin
setforegroundwindow(application.handle);
res:=MessageDlg(noencrypt,mtWarning, [mbOK,mbCancel], 0);
checked:=true;
end;
case res of
mrCancel:begin result:=false;freemem(namelist);exit;end; //exit out
mrYes:begin filemess:='BADFILE';templist^:=filemess; end; //drop the message
mrOK:begin filemess:='GOODFILE';templist^:=filemess; end; //send attached message unencrypted
end;
end;
end else
templist^:='BADFILE'; //drop it if we can't tell what it is
end;
if doencrypt then //if the encryption flag is on for this message, then encrypt
{origfile:=tmpfile;}
if encryptfile(tmpfile)=false then begin
result:=false;
MessageDlg(attacherror, mtInformation, [mbOK], 0);
       freemem(namelist);
  form1.pgp.wipefile(tmpfile);
exit;
end;
if doc<(numdocs-1) then //delete the current attachments
inc(templist);
end;
templist:=namelist;
counter:=0;
for doc := 0 to (strtoint(num)-1) do

begin
start:=0;
if templist^ <>'GOODFILE' then //delete only if it is to be encrypted or was dropped
form1.wpo.CommandString:='AttachmentDelete('+inttostr(start+counter)+')' else
counter:=counter+1;
if doc<(strtoint(num)-1) then
inc(templist);
end;
templist:=namelist;
for doc := 0 to (strtoint(num)-1) do
begin
tmpfile:=templist^;
{tmpfile := form1.PGP.PGPPath+'doc'+inttostr(doc);}
if (tmpfile<>'BADFILE') and (tmpfile<>'GOODFILE') then begin//add only if it was encrypted - all else stays as was
form1.wpo.CommandString:='AttachmentAdd ("'+changefileext(tmpfile,'.asc') +'";No!;)';
if comparetext(tmpfile,changefileext(tmpfile,'.asc'))<>0 then
form1.pgp.wipefile(tmpfile);
form1.killlist.items.add(changefileext(tmpfile,'.asc'));
end;
if doc<(strtoint(num)-1) then
inc(templist);
end;
freemem(namelist);
end;
end;
(*----------------------------------
Name: gwlen

Description: Utility to get message length.  Currently unused

In: NONE

Out: text - string containing text that was counted

Returns: integer - length of current composed message

-------------------------------------------*)
function gwlen(var text:string):integer;
var line,numlines,chars:integer;clipboard:tclipboard;
begin
form1.wpo.commandstring:='postexttop()';
form1.wpo.commandstring:='Selecttoendtext()';
form1.wpo.commandstring:='editcopy()';
clipboard:=tclipboard.create;
result:=(length(clipboard.astext));
text:=clipboard.astext;
clipboard.free;
form1.wpo.commandstring:='postexttop()';
  end;


(*----------------------------------
Name: encryptproc

Description: handles the encryption of a message

In: selectedonly - boolean that is true if only selected text is encrypted, false otherwise
    onetimeencrypt - boolean that is true if encrypting on this pass, false otherwise

Out: NONE

Returns: boolean - true if successful (no errors or cancel) and false otherwise

-------------------------------------------*)
function encryptproc(var selectedonly:boolean;onetimeencrypt:boolean):boolean;
var test:string;
    groupwise,account,tmessage:variant;
numatt,messageid,temp,tmpfile,parmstr,eline : string;
    num:integer;
    fname,efile:textfile;
    count,numread,numwrite,ferror:integer;
    tempchar:array[0..4096] of byte;
    return:char;
    infile,outfile:file;
    signinternal:boolean;
    clipboard:tclipboard;
    len:integer;
     begin
     result:=false;
{   tmpfile := form1.PGP.PGPPath + 'temppgp';}
{    messageid:=gwmess.messageid;}
messageid:='X00'; //this could be changed to a draft messageid in the future
if not selectedonly then begin
form1.wpo.commandstring:='itemgettext("'+messageid+'";Message!)'; //get all the text
tmpfile:=form1.wpo.commandreturn;

end else begin //get only the selected text
form1.wpo.commandstring:='EditCopy()';
tmpfile:=form1.WPO.commandreturn;
if pos('Token failed',tmpfile)=0 then begin
clipboard:=tclipboard.create;
tmpfile:=clipboard.astext;
clipboard.free;
{form1.wpo.commandstring:='EnvClipboardText()';
tmpfile:=form1.wpo.commandreturn;}
end else
begin
selectedonly:=false;
form1.wpo.commandstring:='itemgettext("'+messageid+'";Message!)'; //get all the text
tmpfile:=form1.wpo.commandreturn;
end;
end;

{$ifdef debug}

log(form1.wpo.commandreturn);
if fileexists(tmpfile) then
log('save: '+tmpfile+'exists') else
log('Encrypt: '+tmpfile+'does not exist');
{$endif}
    if onetimeencrypt and (tmpfile='') then begin
            tmpfile:=' ';
end;
   if encrypttext(tmpfile,selectedonly) then begin //encrypt the text
   fixquotes(tmpfile);
   result:=true;

   if not selectedonly then begin //put the encrypt text into the message - convoluted text setting to keep block inserted less than 32k at a time
   form1.wpo.commandstring:='fontnormal()';
   form1.wpo.CommandString := 'ItemSetText("'+messageid+'"; Message!; "";No! )';
   form1.wpo.commandstring:='fontnormal()';
{   if form1.pgp.signone and form1.isinternal then form1.wpo.commandstring:='ItemSetText("'+messageid+'"; Message!;"'+messagebodyonly+chr(13)+chr(10)+'";NO! )';}
   for count :=0 to ((length(tmpfile) div settextsize)-1) do begin
     form1.wpo.commandstring:='fontnormal()';
     form1.wpo.CommandString := 'ItemSetText("'+messageid+'";Message!;"'+copy(tmpfile,(count*settextsize)+1,settextsize)+'";Yes! )';
     end;
    if (length(tmpfile) mod settextsize) >0 then
     form1.wpo.CommandString := 'ItemSetText("'+messageid+'";Message!;"'+copy(tmpfile,((length(tmpfile) div settextsize)*settextsize)+1,length(tmpfile) mod settextsize)+'";Yes! )';
 end else begin //replace only the selected text
    form1.wpo.commandstring:='fontnormal()';
  form1.wpo.CommandString := 'Type("'+tmpfile+'")';
 end;
if ((not form1.isinternal) and (not selectedonly)) then begin //handle the attachments if required by options
  if onetimeencrypt then result:= encryptattach2(messageid)
  end else
  result:=true;

 end else
 if form1.isinternal and (not form1.pgp.signone) then
result:=true;
 form1.pgp.cleanencrypt;

end;





procedure TEncryptForm.OKBtnClick(Sender: TObject); //hides the window when done
var
    fname,efile:textfile;
   eline,tmpfile: string;
    num:integer;
    tempvar:variant;
begin
encryptform.hide;
end;


procedure TEncryptForm.CancelBtnClick(Sender: TObject); //hides the window when done
begin
encryptform.hide;
end;


(*----------------------------------
Name: checkinternal users

Description: iterates over all message recipients to determine whether all are in the same domain

In: users - tstringlist containing all of the recipient addresses

Out: NONE

Returns: true if all have the same domain and false if any doesn't have the same domain or if the address can't be resolved (has no @ in it)

-------------------------------------------*)
function checkinternalusers(users:tstringlist):boolean;
var num:integer;
begin
result:=true;
for num := 0 to (users.count -1) do begin
if not checkinternal(form1.owneraddress,users.strings[num]) then
begin
result:=false;
exit;
end;
end;
end;

(*----------------------------------
Name: tencryptform.c3poencrypt

Description: function sets up the options and encrypts a message
             primary interface between C3PO and Groupwise

In: onetimeencrypt - boolean that is true if the message is to be encrypted and false otherwise
    selectedonly - boolean that is true if only selected text is to be encoded and false if entire message

Out: NONE

Returns: 0 if successful and 1 otherwise (error or cancel)

-------------------------------------------*)
function tencryptform.c3poencrypt(onetimeencrypt,selectedonly:boolean):integer;
var messid,mess,temp:string;
passwd:pchar;
num,tempvar:string;
signit,encryptit,continue:boolean;
users:tstringlist;
begin
     result:=1;
     application.processmessages;
     setforegroundwindow(application.handle);

     if onetimeencrypt then begin
             form1.wpo.commandstring:='itemgettext("X00";Message!)'; //get all the text
        mess:=form1.wpo.commandreturn;
        if mess='' then begin
                num:='0';
           form1.WPO.CommandString := 'ItemAttachmentGetCount("X00")'; //how many attachments
            num := form1.WPO.CommandReturn;
          if num='0' then
            MessageDlg(notextwarn,mtWarning, [mbOK], 0);
            end;
            end;
     users:=form1.selectusers; //get the recipients
     form1.allinternal:=checkinternalusers(users); //see if they are in the same domain
     if form1.allinternal then //if all in the same domain
     form1.isinternal:=false
     {form1.isinternal:=form1.ignoreinternal and form1.sendbutton and (not selectedonly) //set the options based on what the user has asked for}
     else
     form1.isinternal:=false; //if not all internal then full processing
     continue:=true;
     if onetimeencrypt then begin //if encrypt then show the recipients dialog
     if form1.isinternal then continue:=true else
     continue:= form1.pgp.showencryptform(users);
     if not continue then form1.pgp.cleanencrypt;
     end;
          users.free;
     if not continue then result:=1 else
     begin
       form1.ok:=1;
       if encryptproc(selectedonly,onetimeencrypt) then begin //encrypt the message
          form1.wpo.commandstring:='itemgettext("X00";Subject!)'; //get the subject
          if form1.wpo.commandreturn='' then
             form1.wpo.CommandString := 'ItemSetText("X00"; Subject!; "(no subject)";No! )'; //set the subject
        form1.OK:=0;
     result:=form1.OK;
     end;
     end;

  end;

procedure TEncryptForm.FormActivate(Sender: TObject);
begin
{form1.selectusers;}
end;





end.
