unit PGPTLS;
interface
Uses WinTypes,
pgppubtypes,pgpbase,
     WinProcs;


{+//____________________________________________________________________________ }
{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: PGPTLS.PAS,v 1.5.12.2 1999/08/27 22:00:46 build Exp $ }
{=____________________________________________________________________________ }

Type PGPtlsContextRef =pointer;
 PGPtlsConstContextRef =pointer;
 PGPtlsSessionRef=pointer;
 PGPtlsConstSessionRef=pointer;
 PGPTLSFlags=PGPFlags;
 PGPtlsCipherSuiteNum=PGPInt32;
 PGPtlsProtocolState=PGPInt32;
PGPtlsPrime=pgpint32;
PGPtlsAlert=pgpint32;

const
 kPGPtlsFlags_ServerSide = $01;
 kPGPtlsFlags_ClientSide = $02;
 kPGPtlsFlags_RequestClientCert = $04;
 kPGPtlsFlags_NonBlockingIO = $08;

  kPGPtls_TLS_NULL_WITH_NULL_NULL= 0;
	kPGPtls_TLS_PGP_DHE_DSS_WITH_CAST_CBC_SHA=1 ;
	kPGPtls_TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA=2;
	kPGPtls_TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA=3;
	kPGPtls_TLS_RSA_WITH_3DES_EDE_CBC_SHA=4;
	kPGPtls_TLS_RSA_WITH_IDEA_CBC_SHA=5;
	kPGPtls_TLS_PGP_RSA_WITH_CAST_CBC_SHA=6;

kPGPtls_IdleState = 0;
                             kPGPtls_FatalErrorState=1;
                             kPGPtls_ClosedState=2;
                             kPGPtls_HandshakeState=3;
                             kPGPtls_ReadyState=4;


kPGPtls_DHPrime1024 = 0;
                     kPGPtls_DHPrime1536=1;
                     kPGPtls_DHPrime2048=2;
                     kPGPtls_DHPrime3072=3;
                     kPGPtls_DHPrime4096=4;


kPGPtls_AT_CloseNotify = 0;
kPGPtls_AT_UnexpectedMessage = 10;
	kPGPtls_AT_BadRecordMAC			= 20;//* FATAL */
	kPGPtls_AT_DecryptionFailed		= 21;//* FATAL */
	kPGPtls_AT_RecordOverflow		= 22;//* FATAL */
	kPGPtls_AT_DecompressionFailure	= 30;//* FATAL */
	kPGPtls_AT_HandshakeFailure		= 40;//* FATAL */
	kPGPtls_AT_NoCertificate		= 41;//* SSL3  */
	kPGPtls_AT_BadCertificate		= 42;
	kPGPtls_AT_UnsupportedCert		= 43;
	kPGPtls_AT_CertRevoked			= 44;
	kPGPtls_AT_CertExpired			= 45;
	kPGPtls_AT_CertUnknown			= 46;
	kPGPtls_AT_IllegalParameter		= 47;	//* FATAL */
	kPGPtls_AT_UnknownCA			= 48;	//* FATAL */
	kPGPtls_AT_AccessDenied			= 49;	//* FATAL */
	kPGPtls_AT_DecodeError			= 50;	//* FATAL */
	kPGPtls_AT_DecryptError			= 51;
	kPGPtls_AT_ExportRestriction	= 60;	//* FATAL */
	kPGPtls_AT_ProtocolVersion		= 70;	//* FATAL */
	kPGPtls_AT_InsufficientSecurity	= 71;	//* FATAL */
	kPGPtls_AT_InternalError		= 80;	//* FATAL */
	kPGPtls_AT_UserCancelled		= 90;
	kPGPtls_AT_NoRenegotiation		= 100;

	kPGPtls_AT_None					= 255;



{+// The Send and Receive function pointers should return the following }
{-error when the socket is non-blocking and the call would block. }
{-The Send and Receive functions passed in will need to translate }
{-the platform-specific socket error in appropriate cases by using }
{=calls such as WSAGetLastError() on Win32. }

Const kPGPtls_WouldBlockError = -47;

Type   PGPTLSRECEIVEPROCPTR=function(INDATA:pointer; OUTBUFFER:pointer;INBUFFERSIZE:PGPINT32 ):PGPInt32;
Type   PGPTLSSENDPROCPTR=function(INDATA:pointer;const INBUFFER:pointer;INBUFFERLENGTH:PGPINT32 ):PGPInt32;



function PGPNewTLSContext(context: PGPCONTEXTREF; 
                          var outRef: PGPTLSCONTEXTREF): PGPERROR; cdecl; far;


function PGPFreeTLSContext(ref: PGPTLSCONTEXTREF): PGPERROR; cdecl; far;

{+//____________________________________________________________________________ }
{-The following function activates or deactivates the session key cache }
{-for TLS sessions. This defaults to on but can be deactivated with this }
{-function to force all connections to proceed through the entire }
{-handshake. }
{=____________________________________________________________________________ }

function PGPtlsSetCache(ref: PGPTLSCONTEXTREF; 
                        useCache: PGPBOOLEAN): PGPERROR; cdecl; far;


function PGPtlsClearCache(ref: PGPTLSCONTEXTREF): PGPERROR; cdecl; far;


function PGPNewTLSSession(ref: PGPTLSCONTEXTREF; 
                          var outRef: PGPTLSSESSIONREF): PGPERROR; cdecl; far;


function PGPFreeTLSSession(ref: PGPTLSSESSIONREF): PGPERROR; cdecl; far;

{+// Default options are client side and no client cert request */ }

function PGPtlsSetProtocolOptions(ref: PGPTLSSESSIONREF;
                                  options: PGPTLSFLAGS): PGPERROR; cdecl; far;


{+//____________________________________________________________________________ }
{-The following function must be called to cleanly close a TLS }
{-connection. If it is not called, the session will not be able }
{-to be resumed from the session cache. }

{-In the event the application determines any problem with the }
{-connection such as the remote key not being valid, call this }
{-function with dontCache set to true in order to not cache the }
{-session keys. }
{=____________________________________________________________________________ }

function PGPtlsClose(ref: PGPTLSSESSIONREF;
                     dontCache: PGPBOOLEAN): PGPERROR; cdecl; far;

{+//____________________________________________________________________________ }
{-The following function must be called to initiate the PGPtls session. }
{-Once a TLS session has been assigned to a socket, no data can be sent }
{-over that socket by the application until the handshake is completed. }
{-Handshake completion is indicated by completion of this call without }
{-error or by checking the state of the PGPtlsSession. It will be }
{-kPGPtls_ReadyState when the application layer may send and receive }
{-data securely. }

{-This function performs all negotiation of the TLS connection. }
{=____________________________________________________________________________ }

function PGPtlsHandshake(ref: PGPTLSSESSIONREF): PGPERROR; cdecl; far;

{+//____________________________________________________________________________ }
{-The following function should be called before PGPtlsHandshake. }
{-In the general case, the remoteID will be an IP address. This }
{-is provided to PGPtls in order to allow it to cache the current }
{-session and be able to look it up later. If the remoteID passed }
{-into a future session is the same as a previously cached session, }
{-PGPtls will attempt to resume the session. }
{=____________________________________________________________________________ }

function PGPtlsSetRemoteUniqueID(ref: PGPTLSSESSIONREF;
                                 remoteID: PGPUINT32): PGPERROR; cdecl; far;

{+//____________________________________________________________________________ }
{-The following function sets the local private authenticating key. }

{-The passphrase and key are retained in memory. By default, no }
{-key is specified and a client side session will return no key in the }
{-client key exchange message to the server. }
{-It is an error not to specify a key on a server side TLS session. }
{-This function must be passed either PGPOPassphrase or PGPOPasskeyBuffer. }
{=____________________________________________________________________________ }

function PGPtlsSetLocalPrivateKey(ref: PGPTLSSESSIONREF;
                                  inKey: PGPKEYREF;
                                  firstOption: PGPOPTIONLISTREF;
                                  lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;

{+//____________________________________________________________________________ }
{-The following function sets the preferred cipher suite. }

{-There is no guarantee that cipher will actually be negotiated, }
{-but it will be attempted in preference to others. }
{=____________________________________________________________________________ }

function PGPtlsSetPreferredCipherSuite(ref: PGPTLSSESSIONREF;
                                       cipher: PGPTLSCIPHERSUITENUM): PGPERROR; cdecl; far;

{+//____________________________________________________________________________ }
{-The following function sets the desired DH prime. }

{-The requested primes are drawn from a set of primes hard-coded }
{-into PGPtls. New primes can be added in a fully compatible }
{-fashion since the server sends the prime to the client, but this }
{-version of the API does not support passing in a desired prime. The }
{-default prime if this function is not called is kPGPtlsDHPrime1536. }
{=____________________________________________________________________________ }

function PGPtlsSetDHPrime(ref: PGPTLSSESSIONREF;
                          prime: PGPTLSPRIME): PGPERROR; cdecl; far;

{+//____________________________________________________________________________ }
{-The following function gets the authenticated remote key after a }
{-successful handshake. }

{-The key returned must already have been approved through the callback }
{-mechanism. The PGPEvent mechanism is used to request approval from the }
{-client of the remote key received during the TLS handshake. The }
{-callback should be set through the standard PGPSockets callback }
{-mechanism. The event kPGPEvent_TLSRemoteKeyApprovalEvent will be }
{-used in this case. In some cases, the }
{-kPGPEvent_TLSRemoteKeyApprovalEvent may only pass a Key ID to the }
{-caller, and it will be up to the caller to resolve the Key ID into a }
{-key and pass the PGPKeyRef back to TLS. }
{=____________________________________________________________________________ }

function PGPtlsGetRemoteAuthenticatedKey(ref: PGPTLSSESSIONREF;
                                         var outKey: PGPKEYREF): PGPERROR; cdecl; far;

{+//____________________________________________________________________________ }
{-The following function returns the negotiated symmetric cipher. }

{-This function will return an error if called before a successful }
{-handshake. }
{=____________________________________________________________________________ }

function PGPtlsGetNegotiatedCipherSuite(ref: PGPTLSSESSIONREF;
                                        var outCipher: PGPTLSCIPHERSUITENUM): PGPERROR; cdecl; far;


function PGPtlsGetState(ref: PGPTLSSESSIONREF;
                        var outState: PGPTLSPROTOCOLSTATE): PGPERROR; cdecl; far;

{+//____________________________________________________________________________ }
{-The following two functions process data through TLS. }

{-It is an error to call these functions without having set a }
{-Read function pointer or Write function pointer. Most applications }
{-will never need to use these functions as the function pointers }
{-are automatically configured by PGPsockets, and these functions }
{-are automatically called by the PGPsockets implementations of }
{-PGPWrite and PGPRead whenever a PGPtlsSessionRef has been set for }
{-a given socket. }
{=____________________________________________________________________________ }

function PGPtlsReceive(ref: PGPTLSSESSIONREF;
                       outBuffer: Pointer;
                       var bufferSize: PGPSIZE): PGPERROR; cdecl; far;


function PGPtlsSend(ref: PGPTLSSESSIONREF;
                    Const inBuffer: Pointer;
                    inBufferLength: PGPSIZE): PGPERROR; cdecl; far;


function PGPtlsSetReceiveCallback(ref: PGPTLSSESSIONREF;
                                  tlsReceiveProc: PGPTLSRECEIVEPROCPTR;
                                  inData: Pointer): PGPERROR; cdecl; far;


function PGPtlsSetSendCallback(ref: PGPTLSSESSIONREF;
                               tlsSendProc: PGPTLSSENDPROCPTR;
                               inData: Pointer): PGPERROR; cdecl; far;

{+//____________________________________________________________________________ }
{-The following function gets the ID of the fatal alert which caused }
{-the TLS session to abort and go into the kPGPtls_FatalErrorState. }
{=____________________________________________________________________________ }

function PGPtlsGetAlert(ref: PGPTLSSESSIONREF;
                        var outAlert: PGPTLSALERT): PGPERROR; cdecl; far;



implementation

function PGPNewTLSContext; external 'PGPSDKNL.DLL'


function PGPFreeTLSContext; external 'PGPSDKNL.DLL'

function PGPtlsSetCache; external 'PGPSDKNL.DLL';

function PGPtlsClearCache; external 'PGPSDKNL.DLL';

function PGPNewTLSSession; external 'PGPSDKNL.DLL';

function PGPFreeTLSSession; external 'PGPSDKNL.DLL';

function PGPtlsSetProtocolOptions; external 'PGPSDKNL.DLL';

function PGPtlsClose; external 'PGPSDKNL.DLL';

function PGPtlsHandshake; external 'PGPSDKNL.DLL';

function PGPtlsSetRemoteUniqueID; external 'PGPSDKNL.DLL';

function PGPtlsSetLocalPrivateKey; external 'PGPSDKNL.DLL';

function PGPtlsSetPreferredCipherSuite; external 'PGPSDKNL.DLL';

function PGPtlsSetDHPrime; external 'PGPSDKNL.DLL';

function PGPtlsGetRemoteAuthenticatedKey; external 'PGPSDKNL.DLL';

function PGPtlsGetNegotiatedCipherSuite; external 'PGPSDKNL.DLL';

function PGPtlsGetState; external 'PGPSDKNL.DLL';

function PGPtlsReceive; external 'PGPSDKNL.DLL';

function PGPtlsSend; external 'PGPSDKNL.DLL';

function PGPtlsSetReceiveCallback; external 'PGPSDKNL.DLL';

function PGPtlsSetSendCallback; external 'PGPSDKNL.DLL';

function PGPtlsGetAlert; external 'PGPSDKNL.DLL';
end.
