unit PGPCIPHERFEEDBACK;

interface
Uses WinTypes,
     WinProcs,
     pgpSymmetricCipher,
     pgpBase,
     pgpPubTypes;


{+//____________________________________________________________________________ }
{-pgpSymmetricCipher.h }

{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }



{-$Id: PgpcipherFeedback.pas,v 1.5.12.2 1999/08/27 22:00:46 build Exp $ }
{=____________________________________________________________________________ }



{+//____________________________________________________________________________ }
{-A CFB context requires use of a symmetric cipher which has been created }
{-and whose key has been set. An error will be returned if this is not }
{-the case. }

{-After the call, the CipherFeedbackRef "owns" the symmetric ref and will }
{-dispose of it properly (even if an error occurs). }
{-The caller should no longer reference it. }
{=____________________________________________________________________________ }

function PGPNewCipherFeedback(ref: PGPSYMMETRICCIPHERCONTEXTREF;
                              interleaveFactor: PGPUINT16;
                              var outRef: PGPCIPHERFEEDBACKCONTEXTREF): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-Disposal clears all data in memory before releasing it. }
{=____________________________________________________________________________ }

function PGPFreeCipherFeedback(ref: PGPCIPHERFEEDBACKCONTEXTREF): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-Make an exact copy, including current state. Original is not changed. }
{=____________________________________________________________________________ }

function PGPCopyCipherFeedback(ref: PGPCIPHERFEEDBACKCONTEXTREF;
                               var outRef: PGPCIPHERFEEDBACKCONTEXTREF): PGPERROR; cdecl;



{+//____________________________________________________________________________ }
{-IV size is implicit (same size as the symmetric cipher block size). }
{-IV is *copied*. }
{-Caller may want to destroy the original after passing it in. }
{-Calling this implicitly calls PGPResetCipherFeedback(). }
{=____________________________________________________________________________ }

function PGPInitCipherFeedback(ref: PGPCIPHERFEEDBACKCONTEXTREF;
                               var key: PGPBYTE;
                               var initializationVector: PGPBYTE): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-Call repeatedly to process arbitrary amounts of data. }
{=____________________________________________________________________________ }

function PGPCipherFeedbackEncrypt(ref: PGPCIPHERFEEDBACKCONTEXTREF;
                                  var inv: PGPBYTE;
                                  bytesIn: PGPUINT32;
                                  var outv: PGPBYTE): PGPERROR; cdecl;


function PGPCipherFeedbackDecrypt(ref: PGPCIPHERFEEDBACKCONTEXTREF;
                                  var inv: PGPBYTE;
                                  bytesIn: PGPUINT32;
                                  var outv: PGPBYTE): PGPERROR; cdecl;



{+//____________________________________________________________________________ }
{-Get the symmetric cipher being used for this CFB context. }
{-You can use this to determine useful things about the underlying cipher }
{-such as its block size. }
{=____________________________________________________________________________ }

function PGPCipherFeedbackGetSymmetricCipher(ref: PGPCIPHERFEEDBACKCONTEXTREF;
                                             var outRef: PGPSYMMETRICCIPHERCONTEXTREF): PGPERROR; cdecl;



{+//____________________________________________________________________________ }
{-Reset the feedback mechanism to use whatever we have so far, plus previous }
{-bytes for a total of the cipher block size bytes. This effectively }
{-changes the cipher block boundary. }
{=____________________________________________________________________________ }

function PGPCipherFeedbackSync(ref: PGPCIPHERFEEDBACKCONTEXTREF): PGPERROR; cdecl;



{+//____________________________________________________________________________ }
{-Fetch random bytes from the cipher. Returns the actual number of }
{-random bytes obtained. }
{=____________________________________________________________________________ }

function PGPCipherFeedbackGetRandom(ref: PGPCIPHERFEEDBACKCONTEXTREF;
                                    requestCount: PGPUINT32;
                                    var outv: PGPBYTE;
                                    var outCount: PGPUINT32): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-Make more random bytes available using the supplied salt, which must }
{-be the same as the symmetric cipher block size. }
{=____________________________________________________________________________ }

function PGPCipherFeedbackRandomCycle(ref: PGPCIPHERFEEDBACKCONTEXTREF;
                                      var salt: PGPBYTE): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-Make more random bytes available using the supplied salt, which must }
{-be the same as the symmetric cipher block size. }
{=____________________________________________________________________________ }

function PGPCipherFeedbackRandomWash(ref: PGPCIPHERFEEDBACKCONTEXTREF;
                                     var inv: PGPBYTE;
                                     bytesIn: PGPUINT32): PGPERROR; cdecl;



implementation


function PGPNewCipherFeedback; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeCipherFeedback(ref: PGPCIPHERFEEDBACKCONTEXTREF): PGPERROR; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCopyCipherFeedback; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPInitCipherFeedback; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCipherFeedbackEncrypt; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCipherFeedbackDecrypt; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCipherFeedbackGetSymmetricCipher; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCipherFeedbackSync(ref: PGPCIPHERFEEDBACKCONTEXTREF): PGPERROR; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCipherFeedbackGetRandom; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCipherFeedbackRandomCycle; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCipherFeedbackRandomWash; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};



end.
