unit PGPCMDLG;

interface
Uses WinTypes,pflPrefTypes,messages,pgpgroups, pgpbase,pgpkeys,pgppubtypes,pgptls,pgpmemory,pgpencodes,
     WinProcs;



{+//____________________________________________________________________________ }
{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-PGPcomdlg.h - header file for PGP common dialog DLL }


{-$Id: Pgpcmdlg.pas,v 1.5.12.2 1999/08/27 22:00:47 build Exp $ }
{=____________________________________________________________________________ }


{ PGPcdGROUPFILE = record
                         pflcontext: PFLCONTEXTREF;
                         pflfilespec: PFLFILESPECREF;
                         groupset: PGPGROUPSETREF;
                       end;

ppgpcdgroupfile=^PGPcdGROUPFILE;}

Type PGPcdSERVEREVENT = record
                           nmhdr: longint{NMHDR};
                           pData: Pointer;
                           cancel: Bool;
                           step: LongInt;
                           total: LongInt;
                           szmessage: Array[0..255] of Char;
                         end ;


{/// keyserver notifications }
Const PGPCOMDLG_SERVERDONE = $0001;
Const PGPCOMDLG_SERVERPROGRESS = $0002;
Const PGPCOMDLG_SERVERABORT = $0003;
Const PGPCOMDLG_SERVERERROR = $0004;

Const PGPCOMDLG_SERVERINFINITE = -1;

{/// options bits }
Const PGPCOMDLG_ASCIIARMOR = $0001;
Const PGPCOMDLG_DETACHEDSIG = $0002;
Const PGPCOMDLG_PASSONLY = $0004;
Const PGPCOMDLG_WIPEORIG = $0008;

{/// disable bits }
Const PGPCOMDLG_DISABLE_ASCIIARMOR = $0001;
Const PGPCOMDLG_DISABLE_AUTOMODE = $0002;
Const PGPCOMDLG_DISABLE_PASSONLY = $0004;
Const PGPCOMDLG_DISABLE_WIPEORIG = $0008;
const PGPCL_DISABLE_FYEO=$0010;
const PGPCL_DISABLE_SDA=$0020;

{/// flag bits }
Const PGPCOMDLG_RSAENCRYPT = $0001;
Const PGPCOMDLG_DECRYPTION = $0002;
Const PGPCOMDLG_ENCRYPTION = $0004;
const PGPcomdlg_KEYPASSPHRASE=$0008;
{/// preferences pages }
Const PGPCOMDLG_GENERALPREFS = 0;
Const PGPCOMDLG_KEYRINGPREFS = 1;
Const PGPCOMDLG_EMAILPREFS = 2;
Const PGPCOMDLG_KEYSERVERPREFS = 3;
Const PGPCOMDLG_ADVANCEDPREFS = 4;

{/// eval expire codes }
Const PGPCOMDLG_ENCRYPTSIGNEXPIRED = 1;
Const PGPCOMDLG_ALLEXPIRED = 2;

Const PGPCOMDLG_DISPLAY_TIME = 0;
Const PGPCOMDLG_DISPLAY_DATE = 1;
Const PGPCOMDLG_DISPLAY_DURATION = 2;

{/// broadcast message used to inform others of keyring changes }
Const RELOADKEYRINGMSG = ('PGPM_RELOADKEYRING');
Const RELOADKEYSERVERPREFSMSG = ('PGPM_RELOADKEYSERVERPREFS');
Const RELOADPREFSMSG = ('PGPM_RELOADPREFS');

Const PGPcl_SPECIFIEDSERVER = 0;
Const PGPcl_USERIDBASEDSERVER = 1; {// determine server based on userid}
Const PGPcl_DEFAULTSERVER = 2; {// use default keyserver}
Const PGPcl_ROOTSERVER = 3; {// use root keyserver}


{$IFDEF PGP6}

{/// Searches keyserver prefs for specifed keyserver and replaces }
{/// authentication key. }
{/// }
{/// Entry parameters : }
{/// keyserver keyserver data to put in prefs file }


function PGPclSyncKeyserverPrefs(context: PGPCONTEXTREF;
                                    keyserver: pointer{PPGPKEYSERVERENTRY}): PGPERROR; cdecl; far;

                                     function PGPclStartMemLockDriver: PGPERROR; cdecl; far;
function PGPclNotifyKeyserverPrefsChanges(lParam: longint):PGPERROR; cdecl; far;

function PGPclNotifyPrefsChanges(lParam: longint):PGPError; cdecl; far;

function PGPclInitLibrary(thecontext:pgpcontextref): PGPERROR; cdecl; far;

{/// display keyset and allow user to select keys }
{/// }
{/// Entry parameters : }
{/// hWndParent - handle of parent window }
{/// pszPrompt - prompt string }
{/// KeySetToDisplay - keyset containing keys to show }
{/// KeySetMain - backing keyset }
{/// pKeySetSelected - buffer to receive keyset ref of selected keys }
{/// }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPclSelectKeys(Context: PGPCONTEXTREF;
                             tlsContext: PGPTLSCONTEXTREF;
                             hWndParent: HWND;
                             pszPrompt: PChar;
                             KeySetToDisplay: PGPKEYSETREF;
                             KeySetMain: PGPKEYSETREF;
                             var pKeySetSelected: PGPKEYSETREF): PGPERROR; cdecl; far;

function PGPclSystemTimeToDays(pst: PSYSTEMTIME;
                                   var piDays: Integer): PGPERROR; cdecl; far;

{$ELSE}
{$ENDIF}




{///-------------------------------------------------| }
{/// PGPcomdlgWrapBuffer - }
{/// Wrap text using platform independent word wrap code. }
{/// Output buffer must be freed with PGPcomdlgFreeWrapBuffer }
{/// }
{/// Entry parameters : }
{/// szInText - input buffer }
{/// wrapColumn - column at which to wrap }
{/// pszOutText - buffer to receive pointer to }
{/// output buffer containing wrapped text }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPcomdlgWrapBuffer(szInText: PChar;
                             wrapColumn: PGPUINT16;
                             var pszOutText: PChar): PGPERROR ; cdecl; far;

{///-------------------------------------------------| }
{/// PGPcomdlgFreeWrapBuffer - }
{/// Free previously-wrapped text buffer. }
{/// }
{/// Entry parameters : }
{/// textBuffer - buffer to free }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPcomdlgFreeWrapBuffer(textBuffer: PChar): PGPERROR; cdecl; far;

{///-------------------------------------------------| }
{/// PGPcomdlgCloseLibrary - }
{/// Close down DLL and purge passphrase buffers (only }
{/// those used to sign disable/delete on server). }
{/// }
{/// Entry parameters : }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPcomdlgCloseLibrary: PGPERROR; cdecl; far;


{///-------------------------------------------------| }
{/// PGPcomdlgOpenClientPreferences - }
{/// Open client preferences file and returns PrefRef to caller }
{/// }
{/// Entry parameters : }
{/// pPrefRef - pointer to buffer to receive PrefRef }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPcomdlgOpenClientPrefs({$IFDEF PGP6}
                                  memmgr:PGPMemorymgrref;
                                  {$ENDIF}
                                  var pPrefRef: PGPPREFREF): PGPERROR; cdecl; far;


{///-------------------------------------------------| }
{/// PGPcomdlgOpenAdminPreferences - }
{/// Open admin preferences file and returns PrefRef to caller }
{/// }
{/// Entry parameters : }
{/// pPrefRef - pointer to buffer to receive PrefRef }
{/// bLoadDefaults - TRUE=>if file doesn't exist, then create }
{/// and load default values }
{/// FALSE=>if file doesn't exist, return error }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPcomdlgOpenAdminPrefs({$IFDEF PGP6}
                                         memMgr: PGPMEMORYMGRREF;
                                 {$ENDIF}
                                 var pPrefRef: PGPPREFREF;
                                 bLoadDefaults: Bool): PGPERROR ; cdecl; far;


{///-------------------------------------------------| }
{/// PGPcomdlgCloseClientPrefs - }
{/// Closes, and optionally saves changes to, open preference }
{/// file. This routine is used to close both client and admin }
{/// preference files. }
{/// }
{/// Entry parameters : }
{/// PrefRef - PrefRef of file to close }
{/// bSave - TRUE => save changes before closing }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPcomdlgCloseClientPrefs(PrefRef: PGPPREFREF;
                                   bSave: Bool): PGPERROR; cdecl; far;


{///-------------------------------------------------| }
{/// PGPcomdlgCloseAdminPrefs - }
{/// Closes, and optionally saves changes to, open preference }
{/// file. This routine is used to close both client and admin }
{/// preference files. }
{/// }
{/// Entry parameters : }
{/// PrefRef - PrefRef of file to close }
{/// bSave - TRUE => save changes before closing }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPcomdlgCloseAdminPrefs(PrefRef: PGPPREFREF;
                                  bSave: Bool): PGPERROR; cdecl; far;


{///-------------------------------------------------| }
{/// PGPcomdlgGetKeyIDFromKey - }
{/// Get Key ID string from key }
{/// }
{/// Entry parameters : }
{/// Key - PGPKeyRef of key for which to get ID }
{/// bFull - TRUE => get full (64bit) keyID }
{/// szID - string buffer to receive keyID (must be at }
{/// least 11 bytes long for "standard", 19 bytes }
{/// for "full" keyID) }
{/// uLen - length of szID in bytes }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }

{$IFDEF PGP6}
{$ELSE}
function PGPcomdlgGetKeyIDFromKey(Key: PGPKEYREF;
                                  bFull: Bool;
                                  szID: PChar;
                                  uLen: Word): PGPERROR ; cdecl; far;

{$ENDIF}

{///-------------------------------------------------| }
{/// PGPcomdlgGetKeyFromKeyID - }
{/// Get key from Key ID string }
{/// }
{/// Entry parameters : }
{/// context - context ref }
{/// keyset - keyset to find key in }
{/// szID - string representation of key ID }
{/// alg - algorithm of key }
{/// Key - buffer to receive keyref }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPcomdlgGetKeyFromKeyID(context: PGPCONTEXTREF;
                                  keyset: PGPKEYSETREF;
                                  szID: PChar;
                                  alg: integer;
                                  var Key: PGPKEYREF): PGPERROR; cdecl; far;

{///-------------------------------------------------| }
{/// PGPcomdlgSyncKeySets - }
{/// sync keyset properties to resolve SDK problems }
{/// }
{/// Entry parameters : }
{/// context - context ref }
{/// keysetMain - main keyset containing trust info }
{/// keysetNew - new imported keyset to sync up }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPcomdlgSyncKeySets(context: PGPCONTEXTREF;
                              keysetMain: PGPKEYSETREF;
                              keysetNew: PGPKEYSETREF): PGPERROR; cdecl; far;

{///-------------------------------------------------| }
{/// PGPcomdlgPassphraseQuality - }
{/// Calculates index of passphrase quality }
{/// }
{/// Entry parameters : }
{/// szPhrase - passphrase to be evaluated }
{/// }
{/// Returns value in range [0,100] }
{/// }

{$IFDEF PGP6}
{$ELSE}
function PGPcomdlgPassphraseQuality(szPhrase: PChar): PGPERROR ; cdecl; far;

{$ENDIF}


{///-------------------------------------------------| }
{/// PGPcomdlgHelpAbout - }
{/// Post Help About dialog with button for browser }
{/// launch to specified URL. }
{/// }
{/// Entry parameters : }
{/// hWndParent - handle of parent window }
{/// szVersion - string containing version information }
{/// to be displayed }
{/// NULL => use default version string }
{/// szLinkText - text to be displayed on link button }
{/// (should be <= ~20 chars), }
{/// NULL => use default ("www.pgp.com") }
{/// szLink - URL to which to jump }
{/// NULL => use default ("http://www.pgp.com/") }
{/// }
{/// Returns kPGPError_NoErr }
{/// }


function PGPcomdlgHelpAbout({$IFDEF PGP6}
                                    context:pgpcontextref;
                            {$ENDIF}
                            hWndParent: HWND;
                            szVersion: PChar;
                            szLinkText: PChar;
                            szLink: PChar): PGPERROR; cdecl; far;


{///-------------------------------------------------| }
{/// PGPcomdlgHardSell - }
{/// Post hard sell dialog with button for browser }
{/// launch to PGP URL. }
{/// }
{/// Entry parameters : }
{/// hWndParent - handle of parent window }
{/// pszText - string containing text information }
{/// to be displayed }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }

{$IFDEF PGP6}
{$ELSE}
function PGPcomdlgHardSell(hWndParent: HWND;
                           pszText: PChar): PGPERROR  ; cdecl; far;

{$ENDIF}


{///-------------------------------------------------| }
{/// PGPcomdlgNag - }
{/// Post nag dialog with button for browser }
{/// launch to specified URL. }
{/// }
{/// Entry parameters : }
{/// hWndParent - handle of parent window }
{/// szLinkText - text to be displayed on link button }
{/// (should be <= ~20 chars), }
{/// NULL => use default ("Order Now!") }
{/// szLink - URL to which to jump }
{/// NULL => use default ("http://www.pgp.com/") }
{/// }
{/// Returns kPGPError_NoErr }
{/// }


function PGPcomdlgNag(hWndParent: HWND;
                      szLinkText: PChar;
                      szLink: PChar): PGPERROR ; cdecl; far;


{///-------------------------------------------------| }
{/// PGPcomdlgCheckKeyRings - }
{/// check key rings for problems and query user if }
{/// necessary. }
{/// }
{/// Entry parameters : }
{/// hWndParent - handle of parent window }
{/// bForceQuery - TRUE => always ask user }
{/// FALSE => only ask user if problems }
{/// }
{/// Returns kPGPError_UserAbort if user presses the CANCEL }
{/// button. Application should exit in this case. }
{/// }

{$IFDEF PGP6}
{$ELSE}
function PGPcomdlgCheckKeyRings(Context: PGPCONTEXTREF;
                                hWndParent: HWND;
                                bForceQuery: Bool): PGPERROR  ; cdecl; far;

{$ENDIF}


{///-------------------------------------------------| }
{/// PGPcomdlgPreferences - }
{/// post PGP preferences property sheets. }
{/// }
{/// This function posts the "PGP Preferences" property }
{/// sheet dialog boxes. Appropriate calls are made into }
{/// the pgpkeydb library to set the preferences. }
{/// }
{/// Entry parameters : }
{/// Context - PGP library context }
{/// hWndParent - handle of parent window }
{/// iStartsheet - zero-based index of property sheet }
{/// page to display initially. }
{/// use the above-defined constants }
{/// keysetMain - main keyset, if available. If not }
{/// available, NULL is OK. }
{/// }
{/// This function returns kPGPError_NoErr if all was OK or }
{/// kPGPError_UserAbort (if the user presses the cancel button) }
{/// or one of the above-defined error constants. }
{/// }


function PGPcomdlgPreferences(Context: PGPCONTEXTREF; 
                              hWndParent: HWND; 
                              startsheet: Integer
                              {$IFDEF PGP6}
                              ;
                              keysetmain:PGPKEYSETREF
                              {$ELSE}
                              {$ENDIF}): PGPERROR  ; cdecl; far;



{///-------------------------------------------------| }
{/// PGPcomdlgRandom - }
{/// collect random data from keyboard/mouse. }
{/// }
{/// Entry parameters : }
{/// Context - PGP library context }
{/// hWndParent - handle of parent window }
{/// uNeeded - bits of entropy needed }
{/// }
{/// This function returns either kPGPError_UserAbort (if the user }
{/// presses the cancel button) or kPGPError_NoErr or one }
{/// of the above-defined error constants }
{/// }


function PGPcomdlgRandom(Context: PGPCONTEXTREF; 
                         hWndParent: HWND; 
                         uNeeded: Word): PGPERROR  ; cdecl; far;


{///-------------------------------------------------| }
{/// PGPcomdlgGetPhrase - }
{/// get passphrase from user. }
{/// }
{/// Entry parameters : }
{/// context - PGP library context }
{/// hWndParent - handle of parent window }
{/// szPrompt - message string to be displayed to user }
{/// pszPhrase - pointer to receive address of buffer which }
{/// will contain passphrase. The caller should }
{/// deallocate this buffer by calling PGPcomdlgFreePhrase }
{/// KeySet - KeySet containing keys to display in combo or list box }
{/// NULL => hide key selection combo box }
{/// pKeyIDs - additional keyids to tag onto end of listbox in }
{/// decryption dialog }
{/// uKeyCount - total number of keys to display (only necessary when }
{/// keyids are to be displayed, otherwise can be zero) }
{/// pKey - pointer to buffer to receive ref to selected key. }
{/// if buffer contains key on entry, this will be default. }
{/// buffer should be set to NULL to use keyring default key. }
{/// NULL => hide key selection combo box }
{/// uOptions - pointer to buffer which contains and will receive }
{/// options bits }
{/// NULL => hide option checkboxes }
{/// uFlags - flag bits }
{/// PGPCOMDLG_RSAENCRYPT => encrypting to RSA key }
{/// PGPCOMDLG_DECRYPTION => display decryption dialog }
{/// PGPCOMDLG_ENCRYPTION => display conventional encryption }
{/// dialog }
{/// }
{/// This function returns kPGPError_UserAbort if the user }
{/// presses the cancel button. kPGPError_NoErr if no error. }
{/// Or one of the above-defined error constants. }
{/// }

type ppgpkeyid=^pgpkeyid;
PPPGPByte=^PPGPByte;
{$IFDEF PGP6}
function PGPcomdlgGetPhrase (
                   context:PGPContextRef;
			MainKeySet:PGPKeySetRef;
                        hWndParent:HWND;
                        szPrompt:Pchar;
                        pszPhrase:PPChar;
                        KeySet:	PGPKeySetRef	;
		        pKeyIDs:PGPKeyIDRef;
			uKeyCount:PGPUInt32;
		        var pKey:PGPKEYRef;
                        puOptions:Pword;
			uFlags:word;
		         ppPasskeyBuffer:PPPGPByte;
		        var piPasskeyLength:PGPUInt32;
                        MinLength:		PGPUInt32;
		        MinQuality:PGPUInt32;
		         tlsContext:PGPtlsContextRef;
			var AddedKeys:PGPKeySetRef;
                        phrase:pchar {this only works in PGP6.5 - it must be removed for a 6.x build}
		):PGPError ;cdecl;far;
{$ELSE}
function PGPcomdlgGetPhrase(context: PGPCONTEXTREF;
                            hWndParent: HWND;
                            szPrompt: PChar;
                            pszPhrase: ppchar;
                            KeySet: PGPKEYSETREF;
                            pKeyIDs: PGPKEYIDRef;
                            uKeyCount: cardinal;
                            var pKey: PGPKEYREF;
                            uOptions: pWord;
                            uFlags: Word): PGPERROR  ; cdecl; far;

{$ENDIF}

{///-------------------------------------------------| }
{/// PGPcomdlgFreePhrase - }
{/// wipe and deallocate phrase buffer. }
{/// }
{/// Entry parameters : }
{/// szPhrase - passphrase buffer to wipe and deallocate }
{/// }


procedure PGPcomdlgFreePhrase(szPhrase: PChar); cdecl; far;


{///----------------------------------------------------| }
{/// get descriptive string for error code }
{/// }
{/// Entry parameters : }
{/// iCode - error code returned by pgp or simple library routine }
{/// szString - buffer to be filled with descriptive error message }
{/// uLen - length of buffer in bytes }
{/// }
{/// This function evaluates iCode. If iCode warrants an error }
{/// message, the buffer is filled with the message and the function }
{/// returns TRUE. If no message is warranted, the function returns }
{/// FALSE. }
{/// }


function PGPcomdlgErrorToString(iCode: Integer;
                                szString: PChar;
                                uLen: Word): {$IFDEF PGP6} PGPERROR;
                                             {$ELSE}
                                             boolean;
                                             {$ENDIF}
                                             cdecl; far;


{///----------------------------------------------------| }
{/// putup error messagebox (if necessary) }
{/// }
{/// Entry parameters : }
{/// iCode - error code returned by pgp or simple library routine }
{/// }
{/// This function calls PGPcomdlgErrorToString to evaluate iCode. }
{/// If PGPcomdlgErrorToString returns TRUE, a message box is posted }
{/// containing the descriptive text. Otherwise no messagebox is }
{/// displayed. This function returns the value returned by }
{/// PGPcomdlgErrorToString. }
{/// }


function PGPcomdlgErrorMessage({$IFDEF PGP6}hwnd:thandle;{$ENDIF}
                                       iCode: Integer):{$IFDEF PGP6}
                                                        PGPERROR;
                                                       {$ELSE}
                                                        Bool;
                                                       {$ENDIF}
                                                        cdecl; far;


{///----------------------------------------------------| }
{/// Post Splash screen }
{/// }
{/// Entry parameters : }
{/// Context - PGP library context }
{/// hWndParent - handle of parent window (if NULL, }
{/// screen will not be dismissed until }
{/// PGPcomdlgSetSplashParent is called }
{/// with a non-null value }
{/// uMilliseconds - milliseconds to display splash }
{/// }


function PGPcomdlgSplash(Context: PGPCONTEXTREF;
                         hWndParent: HWND;
                         uMS: Word): PGPERROR  ; cdecl; far;


{///----------------------------------------------------| }
{/// Inform splash screen who its parent is }
{/// }
{/// Entry parameters : }
{/// hWndParent - handle of parent window }
{/// }


function PGPcomdlgSetSplashParent(hWndParent: HWND): PGPERROR  ; cdecl; far;


{///----------------------------------------------------| }
{/// Launch web browser and send to specified page }
{/// }
{/// Entry parameters : }
{/// pszURL - URL to open }
{/// }


function PGPcomdlgWebBrowse(pszURL: PChar): PGPERROR  ; cdecl; far;

{///----------------------------------------------------| }
{/// Broadcast message that indicates that the keyring }
{/// has been changed and that others should reload from }
{/// disk. }
{/// }
{/// Entry parameters : }
{/// lParam - 32 value which is passed along as the LPARAM }
{/// of the broadcast message. Current usage }
{/// is to set this to your process ID or your }
{/// window handle so that you can ignore }
{/// your own messages, if you want. Set to }
{/// zero to ensure all recipients process message. }
{/// }


procedure PGPcomdlgNotifyKeyringChanges(lParam: longint); cdecl; far;


{///----------------------------------------------------| }
{/// Returns TRUE if the beta or eval has expired, and displays a message box }
{/// Returns FALSE and does nothing if it's still valid }
{/// }
{/// Entry parameters : }
{/// hwnd Parent of window so we can show the MB. }
{/// NULL is acceptable. }
{/// }


function PGPcomdlgIsExpired(hwnd: HWND): {$IFDEF PGP6}
                                         PGPERROR;
                                         {$ELSE}
                                         bool;
                                         {$ENDIF}
                                         cdecl; far;


{///-------------------------------------------------| }
{/// PGPcomdlgRSADSAMixWarning - }
{/// Post warning dialog }
{/// }
{/// Entry parameters : }
{/// hWndParent - handle of parent window }
{/// }
{/// Returns kPGPError_NoErr, kPGPError_UserAbort, or PGPCOMDLG_NO }
{/// }


function PGPcomdlgRSADSAMixWarning(hWndParent: HWND): PGPERROR  ; cdecl; far;


{///----------------------------------------------------| }
{/// Returns TRUE if the evaluation has expired, and displays a message box }
{/// If the eval is partially expired, the nag screen will be displayed }
{/// }
{/// Entry parameters : }
{/// hwnd Parent of window so we can show the MB or nag screen. }
{/// NULL is acceptable. }
{/// nIndex Type of expiration to test: Encrypt/Sign or All }

function   PGPcomdlgEvalExpired (handle:HWND ;nIndex:integer):{$IFDEF PGP6}
                                                                      PGPERROR;
                                                              {$ELSE}
                                                              boolean;
                                                              {$ENDIF}
                                                              cdecl;far;

{///----------------------------------------------------| }
{/// Searches keyservers (as defined in prefs file) for all }
{/// keys in the specified keyset. }
{/// }
{/// Entry parameters : }
{/// hwndParent parent window }
{/// keysetToUpdate keyset with keys to update }
{/// pkeysetUpdated buffer to receive PGPKeySetRef }
{/// }
{/// returns kPGPError_NoErr. }
{/// }


function PGPcomdlgUpdateKeySetFromServer(context: PGPCONTEXTREF;
                                                  {$IFDEF PGP6}
                                                  tlscontext:pgptlscontextref;
                                                  {$ENDIF}
                                         hwndParent: HWND;
                                         keysetToUpdate: PGPKEYSETREF;
                                         {$IFDEF PGP6}
                                         uServer: Word;
                                         keysetMain: PGPKEYSETREF;
                                         {$ENDIF}
                                         var pkeysetUpdated: PGPKEYSETREF): PGPERROR  ; cdecl; far;

{///----------------------------------------------------| }
{/// Searches keyservers (as defined in prefs file) for the }
{/// specified userid string. }
{/// }
{/// Entry parameters : }
{/// hwndParent parent window }
{/// szUserID string containing userid info }
{/// pkeysetFound buffer to receive PGPKeySetRef }
{/// }
{/// returns kPGPError_NoErr. }
{/// }


function PGPcomdlgSearchServerForUserID(context: PGPCONTEXTREF;
                                        {$IFDEF PGP6}
                                          tlsContext: PGPTLSCONTEXTREF;
                                        {$ENDIF}
                                        hwndParent: HWND;
                                        szUserID: PChar;
                                        {$IFDEF PGP6}
                                        uServer: Word;
                                        keysetMain: PGPKEYSETREF;
                                        {$ENDIF}
                                        var pkeysetFound: PGPKEYSETREF): PGPERROR  ; cdecl; far;

{///----------------------------------------------------| }
{/// Searches default keyserver for the keyids in the list. }
{/// }
{/// Entry parameters : }
{/// hwndParent parent window }
{/// pkeyidList array of PGPKeyID }
{/// iNumKeyIDs number of PGPKeyIDs in list }
{/// pkeysetFound buffer to receive PGPKeySetRef }
{/// }
{/// returns kPGPError_NoErr. }
{/// }


function PGPcomdlgSearchServerForKeyIDs(context: PGPCONTEXTREF;
                                        {$IFDEF PGP6}
                                          tlsContext: PGPTLSCONTEXTREF;
                                        {$ENDIF}
                                        hwndParent: HWND;
                                        var pkeyidList: PGPKEYID;
                                        iNumKeyIDs: Integer;
                                        {$IFDEF PGP6}
                                        uServer: Word;
                                        keysetMain: PGPKEYSETREF;
                                        {$ENDIF}
                                        var pkeysetFound: PGPKEYSETREF): PGPERROR  ; cdecl; far;

{///----------------------------------------------------| }
{/// Sends keys in keyset to the specified keyserver }
{/// }
{/// Entry parameters : }
{/// hwndParent parent window }
{/// szServerURL server to send to }
{/// keysetSigning keyset with potential signing keys }
{/// (used if signed request is required }
{/// by the server) }
{/// keysetToSend keyset with keys to send }
{/// }
{/// returns kPGPError_NoErr. }
{/// }


function PGPcomdlgSendKeysToServer(context: PGPCONTEXTREF;
                                        {$IFDEF PGP6}
                                          tlsContext: PGPTLSCONTEXTREF;
                                        {$ENDIF}
                                   hwndParent: HWND;
                                        {$IFDEF PGP6}
                                        uServer: Word;
                                        pkeyserver:pointer {PPGPKEYSERVERENTRY};
                                        keysetMain: PGPKEYSETREF;
                                        {$ELSE}
                                         szServerURL: PChar;
                                         keysetSigning: PGPKEYSETREF;
                                        {$ENDIF}

                                        keysetToSend: PGPKEYSETREF): PGPERROR  ; cdecl; far;



{$IFDEF PGP6}
{/// Searches default keyserver using the specified filter. }
{/// }
{/// Entry parameters : }
{/// hwndParent parent window }
{/// filter filter to use for search }
{/// uServer one of above-defined server constants }
{/// keysetMain keyset to which tls key is added }
{/// pkeysetFound buffer to receive PGPKeySetRef }


function PGPclSearchServerWithFilter(context: PGPCONTEXTREF;
                                         tlsContext: PGPTLSCONTEXTREF;
                                         hwndParent: HWND;
                                         filter: PGPFILTERREF;
                                         uServer: Word;
                                         keysetMain: PGPKEYSETREF;
                                         var pkeysetFound: PGPKEYSETREF): PGPERROR; cdecl; far;

function PGPclSendKeysToRootServerNotify(context: PGPCONTEXTREF;
                                             tlsContext: PGPTLSCONTEXTREF;
                                             hWndToReceiveNotifications: HWND;
                                             keysetMain: PGPKEYSETREF;
                                             keysetToSend: PGPKEYSETREF): PGPERROR; cdecl; far;

function PGPclGetGroupsFromRootServer(context: PGPCONTEXTREF;
                                          tlsContext: PGPTLSCONTEXTREF;
                                          hwndParent: HWND;
                                          keysetMain: PGPKEYSETREF;
                                          var groupsetDownloaded: PGPGROUPSETREF): PGPERROR; cdecl; far;

function PGPclSendGroupsToRootServer(context: PGPCONTEXTREF;
                                         tlsContext: PGPTLSCONTEXTREF;
                                         hwndParent: HWND;
                                         keysetMain: PGPKEYSETREF;
                                         groupsetToSend: PGPGROUPSETREF): PGPERROR; cdecl; far;

function PGPclSendShares(context: PGPCONTEXTREF;
                            tlsContext: PGPTLSCONTEXTREF;
                             hwndParent: HWND;
                             keysetMain: PGPKEYSETREF): PGPERROR; cdecl; far;

function PGPclReconstituteKey(context: PGPCONTEXTREF;
                                  tlsContext: PGPTLSCONTEXTREF;
                                  hwndParent: HWND;
                                  keysetMain: PGPKEYSETREF;
                                  key: PGPKEYREF;
                                  var ppPasskeyBuffer: PGPBYTE;
                                  var piPasskeyLength: PGPUINT32): PGPERROR; cdecl; far;

Const PGPcomdlg_AUTHRECONSTITUTING = $0001;
Const PGPcomdlg_AUTHNEWKEY = $0002;
Const PGPcomdlg_AUTHUNEXPECTEDKEY = $0004;
Const PGPcomdlg_AUTHEXPECTEDKEY = $0008;


function PGPclConfirmRemoteAuthentication(context: PGPCONTEXTREF;
                                              hwndParent: HWND;
                                              pszServer: PChar;
                                              keyAuth: PGPKEYREF;
                                              keysetMain: PGPKEYSETREF;
                                              uFlags: Word): PGPERROR; cdecl; far;


{$ENDIF}

{///----------------------------------------------------| }
{/// Deletes keys in keyset from the specified keyserver }
{/// }
{/// Entry parameters : }
{/// hwndParent parent window }
{/// szServerURL server to send to }
{/// space pending or active bucket }
{/// keysetSigning keyset with potential signing keys }
{/// (used if signed request is required }
{/// by the server) }
{/// keysetToDelete keyset with keys to delete }
{/// }
{/// returns kPGPError_NoErr. }
{/// }


function PGPcomdlgDeleteKeysFromServer(context: PGPCONTEXTREF;
                                        {$IFDEF PGP6}
                                          tlsContext: PGPTLSCONTEXTREF;
                                        {$ENDIF}
                                       hwndParent: HWND;
                                       {$IFDEF PGP6}
                                       pkeyserver:pointer{PPGPKEYSERVERENTRY};

                                       {$ELSE}
                                       szServerURL: PChar;
                                       {$ENDIF}
                                       space: Integer;
                                       {$IFDEF PGP6}
                                       keysetMain: PGPKEYSETREF;
                                       {$ELSE}
                                       keysetSigning: PGPKEYSETREF;
                                      {$ENDIF}
                                       keysetToDelete: PGPKEYSETREF): PGPERROR  ; cdecl; far;

{///----------------------------------------------------| }
{/// Disables keys in keyset on the specified keyserver }
{/// }
{/// Entry parameters : }
{/// hwndParent parent window }
{/// szServerURL server to send to }
{/// space pending or active bucket }
{/// keysetSigning keyset with potential signing keys }
{/// (used if signed request is required }
{/// by the server) }
{/// keysetToDisable keyset with keys to disable }
{/// }
{/// returns kPGPError_NoErr. }
{/// }


function PGPcomdlgDisableKeysOnServer(context: PGPCONTEXTREF;
                                        {$IFDEF PGP6}
                                          tlsContext: PGPTLSCONTEXTREF;
                                        {$ENDIF}
                                       hwndParent: HWND;
                                       {$IFDEF PGP6}
                                       pkeyserver:pointer{PPGPKEYSERVERENTRY};

                                       {$ELSE}
                                       szServerURL: PChar;
                                       {$ENDIF}
                                       space: Integer;
                                       {$IFDEF PGP6}
                                       keysetMain: PGPKEYSETREF;
                                       {$ELSE}
                                       keysetSigning: PGPKEYSETREF;
                                      {$ENDIF}
                                       keysetToDisable: PGPKEYSETREF): PGPERROR  ; cdecl; far;

{///----------------------------------------------------| }
{/// Sends keys in keyset to the specified keyserver with }
{/// notifications }
{/// }
{/// Entry parameters : }
{/// hWndToReceiveNotifications window to get WM_NOTIFYs }
{/// szServerURL server to send to }
{/// keysetSigning keyset with potential signing keys }
{/// (used if signed request is required }
{/// by the server) }
{/// keysetToSend keyset with keys to send }
{/// }
{/// returns kPGPError_NoErr. Progress notifications and final }
{/// results are sent to window in form of WM_NOTIFY messages }
{/// }

{$IFDEF PGP6}
{$ELSE}
function PGPcomdlgSendKeysToServerNotify(context: PGPCONTEXTREF;
                                         hWndToReceiveNotifications: HWND;
                                         szServerURL: PChar;
                                         keysetSigning: PGPKEYSETREF;
                                         keysetToSend: PGPKEYSETREF): PGPERROR  ; cdecl; far;

{$ENDIF}

{///----------------------------------------------------| }
{/// Fills buffer with the path of the current PGP install. }
{/// }
{/// Entry parameters : }
{/// szPath buffer to receive string }
{/// uLen length of buffer in bytes }
{/// }
{/// returns kPGPError_NoErr if no error. }
{/// }


function PGPcomdlgGetPGPPath(szPath: PChar;
                             uLen: Word): PGPERROR  ; cdecl;far;


{///----------------------------------------------------| }
{/// Fills specified combobox with server name strings. }
{/// }
{/// Entry parameters : }
{/// hwndComboBox handle of combobox to fill }
{/// }
{/// returns kPGPError_NoErr if no error. }
{/// }

{$IFDEF PGP6}
{$ELSE}
function PGPcomdlgFillServerComboBox(hwndComboBox: HWND): PGPERROR  ; cdecl; far;


{$ENDIF}

{///----------------------------------------------------| }
{/// Opens standard groups file }
{/// }
{/// Entry parameters : }
{/// ppGroup address of buffer to receive pointer }
{/// to group file structure }
{/// }
{/// returns kPGPError_NoErr if no error. }
{/// }


{function PGPcomdlgOpenGroupFile(var ppGroup: PGPCDGROUPFILE): PGPERROR  ; cdecl; far;}


{///----------------------------------------------------| }
{/// Saves groups file }
{/// }
{/// Entry parameters : }
{/// pGroup pointer to group file structure }
{/// }
{/// returns kPGPError_NoErr if no error. }
{/// }


{function PGPcomdlgSaveGroupFile(var pGroup: PGPCDGROUPFILE): PGPERROR  ; cdecl; far;}


{///----------------------------------------------------| }
{/// Closes groups file }
{/// }
{/// Entry parameters : }
{/// pGroup pointer to group file structure }
{/// }
{/// returns kPGPError_NoErr if no error. }
{/// }


{function PGPcomdlgCloseGroupFile(var pGroup: PGPCDGROUPFILE): PGPERROR  ; cdecl; far;}


{///----------------------------------------------------| }
{/// Copy user info strings to preferences file }
{/// }
{/// Entry parameters : }
{/// szOwnerName owner name }
{/// szCompanyName company name }
{/// szLicenseNumber license number }
{/// }
{/// returns kPGPError_NoErr if no error. }
{/// }


function PGPcomdlgSetUserInfo(szOwnerName: PChar;
                              szCompanyName: PChar;
                              szLicenseNumber: PChar): PGPERROR  ; cdecl; far;


{///----------------------------------------------------| }
{/// Query SDK for keyring and randseed file paths }
{/// }
{/// Entry parameters : }
{/// pszPubRingPath buffer to receive public keyring file name }
{/// iPubRingLen length of buffer in bytes }
{/// pszPrivRingPath buffer to receive private keyring file name }
{/// iPrivRingLen length of buffer in bytes }
{/// pszRandSeedPath buffer to receive random seed file name }
{/// iRandSeedLen length of buffer in bytes }
{/// }
{/// Note: any or all buffer pointers can be NULL -- they will be ignored. }
{/// }
{/// returns kPGPError_NoErr if no error. }
{/// }


function PGPcomdlgGetSDKFilePaths(pszPubRingPath: PChar;
                                  iPubRingLen: Integer;
                                  pszPrivRingPath: PChar;
                                  iPrivRingLen: Integer;
                                  pszRandSeedPath: PChar;
                                  iRandSeedLen: Integer): PGPERROR  ; cdecl; far;


{///----------------------------------------------------| }
{/// Use SDK to set keyring and randseed file paths }
{/// }
{/// Entry parameters : }
{/// pszPubRingPath buffer containing public keyring file name }
{/// pszPrivRingPath buffer containing private keyring file name }
{/// pszRandSeedPath buffer containing random seed file name }
{/// bForceCreate TRUE => call PGPOpenDefaultKeyRings with "Create" }
{/// flag to force creation of files }
{/// FALSE => do not call PGPOpenDefaultKeyRings }
{/// }
{/// Note: any or all buffer pointers can be NULL -- they will be ignored. }
{/// }
{/// returns kPGPError_NoErr if no error. }
{/// }


function PGPcomdlgSetSDKFilePaths(pszPubRingPath: PChar; 
                                  pszPrivRingPath: PChar;
                                  pszRandSeedPath: PChar;
                                  bForceCreate: Bool): PGPERROR  ; cdecl; far;


{///----------------------------------------------------| }
{/// Check whether SDK supports specified Public Key algorithm }
{/// }
{/// Entry parameters : }
{/// PGPPublicKeyAlgorithm SDK public key algorithm constant }
{/// mustEncrypt TRUE=>SDK must support encryption with }
{/// this algorithm }
{/// mustSign TRUE=>SDK must support signing with }
{/// this algorithm }
{/// }
{/// returns kPGPError_NoErr if SDK supports operations with }
{/// specified algorithm, kPGPError_FeatureNotAvailable otherwise. }
{/// }


function PGPcomdlgCheckSDKSupportForPKAlg(alg: PGPPUBLICKEYALGORITHM; 
                                          mustEncrypt: PGPBOOLEAN; 
                                          mustSign: PGPBOOLEAN): PGPERROR  ; cdecl; far;


{///----------------------------------------------------| }
{/// Check whether SDK supports specified cipher algorithm }
{/// }
{/// Entry parameters : }
{/// PGPCipherAlgorithm SDK cipher algorithm constant }
{/// }
{/// returns kPGPError_NoErr if SDK supports operations with }
{/// specified algorithm, kPGPError_FeatureNotAvailable otherwise. }
{/// }


function PGPcomdlgCheckSDKSupportForCipherAlg(alg: PGPCIPHERALGORITHM): Bool; cdecl; far;


{///----------------------------------------------------| }
{/// Initialize timedate classes }
{/// }
{/// Entry parameters : }
{/// hinst calling instance }
{/// }
{/// returns TRUE if no error. }
{/// }

{$IFDEF PGP6}
{$ELSE}
function PGPcomdlgInitTimeDateControl(hinst: thandle): Bool; cdecl; far;


{$ENDIF}

{///----------------------------------------------------| }
{/// Create a timedate control }
{/// }
{/// Entry parameters : }
{/// hwndParent owner window }
{/// hinst calling instance }
{/// xPos position of left side }
{/// yPos position of top side }
{/// type time, date, duration type }
{/// }
{/// returns handle to control if no error. }
{/// }

{$IFDEF PGP6}
{$ELSE}
function PGPcomdlgCreateTimeDateControl(hwndParent: HWND;
                                        hinst: thandle;
                                        xPos: LongInt;
                                        yPos: LongInt;
                                        typev: LongInt): HWND; cdecl; far;

{$ENDIF}

{///----------------------------------------------------| }
{/// convenient defines for timedate control }
{/// }

Const TD_GETHOUR = WM_USER + 1776;
Const TD_GETMONTH = TD_GETHOUR;
Const TD_GETMINUTE = WM_USER + 1777;
Const TD_GETDAY = TD_GETMINUTE;
Const TD_GETSECOND = WM_USER + 1778;
Const TD_GETYEAR = TD_GETSECOND;

Const TD_SETHOUR = WM_USER + 1779;
Const TD_SETMONTH = TD_SETHOUR;
Const TD_SETMINUTE = WM_USER + 1780;
Const TD_SETDAY = TD_SETMINUTE;
Const TD_SETSECOND = WM_USER + 1781;
Const TD_SETYEAR = TD_SETSECOND;

Const TD_SETHOURLIMIT = WM_USER + 1782;
Const TD_SETMONTHLIMIT = TD_SETHOURLIMIT;
Const TD_SETMINUTELIMIT = WM_USER + 1783;
Const TD_SETDAYLIMIT = TD_SETMINUTELIMIT;
Const TD_SETSECONDLIMIT = WM_USER + 1784;
Const TD_SETYEARLIMIT = TD_SETSECONDLIMIT;

Const TDN_TIMECHANGED = WM_USER + 1785;

{function wipefilelist(window:thandle;name:pointer):integer;stdcall;far;
function filewipe(name:pointer):boolean;stdcall;far;}
{$IFDEF PGP6}
{/// Check to see if it's time to auto-update keys }
{/// }
{/// Entry parameters : }
{/// memoryMgr Memory manager ref }
{/// pbUpdateAllKeys Pointer to boolean, TRUE if it's }
{/// time to update all keys }
{/// pbUpdateTrustedIntroducers Pointer to boolean, TRUE if it's }
{/// time to update trusted introducers }


function PGPclCheckAutoUpdate(memoryMgr: PGPMEMORYMGRREF;
                                  var pbUpdateAllKeys: PGPBOOLEAN;
                                  var pbUpdateTrustedIntroducers: PGPBOOLEAN): PGPERROR; cdecl; far;

{/// Look up an unknown signer's key on the keyserver }
{/// }
{/// Entry parameters : }
{/// context context ref }
{/// hwnd handle to parent window }
{/// event event data pointer }
{/// signingKeyID Key ID of unknown signer }
{/// pbGotKeys Pointer to boolean, TRUE if the key(s) }
{/// of the unknown signer were successfully fetched }

type ppgpevent = ^pgpevent;
function PGPclLookupUnknownSigner(context: PGPCONTEXTREF;
                                      KeySetMain: PGPKEYSETREF;
                                      tlsContext: PGPTLSCONTEXTREF;
                                      hwnd: HWND;
                                      event: PPGPEVENT;
                                      signingKeyID: PGPKEYID;
                                      var pbGotKeys: PGPBOOLEAN): PGPERROR ; cdecl; far;
{/// _______________________________________________________ }

{$ENDIF}

implementation


{$IFDEF PGP6}
function PGPclLookupUnknownSigner;external  pgpclfile;
function PGPclCheckAutoUpdate;external  pgpclfile;
function PGPclSyncKeyserverPrefs;external  pgpclfile;
function PGPclInitLibrary;external  pgpclfile;
function PGPclSelectKeys;external  pgpclfile;
function PGPclSystemTimeToDays;external  pgpclfile;
function PGPclNotifyPrefsChanges;external  pgpclfile;
function PGPclNotifyKeyserverPrefsChanges;external  pgpclfile;
function PGPclStartMemLockDriver;external  pgpclfile;
function PGPclSearchServerWithFilter;external  pgpclfile;
function PGPclSendKeysToRootServerNotify;external  pgpclfile;
function PGPclGetGroupsFromRootServer;external  pgpclfile;
function PGPclSendGroupsToRootServer;external  pgpclfile;
function PGPclSendShares;external  pgpclfile;
function PGPclReconstituteKey;external  pgpclfile;
function PGPclConfirmRemoteAuthentication;external  pgpclfile;

{$ELSE}
function PGPcomdlgGetKeyIDFromKey ; external {$IFDEF PGP6}  pgpclfile   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgPassphraseQuality ; external {$IFDEF PGP6}  pgpclfile   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgHardSell; external {$IFDEF PGP6}  pgpclfile   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgCheckKeyRings ; external {$IFDEF PGP6}  pgpclfile   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgFillServerComboBox  ; external {$IFDEF PGP6}  pgpclfile   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgSendKeysToServerNotify  ; external {$IFDEF PGP6}  pgpclfile   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgInitTimeDateControl; external {$IFDEF PGP6}  pgpclfile   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgCreateTimeDateControl; external {$IFDEF PGP6}  pgpclfile   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

{$ENDIF}

function PGPcomdlgWrapBuffer  ; external {$IFDEF PGP6}  pgpclfile name 'PGPclWrapBuffer'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgFreeWrapBuffer  ; external {$IFDEF PGP6}  pgpclfile name 'PGPclFreeWrapBuffer'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgCloseLibrary  ; external {$IFDEF PGP6}  pgpclfile name 'PGPclCloseLibrary'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgOpenClientPrefs ; external {$IFDEF PGP6}  pgpclfile name 'PGPclOpenClientPrefs'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgOpenAdminPrefs; external {$IFDEF PGP6}  pgpclfile name 'PGPclOpenAdminPrefs'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgCloseClientPrefs ; external {$IFDEF PGP6}  pgpclfile name 'PGPclCloseClientPrefs'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgCloseAdminPrefs  ; external {$IFDEF PGP6}  pgpclfile name 'PGPclCloseAdminPrefs'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgGetKeyFromKeyID ; external {$IFDEF PGP6}  pgpclfile name ' PGPclGetKeyFromKeyID'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgSyncKeySets; external {$IFDEF PGP6}  pgpclfile name 'PGPclSyncKeySets'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgHelpAbout; external {$IFDEF PGP6}  pgpclfile name 'PGPclHelpAbout'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgNag  ; external {$IFDEF PGP6}  pgpclfile name 'PGPclNag'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgPreferences ; external {$IFDEF PGP6}  pgpclfile name 'PGPclPreferences'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgRandom ; external {$IFDEF PGP6}  pgpclfile name 'PGPclRandom'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgGetPhrase ; external {$IFDEF PGP6}  pgpclfile name 'PGPclGetPhrase'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

procedure PGPcomdlgFreePhrase; external {$IFDEF PGP6}  pgpclfile name 'PGPclFreePhrase'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgErrorToString; external {$IFDEF PGP6}  pgpclfile name 'PGPclErrorToString'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgErrorMessage; external {$IFDEF PGP6}  pgpclfile name 'PGPclErrorBox'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgSplash ; external {$IFDEF PGP6}  pgpclfile name 'PGPclSplash'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgSetSplashParent  ; external {$IFDEF PGP6}  pgpclfile name 'PGPclSetSplashParent'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgWebBrowse  ; external {$IFDEF PGP6}  pgpclfile name 'PGPclWebBrowse'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

procedure PGPcomdlgNotifyKeyringChanges; external {$IFDEF PGP6}  pgpclfile name 'PGPclNotifyKeyringChanges'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgIsExpired; external {$IFDEF PGP6}  pgpclfile name 'PGPclIsExpired'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function   PGPcomdlgEvalExpired; external {$IFDEF PGP6}  pgpclfile name 'PGPclEvalExpired'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgRSADSAMixWarning  ; external {$IFDEF PGP6}  pgpclfile name 'PGPclRSADSAMixWarning'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgUpdateKeySetFromServer ; external {$IFDEF PGP6}  pgpclfile name 'PGPclUpdateKeySetFromServer'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgSearchServerForUserID  ; external {$IFDEF PGP6}  pgpclfile name 'PGPclSearchServerForUserID'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgSearchServerForKeyIDs  ; external {$IFDEF PGP6}  pgpclfile name 'PGPclSearchServerForKeyIDs'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgSendKeysToServer; external {$IFDEF PGP6}  pgpclfile name 'PGPclSendKeysToServer'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgDeleteKeysFromServer  ; external {$IFDEF PGP6}  pgpclfile name 'PGPclDeleteKeysFromServer'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgDisableKeysOnServer ; external {$IFDEF PGP6}  pgpclfile name 'PGPclDisableKeysOnServer'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgGetPGPPath ; external {$IFDEF PGP6}  pgpclfile name 'PGPclGetPGPPath'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgSetUserInfo; external {$IFDEF PGP6}  pgpclfile name 'PGPclSetUserInfo'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgGetSDKFilePaths ; external {$IFDEF PGP6}  pgpclfile name 'PGPclGetSDKFilePaths'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgSetSDKFilePaths; external {$IFDEF PGP6}  pgpclfile name 'PGPclSetSDKFilePaths'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgCheckSDKSupportForPKAlg ; external {$IFDEF PGP6}  pgpclfile name 'PGPclCheckSDKSupportForPKAlg'  {$ELSE} 'PGP55CD.DLL' {$ENDIF};

function PGPcomdlgCheckSDKSupportForCipherAlg; external {$IFDEF PGP6}  pgpclfile name 'PGPclCheckSDKSupportForCipherAlg'   {$ELSE} 'PGP55CD.DLL' {$ENDIF};

end.
