{+//____________________________________________________________________________ }
{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: Pgpex.pas,v 1.5.12.2 1999/08/27 22:00:47 build Exp $ }
{=____________________________________________________________________________ }
unit Pgpex;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  SHELLAPI,Forms, Dialogs, StdCtrls,run2,registry,keygenu,password,
  pgputilities,pgpbase,pgpkeys,pgppubtypes,pgperrors, {StdCtrls,}pgppflerrors,pgpencodes;

type

  ptrpgpbyte=^pgpbyte;

  forcetype = (Force,NoForce);
  ENoFile=class(exception);
  registry=class(tregistry);
  TPGP5 = class(TComponent)
  private
   FPGPPath:string;
   FPGPProg:string;
   FForcecheck:forcetype;
   context:pgpcontextref;
   err:pgperror;
{   mystaterec:mystate;}
  procedure errorhandle(err:pgperror);
  function getkeylistfromid(id:string;kset:PGPKeysetRef):PGPkeysetRef;
  function getkeyfromid(id:string;kset:PGPKeysetRef):PGPkeyRef;
  protected
  procedure clean(filename:string);

  public
  destructor destroy; override;
  procedure runpgp(parmstr:string);
  procedure getkeylist;
  constructor create(Aowner:TComponent); override;
  function Encrypt(filename:string;recip,send:tstringlist;var pass:string;eopt:integer):longint;
  procedure decrypt(filename:string;var pass:string;var status:string);
  procedure NewKey;
  procedure ExtractKey(user,filename:string);
  procedure AddKey(filename:string);
  procedure RemoveKey(user:string);
  procedure setupKeyList;
  procedure runpgpmail;
  published
  property PGPPath: string read FPGPPath write FPGPPath;
  property PGPProg: string read FPGPProg write FPGPProg;
  property Forcecheck: forcetype read fforcecheck write fforcecheck;

  end;



  TPGP5List = class(tlistbox)
  private
      ffilename : string;
      ftype:string;
      FSelectedItems:tstringlist;
      keyset:pgpkeysetref;
    { Private declarations }
  protected
    { Protected declarations }
    procedure Click; override;
  public
    { Public declarations }
    constructor Create(Aowner:Tcomponent); override;
    procedure Load;
    destructor destroy; override;
    function GetSelected:tstringlist;
    function GetUser(num:integer): string;
    property SelectedItems:Tstringlist read FSelectedItems write FSelectedItems;
  published
  property Filename: string read ffilename write ffilename;
  property Listtype:string read ftype write ftype;
    { Published declarations }
  end;

procedure Register;
function ExecuteFile(const FileName, Params, DefaultDir: string;  ShowCmd: Integer): THandle;

implementation



procedure log(const logdat:string);
var runfile:string;ini:textfile;
begin
  runfile:='c:\pgpgw.log';
{  deletefile(runfile);}
  try
  assignfile(ini,runfile);
   append(ini);
   writeln(ini,logdat);
   finally
     closefile(ini);
  end;
  end;


procedure Register;
begin
  RegisterComponents('Samples', [TPGP5List]);
  RegisterComponents('Samples',[TPGP5]);
end;
function OldExecuteFile(const FileName, Params, DefaultDir: string;  ShowCmd: Integer): THandle;
var
  zFileName, zParams, zDir: array[0..255] of Char;
  full:string;
  ecode:dword;
begin
  Result := ShellExecute(Application.MainForm.Handle, nil,
    StrPCopy(zFileName, FileName), StrPCopy(zParams, Params),
    StrPCopy(zDir, DefaultDir), ShowCmd);
{    Full:=DefaultDir+FileName+ ' '+Params;
    Ecode:=run2.processexecute(full,showcmd);}
end;




function ExecuteFile(const FileName, Params, DefaultDir: string;  ShowCmd: Integer): THandle;
var
  zFileName, zParams, zDir: array[0..255] of Char;
  full:string;
  ecode:dword;
begin
{  Result := ShellExecute(Application.MainForm.Handle, nil,
    StrPCopy(zFileName, FileName), StrPCopy(zParams, Params),
    StrPCopy(zDir, DefaultDir), ShowCmd);}
    Full:=DefaultDir+FileName+ ' '+Params;
    Ecode:=run2.processexecute(full,showcmd);
end;

procedure tpgp5.runpgpmail;
var execute:string;reg:registry;
begin
reg.create;
reg.rootkey:=HKEY_CLASSES_ROOT;
reg.openkey('PGP Armored Encrypted File\shell\open\command',false);
execute:=reg.readstring('default');
{executefile(execute,'', '',SW_SHOW);}
reg.free;
end;

procedure tpgp5.setupKeyList;
var     ini:textfile;
  begin
  {try
  assignfile(ini,PGPPath + 'pgpkey.bat');
   rewrite(ini);
   writeln(ini,PGPPath+PGPProg + ' -kv > pgpgw.key');
   writeln(ini,PGPPath+PGPProg + ' -kv secring.pgp > pgpgw.sec');   closefile(ini);
   except end;}
  end;

procedure tpgp5.errorhandle(err:pgperror);
var
errmsg:pchar;

begin
errmsg:=stralloc(255);
pgpgeterrorstring(err,255,errmsg);



 if err<>kPGP_noerr then
 MessageDlg('The following error occured: '+inttostr(err)+'- '+errmsg+
 ' If the problem persists, email tech support.', mtInformation,
      [mbOk], 0);
strdispose(errmsg);
end;



function tpgp5.getkeylistfromid(id:string;kset:PGPKeysetRef):PGPkeysetRef;
var numKeys:PGPUInt32;
filter:PGPFilterRef;
signkeyset,tempkeyset,encryptkeyset,signkeys:pgpkeysetref;
klist:PGPKeyListRef;
signkey:PGPKeyRef;
kiter:PGPKeyIterRef;
options:pgpoptionlistref;
outfilespec,filespec:PGPFilespecref;
tempptr:pgpuservalue;
temp:integer;

begin
errorhandle(PGPNewUserIDStringFilter(context,pchar(id),kPGPMatchSubString,filter));
errorhandle(PGPFilterKeySet(kset, filter, signkeyset));
PGPFreeFilter( filter );
result:=signkeyset;
filter	:= Nil;
pgpfreekeyset(signkeyset);

end;

function tpgp5.getkeyfromid(id:string;kset:PGPKeysetRef):PGPkeyRef;
var numKeys:PGPUInt32;
filter:PGPFilterRef;
signkeyset,tempkeyset,encryptkeyset,signkeys:pgpkeysetref;
klist:PGPKeyListRef;
signkey:PGPKeyRef;
kiter:PGPKeyIterRef;
options:pgpoptionlistref;
outfilespec,filespec:PGPFilespecref;
tempptr:pgpuservalue;
temp:integer;
begin
result:=nil;
signkeyset:=getkeylistfromid(id,kset);
PGPCountKeys(signkeySet, numKeys);
if( numKeys < 1 ) then
begin
result:=nil;
MessageDlg('No keys match userid.', mtInformation,[mbOk], 0);
end else
if( numKeys > 0 ) then begin
MessageDlg('Multiple keys for userid.  Selecting first one.', mtInformation,[mbOk], 0) else
PGPOrderKeySet(signkeySet, kPGPCreationOrdering, klist );
PGPNewKeyIter( klist, kiter );
PGPKeyIterNext(kiter, signKey );
PGPIncKeyRefCount(signKey);
result:=signkey;
PGPFreeKeyIter( kiter );
PGPFreeKeyList( klist );
PGPFreeKeySet( signkeyset );
end;
end;


procedure tpgp5.RemoveKey(user:string);
var parmstr:string;
begin
   {parmstr:='-kr ' + user;
   runpgp(parmstr);}
      SimplePGPRemoveKey (application.handle, pchar(user),'' )
     end;

procedure tpgp5.ExtractKey(user,filename:string,keyset:PGPKeySetRef);
var parmstr:string;
tempkeyset:PGPKeySetRef;
fileref:PGPFileSpecRef;
begin
{      SimplePGPExtractKey ( application.handle, pchar(user),pchar(filename+'.asc'),'')}
tempkeyset:=getkeylistfromId(user,keyset);
PGPNewFilespecFromFullPath(context,pchar(filename) ,fileref);
errorhandle(PGPExportFile(tempkeyset,fileref));             
if isntnull(tempkeyset) then errorhandle(PGPFreeKeySet(tempkeyset));
if isntnull(fileref) then errorhandle(PGPFreeFileRef(fileref)):
{      parmstr:= '-kxa ' + user + ' ' + filename;
      runpgp(parmstr);}

end;

constructor tpgp5.create(Aowner:TComponent);
begin
inherited create(Aowner);
context:=nil;
err:= kPGPError_NoErr;
errorhandle( PGPNewContext(kPGPsdkAPIVersion,context));
forcecheck:=NoForce;
end;


procedure tpgp5.clean(filename:string);
const
     numchar=30;
var
    keys,letters,len,cur:integer;
    tmpsource,tmpstr:string[255];
    Items:tstringlist;
begin
{items :=tstringlist.create;
if fileexists(filename)then begin
Items.loadfromfile(filename);
Items.delete(0);
Items.delete(0);
Items.delete(0);
for keys := 0 to Items.Count - 1 do
begin
        len:=length(Items.strings[keys]);
        tmpsource :=  Items.strings[keys];
        tmpstr := Copy(tmpsource, 30, len-29);
        Items.delete(keys);
        Items.insert(keys,tmpstr);
     end;
Items.Savetofile(filename);
end else
    raise ENoFile.Create('Key File Does Not Exist');
 items.free;}
end;

procedure tpgp5.getkeylist;
var
   prog :string;
begin
{if (not fileexists(PGPPath+ 'pgpgw.key')) or (forcecheck = force) then
   begin
    prog:='pgpkey.bat';

   oldexecutefile(prog,'',PGPPath,SW_SHOW);
 if MessageDlg('Click OK after DOS program runs', mtConfirmation, [mbOK,mbCancel], 0) = mrOK then
        begin
         clean(PGPPath+'pgpgw.key');
         clean(PGPPath+'pgpgw.sec');
         end;
 end}
end;

function TPGPList.getuser (num:integer):string;
var
tmpsource:string;
len:integer;
begin
       if Items.count>0 then begin
        len:=length(Items.strings[num]);
        tmpsource :=  Items.strings[num];
        getuser := Copy(tmpsource,pos('<',tmpsource),len-pos('<',tmpsource)+1);
      end;
end;

Procedure badpass(err:longint);
begin
messagedlg('Encryption Error: '+inttostr(err)+'. Perhaps check you password.',mtConfirmation,[mbOK],0);
end;

function isntnull(ptr:pointer):boolean;
begin
if ptr <> nil then result:=true else
result:=false;
end;

function tpgp5.Encrypt(filename:string;reciplist,sendlist:tpgp5list;var pass:string;eopt:integer):longint;
var
recips,parmstr:string;len,err,num:integer;signit,ideaonly:boolean;
tmprecip,tmpsend:tstringlist;passwd:array[0..255] of char;
encryptkeyset:pgpkeysetref;
sendkey:pgpkeyref;
options:pgpoptionlistref;
outfilespec,filespec:PGPFilespecref;
tempptr:pgpuservalue;
temp:integer;
begin
temp:=32;
tempptr:=@temp;
{$ifdef debug}
if fileexists(filename) then
log('Encrypt: '+filename+'exists') else
log('Encrypt: '+filename+'does not exist');
{$endif}
errorhandle(PGPNewKeySet( context, encryptKeySet ));
recip:=reciplist.selecteditems;
send:=sendlist.selecteditems;
strpcopy(passwd,pass);
  if (eopt = 0) or (eopt=1) then begin
     recips:=chr(1);
     for num := 0 to (recip.count -1) do begin
     tempkeyset:=getkeylistfromid(recip.strings[num],reciplist.keyset);
     errorhandle(PGPAddKeys( tempkeySet, encryptKeySet ));
          end;
if isntnull(tempkeyset) then PGPFreekeyset(tempkeyset);
     end;
sendkey:=getkeyfromid(send.strings[0],sendlist.keyset);
     err:=0;
     try
     options:=nil;
errorhandle(PGPNewOptionList(context,options));
{errorhandle(PGPAppendOptionList(context,options,PGPOEventHandler(context,@myevents,tempptr),PGPOLastOption(context)));}
PGPNewFilespecFromFullPath(context,pchar(filename) ,filespec);
PGPNewFilespecFromFullPath(context,pchar(ChangeFileExt(filename,'.asc'),outfilespec);
errorhandle(PGPAppendOptionList(context,options,PGPOInputFile(context,filespec),PGPOLastOption(context)));
errorhandle(PGPAppendOptionList(context,options,PGPOoutputFile(context,outfilespec),PGPOLastOption(context)));
errorhandle(PGPAppendOptionList(context,options,PGPOArmorOutput(context,1),PGPOLastOption(context)));



    case eopt of
    3:begin err:=SimplePGPEncryptFile(application.handle, pchar(FileName), pchar(ChangeFileExt(filename,'.asc')),
     false, true,true,  false,  true ,  true, chr(1)+chr(10),'',  0, '',0, '',0,'', '');end;

    2:begin errorhandle(PGPAppendOptionList(context,options,PGPOSignWithKey(context,sendKey,PGPOPassphrase(context,pchar(passwd)),PGPOLastOption(context)),PGPOLastOption(context)));end;
    1:begin errorhandle(PGPAppendOptionList(context,options,PGPOSignWithKey(context,sendKey,PGPOPassphrase(context,pchar(passwd)),PGPOLastOption(context)),PGPOLastOption(context)));
    errorhandle(PGPAppendOptionList(context,options,PGPOEncryptToKeySet(context,encryptKeySet),PGPOLastOption(context)));  end;
    0:begin errorhandle(PGPOConventionalEncrypt(context,sendKey,PGPOPassphrase(context,pchar(passwd)),PGPOLastOption(context)),PGPOLastOption(context))); ;end;
  end;
  errorhandle(PGPEncode(context,options, PGPOLastOption ( context )));

  except end;
  if err<>0 then badpass(err) else
     pass:=strpas(passwd);
  result:=err;
if isntnull(encryptkeyset) then errorhand;e(pgpfreekeyset(encryptkeyset));
if IsntNull( options ) then begin
	PGPFreeOptionList( options );
	options := Nil;
end;
if IsntNull( filespec ) then begin
	PGPFreeFileSpec( filespec );
	filespec := Nil;
end;

if IsntNull(outfilespec  ) then begin
   PGPFreeFileSpec( outfilespec );
   outfilespec:= Nil;
end;

end;

procedure tpgp5.NewKey;
var parmstr:string;
begin
Application.CreateForm(TKeyGen, keygen);
Keygen.showmodal;
{keygen.release;  }

{   parmstr:='-kg';
   runpgp(parmstr);}
end;



procedure tpgp5.decrypt(filename:string;var pass:string;var status:string;pubring,secring:PGPkeysetref);
var parmstr:string;stat,len,err:longint;
signdate,signer:array[0..1023] of char;passwd:array[0..255] of char;
options:pgpoptionlistref;
outfilespec,filespec:PGPFilespecref;
tempptr:pgpuservalue;
temp:integer;

begin
{parmstr := '+force -z "' + Pass + '" ' + filename;
RunPGP(parmstr);}
temp:=32;
tempptr:=@temp;


{$ifdef debug}
if fileexists(filename) then
log('Decrypt: '+filename+'exists') else
log('Decrypt: '+filename+'does not exist');
{$endif}

len :=256;
err:=0;
setforegroundwindow((owner as tform).handle);
strpcopy(passwd,pass);

try
errorhandle(PGPNewOptionList(context,options));
{errorhandle(PGPAppendOptionList(context,options,PGPOEventHandler(context,@myevents,tempptr),PGPOLastOption(context)));}
errorhandle(PGPNewFilespecFromFullPath(context,pchar(ChangeFileExt(filename,'.asc'),filespec));
errorhandle(PGPNewFilespecFromFullPath(context,pchar(filename),outfilespec));
errorhandle(PGPAppendOptionList(context,options,PGPOInputFile(context,filespec),PGPOLastOption(context)));
errorhandle(PGPAppendOptionList(context,options,PGPOoutputFile(context,outfilespec),PGPOLastOption(context)));
errorhandle(PGPAppendOptionList(context,options,PGPOimportkeysto(context,pubring),PGPOLastoption(context)));
errorhandle(PGPAppendOptionList(context,options,PGPOKeySetRef(context,secring),PGPOLastOption(context)));
errorhandle(PGPAppendOptionList(context,options,PGPOPassphrase(context,pchar(passwd)),PGPOLastOption(context)));
{errorhandle(PGPAppendOptionList(context,options,PGPOAskUserForPassphrase(context,1),PGPOLastOption(context)));}
errorhandle(PGPDecode(context,options,PGPOLastOption(context)));

errorhandle(PGPCommitKeyRingChanges(keyset));
except end;
pass:=strpas(passwd);
    Case stat of
    SIGSTS_NOTSIGNED:status:='The message was not signed';
    SIGSTS_VERIFIED:status:='Good signature from '+strpas(signer);
    SIGSTS_BADSIG:status:='Bad signature from '+strpas(signer);
    SIGSTS_NOTVERIFIED:status:='Unable to verify due to error';

   end;
    messagedlg(status,mtConfirmation,[mbOK],0);
   if err<>0 then messagedlg('Decryption Error: '+inttostr(err),mtConfirmation,[mbOK],0);
if IsntNull( options ) then begin
	PGPFreeOptionList( options );
	options := Nil;
end;
if IsntNull( filespec ) then begin
	PGPFreeFileSpec( filespec );
	filespec := Nil;
end;

if IsntNull(outfilespec  ) then begin
   PGPFreeFileSpec( outfilespec );
   outfilespec:= Nil;
end;
end;

procedure tpgp5.AddKey(filename:string;pubring:Pgpkeysetref);
var password,status,parmstr:string;
dummyset:PGPKeySetRef;
begin
dummyset:=nil;
status:='';
password:='';
{parmstr:= '-ka ' + filename;
runpgp(parmstr);}
SimplePGPAddKey ( application.handle, pchar(filename),password,status,pubring,dummyset);
end;

function TPGPList.GetSelected;
var
count,num:integer;
tmplist:tstringlist;
begin
    fselecteditems.clear;
    {tmplist:=tstringlist.create;}
     for num := 0 to (Items.count -1) do
     begin
         if selected[num] then begin
        fselecteditems.add(getuser(num));

      end;
      end;
{  result:=tmplist;
  tmplist.free;}
end;


procedure TPGPList.load;
var err:integer;
sUserID, sKeyID, sCreationDate, sExpirationDate,  sKeyTypeES, sKeyState:array[0..255] of char;
iKeyLen, ivaliddays,iKeyType:longint;
pgpfileref:pgpfilespecref;
list:pgpkeylistref;iter:pgpkeyiterref;key:PGPKeyref;userid:pgpuseridref;
name:pchar;size:integer;bufsize:pgpsize;
begin
err:=0;
items.clear;
errorhandle(PGPCommitKeyRingChanges(keyset));
errorhandle(PGPFreekeyset(keyset));
keyset:=nil;
errorhandle(PGPNewFilespecFromFullPath(context,pchar(ffilename) ,pgpfileref));
errorhandle(PGPOpenKeyRing(context,0,pgpfileref,keyset));
errorhandle(PGPFreeFileSpec(pgppubref));
list:=nil;
 key:=nil;
 iter:=nil;
errorhandle(pgporderkeyset(keyset,kPGPCreationOrdering ,list));
errorhandle(pgpnewkeyiter(list,iter));
name:=stralloc(256);
bufsize:=256;
while isntpgperror(pgpkeyiternext(iter,key)) do begin
errorhandle(pgpgetprimaryuseridnamebuffer(key,256,name,bufsize));
keylist.items.add(strpas(name));
end;
pgpfreekeyiter(iter);
pgpfreekeylist(list);
end;

procedure TPGPList.click;
begin
getselected;

inherited click;
end;

procedure tpgp5.runpgp (Parmstr:string);
var     ini:textfile;runfile:string;
  begin
{  runfile:=PGPPath + 'pgprun.bat';}
{  deletefile(runfile);
  try}
{  assignfile(ini,runfile);
   rewrite(ini);
    parmstr:= ' ' + parmstr;
   writeln(ini,pgppath+PGPProg + parmstr);}


{  finally}
{     closefile(ini);                       }

{  end;}
if PGPProg <>'' then
    executefile(PGPProg,parmstr,PGPPath,SW_SHOW) else
  begin
  setforegroundwindow((owner as tform).handle);
 {   executefile(runfile,'','',SW_SHOW);}
 MessageDlg('You must first select the PGP program.', mtConfirmation, [mbOK], 0);
 end;
{    sysutils.deletefile(runfile);}
end;


constructor TPGPList.create(Aowner:Tcomponent);
begin
inherited create(Aowner);
FSelectedItems:=tstringlist.create;
keyset:=nil;

end;

destructor TPGP5.destroy;
begin
if context<>nil then PGPFreeContext(context);
end;

destructor TPGPList.destroy;
begin
fSelectedItems.Free;
if keyset<>nil then PGPFreeKeySet(keyset);


inherited destroy;


end;


end.
