{+//____________________________________________________________________________ }
{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: Pgpfeatures.pas,v 1.5.12.2 1999/08/27 22:00:47 build Exp $ }
{=____________________________________________________________________________ }
unit PGPFEATURES;


interface
     PGPFEATURESELECTOR=pgpint32;

     PGPAlgorithmInfo = record
     SHORTNAME:array[0..31] of char;
     LONGNAME:array[0..95] of char;
     COPYRIGHT:array[0..127] of char;
     flags: PGPFLAGS; {= reserved; 0 for now }
     reserved:array[0..15] of PGPUINT32;{= reserved; 0 for now }
 end ;



PGPPublicKeyAlgorithmInfo = record
        info: PGPALGORITHMINFO;
        algID: PGPPUBLICKEYALGORITHM;
        canEncrypt: PGPBOOLEAN;
        {$IFDEF PGP6}
        canDecrypt:PGPBoolean;
        {$ENDIF}
         canSign: PGPBOOLEAN;
         {$IFDEF PGP6}
        canVerify:PGPBoolean;
                canGenerate:PGPBoolean;
        {$ENDIF}

         reserved1: PGPBOOLEAN;
         reserved2: PGPBOOLEAN;
         {$IFDEF PGP6}
         reserved3: PGPBOOLEAN;
         {$ENDIF}
  RESERVED:array[0..7] of PGPUINT32;
end; {PGPPublicKeyAlgorithmInfo};



PGPSymmetricCipherInfo = record
    info: PGPALGORITHMINFO;
    algID: PGPCIPHERALGORITHM;
    RESERVED[0..7] of PGPUINT32;
  end; {PGPSymmetricCipherInfo};



{+//____________________________________________________________________________ }
{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-Determine which features are present in the PGPsdk. This is the only }
{-way to correctly determine which features are present. The version }
{-number may be the same for different builds that lack some features. }

{-$Id: Pgpfeatures.pas,v 1.5.12.2 1999/08/27 22:00:47 build Exp $ }
{=____________________________________________________________________________ }
{$IFNDEF Included_pgpFeatures_h}
{$DEFINE Included_pgpFeatures_h}


{+//____________________________________________________________________________ }
{-Each selector designates a PGPFlags word, which can be obtained via }
{-PGPGetFeatureFlags(). The flags can be tested using the }
{-supplied masks. We can add more selectors as needed. The masks }
{-are not intended to be restricted to a single bit. }
{-Flags should not be used for attributes that have unknown length. }

{-A kPGPError_ItemNotFound will be returned if the caller specifies }
{-a selector which is not recognized by the PGPsdk. This could }
{-occur if an app links to an older version of the SDK. }
{=____________________________________________________________________________ }

{+// selectors which are passed to PGPGetFeatureFlags */ }
const
kPGPFeatures_GeneralSelector= 1;
kPGPFeatures_ImplementationSelector= 2;




{+// flags for kPGPFeatures_GeneralSelector */ }
kPGPFeatureMask_CanEncrypt = $1;
kPGPFeatureMask_CanDecrypt = $2;
kPGPFeatureMask_CanSign = $4;
kPGPFeatureMask_CanVerify = $8 ;
{$IFDEF PGP6}
kPGPFeatureMask_CanGenerate	= $10;
{$ELSE}
{$ENDIF}



{+// flags for kPGPFeatures_ImplementationSelector */ }
kPGPFeatureMask_IsDebugBuild = $1;
kPGPFeatureMask_HasTimeout =$2;




{+// see kPGPsdkAPIVersion in pgpUtilities.h for version format */ }

function PGPGetSDKVersion(var version: PPGPUINT32): PGPERROR; stdcall; far;


{+//____________________________________________________________________________ }
{-Return a C string of the form: }

{-"PGPsdk version 1.0 (C) 1997 Pretty Good Privacy, Inc" }
{=____________________________________________________________________________ }

function PGPGetSDKString(THESTRING:array[0..255] of char): PGPERROR; stdcall; far;



{+// return a flags word for the feature selector */ }

function PGPGetFeatureFlags(selector: PGPFEATURESELECTOR;
                            flags: PPGPFLAGS): PGPERROR; stdcall; far;

{+// use this to test whether a feature exists after getting flags */ }
function PGPFeatureExists(flags:pgpflags; maskValue:pgpflags ):boolean;



{+//____________________________________________________________________________ }
{-Routines to determine which algorithms are present. }

{-To determine if a specific algorithm is available, you will need to }
{-index through the available algorithms and check the algorithm ID. }
{=____________________________________________________________________________ }

function PGPCountPublicKeyAlgorithms(numPKAlgs: PPGPUINT32): PGPERROR; stdcall; far;

function PGPGetIndexedPublicKeyAlgorithmInfo(index: PGPUINT32;
                                             info: PPGPPUBLICKEYALGORITHMINFO): PGPERROR; stdcall; far;


function PGPCountSymmetricCiphers(numPKAlgs: PPGPUINT32): PGPERROR; stdcall; far;

function PGPGetIndexedSymmetricCipherInfo(index: PGPUINT32;
                                          info: PPGPSYMMETRICCIPHERINFO): PGPERROR; stdcall; far;




{$ENDIF}


implementation
{$IFNDEF Included_pgpFeatures_h /* [ */}
{$DEFINE Included_pgpFeatures_h}
function PGPGetSDKVersion(var version: PPGPUINT32): PGPERROR; stdcall; far;


function PGPGetSDKString(THESTRING:array[0..255] of char): PGPERROR; stdcall; far;

function PGPGetFeatureFlags(selector: PGPFEATURESELECTOR;
                            flags: PPGPFLAGS): PGPERROR; stdcall; far;

function PGPFeatureExists(flags:pgpflags; maskValue:pgpflags ):boolean;


function PGPCountPublicKeyAlgorithms(numPKAlgs: PPGPUINT32): PGPERROR; stdcall; far;

function PGPGetIndexedPublicKeyAlgorithmInfo(index: PGPUINT32;
                                             info: PPGPPUBLICKEYALGORITHMINFO): PGPERROR; stdcall; far;


function PGPCountSymmetricCiphers(numPKAlgs: PPGPUINT32): PGPERROR; stdcall; far;

function PGPGetIndexedSymmetricCipherInfo(index: PGPUINT32;



function PGPFeatureExists( flags:pgpflags; maskValue:pgpflags ):boolean;
   begin
   result:=( ( (flags) & (maskValue) ) <> 0 );

   end;

{$ENDIF}
end.
