unit PGPHASH;

interface
Uses WinTypes,
     WinProcs,
     pgpPubTypes,
     pgpBase;

Type
     PGPHashAlgorithm=PGPInt32;

{+//____________________________________________________________________________ }
{-pgpHash.h }

{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }



{-$Id: Pgphash.pas,v 1.5.12.2 1999/08/27 22:00:47 build Exp $ }
{=____________________________________________________________________________ }



{+//____________________________________________________________________________ }
{-Create a new hash of the specified algorithm. }

{-If the algorithm is not available then kPGPError_AlgorithmNotAvailable is }
{-returned. }
{=____________________________________________________________________________ }

function PGPNewHash({$IFDEF PGP6}
                            memorymgr:pointer;
                    {$ELSE}
                    context: PGPCONTEXTREF;
                    {$ENDIF}

                    algorithm: PGPHASHALGORITHM;
                    var outRef: PGPHASHCONTEXTREF): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-Any existing intermediate hash is lost. }
{=____________________________________________________________________________ }

function PGPFreeHash(ref: PGPHASHCONTEXTREF): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-An exact duplicate of the hash is made. }
{=____________________________________________________________________________ }

function PGPCopyHash(ref: PGPCONSTHASHCONTEXTREF; 
                     var outRef: PGPHASHCONTEXTREF): PGPERROR; cdecl;



{+//____________________________________________________________________________ }
{-Reset a hash as if it had been created anew. Any existing intermediate }
{-hash is lost. }
{=____________________________________________________________________________ }

function PGPResetHash(ref: PGPHASHCONTEXTREF): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-Continue the hash, accumulating an intermediate result }
{=____________________________________________________________________________ }

function PGPContinueHash(ref: PGPHASHCONTEXTREF;
                         var inv: PGPBYTE;
                         numBytes: PGPUINT32): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-Finalize the hash, depositing the result into 'hashOut'. }

{-After calling this routine, the hash is reset via PGPResetHash(). }
{-If you want an intermediate result, use PGPCopyHash() and finalize the }
{-copy. }
{=____________________________________________________________________________ }

function PGPFinalizeHash(ref: PGPHASHCONTEXTREF;
                         var hashOut: PGPBYTE): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-Determine size of resulting hash in bytes e.g. a 160 bit hash yields 20. }
{-Used for generic code which may not know how big a hash is being produced. }

{-Question: can we reasonably assume 8 bits per byte? If not, how does }
{-PGPFinalizeHash return its result? }
{=____________________________________________________________________________ }

function PGPGetHashSize(ref: PGPCONSTHASHCONTEXTREF;
                        var hashSize: PGPUINT32): PGPERROR; cdecl;




implementation


function PGPNewHash; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeHash; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCopyHash; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPResetHash; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPContinueHash; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFinalizeHash; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetHashSize; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

end.
