unit PGPKEYS;

interface
Uses WinTypes,
     WinProcs,
     pgpPubTypes,
     pgpHash,
     pgpEncodes,
     pgpbase;

     const
     kPGPMaxKeyIDStringSize=128;

Type
pgpidstringarray=array[0..kpgpmaxkeyidstringsize-1] of char;
    PGPAttributetype=pgpint32;
     PGPKeyOrdering=pgpint32;
     PGPKeyPropName=pgpint32;
     PGPUserIDPropName=pgpint32;
     PGPSigPropName=pgpint32;
     {$IFDEF PGP6}
     PGPKeyRingOpenFlags=pgpflags;
     {$ELSE}
     PGPKeyRingOpenFlags=pgpuint32;
     {$ENDIF}

     PGPMatchCriterion=pgpuint32;
     PGPKeyIDStringType=pgpint32;
{+//____________________________________________________________________________ }
{-pgpKeys.h }

{-Copyright(C) 1996,1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-Public definitions for PGP KeyDB Library }

{-$Id: Pgpkeys.pas,v 1.7.12.2 1999/08/27 22:00:48 build Exp $ }
{=____________________________________________________________________________ }




const
{$IFDEF PGP6}
// Secret sharing header size
kPGPShareHeaderSize=	4;
{$ELSE}
{$ENDIF}



{+// Key ordering }
kPGPMaxExportedKeyIDSize=( sizeof( PGPKeyID ) );
{$IFDEF PGP6}
kPGPinvalidkeyordering=0;
{$ELSE}
{$ENDIF}

kPGPAnyOrdering = 1;
kPGPUserIDOrdering=2;
kPGPReverseUserIDOrdering=3;
kPGPKeyIDOrdering=4;
kPGPReverseKeyIDOrdering=5;
kPGPValidityOrdering=6;
kPGPReverseValidityOrdering=7;
kPGPTrustOrdering=8;
kPGPReverseTrustOrdering=9;
kPGPEncryptKeySizeOrdering=10;
kPGPReverseEncryptKeySizeOrdering=11;
kPGPSigKeySizeOrdering=12;
kPGPReverseSigKeySizeOrdering=13;
kPGPCreationOrdering=14;
kPGPReverseCreationOrdering=15;
kPGPExpirationOrdering=16;
kPGPReverseExpirationOrdering=17;




{+// Key properties }

{$IFDEF PGP6}
kPGPKeyPropFingerprint=1;
kPGPKeyPropPreferredAlgorithms=2;

kPGPKeyPropThirdPartyRevocationKeyID= 3;

{$ELSE}
kPGPKeyPropUNUSED_1 = 10;	{ feel free to use this }
kPGPKeyPropFingerprint=11;
kPGPKeyPropPreferredAlgorithms=12;
{$ENDIF}


        { Number properties }
	kPGPKeyPropAlgID = 20;
	kPGPKeyPropBits=21;
	kPGPKeyPropTrust=22;			{ old trust model only }
	kPGPKeyPropValidity=23;    { both trust models }
{$IFDEF PGP6}
kPGPKeyPropLockingAlgID				= 24;
kPGPKeyPropLockingBits				= 25;

{$ELSE}
{$ENDIF}
	{ Time properties }
{$IFDEF PGP6}
	kPGPKeyPropCreation 				= 40;
	kPGPKeyPropExpiration				= 41;

{$ELSE}
	kPGPKeyPropCreation = 30;
	kPGPKeyPropExpiration=31;

{$ENDIF}
	{ PGPBoolean properties }
        {$IFDEF PGP6}
       	kPGPKeyPropIsSecret 				= 60;
	kPGPKeyPropIsAxiomatic				= 61;
	kPGPKeyPropIsRevoked				= 62;
	kPGPKeyPropIsDisabled				= 63;
	kPGPKeyPropIsNotCorrupt				= 64;
	kPGPKeyPropIsExpired				= 65;
	kPGPKeyPropNeedsPassphrase			= 66;
	kPGPKeyPropHasUnverifiedRevocation	= 67;
	kPGPKeyPropCanEncrypt				= 68;
	kPGPKeyPropCanDecrypt				= 69;
	kPGPKeyPropCanSign					= 70;
	kPGPKeyPropCanVerify				= 71;
	kPGPKeyPropIsEncryptionKey			= 72;
	kPGPKeyPropIsSigningKey				= 73;
	kPGPKeyPropIsSecretShared			= 74;
	kPGPKeyPropIsRevocable				= 75;
	kPGPKeyPropHasThirdPartyRevocation	= 76;

        {$ELSE}
        	kPGPKeyPropIsSecret = 40;
	kPGPKeyPropIsAxiomatic=41;
	kPGPKeyPropIsRevoked=42;
	kPGPKeyPropIsDisabled=43;
	kPGPKeyPropIsNotCorrupt=44;
	kPGPKeyPropIsExpired=45;
	kPGPKeyPropNeedsPassphrase=46;
	kPGPKeyPropCanSign=47;
	kPGPKeyPropCanEncrypt=48;
	kPGPKeyPropHasUnverifiedRevocation=49;

        {$ENDIF}
{+// User ID properties }
	{ String properties }
        {$IFDEF PGP6}
        	kPGPUserIDPropName 					= 80;
	kPGPUserIDPropAttributeData			= 81;

        {$ELSE}
        	kPGPUserIDPropName = 50;
        {$ENDIF}

	{ Number properties }
        {$IFDEF PGP6}
        	kPGPUserIDPropValidity 				= 100;
	kPGPUserIDPropConfidence			= 101;
	kPGPUserIDPropAttributeType			= 102;

        {$ELSE}
kPGPUserIDPropValidity = 60;{ both trust models }
kPGPUserIDPropConfidence=61;	{ new trust model only }

        {$ENDIF}
	{ Time properties }
	{ PGPBoolean properties }
{$IFDEF PGP6}
	kPGPUserIDPropIsAttribute			= 110;
{$ELSE}
{$ENDIF}

{+// Signature properties }
	{ String properties }
        {$IFDEF PGP6}
        	kPGPSigPropKeyID = 120;

        {$ELSE}
        	kPGPSigPropKeyID = 90;
        {$ENDIF}

	{ Number properties }
        {$IFDEF PGP6}
        kPGPSigPropAlgID 					= 140;
	kPGPSigPropTrustLevel				= 141;
	kPGPSigPropTrustValue				= 142;

        {$ELSE}
        	kPGPSigPropAlgID = 100;
	kPGPSigPropTrustLevel=101;
	kPGPSigPropTrustValue=102;

        {$ENDIF}
	{ Time properties }
        {$IFDEF PGP6}
        kPGPSigPropCreation 				= 160;
	kPGPSigPropExpiration				= 161;

        {$ELSE}
        kPGPSigPropCreation = 110;
	kPGPSigPropExpiration=111;
        {$ENDIF}

	{ PGPBoolean properties }
        {$IFDEF PGP6}
        kPGPSigPropIsRevoked 				= 180;
	kPGPSigPropIsNotCorrupt				= 181;
	kPGPSigPropIsTried					= 182;
	kPGPSigPropIsVerified				= 183;
	kPGPSigPropIsMySig					= 184;
	kPGPSigPropIsExportable				= 185;
	kPGPSigPropHasUnverifiedRevocation	= 186;
	kPGPSigPropIsExpired				= 187;

        {$ELSE}
        	kPGPSigPropIsRevoked = 120;
	kPGPSigPropIsNotCorrupt=121;
	kPGPSigPropIsTried=122;
	kPGPSigPropIsVerified=123;
	kPGPSigPropIsMySig=124;
	kPGPSigPropIsExportable=125;
	kPGPSigPropHasUnverifiedRevocation=126;

        {$ENDIF}
{-* Note on kPGPSigPropIsMySig. This is a convenience property for }
{-* determining whether the certification was made by one of the }
{-* caller's own private keys. This can only return true if the }
{-* signing key is in the same base keyset as the certification. If the }
{-* signing key is( suspected to be) in a different base keyset; call }
{-* PGPGetSigCertifierKey( certset; signerset; &key) followed by }
{-* PGPGetKeyBoolean( key; kPGPKeyPropIsSecret; &secret). }
{= }



{+// }
{$IFDEF PGP6}
// Attribute types, for use with kPGPUserIDPropAttributeType
	kPGPAttribute_Image						= 1;
	kPGPAttribute_Notation					= 20;

{$ELSE}
{$ENDIF}



{-* Used by filtering functions to specify type of match. }
{= }
kPGPMatchDefault = 1;
	kPGPMatchEqual = 1;			 { searched val == supplied val }
	kPGPMatchGreaterOrEqual = 2; { searched val >= supplied val }
	kPGPMatchLessOrEqual = 3; { searched val <= supplied val }
	kPGPMatchSubString = 4;	 { searched val is contained in supplied val }

        
{+// This is the value of the expiration time which means "never expires" }
kPGPExpirationTime_Never :PGPTime=0;


{+// Public entry points }


kPGPKeyRingOpenFlags_Reserved=1;
kPGPKeyRingOpenFlags_Mutable=2;
kPGPKeyRingOpenFlags_Create=4;

	{ The following flags are only used by PGPOpenKeyRing }
kPGPKeyRingOpenFlags_Private=128;
kPGPKeyRingOpenFlags_Trusted=256;

kPGPKeyIDString_Abbreviated = 2;
kPGPKeyIDString_Full = 3;

{+// Functions for setting up key filters. }


function PGPIncFilterRefCount(filter: PGPFILTERREF): PGPERROR; cdecl;


function PGPFreeFilter(filter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewKeyIDFilter(context: PGPCONTEXTREF;
                           keyID: PGPCONSTKEYIDREF;
                           var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewKeyEncryptAlgorithmFilter(context: PGPCONTEXTREF;
                                         encryptAlgorithm: PGPPUBLICKEYALGORITHM;
                                         var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewKeyFingerPrintFilter(context: PGPCONTEXTREF;
                                    var fingerPrint: PGPBYTE;
                                    fingerPrintLength: PGPSIZE;
                                    var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewKeyCreationTimeFilter(context: PGPCONTEXTREF;
                                     creationTime: PGPTIME;
                                     match: PGPMATCHCRITERION;
                                     var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewKeyExpirationTimeFilter(context: PGPCONTEXTREF;
                                       expirationTime: PGPTIME;
                                       match: PGPMATCHCRITERION;
                                       var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewKeyRevokedFilter(context: PGPCONTEXTREF;
                                revoked: PGPBOOLEAN;
                                var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewKeyDisabledFilter(context: PGPCONTEXTREF;
                                 disabled: PGPBOOLEAN;
                                 var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewKeySigAlgorithmFilter(context: PGPCONTEXTREF;
                                     sigAlgorithm: PGPPUBLICKEYALGORITHM;
                                     var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewKeyEncryptKeySizeFilter(context: PGPCONTEXTREF;
                                       keySize: PGPUINT32;
                                       match: PGPMATCHCRITERION;
                                       var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewKeySigKeySizeFilter(context: PGPCONTEXTREF;
                                   keySize: PGPUINT32;
                                   match: PGPMATCHCRITERION;
                                   var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewKeyVersionFilter(context: PGPCONTEXTREF;
                                version: PGPBYTE;
                                match: PGPMATCHCRITERION;
                                var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewUserIDStringFilter(context: PGPCONTEXTREF;
                                  const userIDString: PChar;
                                  match: PGPMATCHCRITERION;
                                  var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewUserIDEmailFilter(context: PGPCONTEXTREF;
                                 Const emailString: PChar;
                                 match: PGPMATCHCRITERION;
                                 var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewUserIDNameFilter(context: PGPCONTEXTREF;
                                Const nameString: PChar;
                                match: PGPMATCHCRITERION;
                                var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewUserIDVersionFilter(context: PGPCONTEXTREF;
                                   version: PGPBYTE;
                                   match: PGPMATCHCRITERION;
                                   var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewSigHashAlgorithmFilter(context: PGPCONTEXTREF;
                                      hashAlgorithm: PGPHASHALGORITHM;
                                      var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewSigKeyAlgorithmFilter(context: PGPCONTEXTREF;
                                     sigAlgorithm: PGPPUBLICKEYALGORITHM;
                                     var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewSigClassificationFilter(context: PGPCONTEXTREF; 
                                       sigClassification: PGPBYTE; 
                                       var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewSigCreationTimeFilter(context: PGPCONTEXTREF;
                                     creationTime: PGPTIME;
                                     match: PGPMATCHCRITERION;
                                     var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewSigKeyIDFilter(context: PGPCONTEXTREF;
                              keyID: PGPKEYIDREF;
                              var outFilter: PGPFILTERREF): PGPERROR; cdecl;


function PGPNewSigVersionFilter(context: PGPCONTEXTREF;
                                version: PGPBYTE;
                                match: PGPMATCHCRITERION;
                                var outFilter: PGPFILTERREF): PGPERROR; cdecl;


{+// freeing outfilter will call PGPFreeFilter on filter }

function PGPNegateFilter(filter: PGPFILTERREF;
                         var outFilter: PGPFILTERREF): PGPERROR; cdecl;

{+// freeing outfilter will call PGPFreeFilter on filter1; filter2 }

function PGPIntersectFilters(filter1: PGPFILTERREF;
                             filter2: PGPFILTERREF;
                             var outFilter: PGPFILTERREF): PGPERROR; cdecl;

{+// freeing outfilter will call PGPFreeFilter on filter1; filter2 }

function PGPUnionFilters(filter1: PGPFILTERREF;
                         filter2: PGPFILTERREF;
                         var outFilter: PGPFILTERREF): PGPERROR; cdecl;



function PGPFilterKeySet(origSet: PGPKEYSETREF;
                         filter: PGPFILTERREF;
                         var resultSet: PGPKEYSETREF): PGPERROR; cdecl;


{$IFDEF PGP6}

function PGPGetRevocationKeySet(basekey: PGPKEYREF;
                                allkeys: PGPKEYSETREF;
                                var pRevocationSet: PGPKEYSETREF): PGPERROR; cdecl; far;


function PGPCountAdditionalRecipientRequests(basekey: PGPKEYREF;
                                            var numARKeys: PGPUINT32): PGPERROR; cdecl; far;


function PGPGetIndexedAdditionalRecipientRequestKey(basekey: PGPKEYREF;
                                                    allkeys: PGPKEYSETREF;
                                                    nth: PGPUINT32;
                                                    var arkey: PGPKEYREF;
                                                    var arkeyid: PGPKEYID;
                                                    var arclass: PGPBYTE): PGPERROR; cdecl; far;


function PGPCountRevocationKeys(basekey: PGPKEYREF;
                                var numRevKeys: PGPUINT32): PGPERROR; cdecl; far;


function PGPGetIndexedRevocationKey(basekey: PGPKEYREF;
                                    allkeys: PGPKEYSETREF;
                                    nth: PGPUINT32;
                                    var revkey: PGPKEYREF;
                                    var revkeyid: PGPKEYID): PGPERROR; cdecl; far;
{$ELSE}
{$ENDIF}
{+// Keyserver filter functions }


function PGPLDAPQueryFromFilter(filter: PGPFILTERREF;
                                var queryOut: PChar): PGPERROR; cdecl;


function PGPHKSQueryFromFilter(filter: PGPFILTERREF;
                               var queryOut: PChar): PGPERROR; cdecl;

{+// KeySet manipulations }


{+// Creates a new memory-based KeyDB and returns its root set }

function PGPNewKeySet(context: PGPCONTEXTREF;
                      var keySet: PGPKEYSETREF): PGPERROR; cdecl;


{+// Used for building arbitrary subsets of an existing KeyDB }

function PGPNewEmptyKeySet(origSet: PGPKEYSETREF;
                           var newSet: PGPKEYSETREF): PGPERROR; cdecl;

function PGPNewSingletonKeySet(key: PGPKEYREF;
                              var keySet: PGPKEYSETREF): PGPERROR; cdecl;

function PGPUnionKeySets(set1: PGPKEYSETREF;
                         set2: PGPKEYSETREF;
                         var newSet: PGPKEYSETREF): PGPERROR; cdecl;


function PGPOpenDefaultKeyRings(context: PGPCONTEXTREF;
                                openFlags: PGPKEYRINGOPENFLAGS;
                                var keySet: PGPKEYSETREF): PGPERROR; cdecl;


function PGPOpenKeyRingPair(context: PGPCONTEXTREF;
                            openFlags: PGPKEYRINGOPENFLAGS;
                            pubFileRef: PGPFILESPECREF;
                            secFileRef: PGPFILESPECREF;
                            var keySet: PGPKEYSETREF): PGPERROR; cdecl;


function PGPOpenKeyRing(context: PGPCONTEXTREF;
                        openFlags: PGPKEYRINGOPENFLAGS;
                        fileRef: PGPFILESPECREF;
                        var keySet: PGPKEYSETREF): PGPERROR; cdecl;


function PGPCommitKeyRingChanges(keys: PGPKEYSETREF): PGPERROR; cdecl;


function PGPPropagateTrust(keys: PGPKEYSETREF): PGPERROR; cdecl;


function PGPRevertKeyRingChanges(keys: PGPKEYSETREF): PGPERROR; cdecl;


function PGPCheckKeyRingSigs(keysToCheck: PGPKEYSETREF;
                             keysSigning: PGPKEYSETREF;
                             checkAll: PGPBOOLEAN;
                             progress: PGPEVENTHANDLERPROCPTR;
                             userValue: PGPUSERVALUE): PGPERROR; cdecl;


function PGPReloadKeyRings(keys: PGPKEYSETREF): PGPERROR; cdecl;


function PGPGetKeyByKeyID(keys: PGPKEYSETREF;
                          keyID: PGPKEYIDREF;
                          pubKeyAlgorithm: PGPPUBLICKEYALGORITHM;
                          var outRef: PGPKEYREF): PGPERROR; cdecl;


function PGPKeySetIsMember(key: PGPKEYREF;
                           setv: PGPKEYSETREF): PGPBOOLEAN; cdecl;


function PGPCountKeys(keys: PGPKEYSETREF;
                      var numKeys: PGPUINT32): PGPERROR; cdecl;


function PGPIncKeySetRefCount(keys: PGPKEYSETREF): PGPERROR; cdecl;


function PGPFreeKeySet(keys: PGPKEYSETREF): PGPERROR; cdecl;


function PGPKeySetIsMutable(keys: PGPKEYSETREF): PGPBOOLEAN; cdecl;


function PGPKeySetNeedsCommit(keys: PGPKEYSETREF): PGPBOOLEAN; cdecl;



{function PGPIncKeyRefCount(key: PGPKEYREF): PGPERROR; cdecl;}


function PGPFreeKey(key: PGPKEYREF): PGPERROR; cdecl;


function PGPAddKeys(keysToAdd: PGPKEYSETREF;
                    setv: PGPKEYSETREF): PGPERROR; cdecl;


function PGPRemoveKeys(keysToRemove: PGPKEYSETREF;
                       setv: PGPKEYSETREF): PGPERROR; cdecl;



{+// Key manipulation functions }


function PGPDisableKey(key: PGPKEYREF): PGPERROR; cdecl;


function PGPEnableKey(key: PGPKEYREF): PGPERROR; cdecl;

{$IFDEF PGP6}
{+// Passphrase conversion to passkeybuffer */ }
{+// The size of the output buffer is from the kPGPKeyPropLockingBits property */ }


function PGPGetKeyPasskeyBuffer(key: PGPKEYREF;
                                passkeyBuffer: Pointer;
                                firstOption: PGPOPTIONLISTREF;
                                lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPGetSubKeyPasskeyBuffer(subkey: PGPSUBKEYREF;
                                   passkeyBuffer: Pointer;
                                   firstOption: PGPOPTIONLISTREF;
                                   lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


{+// Change key options which are stored in self signatures internally */ }


function PGPAddKeyOptions(key: PGPKEYREF;
                          firstOption: PGPOPTIONLISTREF;
                          lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPRemoveKeyOptions(key: PGPKEYREF;
                             firstOption: PGPOPTIONLISTREF;
                             lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPUpdateKeyOptions(key: PGPKEYREF;
                             firstOption: PGPOPTIONLISTREF;
                             lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPAddAttributeUserID(key: PGPKEYREF;
                               attributeType: PGPATTRIBUTETYPE;
                               attributeData: PPGPBYTE;
                               attributeLength: PGPSIZE;
                               firstOption: PGPOPTIONLISTREF;
                               lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPGetPrimaryAttributeUserID(key: PGPKEYREF;
                                      attributeType: PGPATTRIBUTETYPE;
                                      var outRef: PGPUSERIDREF): PGPERROR; cdecl; far;

function PGPChangePassphrase(key: PGPKEYREF;
                             firstOption: PGPOPTIONLISTREF;
                             lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPChangeSubKeyPassphrase(subkey: PGPSUBKEYREF;
                                   firstOption: PGPOPTIONLISTREF;
                                   lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPPassphraseIsValid(key: PGPKEYREF;
                              firstOption: PGPOPTIONLISTREF;
                              lastOption: PGPOPTIONLISTREF): PGPBOOLEAN; cdecl;

function PGPSetKeyAxiomatic(key: PGPKEYREF;
                            firstOption: PGPOPTIONLISTREF;
                              lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl;

{+//____________________________________________________________________________ }
{-Secret sharing functionality }
{=____________________________________________________________________________ }


function PGPSecretShareData(context: PGPCONTEXTREF;
                            Const input: Pointer;
                            inputBytes: PGPSIZE;
                            threshold: PGPUINT32;
                            nShares: PGPUINT32;
                            output: Pointer): PGPERROR; cdecl; far;


function PGPSecretReconstructData(context: PGPCONTEXTREF;
                                  input: Pointer;
                                  outputBytes: PGPSIZE;
                                  nShares: PGPUINT32;
                                  output: Pointer): PGPERROR; cdecl; far;


{+//____________________________________________________________________________ }
{-X509 certificate specific }
{=____________________________________________________________________________ }


function PGPVerifyX509CertificateChain(context: PGPCONTEXTREF;
                                       certchain: PPGPBYTE;
                                       rootcerts: PPGPBYTE): PGPERROR; cdecl; far;



{$ELSE}
function PGPChangePassphrase(key: PGPKEYREF;
                             Const oldphrase: PChar;
                             const newphrase: PChar): PGPERROR; cdecl;


function PGPChangeSubKeyPassphrase(subkey: PGPSUBKEYREF;
                                   Const oldphrase: PChar;
                                   Const newphrase: PChar): PGPERROR; cdecl;

function PGPPassphraseIsValid(key: PGPKEYREF;
                              Const passphrase: PChar): PGPBOOLEAN; cdecl;

function PGPSetKeyAxiomatic(key: PGPKEYREF;
                            checkPassphrase: PGPBOOLEAN;
                            Const passphrase: PChar): PGPERROR; cdecl;

{$ENDIF}


function PGPRemoveSubKey(subkey: PGPSUBKEYREF): PGPERROR; cdecl;


function PGPRemoveUserID(userID: PGPUSERIDREF): PGPERROR; cdecl;


function PGPSetPrimaryUserID(userid: PGPUSERIDREF): PGPERROR; cdecl;


function PGPGetSigCertifierKey(cert: PGPSIGREF;
                               allkeys: PGPKEYSETREF;
                               var certkey: PGPKEYREF): PGPERROR; cdecl;


function PGPRemoveSig(cert: PGPSIGREF): PGPERROR; cdecl;


function PGPGetNumMessageRecoveryKeys(basekey: PGPKEYREF;
                                      allkeys: PGPKEYSETREF;
                                      var numMRKeys: PGPUINT32): PGPERROR; cdecl;


function PGPGetIndexedMessageRecoveryKey(basekey: PGPKEYREF;
                                         allkeys: PGPKEYSETREF;
                                         nth: PGPUINT32;
                                        var  mrkey: PGPKEYREF;
                                        var  mrclass: PGPBYTE): PGPERROR; cdecl;




{+// Wrapper functions }

function PGPGenerateKey(context: PGPCONTEXTREF;
                        var key: PGPKEYREF;
                        firstOption,lastoption: PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPGenerateSubKey(context: PGPCONTEXTREF;
                          var  subkey: PGPSUBKEYREF;
                           firstOption,lastoption: PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPGetKeyEntropyNeeded(context: PGPCONTEXTREF;
                                firstOption,lastoption: PGPOPTIONLISTREF): PGPUINT32; cdecl;

function PGPExportKeySet(keys: PGPKEYSETREF;
                         firstOption,lastoption: PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPImportKeySet(context: PGPCONTEXTREF;
                         var keys: PGPKEYSETREF;
                         firstOption,lastoption:PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPSignUserID(userID: PGPUSERIDREF;
                       certifyingKey: PGPKEYREF;
                       firstOption,lastoption: PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPAddUserID(key: PGPKEYREF;
                      Const userID: PChar;
                      firstOption,lastoption:PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPRevokeSig(cert: PGPSIGREF;
                      allkeys: PGPKEYSETREF;
                      firstOption,lastoption:PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPRevokeKey(key: PGPKEYREF;
                      firstOption,lastoption:PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPRevokeSubKey(subkey: PGPSUBKEYREF;
                         firstOption,lastoption: PGPOPTIONLISTREF): PGPERROR; cdecl;


{+// }
{-* Trust values for PGPSetKeyTrust and kPGPKeyPropTrust property: }
{-* }
{-* kPGPKeyTrust_Undefined (do not pass to PGPSetKeyTrust) }
{-* kPGPKeyTrust_Unknown (unknown) }
{-* kPGPKeyTrust_Never (never) }
{-* kPGPKeyTrust_Marginal (sometimes) }
{-* kPGPKeyTrust_Complete (always) }
{-* kPGPKeyTrust_Ultimate (do not pass to PGPSetKeyTrust) }
{= }

{+// old trust model }

function PGPSetKeyTrust(key: PGPKEYREF;
                        trust: PGPUINT32): PGPERROR; cdecl;




function PGPUnsetKeyAxiomatic(key: PGPKEYREF): PGPERROR; cdecl;

{+// Get property functions }


function PGPGetKeyBoolean(key: PGPKEYREF;
                          propname: PGPKEYPROPNAME;
                          var prop: PGPBOOLEAN): PGPERROR; cdecl;


function PGPGetKeyNumber(key: PGPKEYREF;
                         propname: PGPKEYPROPNAME;
                         var prop: PGPINT32): PGPERROR; cdecl;

{+// 'buffer' is NOT null-terminated }
{+// returns kPGPError_BufferTooSmall if buffer is too small; but }
{=fill buffer to capacity }

function PGPGetKeyPropertyBuffer(key: PGPKEYREF;
                                 propname: PGPKEYPROPNAME;
                                 bufferSize: PGPSIZE;
                                 var data: PGPBYTE;
                                 var fullSize: PGPSIZE): PGPERROR; cdecl;


function PGPGetKeyTime(key: PGPKEYREF;
                       propname: PGPKEYPROPNAME;
                       var prop: PGPTIME): PGPERROR; cdecl;


function PGPGetSubKeyBoolean(subkey: PGPSUBKEYREF;
                             propname: PGPKEYPROPNAME;
                             var prop: PGPBOOLEAN): PGPERROR; cdecl;


function PGPGetSubKeyNumber(subkey: PGPSUBKEYREF;
                            propname: PGPKEYPROPNAME;
                            var prop: PGPINT32): PGPERROR; cdecl;

{+// returns kPGPError_BufferTooSmall if buffer is too small; but }
{=fill buffer to capacity }

function PGPGetSubKeyPropertyBuffer(subkey: PGPSUBKEYREF;
                                    propname: PGPKEYPROPNAME;
                                    bufferSize: PGPSIZE;
                                    var prop: PGPBYTE;
                                    var fullSize: PGPSIZE): PGPERROR; cdecl;


function PGPGetSubKeyTime(subkey: PGPSUBKEYREF;
                          propname: PGPKEYPROPNAME;
                          var prop: PGPTIME): PGPERROR; cdecl;


function PGPGetUserIDNumber(userID: PGPUSERIDREF;
                            propname: PGPUSERIDPROPNAME;
                            var prop: PGPINT32): PGPERROR; cdecl;

{$IFDEF PGP6}
 function PGPGetUserIDBoolean(userID: PGPUSERIDREF;
                             propname: PGPUSERIDPROPNAME;
                             var prop: PGPBOOLEAN): PGPERROR;cdecl;
{$ELSE}
{$ENDIF}


{+// 'string' is always NULL-terminated }
{+// returns kPGPError_BufferTooSmall if buffer is too small; but }
{=fill buffer to capacity }

function PGPGetUserIDStringBuffer(userID: PGPUSERIDREF;
                                  propname: PGPUSERIDPROPNAME;
                                  bufferSize: PGPSIZE;
                                  stringv: PChar;
                                  var fullSize: PGPSIZE): PGPERROR; cdecl;


function PGPGetSigBoolean(cert: PGPSIGREF;
                          propname: PGPSIGPROPNAME;
                          var prop: PGPBOOLEAN): PGPERROR; cdecl;


function PGPGetSigNumber(cert: PGPSIGREF;
                         propname: PGPSIGPROPNAME;
                         var prop: PGPINT32): PGPERROR; cdecl;


function PGPNewKeyIDOfCertifier(sig: PGPSIGREF;
                                var outRef: PGPKEYIDREF): PGPERROR; cdecl;


function PGPGetSigTime(cert: PGPSIGREF;
                       propname: PGPSIGPROPNAME;
                       var prop: PGPTIME): PGPERROR; cdecl;


function PGPGetHashAlgUsed(key: PGPKEYREF;
                           var hashAlg: PGPHASHALGORITHM): PGPERROR; cdecl;


{+// Convenience property functions }


function PGPGetPrimaryUserID(key: PGPKEYREF;
                             var outRef: PGPUSERIDREF): PGPERROR; cdecl;

{+// 'string' is always a C string and }
{=*fullSize includes the '\0' terminator }
{+// returns kPGPError_BufferTooSmall if buffer is too small; but }
{=fill buffer to capacity }

function PGPGetPrimaryUserIDNameBuffer(key: PGPKEYREF;
                                       bufferSize: PGPSIZE;
                                       stringv: PChar;
                                       var fullSize: PGPSIZE): PGPERROR; cdecl;

function PGPGetKeyIDFromKey( key:PGPKeyRef ;var id: PGPKeyID  ): PGPERROR; cdecl;

function PGPGetPrimaryUserIDValidity(key: PGPKEYREF;
                                     var validity: PGPVALIDITY): PGPERROR; cdecl;



function PGPCompareKeys(a: PGPKEYREF;
                        b: PGPKEYREF;
                        order: PGPKEYORDERING): PGPINT32; cdecl;


function PGPCompareUserIDStrings(Const a: PChar;
                                 Const b: PChar): PGPINT32; cdecl;


function PGPOrderKeySet(src: PGPKEYSETREF;
                        order: PGPKEYORDERING;
                        var outRef: PGPKEYLISTREF): PGPERROR; cdecl;


function PGPIncKeyListRefCount(keys: PGPKEYLISTREF): PGPERROR; cdecl;


function PGPFreeKeyList(keys: PGPKEYLISTREF): PGPERROR; cdecl;


{+// Key iteration functions }


function PGPIncSubKeyRefCount(subkey: PGPSUBKEYREF): PGPERROR; cdecl;


function PGPIncUserIDRefCount(userid: PGPUSERIDREF): PGPERROR; cdecl;


function PGPIncSigRefCount(cert: PGPSIGREF): PGPERROR; cdecl;


function PGPFreeSubKey(subkey: PGPSUBKEYREF): PGPERROR; cdecl;


function PGPFreeUserID(userid: PGPUSERIDREF): PGPERROR; cdecl;


function PGPFreeSig(cert: PGPSIGREF): PGPERROR; cdecl;


function PGPNewKeyIter(keys: PGPKEYLISTREF;
                       var outRef: PGPKEYITERREF): PGPERROR; cdecl;


function PGPCopyKeyIter(orig: PGPKEYITERREF;
                        var outRef: PGPKEYITERREF): PGPERROR; cdecl;


function PGPFreeKeyIter(iter: PGPKEYITERREF): PGPERROR; cdecl;


function PGPKeyIterIndex(iter: PGPKEYITERREF): PGPINT32; cdecl;


function PGPKeyIterRewind(iter: PGPKEYITERREF): PGPERROR; cdecl;


function PGPKeyIterSeek(iter: PGPKEYITERREF;
                        key: PGPKEYREF): PGPINT32; cdecl;


function PGPKeyIterMove(iter: PGPKEYITERREF;
                        relOffset: PGPINT32;
                        var outRef: PGPKEYREF): PGPERROR; cdecl;


function PGPKeyIterNext(iter: PGPKEYITERREF;
                        var outRef: PGPKEYREF): PGPERROR; cdecl;


function PGPKeyIterPrev(iter: PGPKEYITERREF;
                        var outRef: PGPKEYREF): PGPERROR; cdecl;


function PGPKeyIterKey(iter: PGPKEYITERREF;
                       var outRef: PGPKEYREF): PGPERROR; cdecl;


function PGPKeyIterSubKey(iter: PGPKEYITERREF;
                           var outRef: PGPSUBKEYREF): PGPERROR; cdecl;


function PGPKeyIterUserID(iter: PGPKEYITERREF;
                          var outRef: PGPUSERIDREF): PGPERROR; cdecl;

function PGPKeyIterSig(iter: PGPKEYITERREF;
                       var outRef: PGPSIGREF): PGPERROR; cdecl;


function PGPKeyIterIsValid(iter: PGPKEYITERREF): PGPBOOLEAN; cdecl;


function PGPKeyIterNextSubKey(iter: PGPKEYITERREF;
                             var outRef: PGPSUBKEYREF): PGPERROR; cdecl;


function PGPKeyIterPrevSubKey(iter: PGPKEYITERREF;
                              var outRef: PGPSUBKEYREF): PGPERROR; cdecl;


function PGPKeyIterRewindSubKey(iter: PGPKEYITERREF): PGPERROR; cdecl;


function PGPKeyIterNextUserID(iter: PGPKEYITERREF;
                              var outRef: PGPUSERIDREF): PGPERROR; cdecl;


function PGPKeyIterPrevUserID(iter: PGPKEYITERREF;
                              var outRef: PGPUSERIDREF): PGPERROR; cdecl;


function PGPKeyIterRewindUserID(iter: PGPKEYITERREF): PGPERROR; cdecl;


function PGPKeyIterNextUIDSig(iter: PGPKEYITERREF;
                              var outRef: PGPSIGREF): PGPERROR; cdecl;


function PGPKeyIterPrevUIDSig(iter: PGPKEYITERREF;
                              var outRef: PGPSIGREF): PGPERROR; cdecl;


function PGPKeyIterRewindUIDSig(iter: PGPKEYITERREF): PGPERROR; cdecl;


{+// Get/set default private key }


function PGPGetDefaultPrivateKey(keyset: PGPKEYSETREF;
                                 var outRef: PGPKEYREF): PGPERROR; cdecl;


function PGPSetDefaultPrivateKey(key: PGPKEYREF): PGPERROR; cdecl;



{+// Get/set user value }


function PGPSetKeyUserVal(key: PGPKEYREF;
                          userValue: PGPUSERVALUE): PGPERROR; cdecl;


function PGPSetUserIDUserVal(userid: PGPUSERIDREF;
                             userValue: PGPUSERVALUE): PGPERROR; cdecl;


function PGPSetSubKeyUserVal(subkey: PGPSUBKEYREF;
                             userValue: PGPUSERVALUE): PGPERROR; cdecl;


function PGPSetSigUserVal(cert: PGPSIGREF;
                          userValue: PGPUSERVALUE): PGPERROR; cdecl;


function PGPGetKeyUserVal(key: PGPKEYREF;
                          var userValue: PGPUSERVALUE): PGPERROR; cdecl;


function PGPGetUserIDUserVal(userid: PGPUSERIDREF;
                             var userValue: PGPUSERVALUE): PGPERROR; cdecl;


function PGPGetSubKeyUserVal(subkey: PGPSUBKEYREF;
                             var userValue: PGPUSERVALUE): PGPERROR; cdecl;


function PGPGetSigUserVal(cert: PGPSIGREF;
                          var userValue: PGPUSERVALUE): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-Key IDs }
{=____________________________________________________________________________ }

function PGPNewKeyIDFromString(context: PGPCONTEXTREF;
                               Const stringv: PChar;
                               var outRef: PGPKEYIDREF): PGPERROR; cdecl;


function PGPNewKeyIDFromKey(key: PGPKEYREF;
                            var outRef: PGPKEYIDREF): PGPERROR; cdecl;


function PGPNewKeyIDFromSubKey(key: PGPSUBKEYREF;
                               var outRef: PGPKEYIDREF): PGPERROR; cdecl;


function PGPCopyKeyID(inRef: PGPKEYIDREF;
                      var outRef: PGPKEYIDREF): PGPERROR; cdecl;


function PGPFreeKeyID(ref: PGPKEYIDREF): PGPERROR; cdecl;





function PGPGetKeyIDString(ref: PGPKEYIDREF;
                           typev: PGPKEYIDSTRINGTYPE;
                           var outString: pgpidstringarray): PGPERROR; cdecl;


{+// caller must free *outData with PGPFreeData }
{+// outputs opaque string of bytes for storage }
{+// do NOT attempt to parse the output; it is opaque to you }

function PGPExportKeyID(ref: PGPCONSTKEYIDREF;
                        var outData: PGPBYTE;
                        var outSize: PGPSIZE): PGPERROR; cdecl;

{+// must be in format output by PGPExportKeyID }

function PGPImportKeyID(data:pointer;var keyid: PGPKeyID): PGPERROR; cdecl;

{+// returns 0 if equal; -1 if key1 < key2; 1 if key1 > key2 }

function PGPCompareKeyIDs(key: PGPKEYID;
                          key2: PGPKEYID): PGPINT32; cdecl;




{+//____________________________________________________________________________ }
{-Getting contexts back from key related items. If the key is invalid; }
{-you get kPGPInvalidRef back. }
{=____________________________________________________________________________ }


function PGPGetKeyListContext(ref: PGPKEYLISTREF): PGPCONTEXTREF; cdecl;

function PGPGetKeySetContext(ref: PGPKEYSETREF): PGPCONTEXTREF; cdecl;

function PGPGetKeyIterContext(ref: PGPKEYITERREF): PGPCONTEXTREF; cdecl;

function PGPGetKeyContext(ref: PGPKEYREF): PGPCONTEXTREF; cdecl;

function PGPGetSubKeyContext(ref: PGPSUBKEYREF): PGPCONTEXTREF; cdecl;

function PGPGetUserIDContext(ref: PGPUSERIDREF): PGPCONTEXTREF; cdecl;




implementation

function PGPGetUserIDContext; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPIncFilterRefCount; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeyIDFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeyEncryptAlgorithmFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeyFingerPrintFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeyCreationTimeFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeyExpirationTimeFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeyRevokedFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeyDisabledFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeySigAlgorithmFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeyEncryptKeySizeFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeySigKeySizeFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeyVersionFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewUserIDStringFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewUserIDEmailFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewUserIDNameFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewUserIDVersionFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewSigHashAlgorithmFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewSigKeyAlgorithmFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewSigClassificationFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewSigCreationTimeFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewSigKeyIDFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewSigVersionFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNegateFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPIntersectFilters; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPUnionFilters; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFilterKeySet; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPLDAPQueryFromFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPHKSQueryFromFilter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeySet; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewEmptyKeySet; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewSingletonKeySet; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPUnionKeySets; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOpenDefaultKeyRings; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOpenKeyRingPair; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOpenKeyRing; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCommitKeyRingChanges; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPPropagateTrust; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPRevertKeyRingChanges; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCheckKeyRingSigs; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPReloadKeyRings; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetKeyByKeyID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeySetIsMember; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCountKeys; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPIncKeySetRefCount; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeKeySet; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeySetIsMutable; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeySetNeedsCommit; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPAddKeys; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPRemoveKeys; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPDisableKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPEnableKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

{$IFDEF PGP6}
{+//____________________________________________________________________________ }
{-Secret sharing functionality }
{=____________________________________________________________________________ }


function PGPSecretShareData; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPSecretReconstructData; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPVerifyX509CertificateChain; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetKeyPasskeyBuffer; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetSubKeyPasskeyBuffer; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPAddKeyOptions; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPRemoveKeyOptions; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPUpdateKeyOptions; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetRevocationKeySet; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCountAdditionalRecipientRequests; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetIndexedAdditionalRecipientRequestKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCountRevocationKeys; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetIndexedRevocationKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPAddAttributeUserID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetPrimaryAttributeUserID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};
{$ELSE}

{$ENDIF}
function PGPChangePassphrase; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPChangeSubKeyPassphrase; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPPassphraseIsValid; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPRemoveSubKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPRemoveUserID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPSetPrimaryUserID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetSigCertifierKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPRemoveSig; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetNumMessageRecoveryKeys; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetIndexedMessageRecoveryKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};


function PGPGenerateKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGenerateSubKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetKeyEntropyNeeded; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPExportKeySet; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPImportKeySet; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPSignUserID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPAddUserID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPRevokeSig; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPRevokeKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPRevokeSubKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPSetKeyTrust; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPSetKeyAxiomatic; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPUnsetKeyAxiomatic; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetKeyBoolean; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetKeyNumber; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetKeyPropertyBuffer; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetKeyTime; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetSubKeyBoolean; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetSubKeyNumber; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetSubKeyPropertyBuffer; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetSubKeyTime; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetUserIDNumber; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetUserIDStringBuffer; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};
{$IFDEF PGP6}
 function PGPGetUserIDBoolean; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};
{$ELSE}
{$ENDIF}

function PGPGetSigBoolean; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetSigNumber; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeyIDOfCertifier; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetSigTime; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetHashAlgUsed; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetPrimaryUserID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetPrimaryUserIDNameBuffer; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetPrimaryUserIDValidity; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCompareKeys; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCompareUserIDStrings; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOrderKeySet; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPIncKeyListRefCount; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeKeyList; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPIncSubKeyRefCount; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPIncUserIDRefCount; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPIncSigRefCount; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeSubKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeUserID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeSig; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeyIter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCopyKeyIter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeKeyIter; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterIndex; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterRewind; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterSeek; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterMove; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterNext; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterPrev; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterSubKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterUserID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterSig; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterIsValid; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterNextSubKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterPrevSubKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterRewindSubKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterNextUserID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterPrevUserID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterRewindUserID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterNextUIDSig; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterPrevUIDSig; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPKeyIterRewindUIDSig; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetDefaultPrivateKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPSetDefaultPrivateKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPSetKeyUserVal; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPSetUserIDUserVal; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPSetSubKeyUserVal; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPSetSigUserVal; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetKeyUserVal; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetUserIDUserVal; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetSubKeyUserVal; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetSigUserVal; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeyIDFromString; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeyIDFromKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewKeyIDFromSubKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCopyKeyID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeKeyID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};
function PGPGetKeyIDString; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPExportKeyID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPImportKeyID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCompareKeyIDs; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetKeyListContext; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetKeySetContext; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetKeyIterContext; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetKeyContext; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetSubKeyContext; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetKeyIDFromKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};


end.
