unit PGPPFLERRORS;

interface
Uses WinTypes,
     WinProcs,
     PGPBase;



{+//____________________________________________________________________________ }
{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-Error codes. }

{-$Id: Pgppflerrors.pas,v 1.5.12.2 1999/08/27 22:00:48 build Exp $ }
{=____________________________________________________________________________ }

const
kPGPPFLErrorBase = -12000;
kPGPPFLErrorRange = 500;

	kPGPError_NoErr = 0;


{		NOTE: once we've settled on a numbering scheme; we'll explicitly
		assign a number to each error.  For now; let the enum number them
		implicitly.}


	kPGPError_BadParams		= kPGPPFLErrorBase;
        pflstart=kPGPError_BadParams;
	kPGPError_OutOfMemory=pflstart+1;
	kPGPError_BufferTooSmall=pflstart+2;

	kPGPError_FileNotFound=pflstart+3;
	kPGPError_CantOpenFile=pflstart+4;
	kPGPError_FilePermissions=pflstart+5;
	kPGPError_FileLocked=pflstart+6;
	kPGPError_DiskFull=pflstart+7;
	kPGPError_IllegalFileOp=pflstart+8;
	kPGPError_FileOpFailed=pflstart+9;
	kPGPError_ReadFailed=pflstart+10;
	kPGPError_WriteFailed=pflstart+11;
	kPGPError_EOF=pflstart+12;

	kPGPError_UserAbort=pflstart+13;
	kPGPError_UnknownRequest=pflstart+14;
	kPGPError_LazyProgramme=pflstart+15;
	kPGPError_ItemNotFound=pflstart+16;
	kPGPError_ItemAlreadyExists=pflstart+17;
	kPGPError_AssertFailed=pflstart+18;
	kPGPError_BadMemAddress=pflstart+19;
	kPGPError_UnknownError=pflstart+20;

	kPGPError_PrefNotFound=pflstart+21;
	kPGPError_EndOfIteration=pflstart+22;
	kPGPError_ImproperInitialization=pflstart+23;
	kPGPError_CorruptData=pflstart+24;
	kPGPError_FeatureNotAvailable=pflstart+25;

	kPGPError_LastPFLError = kPGPPFLErrorBase + kPGPPFLErrorRange;


function PGPValidateParam(expr:boolean):PGPError;

function PGPValidatePtr( ptr:pointer ):pgperror;



function PFLGetErrorString(theError: PGPERROR;
                           bufferSize: PGPSIZE;
                           theString: PChar): PGPERROR; cdecl;





 function IsntPGPError(err:PGPError ):boolean;
 function IsPGPError(err:PGPError):boolean;
implementation

function IsPGPError(err:PGPError):boolean;
begin
result:= ( (err) <> kPGPError_NoErr );
 end;

 function IsntPGPError(err:PGPError ):boolean;
 begin
 result:= ( (err) = kPGPError_NoErr );
 end;
function PFLGetErrorString(theError: PGPERROR;
                           bufferSize: PGPSIZE;
                           theString: PChar): PGPERROR; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPValidateParam(expr:boolean):PGPError;
begin
if  not expr then
begin
{	pgpAssert(expr);}
	result:= kPGPError_BadParams;
        end else
        result:=kPGPError_NoErr;
end;

function PGPValidatePtr( ptr:pointer ):pgperror;
begin
result:=PGPValidateParam( (ptr) <> nil );
end;


end.
